/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.util.DateUtils;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public class SEPAUtil {
    public static final String SEPA_WITH_GROUP_TOTAL = "de.businesslogics.format.sepa.WithGroupTotal";
    public static final BigDecimal SEPA_PAYMENT_MAX_AMOUNT = new BigDecimal("999999999.99");
    public static final BigDecimal FORGEIN_MAX_AMOUNT = new BigDecimal("999999999999999.999");
    private static final long ONE_DAY = 86400000L;
    private static final BigInteger NINTY_SEVEN = new BigInteger("97");

    public static String getSEPAString(String s, int maxLength, GeneralSEPAWriter.Version version) {
        if (GeneralSEPAWriter.allowDTAUSChars(version)) {
            return PaymentUtils.getExtendedSEPAString(s, maxLength);
        }
        return PaymentUtils.getBaseSEPAString(s, maxLength);
    }

    public static boolean isExecutionDateTooOld(GeneralSEPAWriter.Version version, boolean isCredit, String debitType, String seqType, Date executionDate, int countDaysLeadTime) {
        Date earliestExecutionDate = SEPAUtil.getEarliestExecutionDate(version, isCredit, debitType, seqType, countDaysLeadTime);
        return executionDate.getTime() + 86400000L <= earliestExecutionDate.getTime();
    }

    public static Date getValidExecutionDate(GeneralSEPAWriter.Version version, boolean isCredit, String debitType, String seqType, Date executionDate, int countDaysLeadTime) {
        Date earliestExecutionDate = SEPAUtil.getEarliestExecutionDate(version, isCredit, debitType, seqType, countDaysLeadTime);
        if (executionDate.getTime() + 86400000L <= earliestExecutionDate.getTime()) {
            return earliestExecutionDate;
        }
        return executionDate;
    }

    public static Date getEarliestExecutionDate(GeneralSEPAWriter.Version version, boolean isCredit, String debitType, String seqType, int countDaysLeadTime) {
        if (isCredit) {
            return DateUtils.getCurrentDateWithoutTimeStamp();
        }
        return SEPAUtil.getEarliestExecutionDate(SEPAUtil.getCountWorkingDays(version, debitType, seqType) + countDaysLeadTime);
    }

    public static int getCountWorkingDays(GeneralSEPAWriter.Version version, String debitType, String seqType) {
        if (GeneralSEPAWriter.isVersion30orNewer(version)) {
            return 1;
        }
        if ("B2B".equals(debitType) || "COR1".equals(debitType)) {
            return 1;
        }
        if ("FRST".equals(seqType) || "OOFF".equals(seqType)) {
            return 5;
        }
        if ("RCUR".equals(seqType) || "FNAL".equals(seqType)) {
            return 2;
        }
        return 0;
    }

    private static Date getEarliestExecutionDate(int countWorkingDays) {
        Calendar cal = DateUtils.getCurrentCalendarWithoutTimeStamp();
        if (countWorkingDays > 0) {
            return DateUtils.addWorkingDays(cal, countWorkingDays).getTime();
        }
        return DateUtils.getNextWorkingDay(cal).getTime();
    }

    public static boolean isSalaryPayment(String paymentCategory, String purposeCode) {
        if (paymentCategory != null && ("SALA".equals(paymentCategory) || "PENS".equals(paymentCategory) || "BONU".equals(paymentCategory))) {
            return true;
        }
        return purposeCode != null && ("SALA".equals(purposeCode) || "PENS".equals(purposeCode) || "BONU".equals(purposeCode));
    }

    private static BigInteger buildNumber(String in) {
        StringBuilder numeric = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            int n = Character.getNumericValue(in.charAt(i));
            if (n < 0) continue;
            numeric.append(n);
        }
        return new BigInteger(numeric.toString());
    }

    public static boolean checkCreditorId(String id) {
        if (RegularExpressions.SEPA_CREDITOR_ID.matches(id)) {
            String toCheck = id.substring(7) + id.substring(0, 4);
            return SEPAUtil.buildNumber(toCheck).mod(NINTY_SEVEN).intValue() == 1;
        }
        return false;
    }

    public static boolean checkMandateReference(String mandateReference) {
        return RegularExpressions.SEPA_RESTRICTED_IDENTIFICATION_1.matches(mandateReference);
    }

    public static void main(String[] args) {
        System.out.println(SEPAUtil.checkCreditorId("DE98ZZZ09999999999"));
        System.out.println(SEPAUtil.checkCreditorId("DE31ZZZZ00000398178"));
        System.out.println(SEPAUtil.checkCreditorId("DE31ZZZ00000398178"));
    }
}

