/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum SEPAServiceLevel {
    SEPA(false),
    URGP(true),
    NURG(true),
    SDVA(true),
    PRPT(true);

    private boolean isAllowedForInternationalPain001;

    private SEPAServiceLevel(boolean isAllowedForInternationalPain001) {
        this.isAllowedForInternationalPain001 = isAllowedForInternationalPain001;
    }

    public static boolean isAllowedForInternationalPain001(String value) {
        try {
            SEPAServiceLevel serviceLevel;
            String s = StringUtils.checkNullAndTrim(value);
            if (s.length() > 0 && (serviceLevel = SEPAServiceLevel.valueOf(s)) != null) {
                return serviceLevel.isAllowedForInternationalPain001;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public static String getLongDescription(String serviceLevel, Locale locale) {
        try {
            return ResourceBundle.getBundle("de.businesslogics.format.sepa.SEPAServiceLevel", locale).getString(serviceLevel);
        }
        catch (MissingResourceException missingResourceException) {
            return serviceLevel;
        }
    }

    public static String[] getValuesForInternationalPayments() {
        ArrayList<String> values = new ArrayList<String>();
        for (SEPAServiceLevel serviceLevel : SEPAServiceLevel.values()) {
            if (!serviceLevel.isAllowedForInternationalPain001) continue;
            values.add(serviceLevel.name());
        }
        return values.toArray(new String[0]);
    }
}

