/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.pain00200103.BICIdentifier;
import de.businesslogics.format.sepa.pain00200103.CustomerPaymentStatusReportV03;
import de.businesslogics.format.sepa.pain00200103.DecimalNumber;
import de.businesslogics.format.sepa.pain00200103.Document;
import de.businesslogics.format.sepa.pain00200103.ExternalStatusReason1Code;
import de.businesslogics.format.sepa.pain00200103.GroupHeaderSEPA;
import de.businesslogics.format.sepa.pain00200103.MandateRelatedInformationSEPA;
import de.businesslogics.format.sepa.pain00200103.Max15NumericText;
import de.businesslogics.format.sepa.pain00200103.OriginalGroupInformationSEPA;
import de.businesslogics.format.sepa.pain00200103.OriginalPaymentInformationSEPA;
import de.businesslogics.format.sepa.pain00200103.OriginalTransactionReferenceSEPA;
import de.businesslogics.format.sepa.pain00200103.PaymentTransactionInformationSEPA;
import de.businesslogics.format.sepa.pain00200103.PaymentTypeInformationSEPA;
import de.businesslogics.format.sepa.pain00200103.RemittanceInformationSEPA2Choice;
import de.businesslogics.format.sepa.pain00200103.StatusReasonInformationSEPA;
import de.businesslogics.format.sepa.pain00200103.StatusReasonSEPA;
import de.businesslogics.format.sepa.pain00200103.TransactionGroupStatusCodeSEPA;
import de.businesslogics.format.sepa.pain00200103.TransactionIndividualStatusCodeSEPA;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SEPAReportExtractorV5 {
    protected static RejectedSEPAOrder getRejectedOrder(Document document) {
        CustomerPaymentStatusReportV03 pain = document.getCstmrPmtStsRpt();
        GroupHeaderSEPA groupHeader = pain.getGrpHdr();
        String msgId = groupHeader.getMsgId().getValue();
        Date creationDate = groupHeader.getCreDtTm().getDate();
        String originatorBic = SEPAReportExtractorV5.getOriginatorBic(groupHeader);
        OriginalGroupInformationSEPA orgnlGrpInfAndSts = pain.getOrgnlGrpInfAndSts();
        String orgnlMsgId = orgnlGrpInfAndSts.getOrgnlMsgId().getValue();
        String orgnlMsgName = orgnlGrpInfAndSts.getOrgnlMsgNmId().getValue();
        boolean isDirectDebitReport = orgnlMsgName != null && orgnlMsgName.startsWith("pain.008");
        RejectedSEPAOrder rejectedOrder = new RejectedSEPAOrder(msgId, creationDate, originatorBic, orgnlMsgId, orgnlMsgName, SEPAReportExtractorV5.getCtrlSum(orgnlGrpInfAndSts.getOrgnlCtrlSum()), SEPAReportExtractorV5.getNbOfTxs(orgnlGrpInfAndSts.getOrgnlNbOfTxs()), SEPAReportExtractorV5.getStatusCode(orgnlGrpInfAndSts.getGrpSts()), SEPAReportExtractorV5.getStatusReasons(orgnlGrpInfAndSts.getStsRsnInfs()));
        if (pain.getOrgnlPmtInfAndStss() != null) {
            ArrayList<RejectedSEPALogicalFile> rejectedLogicalFiles = new ArrayList<RejectedSEPALogicalFile>();
            for (OriginalPaymentInformationSEPA paymentInfo : pain.getOrgnlPmtInfAndStss()) {
                RejectedSEPALogicalFile logicalFile = new RejectedSEPALogicalFile(paymentInfo.getOrgnlPmtInfId().getValue(), SEPAReportExtractorV5.getNbOfTxs(paymentInfo.getOrgnlNbOfTxs()), SEPAReportExtractorV5.getCtrlSum(paymentInfo.getOrgnlCtrlSum()), SEPAReportExtractorV5.getStatusCode(paymentInfo.getPmtInfSts()), SEPAReportExtractorV5.getStatusReasons(paymentInfo.getStsRsnInfs()));
                if (paymentInfo.getTxInfAndStss() != null && paymentInfo.getTxInfAndStss().size() > 0) {
                    for (PaymentTransactionInformationSEPA transactionInfo : paymentInfo.getTxInfAndStss()) {
                        SEPAPaymentData data = SEPAReportExtractorV5.getPaymentData(transactionInfo, isDirectDebitReport);
                        if (data == null) continue;
                        logicalFile.addPayment(new RejectedSEPAPayment(data, SEPAReportExtractorV5.getStatusCode(transactionInfo.getTxSts()), SEPAReportExtractorV5.getStatusReasons(transactionInfo.getStsRsnInfs())));
                    }
                }
                rejectedLogicalFiles.add(logicalFile);
            }
            if (rejectedLogicalFiles.size() > 0) {
                rejectedOrder.setRejectedLogicalFiles(rejectedLogicalFiles);
            }
        }
        return rejectedOrder;
    }

    private static SEPAPaymentData getPaymentData(PaymentTransactionInformationSEPA transactionInfo, boolean isDirectDebitReport) {
        String ultimateRecip;
        String recipBic;
        String recipIban;
        String recip;
        String ultimateOrig;
        String origBic;
        String origIban;
        String orig;
        MandateRelatedInformationSEPA mndtRltdInf;
        BICIdentifier bic2;
        BICIdentifier bic;
        String msgId = null;
        String initParty = null;
        OriginalTransactionReferenceSEPA tx = transactionInfo.getOrgnlTxRef();
        if (tx == null) {
            return null;
        }
        YYMMDD executionDate = null;
        OriginalTransactionReferenceSEPA.OriginalTransactionReferenceSEPA_C1 dateChoice = tx.getChoice1();
        if (dateChoice != null) {
            if (dateChoice.getReqdColltnDt() != null) {
                executionDate = dateChoice.getReqdColltnDt().getDate();
                isDirectDebitReport = true;
            } else if (dateChoice.getReqdExctnDt() != null) {
                executionDate = dateChoice.getReqdExctnDt().getDate();
            }
        }
        String debtorBic = "";
        if (tx.getDbtrAgt() != null && (bic = tx.getDbtrAgt().getFinInstnId().getChoice1().getBIC()) != null) {
            debtorBic = bic.getValue();
        }
        String debtor = "";
        if (tx.getDbtr() != null && tx.getDbtr().getNm() != null) {
            debtor = tx.getDbtr().getNm().getValue();
        }
        String debtorIban = "";
        if (tx.getDbtrAcct() != null) {
            debtorIban = tx.getDbtrAcct().getId().getIBAN().getValue();
        }
        String ultimateDebtor = null;
        if (tx.getUltmtDbtr() != null && tx.getUltmtDbtr().getNm() != null) {
            ultimateDebtor = tx.getUltmtDbtr().getNm().getValue();
        }
        String creditorBic = "";
        if (tx.getCdtrAgt() != null && (bic2 = tx.getCdtrAgt().getFinInstnId().getChoice1().getBIC()) != null) {
            creditorBic = bic2.getValue();
        }
        String creditor = "";
        if (tx.getCdtr() != null && tx.getCdtr().getNm() != null) {
            creditor = tx.getCdtr().getNm().getValue();
        }
        String creditorIban = "";
        if (tx.getCdtrAcct() != null) {
            creditorIban = tx.getCdtrAcct().getId().getIBAN().getValue();
        }
        String ultimateCreditor = "";
        if (tx.getUltmtCdtr() != null && tx.getUltmtCdtr().getNm() != null) {
            ultimateCreditor = tx.getUltmtCdtr().getNm().getValue();
        }
        BigDecimal amount = tx.getAmt() != null ? tx.getAmt().getInstdAmt().getValue() : null;
        Currency currency = tx.getAmt() != null ? Currency.getInstance(tx.getAmt().getInstdAmt().getCcy().getValue()) : null;
        String purpose = "";
        if (tx.getRmtInf() != null) {
            RemittanceInformationSEPA2Choice.RemittanceInformationSEPA2Choice_C1 choice = tx.getRmtInf().getChoice1();
            if (choice.getUstrd() != null) {
                purpose = choice.getUstrd().getValue();
            } else if (choice.getStrd() != null) {
                purpose = "";
            }
        }
        String endToEndId = "";
        if (transactionInfo.getOrgnlEndToEndId() != null) {
            endToEndId = transactionInfo.getOrgnlEndToEndId().getValue();
        }
        String instructionId = "";
        if (transactionInfo.getOrgnlInstrId() != null) {
            instructionId = transactionInfo.getOrgnlInstrId().getValue();
        }
        String paymentCategory = null;
        PaymentTypeInformationSEPA pmtTpInf = tx.getPmtTpInf();
        if (pmtTpInf != null && pmtTpInf.getCtgyPurp() != null) {
            paymentCategory = pmtTpInf.getCtgyPurp().getCd().getValue();
        }
        String debitType = null;
        String sequenceType = null;
        String creditorId = null;
        String mandateId = null;
        YYMMDD mandateSignDate = null;
        if (pmtTpInf != null) {
            if (pmtTpInf.getLclInstrm() != null) {
                debitType = pmtTpInf.getLclInstrm().getCd().getValue();
            }
            if (pmtTpInf.getSeqTp() != null) {
                sequenceType = pmtTpInf.getSeqTp().getValue();
            }
        }
        if (tx.getCdtrSchmeId() != null) {
            isDirectDebitReport = true;
            creditorId = tx.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue();
        }
        if ((mndtRltdInf = tx.getMndtRltdInf()) != null) {
            isDirectDebitReport = true;
            if (mndtRltdInf.getMndtId() != null) {
                mandateId = mndtRltdInf.getMndtId().getValue();
            }
            if (mndtRltdInf.getDtOfSgntr() != null) {
                mandateSignDate = mndtRltdInf.getDtOfSgntr().getDate();
            }
        }
        if (!isDirectDebitReport) {
            orig = debtor;
            origIban = debtorIban;
            origBic = debtorBic;
            ultimateOrig = ultimateDebtor;
            recip = creditor;
            recipIban = creditorIban;
            recipBic = creditorBic;
            ultimateRecip = ultimateCreditor;
        } else {
            orig = creditor;
            origIban = creditorIban;
            origBic = creditorBic;
            ultimateOrig = ultimateCreditor;
            recip = debtor;
            recipIban = debtorIban;
            recipBic = debtorBic;
            ultimateRecip = ultimateDebtor;
        }
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, currency, executionDate, purpose, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
    }

    private static String getOriginatorBic(GroupHeaderSEPA gh) {
        GroupHeaderSEPA.GroupHeaderSEPA_C1 choice = gh.getChoice1();
        if (choice != null) {
            if (choice.getDbtrAgt() != null) {
                return choice.getDbtrAgt().getFinInstnId().getBIC().getValue();
            }
            if (choice.getCdtrAgt() != null) {
                return choice.getCdtrAgt().getFinInstnId().getBIC().getValue();
            }
        }
        return null;
    }

    private static int getNbOfTxs(Max15NumericText nbOfTxs) {
        try {
            if (nbOfTxs != null) {
                String s = StringUtils.removeLeadingChars(nbOfTxs.getValue(), '0');
                return Integer.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static BigDecimal getCtrlSum(DecimalNumber ctrlSum) {
        if (ctrlSum != null) {
            return ctrlSum.getValue();
        }
        return null;
    }

    private static String getStatusCode(TransactionGroupStatusCodeSEPA statusCode) {
        if (statusCode != null) {
            return statusCode.getValue();
        }
        return null;
    }

    private static String getStatusCode(TransactionIndividualStatusCodeSEPA statusCode) {
        if (statusCode != null) {
            return statusCode.getValue();
        }
        return null;
    }

    private static List<StatusReason> getStatusReasons(List<StatusReasonInformationSEPA> reasonInfos) {
        ArrayList<StatusReason> statusReasons = null;
        if (reasonInfos != null && reasonInfos.size() > 0) {
            statusReasons = new ArrayList<StatusReason>();
            for (StatusReasonInformationSEPA reasonInfo : reasonInfos) {
                ExternalStatusReason1Code cd;
                StatusReason statusReason = new StatusReason();
                StatusReasonSEPA reason = reasonInfo.getRsn();
                if (reason != null && (cd = reason.getCd()) != null) {
                    statusReason.setStatusReasonCode(cd.getValue());
                }
                statusReasons.add(statusReason);
            }
        }
        return statusReasons;
    }
}

