/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.iso20022.pain00200103.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00200103.BICIdentifier;
import de.businesslogics.format.iso20022.pain00200103.CustomerPaymentStatusReportV03;
import de.businesslogics.format.iso20022.pain00200103.DecimalNumber;
import de.businesslogics.format.iso20022.pain00200103.Document;
import de.businesslogics.format.iso20022.pain00200103.ExternalStatusReason1Code;
import de.businesslogics.format.iso20022.pain00200103.GenericPersonIdentification1;
import de.businesslogics.format.iso20022.pain00200103.GroupHeader36;
import de.businesslogics.format.iso20022.pain00200103.IBAN2007Identifier;
import de.businesslogics.format.iso20022.pain00200103.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00200103.MandateRelatedInformation6;
import de.businesslogics.format.iso20022.pain00200103.Max105Text;
import de.businesslogics.format.iso20022.pain00200103.Max140Text;
import de.businesslogics.format.iso20022.pain00200103.Max15NumericText;
import de.businesslogics.format.iso20022.pain00200103.NumberOfTransactionsPerStatus3;
import de.businesslogics.format.iso20022.pain00200103.OriginalGroupInformation20;
import de.businesslogics.format.iso20022.pain00200103.OriginalPaymentInformation1;
import de.businesslogics.format.iso20022.pain00200103.OriginalTransactionReference13;
import de.businesslogics.format.iso20022.pain00200103.PartyIdentification32;
import de.businesslogics.format.iso20022.pain00200103.PaymentTransactionInformation25;
import de.businesslogics.format.iso20022.pain00200103.PaymentTypeInformation22;
import de.businesslogics.format.iso20022.pain00200103.StatusReason6Choice;
import de.businesslogics.format.iso20022.pain00200103.StatusReasonInformation8;
import de.businesslogics.format.iso20022.pain00200103.TransactionGroupStatus3Code;
import de.businesslogics.format.iso20022.pain00200103.TransactionIndividualStatus3Code;
import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.StatusTransactionInfo;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SEPAReportExtractorV3Iso {
    protected static RejectedSEPAOrder getRejectedOrder(Document document) {
        CustomerPaymentStatusReportV03 report = document.getCstmrPmtStsRpt();
        GroupHeader36 groupHeader = report.getGrpHdr();
        String msgId = groupHeader.getMsgId().getValue();
        Date creationDate = groupHeader.getCreDtTm().getDate();
        String originatorBic = SEPAReportExtractorV3Iso.getOriginatorBic(groupHeader);
        OriginalGroupInformation20 orgnlGrpInfAndSts = report.getOrgnlGrpInfAndSts();
        String orgnlMsgId = orgnlGrpInfAndSts.getOrgnlMsgId().getValue();
        String orgnlMsgName = orgnlGrpInfAndSts.getOrgnlMsgNmId().getValue();
        boolean isDirectDebitReport = orgnlMsgName != null && orgnlMsgName.startsWith("pain.008");
        RejectedSEPAOrder rejectedOrder = new RejectedSEPAOrder(msgId, creationDate, originatorBic, orgnlMsgId, orgnlMsgName, SEPAReportExtractorV3Iso.getCtrlSum(orgnlGrpInfAndSts.getOrgnlCtrlSum()), SEPAReportExtractorV3Iso.getNbOfTxs(orgnlGrpInfAndSts.getOrgnlNbOfTxs()), SEPAReportExtractorV3Iso.getStatusCode(orgnlGrpInfAndSts.getGrpSts()), SEPAReportExtractorV3Iso.getStatusReasons(orgnlGrpInfAndSts.getStsRsnInfs()));
        List<OriginalPaymentInformation1> orgnlPmtInfs = report.getOrgnlPmtInfAndStss();
        if (orgnlPmtInfs != null && orgnlPmtInfs.size() > 0) {
            ArrayList<RejectedSEPALogicalFile> rejectedLogicalFiles = new ArrayList<RejectedSEPALogicalFile>();
            for (OriginalPaymentInformation1 orgnlPmtInf : orgnlPmtInfs) {
                String orgnlPmtInfId = orgnlPmtInf.getOrgnlPmtInfId().getValue();
                RejectedSEPALogicalFile logicalFile = new RejectedSEPALogicalFile(orgnlPmtInfId, SEPAReportExtractorV3Iso.getNbOfTxs(orgnlPmtInf.getOrgnlNbOfTxs()), SEPAReportExtractorV3Iso.getCtrlSum(orgnlPmtInf.getOrgnlCtrlSum()), SEPAReportExtractorV3Iso.getStatusCode(orgnlPmtInf.getPmtInfSts()), SEPAReportExtractorV3Iso.getStatusReasons(orgnlPmtInf.getStsRsnInfs()));
                List<NumberOfTransactionsPerStatus3> txsPerStsList2 = orgnlPmtInf.getNbOfTxsPerStss();
                for (NumberOfTransactionsPerStatus3 txsPerSts : txsPerStsList2) {
                    int nbOfTxs = SEPAReportExtractorV3Iso.getNbOfTxs(txsPerSts.getDtldNbOfTxs());
                    String sts = SEPAReportExtractorV3Iso.getStatusCode(txsPerSts.getDtldSts());
                    BigDecimal ctrlSum = SEPAReportExtractorV3Iso.getCtrlSum(txsPerSts.getDtldCtrlSum());
                    logicalFile.addStatusTransactionInfo(new StatusTransactionInfo(sts, nbOfTxs, ctrlSum));
                }
                List<PaymentTransactionInformation25> txInfs = orgnlPmtInf.getTxInfAndStss();
                if (txInfs != null && txInfs.size() > 0) {
                    for (PaymentTransactionInformation25 txInf : txInfs) {
                        SEPAPaymentData data = SEPAReportExtractorV3Iso.getPaymentData(txInf, isDirectDebitReport);
                        if (data == null) continue;
                        logicalFile.addPayment(new RejectedSEPAPayment(data, SEPAReportExtractorV3Iso.getStatusCode(txInf.getTxSts()), SEPAReportExtractorV3Iso.getStatusReasons(txInf.getStsRsnInfs())));
                    }
                }
                rejectedLogicalFiles.add(logicalFile);
            }
            rejectedOrder.setRejectedLogicalFiles(rejectedLogicalFiles);
        }
        return rejectedOrder;
    }

    private static String getOriginatorBic(GroupHeader36 gh) {
        if (gh.getDbtrAgt() != null && gh.getDbtrAgt().getFinInstnId().getBIC() != null) {
            return gh.getDbtrAgt().getFinInstnId().getBIC().getValue();
        }
        if (gh.getCdtrAgt() != null && gh.getCdtrAgt().getFinInstnId().getBIC() != null) {
            return gh.getCdtrAgt().getFinInstnId().getBIC().getValue();
        }
        return null;
    }

    private static int getNbOfTxs(Max15NumericText nbOfTxs) {
        try {
            if (nbOfTxs != null) {
                String s = StringUtils.removeLeadingChars(nbOfTxs.getValue(), '0');
                return Integer.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static BigDecimal getCtrlSum(DecimalNumber ctrlSum) {
        if (ctrlSum != null) {
            return ctrlSum.getValue();
        }
        return null;
    }

    private static String getStatusCode(TransactionGroupStatus3Code statusCode) {
        if (statusCode != null) {
            return statusCode.getValue();
        }
        return null;
    }

    private static String getStatusCode(TransactionIndividualStatus3Code statusCode) {
        if (statusCode != null) {
            return statusCode.getValue();
        }
        return null;
    }

    private static List<StatusReason> getStatusReasons(List<StatusReasonInformation8> reasonInfos) {
        ArrayList<StatusReason> statusReasons = null;
        if (reasonInfos != null && reasonInfos.size() > 0) {
            statusReasons = new ArrayList<StatusReason>();
            for (StatusReasonInformation8 reasonInfo : reasonInfos) {
                List<Max105Text> addtlInfs;
                StatusReason statusReason = new StatusReason();
                StatusReason6Choice reason = reasonInfo.getRsn();
                if (reason != null) {
                    ExternalStatusReason1Code cd = reason.getChoice1().getCd();
                    if (cd != null) {
                        statusReason.setStatusReasonCode(cd.getValue());
                    } else if (reason.getChoice1().getPrtry() != null) {
                        statusReason.setStatusReasonCode(reason.getChoice1().getPrtry().getValue());
                    }
                }
                if ((addtlInfs = reasonInfo.getAddtlInfs()) != null && addtlInfs.size() > 0) {
                    for (Max105Text addtlInf : addtlInfs) {
                        statusReason.addAdditionalInfo(addtlInf.getValue());
                    }
                }
                statusReasons.add(statusReason);
            }
        }
        return statusReasons;
    }

    private static SEPAPaymentData getPaymentData(PaymentTransactionInformation25 transactionInfo, boolean isDirectDebitReport) {
        String ultimateRecip;
        String recipBic;
        String recipIban;
        String recip;
        String ultimateOrig;
        String origBic;
        String origIban;
        String orig;
        MandateRelatedInformation6 mndtRltdInf;
        PartyIdentification32 cdtrSchemeId;
        List<Max140Text> ustrds;
        BICIdentifier bic2;
        IBAN2007Identifier iban;
        BICIdentifier bic;
        String msgId = null;
        String initParty = null;
        OriginalTransactionReference13 tx = transactionInfo.getOrgnlTxRef();
        if (tx == null) {
            return null;
        }
        YYMMDD executionDate = null;
        if (tx.getReqdColltnDt() != null) {
            executionDate = tx.getReqdColltnDt().getDate();
            isDirectDebitReport = true;
        } else if (tx.getReqdExctnDt() != null) {
            executionDate = tx.getReqdExctnDt().getDate();
        }
        String debtorBic = "";
        if (tx.getDbtrAgt() != null && (bic = tx.getDbtrAgt().getFinInstnId().getBIC()) != null) {
            debtorBic = bic.getValue();
        }
        String debtor = "";
        if (tx.getDbtr() != null && tx.getDbtr().getNm() != null) {
            debtor = tx.getDbtr().getNm().getValue();
        }
        String debtorIban = "";
        if (tx.getDbtrAcct() != null && (iban = tx.getDbtrAcct().getId().getChoice1().getIBAN()) != null) {
            debtorIban = iban.getValue();
        }
        String ultimateDebtor = null;
        if (tx.getUltmtDbtr() != null && tx.getUltmtDbtr().getNm() != null) {
            ultimateDebtor = tx.getUltmtDbtr().getNm().getValue();
        }
        String creditorBic = "";
        if (tx.getCdtrAgt() != null && (bic2 = tx.getCdtrAgt().getFinInstnId().getBIC()) != null) {
            creditorBic = bic2.getValue();
        }
        String creditor = "";
        if (tx.getCdtr() != null && tx.getCdtr().getNm() != null) {
            creditor = tx.getCdtr().getNm().getValue();
        }
        String creditorIban = "";
        if (tx.getCdtrAcct() != null) {
            AccountIdentification4Choice.AccountIdentification4Choice_C1 choice = tx.getCdtrAcct().getId().getChoice1();
            if (choice.getIBAN() != null) {
                creditorIban = choice.getIBAN().getValue();
            } else if (choice.getOthr() != null) {
                creditorIban = choice.getOthr().getId().getValue();
            }
        }
        String ultimateCreditor = "";
        if (tx.getUltmtCdtr() != null && tx.getUltmtCdtr().getNm() != null) {
            ultimateCreditor = tx.getUltmtCdtr().getNm().getValue();
        }
        BigDecimal amount = tx.getAmt() != null && tx.getAmt().getChoice1().getInstdAmt() != null ? tx.getAmt().getChoice1().getInstdAmt().getValue() : null;
        Currency currency = tx.getAmt() != null && tx.getAmt().getChoice1().getInstdAmt() != null && tx.getAmt().getChoice1().getInstdAmt().getCcy() != null ? Currency.getInstance(tx.getAmt().getChoice1().getInstdAmt().getCcy().getValue()) : null;
        StringBuffer purpose = new StringBuffer();
        if (tx.getRmtInf() != null && (ustrds = tx.getRmtInf().getUstrds()) != null && ustrds.size() > 0) {
            for (Max140Text s : ustrds) {
                if (s == null) continue;
                purpose.append(s.getValue());
            }
        }
        String endToEndId = "";
        if (transactionInfo.getOrgnlEndToEndId() != null) {
            endToEndId = transactionInfo.getOrgnlEndToEndId().getValue();
        }
        String instructionId = "";
        if (transactionInfo.getOrgnlInstrId() != null) {
            instructionId = transactionInfo.getOrgnlInstrId().getValue();
        }
        String paymentCategory = null;
        PaymentTypeInformation22 pmtTpInf = tx.getPmtTpInf();
        if (pmtTpInf != null && pmtTpInf.getCtgyPurp() != null && pmtTpInf.getCtgyPurp().getChoice1().getCd() != null) {
            paymentCategory = pmtTpInf.getCtgyPurp().getChoice1().getCd().getValue();
        }
        String debitType = null;
        String sequenceType = null;
        String creditorId = null;
        String mandateId = null;
        YYMMDD mandateSignDate = null;
        if (pmtTpInf != null) {
            if (pmtTpInf.getLclInstrm() != null && pmtTpInf.getLclInstrm().getChoice1().getCd() != null) {
                debitType = pmtTpInf.getLclInstrm().getChoice1().getCd().getValue();
            }
            if (pmtTpInf.getSeqTp() != null) {
                sequenceType = pmtTpInf.getSeqTp().getValue();
            }
        }
        if ((cdtrSchemeId = tx.getCdtrSchmeId()) != null) {
            List<GenericPersonIdentification1> others;
            isDirectDebitReport = true;
            if (cdtrSchemeId.getId() != null && cdtrSchemeId.getId().getChoice1().getPrvtId() != null && (others = cdtrSchemeId.getId().getChoice1().getPrvtId().getOthrs()).size() > 0) {
                creditorId = others.get(0).getId().getValue();
            }
        }
        if ((mndtRltdInf = tx.getMndtRltdInf()) != null) {
            isDirectDebitReport = true;
            if (mndtRltdInf.getMndtId() != null) {
                mandateId = mndtRltdInf.getMndtId().getValue();
            }
            if (mndtRltdInf.getDtOfSgntr() != null) {
                mandateSignDate = mndtRltdInf.getDtOfSgntr().getDate();
            }
        }
        if (!isDirectDebitReport) {
            orig = debtor;
            origIban = debtorIban;
            origBic = debtorBic;
            ultimateOrig = ultimateDebtor;
            recip = creditor;
            recipIban = creditorIban;
            recipBic = creditorBic;
            ultimateRecip = ultimateCreditor;
        } else {
            orig = creditor;
            origIban = creditorIban;
            origBic = creditorBic;
            ultimateOrig = ultimateCreditor;
            recip = debtor;
            recipIban = debtorIban;
            recipBic = debtorBic;
            ultimateRecip = ultimateDebtor;
        }
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, currency, executionDate, purpose.toString(), paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
    }

    public static boolean isInstantPaymentReport(Document document) {
        LocalInstrument2Choice c;
        OriginalPaymentInformation1 pmtInf;
        List<PaymentTransactionInformation25> txInfList;
        List<OriginalPaymentInformation1> pmtInfList = document.getCstmrPmtStsRpt().getOrgnlPmtInfAndStss();
        if (pmtInfList.size() > 0 && (txInfList = (pmtInf = pmtInfList.get(0)).getTxInfAndStss()).size() > 0 && txInfList.get(0).getOrgnlTxRef() != null && txInfList.get(0).getOrgnlTxRef().getPmtTpInf() != null && (c = txInfList.get(0).getOrgnlTxRef().getPmtTpInf().getLclInstrm()) != null && c.getChoice1() != null && c.getChoice1().getCd() != null) {
            return SEPALocalInstrument.INST.name().equals(c.getChoice1().getCd().getValue());
        }
        return false;
    }
}

