/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.iso20022.pain00200110.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00200110.BranchAndFinancialInstitutionIdentification6;
import de.businesslogics.format.iso20022.pain00200110.CashAccount38;
import de.businesslogics.format.iso20022.pain00200110.ClearingSystemIdentification2Choice;
import de.businesslogics.format.iso20022.pain00200110.CustomerPaymentStatusReportV10;
import de.businesslogics.format.iso20022.pain00200110.DateAndDateTime2Choice;
import de.businesslogics.format.iso20022.pain00200110.DecimalNumber;
import de.businesslogics.format.iso20022.pain00200110.Document;
import de.businesslogics.format.iso20022.pain00200110.ExternalPaymentGroupStatus1Code;
import de.businesslogics.format.iso20022.pain00200110.ExternalPaymentTransactionStatus1Code;
import de.businesslogics.format.iso20022.pain00200110.ExternalStatusReason1Code;
import de.businesslogics.format.iso20022.pain00200110.FinancialInstitutionIdentification18;
import de.businesslogics.format.iso20022.pain00200110.GenericPersonIdentification1;
import de.businesslogics.format.iso20022.pain00200110.GroupHeader86;
import de.businesslogics.format.iso20022.pain00200110.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00200110.MandateRelatedInformation14;
import de.businesslogics.format.iso20022.pain00200110.Max105Text;
import de.businesslogics.format.iso20022.pain00200110.Max140Text;
import de.businesslogics.format.iso20022.pain00200110.Max15NumericText;
import de.businesslogics.format.iso20022.pain00200110.NumberOfTransactionsPerStatus5;
import de.businesslogics.format.iso20022.pain00200110.OriginalGroupHeader17;
import de.businesslogics.format.iso20022.pain00200110.OriginalPaymentInstruction32;
import de.businesslogics.format.iso20022.pain00200110.OriginalTransactionReference28;
import de.businesslogics.format.iso20022.pain00200110.Party40Choice;
import de.businesslogics.format.iso20022.pain00200110.PartyIdentification135;
import de.businesslogics.format.iso20022.pain00200110.PaymentTransaction105;
import de.businesslogics.format.iso20022.pain00200110.PaymentTypeInformation27;
import de.businesslogics.format.iso20022.pain00200110.StatusReason6Choice;
import de.businesslogics.format.iso20022.pain00200110.StatusReasonInformation12;
import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.StatusTransactionInfo;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SEPAReportExtractor00200110 {
    protected static RejectedSEPAOrder getRejectedOrder(Document document) {
        CustomerPaymentStatusReportV10 report = document.getCstmrPmtStsRpt();
        GroupHeader86 groupHeader = report.getGrpHdr();
        String msgId = groupHeader.getMsgId().getValue();
        Date creationDate = groupHeader.getCreDtTm().getDate();
        String originatorBic = SEPAReportExtractor00200110.getOriginatorBic(groupHeader);
        OriginalGroupHeader17 orgnlGrpInfAndSts = report.getOrgnlGrpInfAndSts();
        String orgnlMsgId = orgnlGrpInfAndSts.getOrgnlMsgId().getValue();
        String orgnlMsgName = orgnlGrpInfAndSts.getOrgnlMsgNmId().getValue();
        boolean isDirectDebitReport = orgnlMsgName != null && orgnlMsgName.startsWith("pain.008");
        RejectedSEPAOrder rejectedOrder = new RejectedSEPAOrder(msgId, creationDate, originatorBic, orgnlMsgId, orgnlMsgName, SEPAReportExtractor00200110.getCtrlSum(orgnlGrpInfAndSts.getOrgnlCtrlSum()), SEPAReportExtractor00200110.getNbOfTxs(orgnlGrpInfAndSts.getOrgnlNbOfTxs()), SEPAReportExtractor00200110.getStatusCode(orgnlGrpInfAndSts.getGrpSts()), SEPAReportExtractor00200110.getStatusReasons(orgnlGrpInfAndSts.getStsRsnInfs(), null));
        List<NumberOfTransactionsPerStatus5> groupTxsPerStsList = orgnlGrpInfAndSts.getNbOfTxsPerStss();
        for (NumberOfTransactionsPerStatus5 txsPerSts : groupTxsPerStsList) {
            int nbOfTxs = SEPAReportExtractor00200110.getNbOfTxs(txsPerSts.getDtldNbOfTxs());
            String sts = SEPAReportExtractor00200110.getStatusCode(txsPerSts.getDtldSts());
            BigDecimal ctrlSum = SEPAReportExtractor00200110.getCtrlSum(txsPerSts.getDtldCtrlSum());
            rejectedOrder.addGroupStatusTransactionInfo(new StatusTransactionInfo(sts, nbOfTxs, ctrlSum));
        }
        for (StatusReasonInformation12 stsRsnInf : orgnlGrpInfAndSts.getStsRsnInfs()) {
            for (Max105Text addtlInf : stsRsnInf.getAddtlInfs()) {
                rejectedOrder.addVopLegalInfo(addtlInf.getValue());
            }
        }
        List<OriginalPaymentInstruction32> orgnlPmtInfs = report.getOrgnlPmtInfAndStss();
        if (orgnlPmtInfs != null && orgnlPmtInfs.size() > 0) {
            ArrayList<RejectedSEPALogicalFile> rejectedLogicalFiles = new ArrayList<RejectedSEPALogicalFile>();
            for (OriginalPaymentInstruction32 orgnlPmtInf : orgnlPmtInfs) {
                String orgnlPmtInfId = orgnlPmtInf.getOrgnlPmtInfId().getValue();
                RejectedSEPALogicalFile logicalFile = new RejectedSEPALogicalFile(orgnlPmtInfId, SEPAReportExtractor00200110.getNbOfTxs(orgnlPmtInf.getOrgnlNbOfTxs()), SEPAReportExtractor00200110.getCtrlSum(orgnlPmtInf.getOrgnlCtrlSum()), SEPAReportExtractor00200110.getStatusCode(orgnlPmtInf.getPmtInfSts()), SEPAReportExtractor00200110.getStatusReasons(orgnlPmtInf.getStsRsnInfs(), null));
                for (StatusReasonInformation12 statusReasonInformation12 : orgnlGrpInfAndSts.getStsRsnInfs()) {
                    for (Max105Text addtlInf : statusReasonInformation12.getAddtlInfs()) {
                        logicalFile.addVopLegalInfo(addtlInf.getValue());
                    }
                }
                List<NumberOfTransactionsPerStatus5> txsPerStsList2 = orgnlPmtInf.getNbOfTxsPerStss();
                for (NumberOfTransactionsPerStatus5 txsPerSts : txsPerStsList2) {
                    int nbOfTxs = SEPAReportExtractor00200110.getNbOfTxs(txsPerSts.getDtldNbOfTxs());
                    String sts = SEPAReportExtractor00200110.getStatusCode(txsPerSts.getDtldSts());
                    BigDecimal ctrlSum = SEPAReportExtractor00200110.getCtrlSum(txsPerSts.getDtldCtrlSum());
                    logicalFile.addStatusTransactionInfo(new StatusTransactionInfo(sts, nbOfTxs, ctrlSum));
                }
                List<PaymentTransaction105> list = orgnlPmtInf.getTxInfAndStss();
                if (list != null && list.size() > 0) {
                    for (PaymentTransaction105 txInf : list) {
                        String status;
                        SEPAPaymentData data = SEPAReportExtractor00200110.getPaymentData(txInf, isDirectDebitReport);
                        String string = status = txInf.getTxSts() != null ? txInf.getTxSts().getValue() : null;
                        if (data == null) continue;
                        logicalFile.addPayment(new RejectedSEPAPayment(data, SEPAReportExtractor00200110.getStatusCode(txInf.getTxSts()), SEPAReportExtractor00200110.getStatusReasons(txInf.getStsRsnInfs(), status)));
                    }
                }
                rejectedLogicalFiles.add(logicalFile);
            }
            rejectedOrder.setRejectedLogicalFiles(rejectedLogicalFiles);
        }
        return rejectedOrder;
    }

    private static String getOriginatorBic(GroupHeader86 gh) {
        if (gh.getDbtrAgt() != null && gh.getDbtrAgt().getFinInstnId().getBICFI() != null) {
            return gh.getDbtrAgt().getFinInstnId().getBICFI().getValue();
        }
        if (gh.getCdtrAgt() != null && gh.getCdtrAgt().getFinInstnId().getBICFI() != null) {
            return gh.getCdtrAgt().getFinInstnId().getBICFI().getValue();
        }
        return null;
    }

    private static int getNbOfTxs(Max15NumericText nbOfTxs) {
        try {
            if (nbOfTxs != null) {
                String s = StringUtils.removeLeadingChars(nbOfTxs.getValue(), '0');
                return Integer.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private static BigDecimal getCtrlSum(DecimalNumber ctrlSum) {
        if (ctrlSum != null) {
            return ctrlSum.getValue();
        }
        return null;
    }

    private static String getStatusCode(ExternalPaymentGroupStatus1Code statusCode) {
        if (statusCode != null) {
            return statusCode.getValue();
        }
        return null;
    }

    private static String getStatusCode(ExternalPaymentTransactionStatus1Code statusCode) {
        if (statusCode != null) {
            return statusCode.getValue();
        }
        return null;
    }

    private static List<StatusReason> getStatusReasons(List<StatusReasonInformation12> reasonInfos, String status) {
        ArrayList<StatusReason> statusReasons = null;
        if (reasonInfos != null && reasonInfos.size() > 0) {
            statusReasons = new ArrayList<StatusReason>();
            for (StatusReasonInformation12 reasonInfo : reasonInfos) {
                List<Max105Text> addtlInfs;
                StatusReason statusReason = new StatusReason();
                StatusReason6Choice reason = reasonInfo.getRsn();
                if (reason != null) {
                    ExternalStatusReason1Code cd = reason.getChoice1().getCd();
                    if (cd != null) {
                        statusReason.setStatusReasonCode(cd.getValue());
                    } else if (reason.getChoice1().getPrtry() != null) {
                        statusReason.setStatusReasonCode(reason.getChoice1().getPrtry().getValue());
                    }
                }
                if ((addtlInfs = reasonInfo.getAddtlInfs()) != null && addtlInfs.size() > 0) {
                    if (!"RVMC".equals(status)) {
                        for (Max105Text addtlInf : addtlInfs) {
                            statusReason.addAdditionalInfo(addtlInf.getValue());
                        }
                    } else {
                        for (int i = 0; i < Integer.min(2, addtlInfs.size()); ++i) {
                            Max105Text addtlInf;
                            addtlInf = addtlInfs.get(i);
                            statusReason.addToActualName(addtlInf.getValue());
                        }
                    }
                }
                statusReasons.add(statusReason);
            }
        }
        return statusReasons;
    }

    private static SEPAPaymentData getPaymentData(PaymentTransaction105 transactionInfo, boolean isDirectDebitReport) {
        String ultimateRecip;
        String recipBic;
        String recipIban;
        String recip;
        String ultimateOrig;
        String origBic;
        String origIban;
        String orig;
        MandateRelatedInformation14 mndtRltdInf;
        PartyIdentification135 cdtrSchemeId;
        List<Max140Text> ustrds;
        String msgId = null;
        String initParty = null;
        OriginalTransactionReference28 tx = transactionInfo.getOrgnlTxRef();
        if (tx == null) {
            return null;
        }
        Date executionDate = null;
        if (tx.getReqdColltnDt() != null) {
            executionDate = tx.getReqdColltnDt().getDate();
            isDirectDebitReport = true;
        } else {
            executionDate = SEPAReportExtractor00200110.getExecutionDate(tx.getReqdExctnDt());
        }
        String debtor = SEPAReportExtractor00200110.getPartyName(tx.getDbtr());
        String debtorIban = SEPAReportExtractor00200110.getAccountNumber(tx.getDbtrAcct());
        String debtorBic = SEPAReportExtractor00200110.getBankCode(tx.getDbtrAgt());
        String ultimateDebtor = SEPAReportExtractor00200110.getPartyName(tx.getUltmtDbtr());
        String creditor = SEPAReportExtractor00200110.getPartyName(tx.getCdtr());
        String creditorIban = SEPAReportExtractor00200110.getAccountNumber(tx.getCdtrAcct());
        String creditorBic = SEPAReportExtractor00200110.getBankCode(tx.getCdtrAgt());
        String ultimateCreditor = SEPAReportExtractor00200110.getPartyName(tx.getUltmtCdtr());
        BigDecimal amount = tx.getAmt() != null && tx.getAmt().getChoice1().getInstdAmt() != null ? tx.getAmt().getChoice1().getInstdAmt().getValue() : null;
        Currency currency = tx.getAmt() != null && tx.getAmt().getChoice1().getInstdAmt() != null && tx.getAmt().getChoice1().getInstdAmt().getCcy() != null ? Currency.getInstance(tx.getAmt().getChoice1().getInstdAmt().getCcy().getValue()) : null;
        StringBuffer purpose = new StringBuffer();
        if (tx.getRmtInf() != null && (ustrds = tx.getRmtInf().getUstrds()) != null && ustrds.size() > 0) {
            for (Max140Text s : ustrds) {
                if (s == null) continue;
                purpose.append(s.getValue());
            }
        }
        String endToEndId = "";
        if (transactionInfo.getOrgnlEndToEndId() != null) {
            endToEndId = transactionInfo.getOrgnlEndToEndId().getValue();
        }
        String instructionId = "";
        if (transactionInfo.getOrgnlInstrId() != null) {
            instructionId = transactionInfo.getOrgnlInstrId().getValue();
        }
        String paymentCategory = null;
        PaymentTypeInformation27 pmtTpInf = tx.getPmtTpInf();
        if (pmtTpInf != null && pmtTpInf.getCtgyPurp() != null && pmtTpInf.getCtgyPurp().getChoice1().getCd() != null) {
            paymentCategory = pmtTpInf.getCtgyPurp().getChoice1().getCd().getValue();
        }
        String debitType = null;
        String sequenceType = null;
        String creditorId = null;
        String mandateId = null;
        YYMMDD mandateSignDate = null;
        if (pmtTpInf != null) {
            if (pmtTpInf.getLclInstrm() != null && pmtTpInf.getLclInstrm().getChoice1().getCd() != null) {
                debitType = pmtTpInf.getLclInstrm().getChoice1().getCd().getValue();
            }
            if (pmtTpInf.getSeqTp() != null) {
                sequenceType = pmtTpInf.getSeqTp().getValue();
            }
        }
        if ((cdtrSchemeId = tx.getCdtrSchmeId()) != null) {
            List<GenericPersonIdentification1> others;
            isDirectDebitReport = true;
            if (cdtrSchemeId.getId() != null && tx.getCdtrSchmeId().getId().getChoice1().getPrvtId() != null && (others = cdtrSchemeId.getId().getChoice1().getPrvtId().getOthrs()).size() > 0) {
                creditorId = others.get(0).getId().getValue();
            }
        }
        if ((mndtRltdInf = tx.getMndtRltdInf()) != null) {
            isDirectDebitReport = true;
            if (mndtRltdInf.getMndtId() != null) {
                mandateId = mndtRltdInf.getMndtId().getValue();
            }
            if (mndtRltdInf.getDtOfSgntr() != null) {
                mandateSignDate = mndtRltdInf.getDtOfSgntr().getDate();
            }
        }
        if (!isDirectDebitReport) {
            orig = debtor;
            origIban = debtorIban;
            origBic = debtorBic;
            ultimateOrig = ultimateDebtor;
            recip = creditor;
            recipIban = creditorIban;
            recipBic = creditorBic;
            ultimateRecip = ultimateCreditor;
        } else {
            orig = creditor;
            origIban = creditorIban;
            origBic = creditorBic;
            ultimateOrig = ultimateCreditor;
            recip = debtor;
            recipIban = debtorIban;
            recipBic = debtorBic;
            ultimateRecip = ultimateDebtor;
        }
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, currency, executionDate, purpose.toString(), paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
    }

    private static String getPartyName(Party40Choice choice) {
        Party40Choice.Party40Choice_C1 c1;
        if (choice != null && (c1 = choice.getChoice1()).getPty() != null && c1.getPty().getNm() != null) {
            return c1.getPty().getNm().getValue();
        }
        return "";
    }

    private static String getAccountNumber(CashAccount38 choice) {
        if (choice != null) {
            AccountIdentification4Choice.AccountIdentification4Choice_C1 c = choice.getId().getChoice1();
            if (c.getIBAN() != null) {
                return c.getIBAN().getValue();
            }
            if (c.getOthr() != null) {
                return c.getOthr().getId().getValue();
            }
        }
        return "";
    }

    private static String getBankCode(BranchAndFinancialInstitutionIdentification6 choice) {
        if (choice != null) {
            FinancialInstitutionIdentification18 c = choice.getFinInstnId();
            if (c.getBICFI() != null) {
                return c.getBICFI().getValue();
            }
            if (c.getOthr() != null) {
                return c.getOthr().getId().getValue();
            }
            if (c.getClrSysMmbId() != null) {
                ClearingSystemIdentification2Choice clrSysId = c.getClrSysMmbId().getClrSysId();
                if (clrSysId != null && clrSysId.getChoice1().getCd() != null) {
                    return clrSysId.getChoice1().getCd().getValue() + "/" + c.getClrSysMmbId().getMmbId().getValue();
                }
                return c.getClrSysMmbId().getMmbId().getValue();
            }
        }
        return "";
    }

    private static Date getExecutionDate(DateAndDateTime2Choice choice) {
        if (choice != null) {
            DateAndDateTime2Choice.DateAndDateTime2Choice_C1 c = choice.getChoice1();
            if (c.getDt() != null) {
                return c.getDt().getDate();
            }
            if (c.getDtTm() != null) {
                return c.getDtTm().getDate();
            }
        }
        return null;
    }

    public static boolean isInstantPaymentReport(Document document) {
        LocalInstrument2Choice c;
        OriginalPaymentInstruction32 pmtInf;
        List<PaymentTransaction105> txInfList;
        List<OriginalPaymentInstruction32> pmtInfList = document.getCstmrPmtStsRpt().getOrgnlPmtInfAndStss();
        if (pmtInfList.size() > 0 && (txInfList = (pmtInf = pmtInfList.get(0)).getTxInfAndStss()).size() > 0 && txInfList.get(0).getOrgnlTxRef() != null && txInfList.get(0).getOrgnlTxRef().getPmtTpInf() != null && (c = txInfList.get(0).getOrgnlTxRef().getPmtTpInf().getLclInstrm()) != null && c.getChoice1() != null && c.getChoice1().getCd() != null) {
            return SEPALocalInstrument.INST.name().equals(c.getChoice1().getCd().getValue());
        }
        return false;
    }

    public static boolean isVopReport(Document document, boolean defaultValue) {
        String[] vopSpecificCodes = new String[]{"RCVC", "RVNM", "RVMC", "RVNA"};
        List<NumberOfTransactionsPerStatus5> nbOfTxsPerStss = document.getCstmrPmtStsRpt().getOrgnlGrpInfAndSts().getNbOfTxsPerStss();
        for (NumberOfTransactionsPerStatus5 nbOfTxsPerSts : nbOfTxsPerStss) {
            for (String statusCode : vopSpecificCodes) {
                if (!statusCode.equals(nbOfTxsPerSts.getDtldSts().getValue())) continue;
                return true;
            }
            if ("PDNG".equals(nbOfTxsPerSts.getDtldSts().getValue())) continue;
            return false;
        }
        return defaultValue;
    }
}

