/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SEPAPurposeCode {
    private static final Map<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();
    private static final String[] PURPOSE_CODES = new String[]{"ACCT", "ADCS", "ADMG", "ADVA", "AEMP", "AGRT", "AIRB", "ALLW", "ALMY", "AMEX", "ANNI", "ANTS", "AREN", "AUCO", "B112", "BBSC", "BCDM", "BCFG", "BECH", "BENE", "BEXP", "BFWD", "BKDF", "BKFE", "BKFM", "BKIP", "BKPP", "BLDM", "BNET", "BOCE", "BOND", "BONU", "BR12", "BUSB", "CABD", "CAEQ", "CAFI", "CASH", "CBCR", "CBFF", "CBFR", "CBLK", "CBTV", "CCHD", "CCIR", "CCPC", "CCPM", "CCRD", "CCSM", "CDBL", "CDCB", "CDCD", "CDCS", "CDDP", "CDEP", "CDOC", "CDQC", "CFDI", "CFEE", "CGDD", "CHAR", "CLPR", "CMDT", "COLL", "COMC", "COMM", "COMP", "COMT", "CORT", "COST", "CPEN", "CPKC", "CPYR", "CRDS", "CRPR", "CRSP", "CRTL", "CSDB", "CSLP", "CVCF", "DBCR", "DBTC", "DCRD", "DEBT", "DEPD", "DEPT", "DERI", "DICL", "DIVD", "DMEQ", "DNTS", "DSMT", "DVPM", "ECPG", "ECPR", "ECPU", "EDUC", "EFTC", "EFTD", "ELEC", "ENRG", "EPAY", "EQPT", "EQTS", "EQUS", "ESTX", "ETUP", "EXPT", "EXTD", "FACT", "FAND", "FCOL", "FCPM", "FEES", "FERB", "FIXI", "FLCR", "FNET", "FORW", "FREX", "FUTR", "FWBC", "FWCC", "FWLV", "FWSB", "FWSC", "FXNT", "GAFA", "GAHO", "GAMB", "GASB", "GDDS", "GDSV", "GFRP", "GIFT", "GOVI", "GOVT", "GSCB", "GSTX", "GVEA", "GVEB", "GVEC", "GVED", "GWLT", "HEDG", "HLRP", "HLST", "HLTC", "HLTI", "HREC", "HSPC", "HSTX", "ICCP", "ICRF", "IDCP", "IHRP", "INPC", "INPR", "INSC", "INSM", "INSU", "INTC", "INTE", "INTP", "INTX", "INVS", "IPAY", "IPCA", "IPDO", "IPEA", "IPEC", "IPEW", "IPPS", "IPRT", "IPU2", "IPUW", "IVPT", "LBIN", "LBRI", "LCOL", "LFEE", "LICF", "LIFI", "LIMA", "LMEQ", "LMFI", "LMRK", "LOAN", "LOAR", "LOTT", "LREB", "LREV", "LSFL", "LTCF", "MAFC", "MARF", "MARG", "MBSB", "MBSC", "MCDM", "MCFG", "MDCS", "MGCC", "MGSC", "MOMA", "MP2B", "MP2P", "MSVC", "MTUP", "NETT", "NITX", "NOWS", "NWCH", "NWCM", "OCCC", "OCDM", "OCFG", "OFEE", "OPBC", "OPCC", "OPSB", "OPSC", "OPTN", "OTCD", "OTHR", "OTLC", "PADD", "PAYR", "PCOM", "PDEP", "PEFC", "PENO", "PENS", "PHON", "PLDS", "PLRF", "POPE", "PPTI", "PRCP", "PRME", "PTSP", "PTXP", "RAPI", "RCKE", "RCPT", "RDTX", "REBT", "REFU", "RELG", "RENT", "REOD", "REPO", "RETL", "RHBS", "RIMB", "RINP", "RLWY", "RMCO", "ROYA", "RPBC", "RPCC", "RPNT", "RPSB", "RPSC", "RRBN", "RRCT", "RRTP", "RVPM", "RVPO", "SALA", "SASW", "SAVG", "SBSC", "SCIE", "SCIR", "SCRP", "SCVE", "SECU", "SEPI", "SERV", "SHBC", "SHCC", "SHSL", "SLEB", "SLOA", "SLPI", "SPLT", "SPSP", "SSBE", "STDY", "SUBS", "SUPP", "SWBC", "SWCC", "SWFP", "SWPP", "SWPT", "SWRS", "SWSB", "SWSC", "SWUF", "TAXR", "TAXS", "TBAN", "TBAS", "TBBC", "TBCC", "TBIL", "TCSC", "TELI", "TLRF", "TLRR", "TMPG", "TPRI", "TPRP", "TRAD", "TRCP", "TREA", "TRFD", "TRNC", "TRPT", "TRVC", "UBIL", "UNIT", "VATX", "VIEW", "WEBI", "WHLD", "WTER"};
    private static final String[] PURPOSE_CODES_WITHOUT_SALARIES;
    private static final String[] URGENT_PAYMENT_PURPOSE_CODES;
    private static final String[] URGENT_PAYMENT_PURPOSE_CODES_WITHOUT_SALARIES;

    public static String[] getPurposeCodes(boolean withSalaries) {
        if (withSalaries) {
            return PURPOSE_CODES;
        }
        return PURPOSE_CODES_WITHOUT_SALARIES;
    }

    @Deprecated
    public static String[] getUrgentPaymentPurposeCodes() {
        return SEPAPurposeCode.getUrgentPaymentPurposeCodes(false);
    }

    public static String[] getUrgentPaymentPurposeCodes(boolean withSalaries) {
        if (withSalaries) {
            return URGENT_PAYMENT_PURPOSE_CODES;
        }
        return URGENT_PAYMENT_PURPOSE_CODES_WITHOUT_SALARIES;
    }

    public static String getDescription(String purposeCode) {
        return SEPAPurposeCode.getDescription(purposeCode, Locale.getDefault());
    }

    public static String getDescription(String purposeCode, Locale locale) {
        if (purposeCode != null) {
            try {
                return SEPAPurposeCode.getBundle(locale).getString(purposeCode).trim();
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle result = bundles.get(locale);
        if (result == null) {
            result = ResourceBundle.getBundle("de.businesslogics.format.sepa.SEPAPurposeCode", locale);
            bundles.put(locale, result);
        }
        return result;
    }

    static {
        URGENT_PAYMENT_PURPOSE_CODES = new String[]{"BONU", "CORT", "INTC", "PENS", "SALA"};
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(PURPOSE_CODES));
        tmp.remove("BONU");
        tmp.remove("PENS");
        tmp.remove("SALA");
        PURPOSE_CODES_WITHOUT_SALARIES = tmp.toArray(new String[0]);
        tmp = new ArrayList<String>(Arrays.asList(URGENT_PAYMENT_PURPOSE_CODES));
        tmp.remove("BONU");
        tmp.remove("PENS");
        tmp.remove("SALA");
        URGENT_PAYMENT_PURPOSE_CODES_WITHOUT_SALARIES = tmp.toArray(new String[0]);
    }
}

