/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.ChequeInstructionData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.RegReporting;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SEPAPaymentData
implements Cloneable {
    public static final int MAX_LENGTH_INITIATING_PARTY = 70;
    public static final int MAX_LENGTH_ORIGINATOR = 70;
    public static final int MAX_LENGTH_ULTIMATE_ORIGINATOR = 70;
    public static final int MAX_LENGTH_RECIPIENT = 70;
    public static final int MAX_LENGTH_ULTIMATE_RECIPIENT = 70;
    public static final int MAX_LENGTH_STRUCTURED_PURPOSE = 35;
    public static final int MAX_LENGTH_PURPOSE = 140;
    public static final int MAX_LENGTH_END_TO_END_ID = 35;
    public static final int MAX_LENGTH_INSTR_ID = 35;
    public static final int MAX_LENGTH_CREDITOR_ID = 35;
    public static final int MAX_LENGTH_MANDATE_ID = 35;
    public static final int MAX_LENGTH_ADDRESS_LINE = 70;
    public static final int MAX_LENGTH_DEPARTMENT = 70;
    public static final int MAX_LENGTH_SUB_DEPARTMENT = 70;
    public static final int MAX_LENGTH_STREET_NAME = 70;
    public static final int MAX_LENGTH_STREET_BUILDING_NUMBER = 16;
    public static final int MAX_LENGTH_POST_CODE = 16;
    public static final int MAX_LENGTH_TOWN_NAME = 35;
    public static final int MAX_LENGTH_COUNTRY_SUB_DIVISION = 35;
    public static boolean batchBookingTagIsMandatory = true;
    private int logicalFileNumber;
    private int paymentNumber;
    private String messageId;
    private String initiatingParty;
    private String originator;
    private String originatorIban;
    private boolean isOriginatorIban = true;
    private String originatorBic;
    private String originatorLei;
    private String originatorAccountType;
    private String ultimateOriginator;
    private boolean hasExecutionTime;
    private Date executionDate;
    private String recipient;
    private String recipientIban;
    private boolean isRecipientIban = true;
    private String recipientBic;
    private String recipientLei;
    private String recipientClearingSystemId;
    private String ultimateRecipient;
    private BigDecimal amount;
    private Currency currency;
    private Currency accountCurrency;
    private Currency counterValueCurrency;
    private String purpose;
    private boolean hasStructuredPurpose = false;
    private final List<String> unstructuredPurposeLines = new ArrayList<String>();
    private final List<String> structuredPurposeLines = new ArrayList<String>();
    private String purposeReference;
    private String purposeReferenceTypeCode;
    private String purposeReferenceTypePrtry;
    private String purposeCode;
    private String chargeBearer = SEPAFeeType.SLEV.name();
    private String endToEndId;
    private String instructionId;
    private String serviceLevel = GeneralSEPAExtractor.SEPA;
    private String localInstrument;
    private String paymentCategory;
    private String instructionPriority;
    private String debitType;
    private String sequenceType;
    private String creditorId;
    private String mandateId;
    private Date mandateSignDate;
    private String originalCreditor;
    private String originalCreditorId;
    private String originalMandateId;
    private boolean recipientBankHasChanged = false;
    private boolean recipientAccountHasChanged = false;
    private String originalRecipientIban;
    private String originalRecipientBic;
    private String pmtInfId = null;
    private boolean displayAsSingleBooking = false;
    private String callbackReason;
    public static final Currency EUR = Currency.getInstance("EUR");
    private AddressData originatorAddressData;
    private AddressData recipientAddressData;
    private String recipientBankName;
    private AddressData recipientBankAddressData;
    private String paymentMethod;
    private ChequeInstructionData chequeInstructionData;
    private final List<RegReporting> regReportings = new ArrayList<RegReporting>();
    private Boolean pmtTpInfOnLFLevel = null;
    private GeneralSEPAWriter.Version sepaVersion = null;
    private String vopResult;
    private String vopName;
    private Timestamp vopDate;
    private String vopReason;
    private static final String SEPARATOR = "|";
    private static final ThreadLocal<SimpleDateFormat> yyyyMMdd = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));
    private static final ThreadLocal<SimpleDateFormat> yyyyMMddHHmmss = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmmss"));

    public SEPAPaymentData() {
    }

    public SEPAPaymentData(String messageId, String initiatingParty, String originator, String originatorIban, String originatorBic, String ultimateOriginator, String recipient, String recipientIban, String recipientBic, String ultimateRecipient, BigDecimal amount, Date executionDate, String purpose, String paymentCategory, String endToEndId, String instructionId) {
        this(messageId, initiatingParty, originator, originatorIban, originatorBic, ultimateOriginator, recipient, recipientIban, recipientBic, ultimateRecipient, amount, EUR, executionDate, purpose, paymentCategory, endToEndId, instructionId, GeneralSEPAExtractor.SEPA);
    }

    public SEPAPaymentData(String messageId, String initiatingParty, String originator, String originatorIban, String originatorBic, String ultimateOriginator, String recipient, String recipientIban, String recipientBic, String ultimateRecipient, BigDecimal amount, Currency currency, Date executionDate, String purpose, String paymentCategory, String endToEndId, String instructionId) {
        this(messageId, initiatingParty, originator, originatorIban, originatorBic, ultimateOriginator, recipient, recipientIban, recipientBic, ultimateRecipient, amount, currency, executionDate, purpose, paymentCategory, endToEndId, instructionId, GeneralSEPAExtractor.SEPA);
    }

    public SEPAPaymentData(String messageId, String initiatingParty, String originator, String originatorIban, String originatorBic, String ultimateOriginator, String recipient, String recipientIban, String recipientBic, String ultimateRecipient, BigDecimal amount, Date executionDate, String purpose, String paymentCategory, String endToEndId, String instructionId, String serviceLevel) {
        this(messageId, initiatingParty, originator, originatorIban, originatorBic, ultimateOriginator, recipient, recipientIban, recipientBic, ultimateRecipient, amount, EUR, executionDate, purpose, paymentCategory, endToEndId, instructionId, serviceLevel);
    }

    public SEPAPaymentData(String messageId, String initiatingParty, String originator, String originatorIban, String originatorBic, String ultimateOriginator, String recipient, String recipientIban, String recipientBic, String ultimateRecipient, BigDecimal amount, Currency currency, Date executionDate, String purpose, String paymentCategory, String endToEndId, String instructionId, String serviceLevel) {
        this.messageId = messageId;
        this.initiatingParty = initiatingParty;
        this.originator = originator;
        this.originatorIban = originatorIban;
        this.originatorBic = originatorBic;
        this.ultimateOriginator = ultimateOriginator;
        this.recipient = recipient;
        this.recipientIban = recipientIban;
        this.recipientBic = recipientBic;
        this.ultimateRecipient = ultimateRecipient;
        this.amount = amount;
        this.currency = currency;
        this.executionDate = executionDate;
        this.purpose = purpose;
        this.paymentCategory = paymentCategory;
        this.endToEndId = endToEndId;
        this.instructionId = instructionId;
        this.serviceLevel = serviceLevel;
    }

    public SEPAPaymentData(String messageId, String initiatingParty, String originator, String originatorIban, String originatorBic, String ultimateOriginator, String recipient, String recipientIban, String recipientBic, String ultimateRecipient, BigDecimal amount, Date executionDate, String purpose, String paymentCategory, String endToEndId, String instructionId, String debitType, String sequenceType, String creditorId, String mandateId, Date mandateSignDate) {
        this(messageId, initiatingParty, originator, originatorIban, originatorBic, ultimateOriginator, recipient, recipientIban, recipientBic, ultimateRecipient, amount, EUR, executionDate, purpose, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
    }

    public SEPAPaymentData(String messageId, String initiatingParty, String originator, String originatorIban, String originatorBic, String ultimateOriginator, String recipient, String recipientIban, String recipientBic, String ultimateRecipient, BigDecimal amount, Currency currency, Date executionDate, String purpose, String paymentCategory, String endToEndId, String instructionId, String debitType, String sequenceType, String creditorId, String mandateId, Date mandateSignDate) {
        this(messageId, initiatingParty, originator, originatorIban, originatorBic, ultimateOriginator, recipient, recipientIban, recipientBic, ultimateRecipient, amount, currency, executionDate, purpose, paymentCategory, endToEndId, instructionId, GeneralSEPAExtractor.SEPA);
        this.debitType = debitType;
        this.sequenceType = sequenceType;
        this.creditorId = creditorId;
        this.mandateId = mandateId;
        this.mandateSignDate = mandateSignDate;
    }

    public AddressData getOriginatorAddressData() {
        return this.originatorAddressData;
    }

    public void setOriginatorAddressData(AddressData originatorAddressData) {
        this.originatorAddressData = originatorAddressData;
    }

    public AddressData getRecipientAddressData() {
        return this.recipientAddressData;
    }

    public void setRecipientAddressData(AddressData recipientAddressData) {
        this.recipientAddressData = recipientAddressData;
    }

    public String getRecipientBankName() {
        return this.recipientBankName;
    }

    public void setRecipientBankName(String recipientBankName) {
        this.recipientBankName = recipientBankName;
    }

    public AddressData getRecipientBankAddressData() {
        return this.recipientBankAddressData;
    }

    public void setRecipientBankAddressData(AddressData recipientBankAddressData) {
        this.recipientBankAddressData = recipientBankAddressData;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public ChequeInstructionData getChequeInstructionData() {
        return this.chequeInstructionData;
    }

    public void setChequeInstructionData(ChequeInstructionData chequeInstructionData) {
        this.chequeInstructionData = chequeInstructionData;
    }

    public List<RegReporting> getRegReportings() {
        return this.regReportings;
    }

    public void addRegReporting(RegReporting regReporting) {
        this.regReportings.add(regReporting);
    }

    public Boolean getPmtTpInfOnLFLevel() {
        return this.pmtTpInfOnLFLevel;
    }

    public void setPmtTpInfOnLFLevel(Boolean pmtTpInfOnLFLevel) {
        this.pmtTpInfOnLFLevel = pmtTpInfOnLFLevel;
    }

    public boolean isCredit() {
        return this.debitType == null;
    }

    public int getLogicalFileNumber() {
        return this.logicalFileNumber;
    }

    public void setLogicalFile(int logicalFileNumber) {
        this.logicalFileNumber = logicalFileNumber;
    }

    public int getPaymentNumber() {
        return this.paymentNumber;
    }

    public void setPaymentNumber(int paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public String getOriginatorIban() {
        return this.originatorIban;
    }

    public void setOriginatorIban(String originatorIban) {
        this.originatorIban = originatorIban;
    }

    public void setIsOriginatorIban(boolean isOriginatorIban) {
        this.isOriginatorIban = isOriginatorIban;
    }

    public boolean isOriginatorIban() {
        return this.isOriginatorIban;
    }

    public String getOriginatorBic() {
        return this.originatorBic;
    }

    public void setOriginatorBic(String originatorBic) {
        this.originatorBic = originatorBic;
    }

    public String getOriginatorLei() {
        return this.originatorLei;
    }

    public void setOriginatorLei(String originatorLei) {
        this.originatorLei = originatorLei;
    }

    public String getOriginatorAccountType() {
        return this.originatorAccountType;
    }

    public void setOriginatorAccountType(String originatorAccountType) {
        this.originatorAccountType = originatorAccountType;
    }

    public String getUltimateOriginator() {
        return this.ultimateOriginator;
    }

    public void setUltimateOriginator(String ultimateOriginator) {
        this.ultimateOriginator = ultimateOriginator;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRecipientIban() {
        return this.recipientIban;
    }

    public void setIsRecipientIban(boolean isRecipientIban) {
        this.isRecipientIban = isRecipientIban;
    }

    public boolean isRecipientIban() {
        return this.isRecipientIban;
    }

    public void setRecipientIban(String recipientIban) {
        this.recipientIban = recipientIban;
    }

    public String getRecipientClearingSystemId() {
        return this.recipientClearingSystemId;
    }

    public void setRecipientClearingSystemId(String recipientClearingSystemId) {
        this.recipientClearingSystemId = recipientClearingSystemId;
    }

    public String getRecipientBic() {
        return this.recipientBic;
    }

    public void setRecipientBic(String recipientBic) {
        this.recipientBic = recipientBic;
    }

    public String getRecipientLei() {
        return this.recipientLei;
    }

    public void setRecipientLei(String recipientLei) {
        this.recipientLei = recipientLei;
    }

    public String getUltimateRecipient() {
        return this.ultimateRecipient;
    }

    public void setUltimateRecipient(String ultimateRecipient) {
        this.ultimateRecipient = ultimateRecipient;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Currency getCurrency() {
        if (this.currency != null) {
            return this.currency;
        }
        return EUR;
    }

    public void setAccountCurrency(Currency accountCurrency) {
        this.accountCurrency = accountCurrency;
    }

    public Currency getAccountCurrency() {
        return this.accountCurrency;
    }

    public Currency getCounterValueCurrency() {
        return this.counterValueCurrency;
    }

    public void setCounterValueCurrency(Currency counterValueCurrency) {
        this.counterValueCurrency = counterValueCurrency;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public boolean hasExecutionTime() {
        return this.hasExecutionTime;
    }

    public void setHasExecutionTime(boolean hasExecutionTime) {
        this.hasExecutionTime = hasExecutionTime;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public boolean hasStructuredPurpose() {
        return this.hasStructuredPurpose;
    }

    public void setHasStructuredPurpose(boolean hasStructuredPurpose) {
        this.hasStructuredPurpose = hasStructuredPurpose;
    }

    public List<String> getUnstructuredPurposeLines() {
        return this.unstructuredPurposeLines;
    }

    public List<String> getStructuredPurposeLines() {
        return this.structuredPurposeLines;
    }

    public String getPurposeReference() {
        return this.purposeReference;
    }

    public void setPurposeReference(String purposeReference) {
        this.purposeReference = purposeReference;
    }

    public String getPurposeReferenceTypeCode() {
        return this.purposeReferenceTypeCode;
    }

    public void setPurposeReferenceTypeCode(String purposeReferenceTypeCode) {
        this.purposeReferenceTypeCode = purposeReferenceTypeCode;
    }

    public String getPurposeReferenceTypePrtry() {
        return this.purposeReferenceTypePrtry;
    }

    public void setPurposeReferenceTypePrtry(String purposeReferenceTypePrtry) {
        this.purposeReferenceTypePrtry = purposeReferenceTypePrtry;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(String purposeCode) {
        this.purposeCode = purposeCode;
    }

    public String getChargeBearer() {
        return this.chargeBearer;
    }

    public void setChargeBearer(String chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public String getEndToEndId() {
        return this.endToEndId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public String getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public String getInitiatingParty() {
        return this.initiatingParty;
    }

    public void setInitiatingParty(String initiatingParty) {
        this.initiatingParty = initiatingParty;
    }

    public String getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(String serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public String getPaymentCategory() {
        return this.paymentCategory;
    }

    public void setPaymentCategory(String paymentCategory) {
        this.paymentCategory = paymentCategory;
    }

    public String getInstructionPriority() {
        return this.instructionPriority;
    }

    public void setInstructionPriority(String instructionPriority) {
        this.instructionPriority = instructionPriority;
    }

    public String getVopResult() {
        return this.vopResult;
    }

    public void setVopResult(String vopResult) {
        this.vopResult = vopResult;
    }

    public String getVopName() {
        return this.vopName;
    }

    public void setVopName(String vopName) {
        this.vopName = vopName;
    }

    public String getVopReason() {
        return this.vopReason;
    }

    public void setVopReason(String vopReason) {
        this.vopReason = vopReason;
    }

    public Timestamp getVopDate() {
        return this.vopDate;
    }

    public void setVopDate(Timestamp vopDate) {
        this.vopDate = vopDate;
    }

    public boolean isInstantPayment() {
        return SEPALocalInstrument.INST.name().equals(this.localInstrument);
    }

    public boolean isUrgentPayment() {
        return !(this.debitType != null || !SEPAServiceLevel.URGP.name().equals(this.serviceLevel) || !EUR.equals(this.currency) || this.recipientBic != null && !this.recipientBic.isEmpty() && !PaymentUtils.isBIC(this.recipientBic) || this.recipientClearingSystemId != null || !this.hasRecipientIbanFromSEPACountry() || this.recipientBankAddressData != null && !this.recipientBankAddressData.isEmpty() || !this.hasUrgentCreditChargeBearer());
    }

    private boolean hasRecipientIbanFromSEPACountry() {
        return IbanUtil.checkIban(this.recipientIban) && SepaCountry.isSepaCountry(IbanUtil.getCountryCode(this.recipientIban));
    }

    private boolean hasUrgentCreditChargeBearer() {
        return SEPAFeeType.SLEV.name().equals(this.chargeBearer) || SEPAFeeType.SHAR.name().equals(this.chargeBearer);
    }

    public boolean isSwissDomesticTransfer() {
        return this.debitType == null && !this.isCHPayment() && SEPAServiceLevel.isAllowedForInternationalPain001(this.serviceLevel) && IbanUtil.isSwissOrLiechtensteinIban(this.originatorIban) && IbanUtil.isSwissOrLiechtensteinIban(this.recipientIban);
    }

    public boolean isForeignPayment() {
        return this.debitType == null && !this.isCHPayment() && SEPAServiceLevel.isAllowedForInternationalPain001(this.serviceLevel) && (!IbanUtil.isSwissOrLiechtensteinIban(this.originatorIban) || !IbanUtil.isSwissOrLiechtensteinIban(this.recipientIban)) && this.recipientAddressData != null && this.recipientAddressData.getCountry() != null && !this.recipientAddressData.getCountry().isEmpty();
    }

    public boolean isChequePayment() {
        return SEPAPaymentMethod.CHK.name().equals(this.paymentMethod);
    }

    public boolean isCHPayment() {
        return this.localInstrument != null && this.localInstrument.startsWith("CH");
    }

    public boolean isESRPayment() {
        return SEPALocalInstrument.CH01.name().equals(this.localInstrument);
    }

    public boolean isES1Payment() {
        return SEPALocalInstrument.CH02.name().equals(this.localInstrument);
    }

    public boolean isES2Payment() {
        return SEPALocalInstrument.CH03.name().equals(this.localInstrument);
    }

    public String getDebitType() {
        return this.debitType;
    }

    public void setDebitType(String debitType) {
        this.debitType = debitType;
    }

    public String getSequenceType() {
        return this.sequenceType;
    }

    public void setSequenceType(String sequenceType) {
        this.sequenceType = sequenceType;
    }

    public String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public String getMandateId() {
        return this.mandateId;
    }

    public void setMandateId(String mandateId) {
        this.mandateId = mandateId;
    }

    public Date getMandateSignDate() {
        return this.mandateSignDate;
    }

    public void setMandateSignDate(Date mandateSignDate) {
        this.mandateSignDate = mandateSignDate;
    }

    public boolean displayAsSingleBooking() {
        return this.displayAsSingleBooking;
    }

    public void setDisplayAsSingleBooking(boolean displayAsSingleBooking) {
        this.displayAsSingleBooking = displayAsSingleBooking;
    }

    public Boolean getBatchBooking() {
        if (this.displayAsSingleBooking) {
            return Boolean.FALSE;
        }
        return batchBookingTagIsMandatory ? Boolean.TRUE : null;
    }

    public String getOriginalCreditor() {
        return this.originalCreditor;
    }

    public void setOriginalCreditor(String originalCreditor) {
        this.originalCreditor = originalCreditor;
    }

    public String getOriginalCreditorId() {
        return this.originalCreditorId;
    }

    public void setOriginalCreditorId(String originalCreditorId) {
        this.originalCreditorId = originalCreditorId;
    }

    public String getOriginalMandateId() {
        return this.originalMandateId;
    }

    public void setOriginalMandateId(String originalMandateId) {
        this.originalMandateId = originalMandateId;
    }

    public boolean recipientAccountHasChanged() {
        return this.recipientAccountHasChanged;
    }

    public void setRecipientAccountHasChanged(boolean recipientAccountHasChanged) {
        this.recipientAccountHasChanged = recipientAccountHasChanged;
    }

    public boolean recipientBankHasChanged() {
        return this.recipientBankHasChanged;
    }

    public void setRecipientBankHasChanged(boolean recipientBankHasChanged) {
        this.recipientBankHasChanged = recipientBankHasChanged;
    }

    public String getOriginalRecipientIban() {
        return this.originalRecipientIban;
    }

    public void setOriginalRecipientIban(String originalRecipientIban) {
        this.originalRecipientIban = originalRecipientIban;
    }

    public String getOriginalRecipientBic() {
        return this.originalRecipientBic;
    }

    public void setOriginalRecipientBic(String originalRecipientBic) {
        this.originalRecipientBic = originalRecipientBic;
    }

    public boolean hasModifiedMandate() {
        return this.originalCreditor != null || this.originalCreditorId != null || this.originalMandateId != null || this.recipientAccountHasChanged || this.recipientBankHasChanged || this.originalRecipientIban != null || this.originalRecipientBic != null;
    }

    public String getCallbackReason() {
        return this.callbackReason;
    }

    public void setCallbackReason(String callbackReason) {
        this.callbackReason = callbackReason;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException noClone) {
            return this;
        }
    }

    public void replaceDTAUSChars() {
        this.initiatingParty = PaymentUtils.getBaseSEPAString(this.initiatingParty, 70);
        this.originator = PaymentUtils.getBaseSEPAString(this.originator, 70);
        this.ultimateOriginator = PaymentUtils.getBaseSEPAString(this.ultimateOriginator, 70);
        this.recipient = PaymentUtils.getBaseSEPAString(this.recipient, 70);
        this.ultimateRecipient = PaymentUtils.getBaseSEPAString(this.ultimateRecipient, 70);
        this.purpose = PaymentUtils.getBaseSEPAString(this.purpose, 140);
    }

    public void replaceSEPAForeignChars() {
        this.originator = PaymentUtils.getSEPAForeignStringForGUI(this.originator, 70);
        this.ultimateOriginator = PaymentUtils.getSEPAForeignStringForGUI(this.ultimateOriginator, 70);
        this.initiatingParty = PaymentUtils.getSEPAForeignStringForGUI(this.initiatingParty, 70);
        this.originatorAddressData = AddressData.replaceSEPAForeignChars(this.originatorAddressData);
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public void setPmtInfId(String pmtInfId) {
        this.pmtInfId = pmtInfId;
    }

    public String getLogicalFileKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.displayAsSingleBooking() ? "s" : "b");
        sb.append(SEPARATOR);
        sb.append(this.getOriginator());
        sb.append(SEPARATOR);
        if (this.getPaymentCategory() != null) {
            sb.append(this.getPaymentCategory());
        }
        sb.append(SEPARATOR);
        if (this.hasExecutionTime) {
            sb.append(yyyyMMddHHmmss.get().format(this.getExecutionDate()));
        } else {
            sb.append(yyyyMMdd.get().format(this.getExecutionDate()));
        }
        sb.append(SEPARATOR);
        sb.append(this.getOriginatorIban());
        sb.append(SEPARATOR);
        sb.append(this.getOriginatorBic());
        sb.append(SEPARATOR);
        sb.append(this.getAddressInfo(this.originatorAddressData));
        sb.append(SEPARATOR);
        sb.append(this.getCurrency().getCurrencyCode());
        sb.append(SEPARATOR);
        sb.append(StringUtils.checkNullAndTrim(this.localInstrument));
        sb.append(SEPARATOR);
        sb.append(StringUtils.checkNullAndTrim(this.paymentMethod));
        sb.append(SEPARATOR);
        sb.append(StringUtils.checkNullAndTrim(this.serviceLevel));
        sb.append(SEPARATOR);
        if (this.getInstructionPriority() != null) {
            sb.append(this.getInstructionPriority());
        }
        sb.append(SEPARATOR);
        if (this.getChargeBearer() != null) {
            sb.append(this.getChargeBearer());
        }
        sb.append(SEPARATOR);
        sb.append(StringUtils.checkNullAndTrim(this.originatorAccountType));
        sb.append(SEPARATOR);
        String ci = this.getCreditorId();
        if (ci != null && ci.length() > 0) {
            sb.append(ci);
            sb.append(SEPARATOR);
            sb.append(this.getSequenceType());
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    private String getAddressInfo(AddressData addressData) {
        if (addressData != null) {
            StringBuilder sb = new StringBuilder();
            for (String addressLine : addressData.getAddressLines()) {
                sb.append(addressLine);
                sb.append(' ');
            }
            sb.append(addressData.getCountry());
            return sb.toString();
        }
        return "";
    }

    public static List<List<SEPAPaymentData>> groupPayments(List<SEPAPaymentData> list) {
        ArrayList<List<SEPAPaymentData>> toReturn = new ArrayList<List<SEPAPaymentData>>();
        HashMap<String, List> map = new HashMap<String, List>();
        for (SEPAPaymentData p : list) {
            String key = p.getLogicalFileKey();
            List l = map.computeIfAbsent(key, k -> new ArrayList());
            l.add(p);
        }
        Set set = map.keySet();
        List<String> li = SEPAPaymentData.asSortedList(set);
        for (String h : li) {
            toReturn.add((List)map.get(h));
        }
        return toReturn;
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public GeneralSEPAWriter.Version getSepaVersion() {
        return this.sepaVersion;
    }

    void setSepaVersion(GeneralSEPAWriter.Version version) {
        this.sepaVersion = version;
    }
}

