/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SEPAPaymentCategory {
    private static final Map<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();
    private static final String[] PAYMENT_CATEGORIES = new String[]{"BONU", "CASH", "CBLK", "CCRD", "CGWV", "CIPC", "CONC", "CORT", "CTDF", "DCRD", "DIVI", "DVPM", "EPAY", "FCDT", "FCIN", "FCOL", "GOVT", "GP2P", "HEDG", "ICCP", "IDCP", "INTC", "INTE", "LBOX", "LOAN", "MP2B", "MP2P", "OTHR", "PENS", "RPRE", "RRCT", "RVPM", "SALA", "SAVG", "SECU", "SSBE", "SUPP", "SWEP", "TAXS", "TOPG", "TRAD", "TREA", "VATX", "VOST", "WHLD", "ZABA"};
    private static final String[] PAYMENT_CATEGORIES_WITHOUT_SALARIES;
    private static final String[] URGENT_PAYMENT_CATEGORIES;
    private static final String[] URGENT_PAYMENT_CATEGORIES_WITHOUT_SALARIES;
    private static final String[] ING_PAYMENT_CATEGORIES;
    private static final String[] PAYMENT_CATEGORIES_WITHOUT_UNSTRUCTURED_PURPOSE;

    public static String[] getPaymentCategories(boolean withSalaries) {
        if (withSalaries) {
            return PAYMENT_CATEGORIES;
        }
        return PAYMENT_CATEGORIES_WITHOUT_SALARIES;
    }

    @Deprecated
    public static String[] getUrgentPaymentCategories() {
        return SEPAPaymentCategory.getUrgentPaymentCategories(false);
    }

    public static String[] getUrgentPaymentCategories(boolean withSalaries) {
        if (withSalaries) {
            return URGENT_PAYMENT_CATEGORIES;
        }
        return URGENT_PAYMENT_CATEGORIES_WITHOUT_SALARIES;
    }

    public static String[] getINGPaymentCategories() {
        return ING_PAYMENT_CATEGORIES;
    }

    public static boolean isProprietary(String paymentCategory) {
        for (String category : PAYMENT_CATEGORIES) {
            if (!category.equals(paymentCategory)) continue;
            return false;
        }
        return true;
    }

    public static boolean allowsUnstructuredPurpose(String paymentCategory) {
        for (String category : PAYMENT_CATEGORIES_WITHOUT_UNSTRUCTURED_PURPOSE) {
            if (!category.equals(paymentCategory)) continue;
            return false;
        }
        return true;
    }

    public static String getDescription(String paymentCategory) {
        return SEPAPaymentCategory.getDescription(paymentCategory, Locale.getDefault());
    }

    public static String getDescription(String paymentCategory, Locale locale) {
        if (paymentCategory != null) {
            try {
                return SEPAPaymentCategory.getBundle(locale).getString(paymentCategory);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        return null;
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle result = bundles.get(locale);
        if (result == null) {
            result = ResourceBundle.getBundle("de.businesslogics.format.sepa.SEPAPaymentCategory", locale);
            bundles.put(locale, result);
        }
        return result;
    }

    static {
        URGENT_PAYMENT_CATEGORIES = new String[]{"BONU", "CORT", "INTC", "PENS", "SALA"};
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(PAYMENT_CATEGORIES));
        tmp.remove("BONU");
        tmp.remove("PENS");
        tmp.remove("SALA");
        PAYMENT_CATEGORIES_WITHOUT_SALARIES = tmp.toArray(new String[0]);
        tmp = new ArrayList<String>(Arrays.asList(URGENT_PAYMENT_CATEGORIES));
        tmp.remove("BONU");
        tmp.remove("PENS");
        tmp.remove("SALA");
        URGENT_PAYMENT_CATEGORIES_WITHOUT_SALARIES = tmp.toArray(new String[0]);
        ING_PAYMENT_CATEGORIES = new String[]{"INTC", "TREA"};
        PAYMENT_CATEGORIES_WITHOUT_UNSTRUCTURED_PURPOSE = new String[]{"INTE", "FCOL", "FCIN"};
    }
}

