/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SEPALogicalFile {
    private final String pmtInfId;
    private final String msgId;
    private final List<SEPAPaymentData> transactions;
    private long nbOfTxs;
    private BigDecimal ctrlSum;

    public SEPALogicalFile(String pmtInfId, String msgId) {
        this.pmtInfId = pmtInfId;
        this.msgId = msgId;
        this.transactions = new ArrayList<SEPAPaymentData>();
    }

    public SEPALogicalFile(String pmtInfId, String msgId, List<SEPAPaymentData> transactions) {
        this.pmtInfId = pmtInfId;
        this.msgId = msgId;
        this.transactions = transactions;
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public List<SEPAPaymentData> getTransactions() {
        return this.transactions;
    }

    public long getNbOfTxs() {
        return this.nbOfTxs;
    }

    public void setNbOfTxs(long nbOfTxs) {
        this.nbOfTxs = nbOfTxs;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public void setCtrlSum(BigDecimal ctrlSum) {
        this.ctrlSum = ctrlSum;
    }

    public void setVersion(GeneralSEPAWriter.Version version) {
        for (SEPAPaymentData t : this.transactions) {
            t.setSepaVersion(version);
        }
    }
}

