/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum SEPAFeeType {
    SHAR(true),
    DEBT(true),
    CRED(true),
    SLEV(false);

    private boolean isAllowedForInternationalPain001;
    private static final Map<String, ResourceBundle> bundles;

    private SEPAFeeType(boolean isAllowedForInternationalPain001) {
        this.isAllowedForInternationalPain001 = isAllowedForInternationalPain001;
    }

    public static String getDescription(String feeTypeString, Locale locale) {
        ResourceBundle bundle = bundles.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.SEPAFeeType", locale);
            bundles.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("SEPAFeeType." + feeTypeString);
        }
        catch (MissingResourceException e) {
            return "!SEPAFeeType." + feeTypeString + "!";
        }
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        return SEPAFeeType.getDescription(this.name(), locale);
    }

    public static SEPAFeeType[] getValuesForInternationalPayments() {
        ArrayList<SEPAFeeType> values = new ArrayList<SEPAFeeType>();
        for (SEPAFeeType feeType : SEPAFeeType.values()) {
            if (!feeType.isAllowedForInternationalPain001) continue;
            values.add(feeType);
        }
        return values.toArray(new SEPAFeeType[0]);
    }

    static {
        bundles = new HashMap<String, ResourceBundle>();
    }
}

