/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.iso20022.pain00100109.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00100109.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00100109.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.iso20022.pain00100109.AmountType4Choice;
import de.businesslogics.format.iso20022.pain00100109.BICFIDec2014Identifier;
import de.businesslogics.format.iso20022.pain00100109.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00100109.BranchAndFinancialInstitutionIdentification6;
import de.businesslogics.format.iso20022.pain00100109.CashAccount38;
import de.businesslogics.format.iso20022.pain00100109.CashAccountType2Choice;
import de.businesslogics.format.iso20022.pain00100109.CategoryPurpose1Choice;
import de.businesslogics.format.iso20022.pain00100109.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00100109.Cheque11;
import de.businesslogics.format.iso20022.pain00100109.ChequeDelivery1Code;
import de.businesslogics.format.iso20022.pain00100109.ChequeDeliveryMethod1Choice;
import de.businesslogics.format.iso20022.pain00100109.ChequeType2Code;
import de.businesslogics.format.iso20022.pain00100109.ClearingSystemIdentification2Choice;
import de.businesslogics.format.iso20022.pain00100109.ClearingSystemMemberIdentification2;
import de.businesslogics.format.iso20022.pain00100109.CountryCode;
import de.businesslogics.format.iso20022.pain00100109.CreditTransferTransaction34;
import de.businesslogics.format.iso20022.pain00100109.CreditorReferenceInformation2;
import de.businesslogics.format.iso20022.pain00100109.CreditorReferenceType1Choice;
import de.businesslogics.format.iso20022.pain00100109.CreditorReferenceType2;
import de.businesslogics.format.iso20022.pain00100109.CustomerCreditTransferInitiationV09;
import de.businesslogics.format.iso20022.pain00100109.DateAndDateTime2Choice;
import de.businesslogics.format.iso20022.pain00100109.DecimalNumber;
import de.businesslogics.format.iso20022.pain00100109.Document;
import de.businesslogics.format.iso20022.pain00100109.DocumentType3Code;
import de.businesslogics.format.iso20022.pain00100109.EquivalentAmount2;
import de.businesslogics.format.iso20022.pain00100109.ExternalCashAccountType1Code;
import de.businesslogics.format.iso20022.pain00100109.ExternalCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00100109.ExternalClearingSystemIdentification1Code;
import de.businesslogics.format.iso20022.pain00100109.ExternalLocalInstrument1Code;
import de.businesslogics.format.iso20022.pain00100109.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.pain00100109.ExternalServiceLevel1Code;
import de.businesslogics.format.iso20022.pain00100109.FinancialInstitutionIdentification18;
import de.businesslogics.format.iso20022.pain00100109.GenericAccountIdentification1;
import de.businesslogics.format.iso20022.pain00100109.GenericFinancialIdentification1;
import de.businesslogics.format.iso20022.pain00100109.GroupHeader85;
import de.businesslogics.format.iso20022.pain00100109.IBAN2007Identifier;
import de.businesslogics.format.iso20022.pain00100109.ISODate;
import de.businesslogics.format.iso20022.pain00100109.ISODateTime;
import de.businesslogics.format.iso20022.pain00100109.LEIIdentifier;
import de.businesslogics.format.iso20022.pain00100109.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00100109.Max10Text;
import de.businesslogics.format.iso20022.pain00100109.Max140Text;
import de.businesslogics.format.iso20022.pain00100109.Max15NumericText;
import de.businesslogics.format.iso20022.pain00100109.Max16Text;
import de.businesslogics.format.iso20022.pain00100109.Max34Text;
import de.businesslogics.format.iso20022.pain00100109.Max35Text;
import de.businesslogics.format.iso20022.pain00100109.Max70Text;
import de.businesslogics.format.iso20022.pain00100109.NameAndAddress16;
import de.businesslogics.format.iso20022.pain00100109.OrganisationIdentification29;
import de.businesslogics.format.iso20022.pain00100109.Party38Choice;
import de.businesslogics.format.iso20022.pain00100109.PartyIdentification135;
import de.businesslogics.format.iso20022.pain00100109.PaymentIdentification6;
import de.businesslogics.format.iso20022.pain00100109.PaymentInstruction30;
import de.businesslogics.format.iso20022.pain00100109.PaymentMethod3Code;
import de.businesslogics.format.iso20022.pain00100109.PaymentTypeInformation26;
import de.businesslogics.format.iso20022.pain00100109.PostalAddress24;
import de.businesslogics.format.iso20022.pain00100109.Priority2Code;
import de.businesslogics.format.iso20022.pain00100109.Purpose2Choice;
import de.businesslogics.format.iso20022.pain00100109.RegulatoryAuthority2;
import de.businesslogics.format.iso20022.pain00100109.RegulatoryReporting3;
import de.businesslogics.format.iso20022.pain00100109.RegulatoryReportingType1Code;
import de.businesslogics.format.iso20022.pain00100109.RemittanceInformation16;
import de.businesslogics.format.iso20022.pain00100109.ServiceLevel8Choice;
import de.businesslogics.format.iso20022.pain00100109.StructuredRegulatoryReporting3;
import de.businesslogics.format.iso20022.pain00100109.StructuredRemittanceInformation16;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.ChequeInstructionData;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.RegReporting;
import de.businesslogics.format.sepa.RegReportingDetail;
import de.businesslogics.format.sepa.SEPAAccountType;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV9Iso {
    public static XMLDate getDateSRZ(Document document) {
        DateAndDateTime2Choice.DateAndDateTime2Choice_C1 choice = document.getCstmrCdtTrfInitn().getPmtInfs().get(0).getReqdExctnDt().getChoice1();
        ISODate date = choice.getDt();
        if (date != null) {
            return date;
        }
        ISODateTime dateTime = choice.getDtTm();
        return new XMLDate(new YYMMDD(dateTime.getDate().getTime(), dateTime.getTimeZone()));
    }

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        CustomerCreditTransferInitiationV09 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader85 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstruction30 p : ccti.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            SEPAExtractorV9Iso.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (CreditTransferTransaction34 c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV9Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.Iso00100109);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerCreditTransferInitiationV09 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader85 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstruction30 p : ccti.getPmtInfs()) {
            for (CreditTransferTransaction34 c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV9Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstruction30 p, CreditTransferTransaction34 t) {
        PaymentIdentification6 pmtId;
        String endToEndId;
        Date executionDate;
        AccountNumberInfo recipAccNumberInfo;
        PartyIdentification135 debtor = p.getDbtr();
        String origName = SimpleStringElement.getNonNullValue(debtor.getNm());
        String origAccNumber = null;
        boolean isOrigIban = true;
        CashAccount38 originatorAccount = p.getDbtrAcct();
        AccountNumberInfo origAccNumberInfo = SEPAExtractorV9Iso.getAccountNumberInfo(originatorAccount.getId().getChoice1());
        if (origAccNumberInfo != null) {
            origAccNumber = origAccNumberInfo.getAccountNumber();
            isOrigIban = origAccNumberInfo.isFromIbanTag();
        }
        String origBankCode = SEPAExtractorV9Iso.getBankIdentifier(p.getDbtrAgt().getFinInstnId());
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        String recip = "";
        PartyIdentification135 creditor = t.getCdtr();
        if (creditor != null) {
            recip = SimpleStringElement.getNonNullValue(creditor.getNm());
        }
        String recipAccNumber = null;
        boolean isRecipIban = true;
        if (t.getCdtrAcct() != null && (recipAccNumberInfo = SEPAExtractorV9Iso.getAccountNumberInfo(t.getCdtrAcct().getId().getChoice1())) != null) {
            recipAccNumber = recipAccNumberInfo.getAccountNumber();
            isRecipIban = recipAccNumberInfo.isFromIbanTag();
        }
        String recipBIC = null;
        FinancialInstitutionIdentification18 recipientBankIdentification = null;
        if (t.getCdtrAgt() != null) {
            recipientBankIdentification = t.getCdtrAgt().getFinInstnId();
            recipBIC = SEPAExtractorV9Iso.getRecipientBIC(recipientBankIdentification);
        }
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV9Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
        Currency counterValueCurrency = SEPAExtractorV9Iso.getCounterValueCurrency(t.getAmt().getChoice1());
        boolean hasExecutionTime = false;
        DateAndDateTime2Choice.DateAndDateTime2Choice_C1 choice = p.getReqdExctnDt().getChoice1();
        if (choice.getDt() != null) {
            executionDate = choice.getDt().getDate();
        } else {
            executionDate = choice.getDtTm().getDate();
            hasExecutionTime = true;
        }
        PaymentTypeInformation26 pmtTpInfLF = p.getPmtTpInf();
        PaymentTypeInformation26 pmtTpInfTX = t.getPmtTpInf();
        String paymentCategory = null;
        String serviceLevel = null;
        if (pmtTpInfLF != null) {
            paymentCategory = SEPAExtractorV9Iso.getPaymentCategory(pmtTpInfLF.getCtgyPurp());
            serviceLevel = SEPAExtractorV9Iso.getServiceLevel(pmtTpInfLF.getSvcLvls());
        }
        if (pmtTpInfTX != null) {
            if (paymentCategory == null) {
                paymentCategory = SEPAExtractorV9Iso.getPaymentCategory(pmtTpInfTX.getCtgyPurp());
            }
            if (serviceLevel == null) {
                serviceLevel = SEPAExtractorV9Iso.getServiceLevel(pmtTpInfTX.getSvcLvls());
            }
        }
        if ("NOTPROVIDED".equals(endToEndId = (pmtId = t.getPmtId()).getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(pmtId.getInstrId());
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBIC, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()), executionDate, null, paymentCategory, endToEndId, instructionId, serviceLevel);
        paymentData.setIsOriginatorIban(isOrigIban);
        paymentData.setIsRecipientIban(isRecipIban);
        paymentData.setCounterValueCurrency(counterValueCurrency);
        paymentData.setHasExecutionTime(hasExecutionTime);
        paymentData.setOriginatorLei(SEPAExtractorV9Iso.getLegalEntityIdentifier(debtor.getId()));
        paymentData.setRecipientLei(SEPAExtractorV9Iso.getLegalEntityIdentifier(creditor.getId()));
        paymentData.setAccountCurrency(originatorAccount.getCcy() != null ? Currency.getInstance(originatorAccount.getCcy().getValue()) : null);
        paymentData.setOriginatorAccountType(SEPAExtractorV9Iso.getAccountType(originatorAccount));
        paymentData.setPaymentMethod(p.getPmtMtd().getValue());
        String localInstrument = null;
        String instructionPriority = null;
        if (pmtTpInfLF != null) {
            localInstrument = SEPAExtractorV9Iso.getLocalInstrument(pmtTpInfLF.getLclInstrm());
            instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfLF.getInstrPrty());
        }
        if (pmtTpInfTX != null) {
            if (localInstrument == null) {
                localInstrument = SEPAExtractorV9Iso.getLocalInstrument(pmtTpInfTX.getLclInstrm());
            }
            if (instructionPriority == null) {
                instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfTX.getInstrPrty());
            }
        }
        paymentData.setLocalInstrument(localInstrument);
        paymentData.setInstructionPriority(instructionPriority);
        if (t.getPurp() != null) {
            paymentData.setPurposeCode(SimpleStringElement.getNonNullValue(t.getPurp().getChoice1().getCd()));
        }
        if (p.getChrgBr() != null) {
            paymentData.setChargeBearer(p.getChrgBr().getValue());
        } else if (t.getChrgBr() != null) {
            paymentData.setChargeBearer(t.getChrgBr().getValue());
        } else {
            paymentData.setChargeBearer(null);
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        if (debtor.getPstlAdr() != null) {
            paymentData.setOriginatorAddressData(SEPAExtractorV9Iso.getAddressData(debtor.getPstlAdr()));
        }
        if (creditor != null && creditor.getPstlAdr() != null) {
            paymentData.setRecipientAddressData(SEPAExtractorV9Iso.getAddressData(creditor.getPstlAdr()));
        }
        SEPAExtractorV9Iso.setPurposeInformation(t.getRmtInf(), paymentData);
        if (recipientBankIdentification != null) {
            SEPAExtractorV9Iso.loadOtherRecipientBankData(recipientBankIdentification, paymentData);
        }
        SEPAExtractorV9Iso.loadChequeInstructionData(t.getChqInstr(), paymentData);
        List<RegulatoryReporting3> rptgs = t.getRgltryRptgs();
        if (rptgs != null) {
            for (RegulatoryReporting3 rptg : rptgs) {
                paymentData.addRegReporting(SEPAExtractorV9Iso.getRegReporting(rptg));
            }
        }
        return paymentData;
    }

    private static RegReporting getRegReporting(RegulatoryReporting3 rptg) {
        RegReporting reporting = new RegReporting();
        if (rptg != null) {
            List<StructuredRegulatoryReporting3> dtls;
            RegulatoryReportingType1Code code = rptg.getDbtCdtRptgInd();
            if (code != null) {
                reporting.setCreditDebitIndicator(code.getValue());
            }
            if (rptg.getAuthrty() != null) {
                if (rptg.getAuthrty().getNm() != null) {
                    reporting.setAuthorityName(rptg.getAuthrty().getNm().getValue());
                }
                if (rptg.getAuthrty().getCtry() != null) {
                    reporting.setAuthorityCountry(rptg.getAuthrty().getCtry().getValue());
                }
            }
            if ((dtls = rptg.getDtlss()) != null) {
                for (StructuredRegulatoryReporting3 dtl : dtls) {
                    reporting.addDetail(SEPAExtractorV9Iso.getRegReportingDetail(dtl));
                }
            }
        }
        return reporting;
    }

    private static RegReportingDetail getRegReportingDetail(StructuredRegulatoryReporting3 rptg) {
        RegReportingDetail detail = new RegReportingDetail();
        if (rptg != null) {
            if (rptg.getAmt() != null) {
                detail.setAmount(rptg.getAmt().getValue());
            }
            if (rptg.getCd() != null) {
                detail.setCode(rptg.getCd().getValue());
            }
            if (rptg.getCtry() != null) {
                detail.setCountry(rptg.getCtry().getValue());
            }
            if (rptg.getDt() != null) {
                detail.setDate(rptg.getDt().getDate());
            }
            if (rptg.getTp() != null) {
                detail.setType(rptg.getTp().getValue());
            }
            if (rptg.getInfs() != null) {
                for (Max35Text inf : rptg.getInfs()) {
                    detail.addInf(inf.getValue());
                }
            }
        }
        return detail;
    }

    private static String getLegalEntityIdentifier(Party38Choice choice) {
        LEIIdentifier lei;
        OrganisationIdentification29 orgId;
        if (choice != null && (orgId = choice.getChoice1().getOrgId()) != null && (lei = orgId.getLEI()) != null) {
            return lei.getValue();
        }
        return null;
    }

    private static void loadChequeInstructionData(Cheque11 cheque, SEPAPaymentData paymentData) {
        if (cheque != null) {
            NameAndAddress16 nameAndAddress;
            ChequeInstructionData checkInstructionData = new ChequeInstructionData();
            if (cheque.getChqTp() != null) {
                checkInstructionData.setChequeType(cheque.getChqTp().getValue());
            }
            if (cheque.getDlvryMtd() != null) {
                ChequeDelivery1Code deliveryCode = cheque.getDlvryMtd().getChoice1().getCd();
                if (deliveryCode != null) {
                    checkInstructionData.setDeliveryMethod(deliveryCode.getValue());
                } else {
                    Max35Text deliveryText = cheque.getDlvryMtd().getChoice1().getPrtry();
                    if (deliveryText != null) {
                        checkInstructionData.setDeliveryMethod(deliveryText.getValue());
                    }
                }
            }
            if (cheque.getDlvrTo() != null && (nameAndAddress = cheque.getDlvrTo()) != null) {
                checkInstructionData.setDeliverToName(nameAndAddress.getNm().getValue());
                checkInstructionData.setDeliverToAddress(SEPAExtractorV9Iso.getAddressData(nameAndAddress.getAdr()));
            }
            paymentData.setChequeInstructionData(checkInstructionData);
        }
    }

    private static Cheque11 getChqInstr(SEPAPaymentData paymentData) {
        ChequeInstructionData chequeInstructionData = paymentData.getChequeInstructionData();
        if (chequeInstructionData != null) {
            String deliveryMethod;
            Cheque11 cheque = new Cheque11();
            String chequeType = StringUtils.checkNullAndTrim(chequeInstructionData.getChequeType());
            if (chequeType.length() > 0) {
                cheque.setChqTp(new ChequeType2Code(chequeType));
            }
            if ((deliveryMethod = chequeInstructionData.getDeliveryMethod()) != null && deliveryMethod.trim().length() > 0) {
                ChequeDeliveryMethod1Choice.ChequeDeliveryMethod1Choice_C1 choice1 = ChequeDeliveryMethod1Choice.ChequeDeliveryMethod1Choice_C1.fromCd(new ChequeDelivery1Code(deliveryMethod.trim()));
                cheque.setDlvryMtd(new ChequeDeliveryMethod1Choice(choice1));
            }
            cheque.setDlvrTo(SEPAExtractorV9Iso.getDlvrTo(chequeInstructionData.getDeliverToName(), chequeInstructionData.getDeliverToAddress()));
            return cheque;
        }
        return null;
    }

    private static NameAndAddress16 getDlvrTo(String name, AddressData addressData) {
        if (name != null && addressData != null) {
            return new NameAndAddress16(new Max140Text(name), SEPAExtractorV9Iso.saveAddress(addressData));
        }
        return null;
    }

    public static String getPaymentCategory(CategoryPurpose1Choice choice) {
        if (choice != null) {
            ExternalCategoryPurpose1Code categoryFromCd = choice.getChoice1().getCd();
            if (categoryFromCd != null) {
                return SimpleStringElement.getNonNullValue(categoryFromCd);
            }
            if (choice.getChoice1().getPrtry() != null) {
                return choice.getChoice1().getPrtry().getValue();
            }
        }
        return null;
    }

    private static CategoryPurpose1Choice getPaymentCategory(String paymentCategory) {
        String value = StringUtils.checkNullAndTrim(paymentCategory);
        if (value.length() > 0) {
            ExternalCategoryPurpose1Code cd = new ExternalCategoryPurpose1Code(value);
            if (SEPAPaymentCategory.isProprietary(value)) {
                return new CategoryPurpose1Choice(CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromPrtry(new Max35Text(value)));
            }
            return new CategoryPurpose1Choice(CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromCd(cd));
        }
        return null;
    }

    public static String getServiceLevel(List<ServiceLevel8Choice> choices) {
        if (choices != null && choices.size() > 0) {
            return SimpleStringElement.getNonNullValue(choices.get(0).getChoice1().getCd());
        }
        return null;
    }

    private static ServiceLevel8Choice getServiceLevel(String serviceLevel) {
        String value = StringUtils.checkNullAndTrim(serviceLevel);
        if (value.length() > 0) {
            return new ServiceLevel8Choice(ServiceLevel8Choice.ServiceLevel8Choice_C1.fromCd(new ExternalServiceLevel1Code(value)));
        }
        return null;
    }

    public static String getLocalInstrument(LocalInstrument2Choice choice) {
        if (choice != null) {
            if (choice.getChoice1().getCd() != null) {
                return choice.getChoice1().getCd().getValue();
            }
            if (choice.getChoice1().getPrtry() != null) {
                return choice.getChoice1().getPrtry().getValue();
            }
        }
        return null;
    }

    private static LocalInstrument2Choice getLocalInstrument(String localInstrument) {
        String value = StringUtils.checkNullAndTrim(localInstrument);
        if (value.length() > 0) {
            if (SEPALocalInstrument.isProprietaryValue(value)) {
                return new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromPrtry(new Max35Text(value)));
            }
            return new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromCd(new ExternalLocalInstrument1Code(value)));
        }
        return null;
    }

    protected static AccountNumberInfo getAccountNumberInfo(AccountIdentification4Choice.AccountIdentification4Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return new AccountNumberInfo(choice.getIBAN().getValue(), true);
        }
        if (choice.getOthr() != null) {
            return new AccountNumberInfo(choice.getOthr().getId().getValue(), false);
        }
        return null;
    }

    protected static String getBankIdentifier(FinancialInstitutionIdentification18 finInstnId) {
        if (finInstnId.getBICFI() != null) {
            return finInstnId.getBICFI().getValue();
        }
        if (finInstnId.getClrSysMmbId() != null) {
            return finInstnId.getClrSysMmbId().getMmbId().getValue();
        }
        if (finInstnId.getOthr() != null) {
            String othrId = finInstnId.getOthr().getId().getValue();
            if ("NOTPROVIDED".equals(othrId)) {
                return "";
            }
            return othrId;
        }
        return null;
    }

    private static String getRecipientBIC(FinancialInstitutionIdentification18 finInstnId) {
        if (finInstnId.getBICFI() != null) {
            return finInstnId.getBICFI().getValue();
        }
        return null;
    }

    private static void loadOtherRecipientBankData(FinancialInstitutionIdentification18 finInstnId, SEPAPaymentData paymentData) {
        boolean bicIsMissing;
        boolean bl = bicIsMissing = finInstnId.getBICFI() == null;
        if (finInstnId.getNm() != null) {
            paymentData.setRecipientBankName(finInstnId.getNm().getValue());
        }
        if (bicIsMissing) {
            String otherId;
            ClearingSystemMemberIdentification2 clrSysMbId = finInstnId.getClrSysMmbId();
            if (clrSysMbId != null) {
                if (clrSysMbId.getClrSysId() != null) {
                    ClearingSystemIdentification2Choice.ClearingSystemIdentification2Choice_C1 choice = clrSysMbId.getClrSysId().getChoice1();
                    if (choice.getCd() != null) {
                        paymentData.setRecipientClearingSystemId(choice.getCd().getValue());
                    } else if (choice.getPrtry() != null) {
                        paymentData.setRecipientClearingSystemId(choice.getPrtry().getValue());
                    }
                }
                paymentData.setRecipientBic(clrSysMbId.getMmbId().getValue());
            } else if (finInstnId.getOthr() != null && !"NOTPROVIDED".equals(otherId = finInstnId.getOthr().getId().getValue())) {
                paymentData.setRecipientBic(otherId);
            }
        }
        if (finInstnId.getPstlAdr() != null) {
            paymentData.setRecipientBankAddressData(SEPAExtractorV9Iso.getAddressData(finInstnId.getPstlAdr()));
        }
    }

    protected static ActiveOrHistoricCurrencyAndAmount getCurrencyAndAmount(AmountType4Choice.AmountType4Choice_C1 choice) {
        if (choice.getInstdAmt() != null) {
            return choice.getInstdAmt();
        }
        if (choice.getEqvtAmt() != null) {
            return choice.getEqvtAmt().getAmt();
        }
        return null;
    }

    private static Currency getCounterValueCurrency(AmountType4Choice.AmountType4Choice_C1 choice) {
        if (choice.getEqvtAmt() != null) {
            return Currency.getInstance(choice.getEqvtAmt().getCcyOfTrf().getValue());
        }
        return null;
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstruction30 logicalFile = SEPAExtractorV9Iso.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeader85 grpHdr = SEPAExtractorV9Iso.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerCreditTransferInitiationV09 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV09(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstruction30> logicalFiles = new ArrayList<PaymentInstruction30>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV9Iso.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeader85 grpHdr = SEPAExtractorV9Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        return new Document(new CustomerCreditTransferInitiationV09(grpHdr, logicalFiles));
    }

    private static GroupHeader85 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        GroupHeader85 grpHdr = new GroupHeader85(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), SEPAExtractorV9Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstruction30 getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        String chargeBearer;
        PaymentTypeInformation26 pmtTpInf;
        SEPAPaymentData firstPayment = paymentList.get(0);
        PaymentMethod3Code paymentMethod = SEPAExtractorV9Iso.getPaymentMethodCode(firstPayment);
        DateAndDateTime2Choice choice = firstPayment.hasExecutionTime() ? new DateAndDateTime2Choice(DateAndDateTime2Choice.DateAndDateTime2Choice_C1.fromDtTm(new ISODateTime(firstPayment.getExecutionDate()))) : new DateAndDateTime2Choice(DateAndDateTime2Choice.DateAndDateTime2Choice_C1.fromDt(new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()))));
        PartyIdentification135 originator = SEPAExtractorV9Iso.getParty(firstPayment.getOriginator(), firstPayment.getOriginatorAddressData(), firstPayment.getOriginatorLei());
        BranchAndFinancialInstitutionIdentification6 originatorBank = SEPAExtractorV9Iso.getBankId(firstPayment.getOriginatorBic());
        CashAccount38 originatorAccount = SEPAExtractorV9Iso.getAccountId(firstPayment.getOriginatorIban());
        SEPAExtractorV9Iso.setAccountCurrencyAndType(originatorAccount, firstPayment.getAccountCurrency(), firstPayment.getOriginatorAccountType());
        boolean pmtTpInfOnLFLevel = firstPayment.getPmtTpInfOnLFLevel() != null ? firstPayment.getPmtTpInfOnLFLevel() : SEPAServiceLevel.SEPA.name().equals(firstPayment.getServiceLevel()) || firstPayment.isUrgentPayment();
        boolean chargeBearerOnLFLevel = pmtTpInfOnLFLevel;
        PaymentInstruction30 logicalFile = new PaymentInstruction30(new Max35Text(logicalFileId), paymentMethod, choice, originator, originatorAccount, originatorBank, SEPAExtractorV9Iso.getTransactions(logicalFileId, paymentList, pmtTpInfOnLFLevel, chargeBearerOnLFLevel));
        BigDecimal controlSum = BigDecimal.ZERO;
        for (SEPAPaymentData p : paymentList) {
            controlSum = controlSum.add(p.getAmount());
        }
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(paymentList.size())));
        if (pmtTpInfOnLFLevel && (pmtTpInf = SEPAExtractorV9Iso.getPaymentTypeInfo(firstPayment)) != null) {
            logicalFile.setPmtTpInf(pmtTpInf);
        }
        if (chargeBearerOnLFLevel && (chargeBearer = StringUtils.checkNullAndTrim(firstPayment.getChargeBearer())).length() > 0) {
            logicalFile.setChrgBr(new ChargeBearerType1Code(chargeBearer));
        }
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return logicalFile;
    }

    private static PaymentMethod3Code getPaymentMethodCode(SEPAPaymentData firstPayment) {
        String paymentMethod = firstPayment.getPaymentMethod();
        if (paymentMethod != null && paymentMethod.trim().length() > 0) {
            return new PaymentMethod3Code(paymentMethod.trim());
        }
        return new PaymentMethod3Code(SEPAPaymentMethod.TRF.name());
    }

    private static void setAccountCurrencyAndType(CashAccount38 account, Currency currency, String type) {
        if (currency != null) {
            account.setCcy(new ActiveOrHistoricCurrencyCode(currency.getCurrencyCode()));
        }
        if ((type = StringUtils.checkNullAndTrim(type)).length() > 0) {
            if (SEPAAccountType.isProprietaryValue(type)) {
                account.setTp(new CashAccountType2Choice(CashAccountType2Choice.CashAccountType2Choice_C1.fromPrtry(new Max35Text(type))));
            } else {
                account.setTp(new CashAccountType2Choice(CashAccountType2Choice.CashAccountType2Choice_C1.fromCd(new ExternalCashAccountType1Code(type))));
            }
        }
    }

    private static String getAccountType(CashAccount38 account) {
        if (account.getTp() != null) {
            if (account.getTp().getChoice1().getPrtry() != null) {
                return account.getTp().getChoice1().getPrtry().getValue();
            }
            if (account.getTp().getChoice1().getCd() != null) {
                return account.getTp().getChoice1().getCd().getValue();
            }
        }
        return null;
    }

    private static PaymentTypeInformation26 getPaymentTypeInfo(SEPAPaymentData paymentData) {
        String instructionPriority;
        CategoryPurpose1Choice ctgyPurp;
        LocalInstrument2Choice lclInstrm;
        PaymentTypeInformation26 pmtTpInf = null;
        ServiceLevel8Choice svcLvl = SEPAExtractorV9Iso.getServiceLevel(paymentData.getServiceLevel());
        if (svcLvl != null) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation26();
            }
            pmtTpInf.getSvcLvls().add(svcLvl);
        }
        if ((lclInstrm = SEPAExtractorV9Iso.getLocalInstrument(paymentData.getLocalInstrument())) != null) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation26();
            }
            pmtTpInf.setLclInstrm(lclInstrm);
        }
        if ((ctgyPurp = SEPAExtractorV9Iso.getPaymentCategory(paymentData.getPaymentCategory())) != null) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation26();
            }
            pmtTpInf.setCtgyPurp(ctgyPurp);
        }
        if ((instructionPriority = StringUtils.checkNullAndTrim(paymentData.getInstructionPriority())).length() > 0) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation26();
            }
            pmtTpInf.setInstrPrty(new Priority2Code(instructionPriority));
        }
        return pmtTpInf;
    }

    private static List<CreditTransferTransaction34> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList, boolean pmtTpInfOnLFLevel, boolean chargeBearerOnLFLevel) {
        ArrayList<CreditTransferTransaction34> transactions = new ArrayList<CreditTransferTransaction34>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String chargeBearer;
            String purposeCode;
            String ultimateCreditor;
            String ultimateDebitor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification6 pmtId = new PaymentIdentification6(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            PartyIdentification135 recipient = SEPAExtractorV9Iso.getParty(paymentData.getRecipient(), paymentData.getRecipientAddressData(), paymentData.getRecipientLei());
            CashAccount38 recipientIban = SEPAExtractorV9Iso.getAccountId(paymentData.getRecipientIban());
            CreditTransferTransaction34 transaction = new CreditTransferTransaction34(pmtId, SEPAExtractorV9Iso.getAmt(paymentData.getAmount(), paymentData.getCurrency(), paymentData.getCounterValueCurrency()));
            transaction.setCdtr(recipient);
            transaction.setCdtrAcct(recipientIban);
            BranchAndFinancialInstitutionIdentification6 cdtrAgt = SEPAExtractorV9Iso.getCdtrAgt(paymentData);
            if (cdtrAgt != null) {
                transaction.setCdtrAgt(cdtrAgt);
            }
            if ((ultimateDebitor = paymentData.getUltimateOriginator()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPAExtractorV9Iso.getParty(ultimateDebitor));
            }
            if ((ultimateCreditor = paymentData.getUltimateRecipient()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPAExtractorV9Iso.getParty(ultimateCreditor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose2Choice(Purpose2Choice.Purpose2Choice_C1.fromCd(new ExternalPurpose1Code(purposeCode.trim()))));
            }
            for (RegReporting reporting : paymentData.getRegReportings()) {
                transaction.getRgltryRptgs().add(SEPAExtractorV9Iso.getRegulatoryReporting(reporting));
            }
            RemittanceInformation16 remittanceInfo = SEPAExtractorV9Iso.getRemittanceInformation(paymentData);
            if (remittanceInfo != null) {
                transaction.setRmtInf(remittanceInfo);
            }
            if (!pmtTpInfOnLFLevel) {
                transaction.setPmtTpInf(SEPAExtractorV9Iso.getPaymentTypeInfo(paymentData));
            }
            if (!chargeBearerOnLFLevel && (chargeBearer = StringUtils.checkNullAndTrim(paymentData.getChargeBearer())).length() > 0) {
                transaction.setChrgBr(new ChargeBearerType1Code(chargeBearer));
            }
            transaction.setChqInstr(SEPAExtractorV9Iso.getChqInstr(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static RegulatoryReporting3 getRegulatoryReporting(RegReporting reporting) {
        String indicator;
        RegulatoryReporting3 rr = new RegulatoryReporting3();
        RegulatoryAuthority2 regAuth = SEPAExtractorV9Iso.getRegAuthority(reporting.getAuthorityCountry(), reporting.getAuthorityName());
        if (regAuth != null) {
            rr.setAuthrty(regAuth);
        }
        if ((indicator = StringUtils.checkNullAndTrim(reporting.getCreditDebitIndicator())).length() > 0) {
            rr.setDbtCdtRptgInd(new RegulatoryReportingType1Code(indicator));
        }
        for (RegReportingDetail reportingDetail : reporting.getDetails()) {
            StructuredRegulatoryReporting3 srr = SEPAExtractorV9Iso.getRegulatoryReportingDetail(reportingDetail);
            if (srr == null) continue;
            rr.getDtlss().add(srr);
        }
        return rr;
    }

    private static RegulatoryAuthority2 getRegAuthority(String countryCode, String name) {
        String regAuthName;
        RegulatoryAuthority2 regAuth = null;
        if (countryCode != null && RegularExpressions.COUNTRY_CODE.matches(countryCode)) {
            regAuth = new RegulatoryAuthority2();
            regAuth.setCtry(new CountryCode(countryCode));
        }
        if ((regAuthName = StringUtils.checkNullAndTrim(name)).length() > 0) {
            if (regAuth == null) {
                regAuth = new RegulatoryAuthority2();
            }
            regAuth.setNm(new Max140Text(regAuthName));
        }
        return regAuth;
    }

    private static StructuredRegulatoryReporting3 getRegulatoryReportingDetail(RegReportingDetail detail) {
        String type;
        String code;
        StructuredRegulatoryReporting3 srr = null;
        if (detail.getAmount() != null && detail.getCurrency() != null) {
            srr = new StructuredRegulatoryReporting3();
            srr.setAmt(new ActiveOrHistoricCurrencyAndAmount(detail.getAmount(), new ActiveOrHistoricCurrencyCode(detail.getCurrency().getCurrencyCode())));
        }
        if ((code = StringUtils.checkNullAndTrim(detail.getCode())).length() > 0) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setCd(new Max10Text(code));
        }
        if (detail.getCountry() != null && RegularExpressions.COUNTRY_CODE.matches(detail.getCountry())) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setCtry(new CountryCode(detail.getCountry()));
        }
        if (detail.getDate() != null) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setDt(new ISODate(new YYMMDD(detail.getDate().getTime())));
        }
        if ((type = StringUtils.checkNullAndTrim(detail.getType())).length() > 0) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setTp(new Max35Text(type));
        }
        for (String inf : detail.getInfs()) {
            String info = StringUtils.checkNullAndTrim(inf);
            if (info.length() <= 0) continue;
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.getInfs().add(new Max35Text(inf));
        }
        return srr;
    }

    private static BranchAndFinancialInstitutionIdentification6 getCdtrAgt(SEPAPaymentData paymentData) {
        PostalAddress24 recipientBankAddress;
        String bankName;
        FinancialInstitutionIdentification18 finInstnId = new FinancialInstitutionIdentification18();
        boolean hasValues = false;
        String bankCode = StringUtils.checkNullAndTrim(paymentData.getRecipientBic());
        if (bankCode.length() > 0) {
            String clearingSystemId = StringUtils.checkNullAndTrim(paymentData.getRecipientClearingSystemId());
            if (clearingSystemId.length() > 0) {
                ClearingSystemMemberIdentification2 clrSysMmbId = new ClearingSystemMemberIdentification2(new Max35Text(bankCode));
                ExternalClearingSystemIdentification1Code clrSysCode = new ExternalClearingSystemIdentification1Code(clearingSystemId);
                clrSysMmbId.setClrSysId(new ClearingSystemIdentification2Choice(ClearingSystemIdentification2Choice.ClearingSystemIdentification2Choice_C1.fromCd(clrSysCode)));
                finInstnId.setClrSysMmbId(clrSysMmbId);
            } else if (RegularExpressions.BIC.matches(bankCode)) {
                finInstnId.setBICFI(new BICFIDec2014Identifier(bankCode));
            } else {
                finInstnId.setOthr(new GenericFinancialIdentification1(new Max35Text(bankCode)));
            }
            hasValues = true;
        }
        if ((bankName = StringUtils.checkNullAndTrim(paymentData.getRecipientBankName())).length() > 0) {
            finInstnId.setNm(new Max140Text(bankName));
            hasValues = true;
        }
        if ((recipientBankAddress = SEPAExtractorV9Iso.saveAddress(paymentData.getRecipientBankAddressData())) != null) {
            finInstnId.setPstlAdr(recipientBankAddress);
            hasValues = true;
        }
        if (hasValues) {
            return new BranchAndFinancialInstitutionIdentification6(finInstnId);
        }
        return null;
    }

    private static RemittanceInformation16 getRemittanceInformation(SEPAPaymentData paymentData) {
        RemittanceInformation16 remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            List<String> purposeLines;
            StructuredRemittanceInformation16 structured = null;
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                CreditorReferenceInformation2 cdtrRefInf = new CreditorReferenceInformation2();
                cdtrRefInf.setRef(new Max35Text(paymentData.getPurposeReference()));
                CreditorReferenceType2 tp = SEPAExtractorV9Iso.getPurposeReferenceType(paymentData);
                if (tp != null) {
                    cdtrRefInf.setTp(tp);
                }
                structured = new StructuredRemittanceInformation16();
                structured.setCdtrRefInf(cdtrRefInf);
            }
            if ((purposeLines = paymentData.getStructuredPurposeLines()).size() > 0) {
                if (structured == null) {
                    structured = new StructuredRemittanceInformation16();
                }
                for (String purposeLine : purposeLines) {
                    structured.getAddtlRmtInfs().add(new Max140Text(purposeLine));
                }
            }
            if (structured != null) {
                remittanceInfo = new RemittanceInformation16();
                remittanceInfo.getStrds().add(structured);
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformation16();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
            }
        }
        return remittanceInfo;
    }

    private static CreditorReferenceType2 getPurposeReferenceType(SEPAPaymentData paymentData) {
        CreditorReferenceType1Choice choice = null;
        String structuredTypeCode = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypeCode());
        if (structuredTypeCode.length() > 0) {
            DocumentType3Code code = new DocumentType3Code(structuredTypeCode);
            choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromCd(code));
        } else {
            String structuredTypePrtry = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypePrtry());
            if (structuredTypePrtry.length() > 0) {
                Max35Text prtry = new Max35Text(structuredTypePrtry);
                choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromPrtry(prtry));
            }
        }
        if (choice != null) {
            return new CreditorReferenceType2(choice);
        }
        return null;
    }

    private static void setPurposeInformation(RemittanceInformation16 rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            List<Max140Text> unstructuredLines = rmtInf.getUstrds();
            List<StructuredRemittanceInformation16> structuredInfoList = rmtInf.getStrds();
            if (unstructuredLines != null && unstructuredLines.size() > 0) {
                paymentData.setHasStructuredPurpose(false);
                StringBuilder sb = new StringBuilder();
                for (Max140Text purposeLine : unstructuredLines) {
                    String s = purposeLine.getValue();
                    paymentData.getUnstructuredPurposeLines().add(s);
                    sb.append(s);
                }
                paymentData.setPurpose(sb.toString());
            } else if (structuredInfoList != null && structuredInfoList.size() > 0) {
                CreditorReferenceInformation2 cdtrRefInf;
                paymentData.setHasStructuredPurpose(true);
                StructuredRemittanceInformation16 structuredInfo = structuredInfoList.get(0);
                List<Max140Text> purposeLines = structuredInfo.getAddtlRmtInfs();
                if (purposeLines.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (Max140Text purposeLine : purposeLines) {
                        String s = purposeLine.getValue();
                        paymentData.getStructuredPurposeLines().add(s);
                        sb.append(s);
                    }
                    paymentData.setPurpose(sb.toString());
                }
                if ((cdtrRefInf = structuredInfo.getCdtrRefInf()) != null) {
                    CreditorReferenceType2 tp;
                    if (cdtrRefInf.getRef() != null) {
                        paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                    }
                    if ((tp = cdtrRefInf.getTp()) != null) {
                        CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1 c = tp.getCdOrPrtry().getChoice1();
                        if (c.getCd() != null) {
                            paymentData.setPurposeReferenceTypeCode(c.getCd().getValue());
                        } else if (c.getPrtry() != null) {
                            paymentData.setPurposeReferenceTypePrtry(c.getPrtry().getValue());
                        }
                    }
                }
            }
        }
    }

    private static PartyIdentification135 getParty(String name) {
        return SEPAExtractorV9Iso.getParty(name, null, null);
    }

    private static PartyIdentification135 getParty(String name, AddressData addressData, String legalEntityIdentifier) {
        String lei;
        PostalAddress24 address;
        PartyIdentification135 party = new PartyIdentification135();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max140Text(name));
        }
        if ((address = SEPAExtractorV9Iso.saveAddress(addressData)) != null) {
            party.setPstlAdr(address);
        }
        if ((lei = StringUtils.checkNullAndTrim(legalEntityIdentifier)).length() > 0) {
            OrganisationIdentification29 orgId = new OrganisationIdentification29();
            orgId.setLEI(new LEIIdentifier(legalEntityIdentifier));
            party.setId(new Party38Choice(Party38Choice.Party38Choice_C1.fromOrgId(orgId)));
        }
        return party;
    }

    private static PostalAddress24 saveAddress(AddressData addressData) {
        if (addressData != null) {
            String s;
            PostalAddress24 pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getDepartment())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setDept(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getSubDepartment())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setSubDept(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getStreetName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setStrtNm(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getBuildingNumber())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setBldgNb(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getBuildingName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setBldgNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getFloor())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setFlr(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getPostCode())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setPstCd(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getTownName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setTwnNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getCountrySubDivision())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setCtrySubDvsn(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getBuildingName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setBldgNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getFloor())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setFlr(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getRoom())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setRoom(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getPostBox())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setPstBx(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getTownLocationName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setTwnLctnNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getDistrictName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setDstrctNm(new Max35Text(s));
            }
            if (pstlAdr != null && (pstlAdr.getCtry() == null || pstlAdr.getTwnNm() == null)) {
                return null;
            }
            return pstlAdr;
        }
        return null;
    }

    private static AddressData getAddressData(PostalAddress24 address) {
        AddressData addressData = new AddressData();
        CountryCode countryCode = address.getCtry();
        if (countryCode != null) {
            addressData.setCountry(countryCode.getValue());
        }
        for (Max70Text line : address.getAdrLines()) {
            addressData.getAddressLines().add(line.getValue());
        }
        addressData.setDepartment(SimpleStringElement.getValue(address.getDept()));
        addressData.setSubDepartment(SimpleStringElement.getValue(address.getSubDept()));
        addressData.setStreetName(SimpleStringElement.getValue(address.getStrtNm()));
        addressData.setBuildingNumber(SimpleStringElement.getValue(address.getBldgNb()));
        addressData.setPostCode(SimpleStringElement.getValue(address.getPstCd()));
        addressData.setTownName(SimpleStringElement.getValue(address.getTwnNm()));
        addressData.setCountrySubDivision(SimpleStringElement.getValue(address.getCtrySubDvsn()));
        addressData.setBuildingName(SimpleStringElement.getValue(address.getBldgNm()));
        addressData.setFloor(SimpleStringElement.getValue(address.getFlr()));
        addressData.setRoom(SimpleStringElement.getValue(address.getRoom()));
        addressData.setPostBox(SimpleStringElement.getValue(address.getPstBx()));
        addressData.setTownLocationName(SimpleStringElement.getValue(address.getTwnLctnNm()));
        addressData.setDistrictName(SimpleStringElement.getValue(address.getDstrctNm()));
        return addressData;
    }

    private static BranchAndFinancialInstitutionIdentification6 getBankId(String bic) {
        FinancialInstitutionIdentification18 id = new FinancialInstitutionIdentification18();
        if (bic != null && bic.trim().length() >= 8) {
            id.setBICFI(new BICFIDec2014Identifier(bic.trim()));
        } else {
            id.setOthr(new GenericFinancialIdentification1(new Max35Text("NOTPROVIDED")));
        }
        return new BranchAndFinancialInstitutionIdentification6(id);
    }

    private static CashAccount38 getAccountId(String iban) {
        String accountNumber = StringUtils.checkNullAndTrim(iban);
        if (accountNumber.length() > 0) {
            AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = null;
            c1 = IbanUtil.checkIbanPattern(accountNumber) ? AccountIdentification4Choice.AccountIdentification4Choice_C1.fromIBAN(new IBAN2007Identifier(accountNumber)) : AccountIdentification4Choice.AccountIdentification4Choice_C1.fromOthr(new GenericAccountIdentification1(new Max34Text(accountNumber)));
            return new CashAccount38(new AccountIdentification4Choice(c1));
        }
        return null;
    }

    private static AmountType4Choice getAmt(BigDecimal amount, Currency currency, Currency counterValueCurrency) {
        AmountType4Choice.AmountType4Choice_C1 c1;
        ActiveOrHistoricCurrencyCode ccy = new ActiveOrHistoricCurrencyCode(currency.getCurrencyCode());
        ActiveOrHistoricCurrencyAndAmount amt = new ActiveOrHistoricCurrencyAndAmount(amount, ccy);
        if (counterValueCurrency != null) {
            ActiveOrHistoricCurrencyCode counterValueCcy = new ActiveOrHistoricCurrencyCode(counterValueCurrency.getCurrencyCode());
            c1 = AmountType4Choice.AmountType4Choice_C1.fromEqvtAmt(new EquivalentAmount2(amt, counterValueCcy));
        } else {
            c1 = AmountType4Choice.AmountType4Choice_C1.fromInstdAmt(amt);
        }
        return new AmountType4Choice(c1);
    }
}

