/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.pain00100108.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00100108.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00100108.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.iso20022.pain00100108.AmountType4Choice;
import de.businesslogics.format.iso20022.pain00100108.BICFIIdentifier;
import de.businesslogics.format.iso20022.pain00100108.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00100108.BranchAndFinancialInstitutionIdentification5;
import de.businesslogics.format.iso20022.pain00100108.CashAccount24;
import de.businesslogics.format.iso20022.pain00100108.CategoryPurpose1Choice;
import de.businesslogics.format.iso20022.pain00100108.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00100108.CreditTransferTransaction26;
import de.businesslogics.format.iso20022.pain00100108.CustomerCreditTransferInitiationV08;
import de.businesslogics.format.iso20022.pain00100108.DateAndDateTimeChoice;
import de.businesslogics.format.iso20022.pain00100108.DecimalNumber;
import de.businesslogics.format.iso20022.pain00100108.Document;
import de.businesslogics.format.iso20022.pain00100108.ExternalCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00100108.ExternalLocalInstrument1Code;
import de.businesslogics.format.iso20022.pain00100108.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.pain00100108.ExternalServiceLevel1Code;
import de.businesslogics.format.iso20022.pain00100108.FinancialInstitutionIdentification8;
import de.businesslogics.format.iso20022.pain00100108.GenericAccountIdentification1;
import de.businesslogics.format.iso20022.pain00100108.GenericFinancialIdentification1;
import de.businesslogics.format.iso20022.pain00100108.GroupHeader48;
import de.businesslogics.format.iso20022.pain00100108.IBAN2007Identifier;
import de.businesslogics.format.iso20022.pain00100108.ISODate;
import de.businesslogics.format.iso20022.pain00100108.ISODateTime;
import de.businesslogics.format.iso20022.pain00100108.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00100108.Max140Text;
import de.businesslogics.format.iso20022.pain00100108.Max15NumericText;
import de.businesslogics.format.iso20022.pain00100108.Max34Text;
import de.businesslogics.format.iso20022.pain00100108.Max35Text;
import de.businesslogics.format.iso20022.pain00100108.PartyIdentification43;
import de.businesslogics.format.iso20022.pain00100108.PaymentIdentification1;
import de.businesslogics.format.iso20022.pain00100108.PaymentInstruction22;
import de.businesslogics.format.iso20022.pain00100108.PaymentMethod3Code;
import de.businesslogics.format.iso20022.pain00100108.PaymentTypeInformation19;
import de.businesslogics.format.iso20022.pain00100108.Purpose2Choice;
import de.businesslogics.format.iso20022.pain00100108.ReferredDocumentInformation7;
import de.businesslogics.format.iso20022.pain00100108.RemittanceInformation11;
import de.businesslogics.format.iso20022.pain00100108.ServiceLevel8Choice;
import de.businesslogics.format.iso20022.pain00100108.StructuredRemittanceInformation13;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV8Iso {
    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        CustomerCreditTransferInitiationV08 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader48 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstruction22 p : ccti.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            SEPAExtractorV8Iso.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (CreditTransferTransaction26 c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV8Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.Iso00100108);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerCreditTransferInitiationV08 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader48 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstruction22 p : ccti.getPmtInfs()) {
            for (CreditTransferTransaction26 c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV8Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstruction22 p, CreditTransferTransaction26 t) {
        Date executionDate;
        String origName = SimpleStringElement.getNonNullValue(p.getDbtr().getNm());
        String origAccNumber = null;
        boolean isOrigIban = true;
        AccountNumberInfo origAccNumberInfo = SEPAExtractorV8Iso.getAccountNumberInfo(p.getDbtrAcct().getId().getChoice1());
        if (origAccNumberInfo != null) {
            origAccNumber = origAccNumberInfo.getAccountNumber();
            isOrigIban = origAccNumberInfo.isFromIbanTag();
        }
        String origBankCode = SEPAExtractorV8Iso.getBankIdentifier(p.getDbtrAgt().getFinInstnId());
        Currency accountCurrency = null;
        ActiveOrHistoricCurrencyCode ccy = p.getDbtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        String recip = "";
        if (t.getCdtr() != null) {
            recip = SimpleStringElement.getNonNullValue(t.getCdtr().getNm());
        }
        String recipAccNumber = null;
        boolean isRecipIban = true;
        AccountNumberInfo recipAccNumberInfo = SEPAExtractorV8Iso.getAccountNumberInfo(t.getCdtrAcct().getId().getChoice1());
        if (recipAccNumberInfo != null) {
            recipAccNumber = recipAccNumberInfo.getAccountNumber();
            isRecipIban = recipAccNumberInfo.isFromIbanTag();
        }
        String recipBankCode = "";
        if (t.getCdtrAgt() != null) {
            recipBankCode = SEPAExtractorV8Iso.getBankIdentifier(t.getCdtrAgt().getFinInstnId());
        }
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV8Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
        boolean hasExecutionTime = false;
        DateAndDateTimeChoice.DateAndDateTimeChoice_C1 choice = p.getReqdExctnDt().getChoice1();
        if (choice.getDt() != null) {
            executionDate = choice.getDt().getDate();
        } else {
            executionDate = choice.getDtTm().getDate();
            hasExecutionTime = true;
        }
        String purpose = SEPAExtractorV8Iso.getPurpose(t.getRmtInf());
        String paymentCategory = "";
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = SEPAExtractorV8Iso.getPaymentCategory(p.getPmtTpInf().getCtgyPurp().getChoice1());
        } else if (t.getPmtTpInf() != null && t.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = SEPAExtractorV8Iso.getPaymentCategory(t.getPmtTpInf().getCtgyPurp().getChoice1());
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        PaymentTypeInformation19 pmtTpInf = p.getPmtTpInf();
        String serviceLevel = null;
        serviceLevel = pmtTpInf != null && pmtTpInf.getSvcLvl() != null && pmtTpInf.getSvcLvl().getChoice1().getCd() != null ? pmtTpInf.getSvcLvl().getChoice1().getCd().getValue() : GeneralSEPAExtractor.SEPA;
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBankCode, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()), executionDate, purpose, paymentCategory, endToEndId, instructionId, serviceLevel);
        paymentData.setIsOriginatorIban(isOrigIban);
        paymentData.setIsRecipientIban(isRecipIban);
        paymentData.setHasExecutionTime(hasExecutionTime);
        paymentData.setAccountCurrency(accountCurrency);
        if (pmtTpInf != null && pmtTpInf.getLclInstrm() != null && pmtTpInf.getLclInstrm().getChoice1().getCd() != null) {
            paymentData.setLocalInstrument(pmtTpInf.getLclInstrm().getChoice1().getCd().getValue());
        }
        if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getChoice1().getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        return paymentData;
    }

    public static String getPaymentCategory(CategoryPurpose1Choice.CategoryPurpose1Choice_C1 choice) {
        if (choice != null) {
            ExternalCategoryPurpose1Code categoryFromCd = choice.getCd();
            if (categoryFromCd != null) {
                return SimpleStringElement.getNonNullValue(categoryFromCd);
            }
            if (choice.getPrtry() != null) {
                return choice.getPrtry().getValue();
            }
        }
        return null;
    }

    private static CategoryPurpose1Choice getPaymentCategory(String paymentCategory) {
        String value = StringUtils.checkNullAndTrim(paymentCategory);
        if (value.length() > 0) {
            ExternalCategoryPurpose1Code cd = new ExternalCategoryPurpose1Code(value);
            if (SEPAPaymentCategory.isProprietary(value)) {
                return new CategoryPurpose1Choice(CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromPrtry(new Max35Text(value)));
            }
            return new CategoryPurpose1Choice(CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromCd(cd));
        }
        return null;
    }

    protected static AccountNumberInfo getAccountNumberInfo(AccountIdentification4Choice.AccountIdentification4Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return new AccountNumberInfo(choice.getIBAN().getValue(), true);
        }
        if (choice.getOthr() != null) {
            return new AccountNumberInfo(choice.getOthr().getId().getValue(), false);
        }
        return null;
    }

    protected static String getBankIdentifier(FinancialInstitutionIdentification8 choice) {
        if (choice.getBICFI() != null) {
            return choice.getBICFI().getValue();
        }
        if (choice.getOthr() != null) {
            String othrId = choice.getOthr().getId().getValue();
            if ("NOTPROVIDED".equals(othrId)) {
                return "";
            }
            return othrId;
        }
        return null;
    }

    protected static ActiveOrHistoricCurrencyAndAmount getCurrencyAndAmount(AmountType4Choice.AmountType4Choice_C1 choice) {
        if (choice.getInstdAmt() != null) {
            return choice.getInstdAmt();
        }
        if (choice.getEqvtAmt() != null) {
            return choice.getEqvtAmt().getAmt();
        }
        return null;
    }

    protected static String getPurpose(RemittanceInformation11 rmtInf) {
        if (rmtInf != null) {
            StringBuffer sb = new StringBuffer();
            if (rmtInf.getUstrds().size() > 0) {
                for (Max140Text text : rmtInf.getUstrds()) {
                    sb.append(SimpleStringElement.getNonNullValue(text));
                }
            } else if (rmtInf.getStrds().size() > 0) {
                for (StructuredRemittanceInformation13 s : rmtInf.getStrds()) {
                    if (s.getRfrdDocInfs() == null) continue;
                    for (ReferredDocumentInformation7 inf : s.getRfrdDocInfs()) {
                        sb.append(SimpleStringElement.getNonNullValue(inf.getNb()));
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstruction22 logicalFile = SEPAExtractorV8Iso.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeader48 grpHdr = SEPAExtractorV8Iso.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerCreditTransferInitiationV08 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV08(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstruction22> logicalFiles = new ArrayList<PaymentInstruction22>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV8Iso.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeader48 grpHdr = SEPAExtractorV8Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        return new Document(new CustomerCreditTransferInitiationV08(grpHdr, logicalFiles));
    }

    private static GroupHeader48 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        GroupHeader48 grpHdr = new GroupHeader48(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), SEPAExtractorV8Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstruction22 getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        PaymentMethod3Code paymentMethod = new PaymentMethod3Code(GeneralSEPAExtractor.TRF);
        DateAndDateTimeChoice choice = firstPayment.hasExecutionTime() ? new DateAndDateTimeChoice(DateAndDateTimeChoice.DateAndDateTimeChoice_C1.fromDtTm(new ISODateTime(firstPayment.getExecutionDate()))) : new DateAndDateTimeChoice(DateAndDateTimeChoice.DateAndDateTimeChoice_C1.fromDt(new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()))));
        PartyIdentification43 originator = SEPAExtractorV8Iso.getParty(firstPayment.getOriginator());
        BranchAndFinancialInstitutionIdentification5 originatorBic = SEPAExtractorV8Iso.getBankId(firstPayment.getOriginatorBic());
        CashAccount24 originatorIban = SEPAExtractorV8Iso.getAccountId(firstPayment.getOriginatorIban());
        if (firstPayment.getAccountCurrency() != null) {
            originatorIban.setCcy(new ActiveOrHistoricCurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstruction22 logicalFile = new PaymentInstruction22(new Max35Text(logicalFileId), paymentMethod, choice, originator, originatorIban, originatorBic, SEPAExtractorV8Iso.getTransactions(logicalFileId, paymentList));
        BigDecimal controlSum = BigDecimal.ZERO;
        for (SEPAPaymentData p : paymentList) {
            controlSum = controlSum.add(p.getAmount());
        }
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(paymentList.size())));
        PaymentTypeInformation19 paymentType = new PaymentTypeInformation19();
        ServiceLevel8Choice svcLvl = new ServiceLevel8Choice(ServiceLevel8Choice.ServiceLevel8Choice_C1.fromCd(new ExternalServiceLevel1Code(firstPayment.getServiceLevel())));
        paymentType.setSvcLvl(svcLvl);
        String localInstrument = StringUtils.checkNullAndTrim(firstPayment.getLocalInstrument());
        if (localInstrument.length() > 0) {
            LocalInstrument2Choice lclInstrm = new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromCd(new ExternalLocalInstrument1Code(localInstrument)));
            paymentType.setLclInstrm(lclInstrm);
        }
        paymentType.setCtgyPurp(SEPAExtractorV8Iso.getPaymentCategory(firstPayment.getPaymentCategory()));
        logicalFile.setPmtTpInf(paymentType);
        logicalFile.setChrgBr(new ChargeBearerType1Code("SLEV"));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return logicalFile;
    }

    private static List<CreditTransferTransaction26> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransaction26> transactions = new ArrayList<CreditTransferTransaction26>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String purposeCode;
            String ultimateCreditor;
            String ultimateDebitor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            PartyIdentification43 recipient = SEPAExtractorV8Iso.getParty(paymentData.getRecipient());
            CashAccount24 recipientIban = SEPAExtractorV8Iso.getAccountId(paymentData.getRecipientIban());
            CreditTransferTransaction26 transaction = new CreditTransferTransaction26(pmtId, SEPAExtractorV8Iso.getInstdAmount(paymentData.getAmount(), paymentData.getCurrency()));
            transaction.setCdtr(recipient);
            transaction.setCdtrAcct(recipientIban);
            String bic = paymentData.getRecipientBic();
            if (bic != null && bic.trim().length() >= 8) {
                FinancialInstitutionIdentification8 id = new FinancialInstitutionIdentification8();
                id.setBICFI(new BICFIIdentifier(bic.trim()));
                transaction.setCdtrAgt(new BranchAndFinancialInstitutionIdentification5(id));
            }
            if ((ultimateDebitor = paymentData.getUltimateOriginator()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPAExtractorV8Iso.getParty(ultimateDebitor));
            }
            if ((ultimateCreditor = paymentData.getUltimateRecipient()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPAExtractorV8Iso.getParty(ultimateCreditor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose2Choice(Purpose2Choice.Purpose2Choice_C1.fromCd(new ExternalPurpose1Code(purposeCode.trim()))));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                RemittanceInformation11 remittanceInfo = new RemittanceInformation11();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
                transaction.setRmtInf(remittanceInfo);
            }
            transactions.add(transaction);
        }
        return transactions;
    }

    private static PartyIdentification43 getParty(String name) {
        PartyIdentification43 party = new PartyIdentification43();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max140Text(name));
        }
        return party;
    }

    private static BranchAndFinancialInstitutionIdentification5 getBankId(String bic) {
        FinancialInstitutionIdentification8 id = new FinancialInstitutionIdentification8();
        if (bic != null && bic.trim().length() >= 8) {
            id.setBICFI(new BICFIIdentifier(bic.trim()));
        } else {
            id.setOthr(new GenericFinancialIdentification1(new Max35Text("NOTPROVIDED")));
        }
        return new BranchAndFinancialInstitutionIdentification5(id);
    }

    private static CashAccount24 getAccountId(String iban) {
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = null;
        c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification4Choice.AccountIdentification4Choice_C1.fromIBAN(new IBAN2007Identifier(iban)) : AccountIdentification4Choice.AccountIdentification4Choice_C1.fromOthr(new GenericAccountIdentification1(new Max34Text(iban)));
        return new CashAccount24(new AccountIdentification4Choice(c1));
    }

    private static AmountType4Choice getInstdAmount(BigDecimal amt, Currency c) {
        ActiveOrHistoricCurrencyCode ccy = new ActiveOrHistoricCurrencyCode(c.getCurrencyCode());
        ActiveOrHistoricCurrencyAndAmount instdAmt = new ActiveOrHistoricCurrencyAndAmount(amt, ccy);
        return new AmountType4Choice(AmountType4Choice.AmountType4Choice_C1.fromInstdAmt(instdAmt));
    }
}

