/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.pain00100103.AccountIdentificationSEPA;
import de.businesslogics.format.sepa.pain00100103.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.sepa.pain00100103.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.sepa.pain00100103.ActiveOrHistoricCurrencyCodeEUR;
import de.businesslogics.format.sepa.pain00100103.AmountTypeSEPA;
import de.businesslogics.format.sepa.pain00100103.BICIdentifier;
import de.businesslogics.format.sepa.pain00100103.BatchBookingIndicator;
import de.businesslogics.format.sepa.pain00100103.BranchAndFinancialInstitutionIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100103.BranchAndFinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00100103.CashAccountSEPA1;
import de.businesslogics.format.sepa.pain00100103.CashAccountSEPA2;
import de.businesslogics.format.sepa.pain00100103.CategoryPurposeSEPA;
import de.businesslogics.format.sepa.pain00100103.ChargeBearerTypeSEPACode;
import de.businesslogics.format.sepa.pain00100103.CountryCode;
import de.businesslogics.format.sepa.pain00100103.CreditTransferTransactionInformationSCT;
import de.businesslogics.format.sepa.pain00100103.CreditorReferenceInformationSEPA1;
import de.businesslogics.format.sepa.pain00100103.CreditorReferenceTypeCodeSEPA;
import de.businesslogics.format.sepa.pain00100103.CreditorReferenceTypeSEPA;
import de.businesslogics.format.sepa.pain00100103.CustomerCreditTransferInitiationV03;
import de.businesslogics.format.sepa.pain00100103.DecimalNumber;
import de.businesslogics.format.sepa.pain00100103.Document;
import de.businesslogics.format.sepa.pain00100103.DocumentType3CodeSEPA;
import de.businesslogics.format.sepa.pain00100103.ExternalCategoryPurpose1Code;
import de.businesslogics.format.sepa.pain00100103.ExternalPurpose1Code;
import de.businesslogics.format.sepa.pain00100103.ExternalServiceLevel1Code;
import de.businesslogics.format.sepa.pain00100103.FinancialInstitutionIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100103.FinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00100103.GroupHeaderSCT;
import de.businesslogics.format.sepa.pain00100103.IBAN2007Identifier;
import de.businesslogics.format.sepa.pain00100103.ISODate;
import de.businesslogics.format.sepa.pain00100103.ISODateTime;
import de.businesslogics.format.sepa.pain00100103.Max140Text;
import de.businesslogics.format.sepa.pain00100103.Max15NumericText;
import de.businesslogics.format.sepa.pain00100103.Max35Text;
import de.businesslogics.format.sepa.pain00100103.Max70Text;
import de.businesslogics.format.sepa.pain00100103.OthrIdentification;
import de.businesslogics.format.sepa.pain00100103.OthrIdentificationCode;
import de.businesslogics.format.sepa.pain00100103.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100103.PartyIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00100103.PaymentIdentificationSEPA;
import de.businesslogics.format.sepa.pain00100103.PaymentInstructionInformationSCT;
import de.businesslogics.format.sepa.pain00100103.PaymentMethodSCTCode;
import de.businesslogics.format.sepa.pain00100103.PaymentTypeInformationSCT1;
import de.businesslogics.format.sepa.pain00100103.PostalAddressSEPA;
import de.businesslogics.format.sepa.pain00100103.Priority2Code;
import de.businesslogics.format.sepa.pain00100103.PurposeSEPA;
import de.businesslogics.format.sepa.pain00100103.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.pain00100103.RestrictedIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100103.ServiceLevel;
import de.businesslogics.format.sepa.pain00100103.StructuredRemittanceInformationSEPA1;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV5 {
    public static XMLDate getDateSRZ(Document document) {
        return document.getCstmrCdtTrfInitn().getPmtInfs().get(0).getReqdExctnDt();
    }

    protected static List<SEPAPaymentData> getPaymentsFromCCT(Document document) {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        CustomerCreditTransferInitiationV03 pain00100202 = document.getCstmrCdtTrfInitn();
        String msgId = pain00100202.getGrpHdr().getMsgId().getValue();
        String initParty = pain00100202.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSCT p : pain00100202.getPmtInfs()) {
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV5.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFilesFromCCT(Document document) {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        CustomerCreditTransferInitiationV03 pain00100202 = document.getCstmrCdtTrfInitn();
        String msgId = pain00100202.getGrpHdr().getMsgId().getValue();
        String initParty = pain00100202.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSCT p : pain00100202.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(p.getPmtInfId().getValue(), msgId);
            SEPAExtractorV5.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV5.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V30);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    private static SEPAPaymentData getPaymentDataFromCCT(String msgId, String initParty, PaymentInstructionInformationSCT p, CreditTransferTransactionInformationSCT c) {
        PartyIdentificationSEPA2 debtor = p.getDbtr();
        String orig = debtor.getNm().getValue();
        String origIban = p.getDbtrAcct().getId().getIBAN().getValue();
        Currency accountCurrency = null;
        ActiveOrHistoricCurrencyCode ccy = p.getDbtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String origBic = "";
        BICIdentifier bic = p.getDbtrAgt().getFinInstnId().getChoice1().getBIC();
        if (bic != null) {
            origBic = bic.getValue();
        }
        String ultimateOrig = null;
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(p.getUltmtDbtr().getNm());
        } else if (c.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(c.getUltmtDbtr().getNm());
        }
        String recip = c.getCdtr().getNm().getValue();
        String recipIban = c.getCdtrAcct().getId().getIBAN().getValue();
        String recipBic = "";
        if (c.getCdtrAgt() != null) {
            recipBic = c.getCdtrAgt().getFinInstnId().getBIC().getValue();
        }
        String ultimateRecip = null;
        if (c.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getValue(c.getUltmtCdtr().getNm());
        }
        BigDecimal amount = c.getAmt().getInstdAmt().getValue();
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null && p.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getCd().getValue();
        } else if (c.getPmtTpInf() != null && c.getPmtTpInf().getCtgyPurp() != null && c.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = c.getPmtTpInf().getCtgyPurp().getCd().getValue();
        }
        String endToEndId = c.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = null;
        instructionId = c.getPmtId().getInstrId() != null ? c.getPmtId().getInstrId().getValue() : "";
        String serviceLevel = null;
        serviceLevel = p.getPmtTpInf() != null ? p.getPmtTpInf().getSvcLvl().getCd().getValue() : GeneralSEPAExtractor.SEPA;
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, null, paymentCategory, endToEndId, instructionId, serviceLevel);
        paymentData.setAccountCurrency(accountCurrency);
        PurposeSEPA purposeCode = c.getPurp();
        if (purposeCode != null) {
            paymentData.setPurposeCode(purposeCode.getCd().getValue());
        }
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getInstrPrty() != null) {
            paymentData.setInstructionPriority(p.getPmtTpInf().getInstrPrty().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        if (debtor.getPstlAdr() != null) {
            paymentData.setOriginatorAddressData(SEPAExtractorV5.getAddressData(debtor.getPstlAdr()));
        }
        SEPAExtractorV5.setPurposeInformation(c.getRmtInf(), paymentData);
        return paymentData;
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformationSCT logicalFile = SEPAExtractorV5.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeaderSCT grpHdr = SEPAExtractorV5.getGroupHeader(new ISODateTime(new Date()), "TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerCreditTransferInitiationV03 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV03(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        return SEPAExtractorV5.getCreditDocument(new ISODateTime(new Date()), messageId, initiatingParty, paymentLists);
    }

    public static Document getCreditDocument(ISODateTime creationDate, String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSCT> logicalFiles = new ArrayList<PaymentInstructionInformationSCT>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV5.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeaderSCT grpHdr = SEPAExtractorV5.getGroupHeader(creationDate, messageId, initiatingParty, totalCountTransactions, ctrlSum);
        CustomerCreditTransferInitiationV03 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV03(grpHdr);
        for (PaymentInstructionInformationSCT logicalFile : logicalFiles) {
            cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        }
        return new Document(cstmrCdtTrfInitn);
    }

    private static GroupHeaderSCT getGroupHeader(ISODateTime creationDate, String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        PartyIdentificationSEPA1 initgPty = new PartyIdentificationSEPA1();
        if (initiatingParty != null && !initiatingParty.isEmpty()) {
            initgPty.setNm(new Max70Text(initiatingParty));
        }
        GroupHeaderSCT grpHdr = new GroupHeaderSCT(new RestrictedIdentificationSEPA1(messageId), creationDate, new Max15NumericText(String.valueOf(totalCountTransactions)), initgPty);
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformationSCT getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        String instructionPriority;
        SEPAPaymentData firstPayment = paymentList.get(0);
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSEPA2 originator = new PartyIdentificationSEPA2(new Max70Text(firstPayment.getOriginator()));
        PostalAddressSEPA originatorAddress = SEPAExtractorV5.saveAddress(firstPayment.getOriginatorAddressData());
        if (originatorAddress != null) {
            originator.setPstlAdr(originatorAddress);
        }
        CashAccountSEPA1 originatorIban = new CashAccountSEPA1(new AccountIdentificationSEPA(new IBAN2007Identifier(firstPayment.getOriginatorIban())));
        if (firstPayment.getAccountCurrency() != null) {
            originatorIban.setCcy(new ActiveOrHistoricCurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstructionInformationSCT logicalFile = new PaymentInstructionInformationSCT(new RestrictedIdentificationSEPA1(logicalFileId), new PaymentMethodSCTCode(GeneralSEPAExtractor.TRF), executionDate, originator, originatorIban, SEPAExtractorV5.getBankId(firstPayment.getOriginatorBic()));
        PaymentTypeInformationSCT1 category = new PaymentTypeInformationSCT1(new ServiceLevel(new ExternalServiceLevel1Code(firstPayment.getServiceLevel())));
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            category.setCtgyPurp(new CategoryPurposeSEPA(new ExternalCategoryPurpose1Code(categoryPurpose)));
        }
        if ((instructionPriority = firstPayment.getInstructionPriority()) != null && instructionPriority.length() > 0) {
            category.setInstrPrty(new Priority2Code(instructionPriority));
        }
        logicalFile.setPmtTpInf(category);
        logicalFile.setChrgBr(new ChargeBearerTypeSEPACode(SEPAFeeType.SLEV.name()));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        BigDecimal controlSum = BigDecimal.ZERO;
        for (CreditTransferTransactionInformationSCT transaction : SEPAExtractorV5.getTransactions(logicalFileId, paymentList)) {
            logicalFile.getCdtTrfTxInfs().add(transaction);
            controlSum = controlSum.add(transaction.getAmt().getInstdAmt().getValue());
        }
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(logicalFile.getCdtTrfTxInfs().size())));
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        return logicalFile;
    }

    private static BranchAndFinancialInstitutionIdentificationSEPA3 getBankId(String bic) {
        FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1 c = null;
        c = bic != null && bic.trim().length() >= 8 ? FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1.fromBIC(new BICIdentifier(bic.trim())) : FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1.fromOthr(new OthrIdentification(new OthrIdentificationCode("NOTPROVIDED")));
        return new BranchAndFinancialInstitutionIdentificationSEPA3(new FinancialInstitutionIdentificationSEPA3(c));
    }

    private static List<CreditTransferTransactionInformationSCT> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransactionInformationSCT> transactions = new ArrayList<CreditTransferTransactionInformationSCT>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purposeCode;
            String ultimateRecipient;
            String ultimateOriginator;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentificationSEPA pmtId = new PaymentIdentificationSEPA(new RestrictedIdentificationSEPA1((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new RestrictedIdentificationSEPA1(instructionId));
            }
            AmountTypeSEPA amount = new AmountTypeSEPA(new ActiveOrHistoricCurrencyAndAmountSEPA(paymentData.getAmount(), new ActiveOrHistoricCurrencyCodeEUR("EUR")));
            PartyIdentificationSEPA2 recipient = SEPAExtractorV5.getParty(paymentData.getRecipient(), paymentData.getRecipientAddressData());
            CashAccountSEPA2 recipientIban = new CashAccountSEPA2(new AccountIdentificationSEPA(new IBAN2007Identifier(paymentData.getRecipientIban())));
            CreditTransferTransactionInformationSCT transaction = new CreditTransferTransactionInformationSCT(pmtId, amount, recipient, recipientIban);
            String bic = paymentData.getRecipientBic();
            if (bic != null && bic.trim().length() >= 8) {
                transaction.setCdtrAgt(new BranchAndFinancialInstitutionIdentificationSEPA1(new FinancialInstitutionIdentificationSEPA1(new BICIdentifier(bic.trim()))));
            }
            if ((ultimateOriginator = paymentData.getUltimateOriginator()) != null && ultimateOriginator.length() > 0) {
                PartyIdentificationSEPA1 ultimateOrig = new PartyIdentificationSEPA1();
                ultimateOrig.setNm(new Max70Text(ultimateOriginator));
                transaction.setUltmtDbtr(ultimateOrig);
            }
            if ((ultimateRecipient = paymentData.getUltimateRecipient()) != null && ultimateRecipient.length() > 0) {
                PartyIdentificationSEPA1 ultimateRecip = new PartyIdentificationSEPA1();
                ultimateRecip.setNm(new Max70Text(ultimateRecipient));
                transaction.setUltmtCdtr(ultimateRecip);
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new PurposeSEPA(new ExternalPurpose1Code(purposeCode.trim())));
            }
            transaction.setRmtInf(SEPAExtractorV5.getRemittanceInformation(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static PartyIdentificationSEPA2 getParty(String name, AddressData addressData) {
        PartyIdentificationSEPA2 party = new PartyIdentificationSEPA2(new Max70Text(name));
        PostalAddressSEPA address = SEPAExtractorV5.saveAddress(addressData);
        if (address != null) {
            party.setPstlAdr(address);
        }
        return party;
    }

    private static void setPurposeInformation(RemittanceInformationSEPA1Choice rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            if (rmtInf.getChoice1().getUstrd() != null) {
                paymentData.setPurpose(rmtInf.getChoice1().getUstrd().getValue());
            } else if (rmtInf.getChoice1().getStrd() != null && rmtInf.getChoice1().getStrd().getCdtrRefInf() != null) {
                CreditorReferenceInformationSEPA1 strctRmtInf = rmtInf.getChoice1().getStrd().getCdtrRefInf();
                paymentData.setHasStructuredPurpose(true);
                paymentData.setPurposeReference(strctRmtInf.getRef().getValue());
                paymentData.setPurposeReferenceTypeCode(strctRmtInf.getTp().getCdOrPrtry().getCd().getValue());
            }
        }
    }

    private static RemittanceInformationSEPA1Choice getRemittanceInformation(SEPAPaymentData paymentData) {
        RemittanceInformationSEPA1Choice remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                DocumentType3CodeSEPA documentTypeCode = new DocumentType3CodeSEPA("SCOR");
                CreditorReferenceTypeCodeSEPA cdtrReferenceTypeCode = new CreditorReferenceTypeCodeSEPA(documentTypeCode);
                CreditorReferenceTypeSEPA cdtrReferenceType = new CreditorReferenceTypeSEPA(cdtrReferenceTypeCode);
                CreditorReferenceInformationSEPA1 cdtrReference = new CreditorReferenceInformationSEPA1(cdtrReferenceType, new Max35Text(purposeReference));
                StructuredRemittanceInformationSEPA1 structured = new StructuredRemittanceInformationSEPA1();
                structured.setCdtrRefInf(cdtrReference);
                remittanceInfo = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromStrd(structured));
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromUstrd(new Max140Text(purpose)));
            }
        }
        return remittanceInfo;
    }

    private static PostalAddressSEPA saveAddress(AddressData addressData) {
        if (addressData != null) {
            PostalAddressSEPA pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddressSEPA();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddressSEPA();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            return pstlAdr;
        }
        return null;
    }

    private static AddressData getAddressData(PostalAddressSEPA address) {
        AddressData addressData = new AddressData();
        CountryCode countryCode = address.getCtry();
        if (countryCode != null) {
            addressData.setCountry(countryCode.getValue());
        }
        for (Max70Text line : address.getAdrLines()) {
            addressData.getAddressLines().add(line.getValue());
        }
        return addressData;
    }
}

