/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.iso20022.pain00100103.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00100103.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00100103.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.iso20022.pain00100103.AmountType3Choice;
import de.businesslogics.format.iso20022.pain00100103.BICIdentifier;
import de.businesslogics.format.iso20022.pain00100103.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00100103.BranchAndFinancialInstitutionIdentification4;
import de.businesslogics.format.iso20022.pain00100103.CashAccount16;
import de.businesslogics.format.iso20022.pain00100103.CashAccountType2;
import de.businesslogics.format.iso20022.pain00100103.CashAccountType4Code;
import de.businesslogics.format.iso20022.pain00100103.CategoryPurpose1Choice;
import de.businesslogics.format.iso20022.pain00100103.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00100103.Cheque6;
import de.businesslogics.format.iso20022.pain00100103.ChequeDelivery1Code;
import de.businesslogics.format.iso20022.pain00100103.ChequeDeliveryMethod1Choice;
import de.businesslogics.format.iso20022.pain00100103.ChequeType2Code;
import de.businesslogics.format.iso20022.pain00100103.ClearingSystemIdentification2Choice;
import de.businesslogics.format.iso20022.pain00100103.ClearingSystemMemberIdentification2;
import de.businesslogics.format.iso20022.pain00100103.CountryCode;
import de.businesslogics.format.iso20022.pain00100103.CreditTransferTransactionInformation10;
import de.businesslogics.format.iso20022.pain00100103.CreditorReferenceInformation2;
import de.businesslogics.format.iso20022.pain00100103.CreditorReferenceType1Choice;
import de.businesslogics.format.iso20022.pain00100103.CreditorReferenceType2;
import de.businesslogics.format.iso20022.pain00100103.CustomerCreditTransferInitiationV03;
import de.businesslogics.format.iso20022.pain00100103.DecimalNumber;
import de.businesslogics.format.iso20022.pain00100103.Document;
import de.businesslogics.format.iso20022.pain00100103.Document2;
import de.businesslogics.format.iso20022.pain00100103.DocumentType3Code;
import de.businesslogics.format.iso20022.pain00100103.EquivalentAmount2;
import de.businesslogics.format.iso20022.pain00100103.ExternalCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00100103.ExternalClearingSystemIdentification1Code;
import de.businesslogics.format.iso20022.pain00100103.ExternalLocalInstrument1Code;
import de.businesslogics.format.iso20022.pain00100103.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.pain00100103.ExternalServiceLevel1Code;
import de.businesslogics.format.iso20022.pain00100103.FinancialInstitutionIdentification7;
import de.businesslogics.format.iso20022.pain00100103.GenericAccountIdentification1;
import de.businesslogics.format.iso20022.pain00100103.GenericFinancialIdentification1;
import de.businesslogics.format.iso20022.pain00100103.GroupHeader32;
import de.businesslogics.format.iso20022.pain00100103.IBAN2007Identifier;
import de.businesslogics.format.iso20022.pain00100103.ISODate;
import de.businesslogics.format.iso20022.pain00100103.ISODateTime;
import de.businesslogics.format.iso20022.pain00100103.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00100103.Max10Text;
import de.businesslogics.format.iso20022.pain00100103.Max140Text;
import de.businesslogics.format.iso20022.pain00100103.Max15NumericText;
import de.businesslogics.format.iso20022.pain00100103.Max16Text;
import de.businesslogics.format.iso20022.pain00100103.Max34Text;
import de.businesslogics.format.iso20022.pain00100103.Max35Text;
import de.businesslogics.format.iso20022.pain00100103.Max70Text;
import de.businesslogics.format.iso20022.pain00100103.NameAndAddress10;
import de.businesslogics.format.iso20022.pain00100103.PartyIdentification32;
import de.businesslogics.format.iso20022.pain00100103.PaymentIdentification1;
import de.businesslogics.format.iso20022.pain00100103.PaymentInstructionInformation3;
import de.businesslogics.format.iso20022.pain00100103.PaymentMethod3Code;
import de.businesslogics.format.iso20022.pain00100103.PaymentTypeInformation19;
import de.businesslogics.format.iso20022.pain00100103.PostalAddress6;
import de.businesslogics.format.iso20022.pain00100103.Priority2Code;
import de.businesslogics.format.iso20022.pain00100103.Purpose2Choice;
import de.businesslogics.format.iso20022.pain00100103.ReferredDocumentInformation3;
import de.businesslogics.format.iso20022.pain00100103.RegulatoryAuthority2;
import de.businesslogics.format.iso20022.pain00100103.RegulatoryReporting3;
import de.businesslogics.format.iso20022.pain00100103.RegulatoryReportingType1Code;
import de.businesslogics.format.iso20022.pain00100103.RemittanceInformation5;
import de.businesslogics.format.iso20022.pain00100103.ServiceLevel8Choice;
import de.businesslogics.format.iso20022.pain00100103.StructuredRegulatoryReporting3;
import de.businesslogics.format.iso20022.pain00100103.StructuredRemittanceInformation7;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.ChequeInstructionData;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.RegReporting;
import de.businesslogics.format.sepa.RegReportingDetail;
import de.businesslogics.format.sepa.SEPAAccountType;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV3Iso {
    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        CustomerCreditTransferInitiationV03 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader32 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstructionInformation3 p : ccti.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            SEPAExtractorV3Iso.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (CreditTransferTransactionInformation10 c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV3Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V25Iso);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerCreditTransferInitiationV03 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader32 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation3 p : ccti.getPmtInfs()) {
            for (CreditTransferTransactionInformation10 c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV3Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPAPaymentData> getATXPayments(Document2 document) {
        CustomerCreditTransferInitiationV03 ccti = document.getCstmrCdtTrfInitn();
        GroupHeader32 grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation3 paymentInstructionInformation3 : ccti.getPmtInfs()) {
            for (CreditTransferTransactionInformation10 c : paymentInstructionInformation3.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV3Iso.getPaymentData(msgId, initParty, paymentInstructionInformation3, c));
            }
        }
        for (SEPAPaymentData sEPAPaymentData : payments) {
            sEPAPaymentData.setSepaVersion(GeneralSEPAWriter.Version.V25IsoATX);
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformation3 p, CreditTransferTransactionInformation10 t) {
        PaymentIdentification1 pmtId;
        String endToEndId;
        AccountNumberInfo recipAccNumberInfo;
        PartyIdentification32 debtor = p.getDbtr();
        String origName = SimpleStringElement.getNonNullValue(debtor.getNm());
        String origAccNumber = null;
        boolean isOrigIban = true;
        CashAccount16 originatorAccount = p.getDbtrAcct();
        AccountNumberInfo origAccNumberInfo = SEPAExtractorV3Iso.getAccountNumberInfo(originatorAccount.getId().getChoice1());
        if (origAccNumberInfo != null) {
            origAccNumber = origAccNumberInfo.getAccountNumber();
            isOrigIban = origAccNumberInfo.isFromIbanTag();
        }
        String origBankCode = SEPAExtractorV3Iso.getBankIdentifier(p.getDbtrAgt().getFinInstnId());
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        String recip = "";
        PartyIdentification32 creditor = t.getCdtr();
        if (creditor != null) {
            recip = SimpleStringElement.getNonNullValue(creditor.getNm());
        }
        String recipAccNumber = null;
        boolean isRecipIban = true;
        if (t.getCdtrAcct() != null && (recipAccNumberInfo = SEPAExtractorV3Iso.getAccountNumberInfo(t.getCdtrAcct().getId().getChoice1())) != null) {
            recipAccNumber = recipAccNumberInfo.getAccountNumber();
            isRecipIban = recipAccNumberInfo.isFromIbanTag();
        }
        String recipBIC = null;
        FinancialInstitutionIdentification7 recipientBankIdentification = null;
        if (t.getCdtrAgt() != null) {
            recipientBankIdentification = t.getCdtrAgt().getFinInstnId();
            recipBIC = SEPAExtractorV3Iso.getRecipientBIC(recipientBankIdentification);
        }
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV3Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
        Currency counterValueCurrency = SEPAExtractorV3Iso.getCounterValueCurrency(t.getAmt().getChoice1());
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        PaymentTypeInformation19 pmtTpInfLF = p.getPmtTpInf();
        PaymentTypeInformation19 pmtTpInfTX = t.getPmtTpInf();
        String paymentCategory = null;
        String serviceLevel = null;
        if (pmtTpInfLF != null) {
            paymentCategory = SEPAExtractorV3Iso.getPaymentCategory(pmtTpInfLF.getCtgyPurp());
            serviceLevel = SEPAExtractorV3Iso.getServiceLevel(pmtTpInfLF.getSvcLvl());
        }
        if (pmtTpInfTX != null) {
            if (paymentCategory == null) {
                paymentCategory = SEPAExtractorV3Iso.getPaymentCategory(pmtTpInfTX.getCtgyPurp());
            }
            if (serviceLevel == null) {
                serviceLevel = SEPAExtractorV3Iso.getServiceLevel(pmtTpInfTX.getSvcLvl());
            }
        }
        if ("NOTPROVIDED".equals(endToEndId = (pmtId = t.getPmtId()).getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(pmtId.getInstrId());
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBIC, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()), executionDate, null, paymentCategory, endToEndId, instructionId, serviceLevel);
        paymentData.setIsOriginatorIban(isOrigIban);
        paymentData.setIsRecipientIban(isRecipIban);
        paymentData.setCounterValueCurrency(counterValueCurrency);
        paymentData.setAccountCurrency(originatorAccount.getCcy() != null ? Currency.getInstance(originatorAccount.getCcy().getValue()) : null);
        paymentData.setOriginatorAccountType(SEPAExtractorV3Iso.getAccountType(originatorAccount));
        if (debtor.getPstlAdr() != null) {
            paymentData.setOriginatorAddressData(SEPAExtractorV3Iso.getAddressData(debtor.getPstlAdr()));
        }
        if (creditor != null && creditor.getPstlAdr() != null) {
            paymentData.setRecipientAddressData(SEPAExtractorV3Iso.getAddressData(creditor.getPstlAdr()));
        }
        paymentData.setPaymentMethod(p.getPmtMtd().getValue());
        String localInstrument = null;
        String instructionPriority = null;
        if (pmtTpInfLF != null) {
            localInstrument = SEPAExtractorV3Iso.getLocalInstrument(pmtTpInfLF.getLclInstrm());
            instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfLF.getInstrPrty());
        }
        if (pmtTpInfTX != null) {
            if (localInstrument == null) {
                localInstrument = SEPAExtractorV3Iso.getLocalInstrument(pmtTpInfTX.getLclInstrm());
            }
            if (instructionPriority == null) {
                instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfTX.getInstrPrty());
            }
        }
        paymentData.setLocalInstrument(localInstrument);
        paymentData.setInstructionPriority(instructionPriority);
        if (t.getPurp() != null) {
            paymentData.setPurposeCode(SimpleStringElement.getNonNullValue(t.getPurp().getChoice1().getCd()));
        }
        if (p.getChrgBr() != null) {
            paymentData.setChargeBearer(p.getChrgBr().getValue());
        } else if (t.getChrgBr() != null) {
            paymentData.setChargeBearer(t.getChrgBr().getValue());
        } else {
            paymentData.setChargeBearer(null);
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        SEPAExtractorV3Iso.setPurposeInformation(t.getRmtInf(), paymentData);
        if (recipientBankIdentification != null) {
            SEPAExtractorV3Iso.loadOtherRecipientBankData(recipientBankIdentification, paymentData);
        }
        SEPAExtractorV3Iso.loadChequeInstructionData(t.getChqInstr(), paymentData);
        List<RegulatoryReporting3> rptgs = t.getRgltryRptgs();
        if (rptgs != null) {
            for (RegulatoryReporting3 rptg : rptgs) {
                paymentData.addRegReporting(SEPAExtractorV3Iso.getRegReporting(rptg));
            }
        }
        return paymentData;
    }

    private static RegReporting getRegReporting(RegulatoryReporting3 rptg) {
        RegReporting reporting = new RegReporting();
        if (rptg != null) {
            List<StructuredRegulatoryReporting3> dtls;
            RegulatoryReportingType1Code code = rptg.getDbtCdtRptgInd();
            if (code != null) {
                reporting.setCreditDebitIndicator(code.getValue());
            }
            if (rptg.getAuthrty() != null) {
                if (rptg.getAuthrty().getNm() != null) {
                    reporting.setAuthorityName(rptg.getAuthrty().getNm().getValue());
                }
                if (rptg.getAuthrty().getCtry() != null) {
                    reporting.setAuthorityCountry(rptg.getAuthrty().getCtry().getValue());
                }
            }
            if ((dtls = rptg.getDtlss()) != null) {
                for (StructuredRegulatoryReporting3 dtl : dtls) {
                    reporting.addDetail(SEPAExtractorV3Iso.getRegReportingDetail(dtl));
                }
            }
        }
        return reporting;
    }

    private static RegReportingDetail getRegReportingDetail(StructuredRegulatoryReporting3 rptg) {
        RegReportingDetail detail = new RegReportingDetail();
        if (rptg != null) {
            if (rptg.getAmt() != null) {
                detail.setAmount(rptg.getAmt().getValue());
            }
            if (rptg.getCd() != null) {
                detail.setCode(rptg.getCd().getValue());
            }
            if (rptg.getCtry() != null) {
                detail.setCountry(rptg.getCtry().getValue());
            }
            if (rptg.getDt() != null) {
                detail.setDate(rptg.getDt().getDate());
            }
            if (rptg.getTp() != null) {
                detail.setType(rptg.getTp().getValue());
            }
            if (rptg.getInfs() != null) {
                for (Max35Text inf : rptg.getInfs()) {
                    detail.addInf(inf.getValue());
                }
            }
        }
        return detail;
    }

    public static String getPaymentCategory(CategoryPurpose1Choice choice) {
        if (choice != null) {
            ExternalCategoryPurpose1Code categoryFromCd = choice.getChoice1().getCd();
            if (categoryFromCd != null) {
                return SimpleStringElement.getNonNullValue(categoryFromCd);
            }
            if (choice.getChoice1().getPrtry() != null) {
                return choice.getChoice1().getPrtry().getValue();
            }
        }
        return null;
    }

    private static CategoryPurpose1Choice getPaymentCategory(String paymentCategory) {
        String value = StringUtils.checkNullAndTrim(paymentCategory);
        if (value.length() > 0) {
            ExternalCategoryPurpose1Code cd = new ExternalCategoryPurpose1Code(value);
            if (SEPAPaymentCategory.isProprietary(value)) {
                return new CategoryPurpose1Choice(CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromPrtry(new Max35Text(value)));
            }
            return new CategoryPurpose1Choice(CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromCd(cd));
        }
        return null;
    }

    public static String getServiceLevel(ServiceLevel8Choice choice) {
        if (choice != null) {
            return SimpleStringElement.getNonNullValue(choice.getChoice1().getCd());
        }
        return null;
    }

    private static ServiceLevel8Choice getServiceLevel(String serviceLevel) {
        String value = StringUtils.checkNullAndTrim(serviceLevel);
        if (value.length() > 0) {
            return new ServiceLevel8Choice(ServiceLevel8Choice.ServiceLevel8Choice_C1.fromCd(new ExternalServiceLevel1Code(value)));
        }
        return null;
    }

    public static String getLocalInstrument(LocalInstrument2Choice choice) {
        if (choice != null) {
            if (choice.getChoice1().getCd() != null) {
                return choice.getChoice1().getCd().getValue();
            }
            if (choice.getChoice1().getPrtry() != null) {
                return choice.getChoice1().getPrtry().getValue();
            }
        }
        return null;
    }

    private static LocalInstrument2Choice getLocalInstrument(String localInstrument) {
        String value = StringUtils.checkNullAndTrim(localInstrument);
        if (value.length() > 0) {
            if (SEPALocalInstrument.isProprietaryValue(value)) {
                return new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromPrtry(new Max35Text(value)));
            }
            return new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromCd(new ExternalLocalInstrument1Code(value)));
        }
        return null;
    }

    protected static AccountNumberInfo getAccountNumberInfo(AccountIdentification4Choice.AccountIdentification4Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return new AccountNumberInfo(choice.getIBAN().getValue(), true);
        }
        if (choice.getOthr() != null) {
            return new AccountNumberInfo(choice.getOthr().getId().getValue(), false);
        }
        return null;
    }

    protected static String getBankIdentifier(FinancialInstitutionIdentification7 finInstnId) {
        if (finInstnId.getBIC() != null) {
            return finInstnId.getBIC().getValue();
        }
        if (finInstnId.getClrSysMmbId() != null) {
            return finInstnId.getClrSysMmbId().getMmbId().getValue();
        }
        if (finInstnId.getOthr() != null) {
            String othrId = finInstnId.getOthr().getId().getValue();
            if ("NOTPROVIDED".equals(othrId)) {
                return "";
            }
            return othrId;
        }
        return null;
    }

    private static String getRecipientBIC(FinancialInstitutionIdentification7 finInstnId) {
        if (finInstnId.getBIC() != null) {
            return finInstnId.getBIC().getValue();
        }
        return null;
    }

    private static void loadOtherRecipientBankData(FinancialInstitutionIdentification7 finInstnId, SEPAPaymentData paymentData) {
        boolean bicIsMissing;
        boolean bl = bicIsMissing = finInstnId.getBIC() == null;
        if (finInstnId.getNm() != null) {
            paymentData.setRecipientBankName(finInstnId.getNm().getValue());
        }
        if (bicIsMissing) {
            String otherId;
            ClearingSystemMemberIdentification2 clrSysMbId = finInstnId.getClrSysMmbId();
            if (clrSysMbId != null) {
                if (clrSysMbId.getClrSysId() != null) {
                    ClearingSystemIdentification2Choice.ClearingSystemIdentification2Choice_C1 choice = clrSysMbId.getClrSysId().getChoice1();
                    if (choice.getCd() != null) {
                        paymentData.setRecipientClearingSystemId(choice.getCd().getValue());
                    } else if (choice.getPrtry() != null) {
                        paymentData.setRecipientClearingSystemId(choice.getPrtry().getValue());
                    }
                }
                paymentData.setRecipientBic(clrSysMbId.getMmbId().getValue());
            } else if (finInstnId.getOthr() != null && !"NOTPROVIDED".equals(otherId = finInstnId.getOthr().getId().getValue())) {
                paymentData.setRecipientBic(otherId);
            }
        }
        if (finInstnId.getPstlAdr() != null) {
            paymentData.setRecipientBankAddressData(SEPAExtractorV3Iso.getAddressData(finInstnId.getPstlAdr()));
        }
    }

    private static void loadChequeInstructionData(Cheque6 cheque, SEPAPaymentData paymentData) {
        if (cheque != null) {
            NameAndAddress10 nameAndAddress;
            ChequeInstructionData checkInstructionData = new ChequeInstructionData();
            if (cheque.getChqTp() != null) {
                checkInstructionData.setChequeType(cheque.getChqTp().getValue());
            }
            if (cheque.getDlvryMtd() != null) {
                ChequeDelivery1Code deliveryCode = cheque.getDlvryMtd().getChoice1().getCd();
                if (deliveryCode != null) {
                    checkInstructionData.setDeliveryMethod(deliveryCode.getValue());
                } else {
                    Max35Text deliveryText = cheque.getDlvryMtd().getChoice1().getPrtry();
                    if (deliveryText != null) {
                        checkInstructionData.setDeliveryMethod(deliveryText.getValue());
                    }
                }
            }
            if (cheque.getDlvrTo() != null && (nameAndAddress = cheque.getDlvrTo()) != null) {
                checkInstructionData.setDeliverToName(nameAndAddress.getNm().getValue());
                checkInstructionData.setDeliverToAddress(SEPAExtractorV3Iso.getAddressData(nameAndAddress.getAdr()));
            }
            paymentData.setChequeInstructionData(checkInstructionData);
        }
    }

    protected static ActiveOrHistoricCurrencyAndAmount getCurrencyAndAmount(AmountType3Choice.AmountType3Choice_C1 choice) {
        if (choice.getInstdAmt() != null) {
            return choice.getInstdAmt();
        }
        if (choice.getEqvtAmt() != null) {
            return choice.getEqvtAmt().getAmt();
        }
        return null;
    }

    private static Currency getCounterValueCurrency(AmountType3Choice.AmountType3Choice_C1 choice) {
        if (choice.getEqvtAmt() != null) {
            return Currency.getInstance(choice.getEqvtAmt().getCcyOfTrf().getValue());
        }
        return null;
    }

    protected static String getPurpose(RemittanceInformation5 rmtInf) {
        if (rmtInf != null) {
            StringBuffer sb = new StringBuffer();
            if (rmtInf.getUstrds().size() > 0) {
                for (Max140Text text : rmtInf.getUstrds()) {
                    sb.append(SimpleStringElement.getNonNullValue(text));
                }
            } else if (rmtInf.getStrds().size() > 0) {
                for (StructuredRemittanceInformation7 s : rmtInf.getStrds()) {
                    if (s.getRfrdDocInfs() == null) continue;
                    for (ReferredDocumentInformation3 inf : s.getRfrdDocInfs()) {
                        sb.append(SimpleStringElement.getNonNullValue(inf.getNb()));
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        return new Document(SEPAExtractorV3Iso.getCreditDocumentContent(paymentData));
    }

    private static CustomerCreditTransferInitiationV03 getCreditDocumentContent(SEPAPaymentData paymentData) {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformation3 logicalFile = SEPAExtractorV3Iso.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeader32 grpHdr = SEPAExtractorV3Iso.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerCreditTransferInitiationV03 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV03(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return cstmrCdtTrfInitn;
    }

    public static Document2 getATXCreditDocument(SEPAPaymentData paymentData) throws IOException {
        return new Document2(SEPAExtractorV3Iso.getCreditDocumentContent(paymentData));
    }

    private static CustomerCreditTransferInitiationV03 getCreditDocumentContent(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformation3> logicalFiles = new ArrayList<PaymentInstructionInformation3>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV3Iso.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeader32 grpHdr = SEPAExtractorV3Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        return new CustomerCreditTransferInitiationV03(grpHdr, logicalFiles);
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        return new Document(SEPAExtractorV3Iso.getCreditDocumentContent(messageId, initiatingParty, paymentLists));
    }

    public static Document2 getATXCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        return new Document2(SEPAExtractorV3Iso.getCreditDocumentContent(messageId, initiatingParty, paymentLists));
    }

    private static GroupHeader32 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        GroupHeader32 grpHdr = new GroupHeader32(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), SEPAExtractorV3Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformation3 getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        String chargeBearer;
        SEPAPaymentData firstPayment = paymentList.get(0);
        PaymentMethod3Code paymentMethod = SEPAExtractorV3Iso.getPaymentMethodCode(firstPayment);
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentification32 originator = SEPAExtractorV3Iso.getParty(firstPayment.getOriginator(), firstPayment.getOriginatorAddressData());
        BranchAndFinancialInstitutionIdentification4 originatorBank = SEPAExtractorV3Iso.getBankId(firstPayment.getOriginatorBic());
        CashAccount16 originatorAccount = SEPAExtractorV3Iso.getAccountId(firstPayment.getOriginatorIban());
        SEPAExtractorV3Iso.setAccountCurrencyAndType(originatorAccount, firstPayment.getAccountCurrency(), firstPayment.getOriginatorAccountType());
        PaymentInstructionInformation3 logicalFile = new PaymentInstructionInformation3(new Max35Text(logicalFileId), paymentMethod, executionDate, originator, originatorAccount, originatorBank, SEPAExtractorV3Iso.getTransactions(logicalFileId, paymentList));
        BigDecimal controlSum = BigDecimal.ZERO;
        for (SEPAPaymentData p : paymentList) {
            controlSum = controlSum.add(p.getAmount());
        }
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(paymentList.size())));
        PaymentTypeInformation19 pmtTpInf = SEPAExtractorV3Iso.getPaymentTypeInfo(firstPayment);
        if (pmtTpInf != null) {
            logicalFile.setPmtTpInf(pmtTpInf);
        }
        if ((chargeBearer = StringUtils.checkNullAndTrim(firstPayment.getChargeBearer())).length() > 0) {
            logicalFile.setChrgBr(new ChargeBearerType1Code(chargeBearer));
        }
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return logicalFile;
    }

    private static PaymentMethod3Code getPaymentMethodCode(SEPAPaymentData firstPayment) {
        String paymentMethod = firstPayment.getPaymentMethod();
        if (paymentMethod != null && paymentMethod.trim().length() > 0) {
            return new PaymentMethod3Code(paymentMethod.trim());
        }
        return new PaymentMethod3Code(SEPAPaymentMethod.TRF.name());
    }

    private static void setAccountCurrencyAndType(CashAccount16 account, Currency currency, String type) {
        if (currency != null) {
            account.setCcy(new ActiveOrHistoricCurrencyCode(currency.getCurrencyCode()));
        }
        if ((type = StringUtils.checkNullAndTrim(type)).length() > 0) {
            if (SEPAAccountType.isProprietaryValue(type)) {
                account.setTp(new CashAccountType2(CashAccountType2.CashAccountType2_C1.fromPrtry(new Max35Text(type))));
            } else {
                account.setTp(new CashAccountType2(CashAccountType2.CashAccountType2_C1.fromCd(new CashAccountType4Code(type))));
            }
        }
    }

    private static String getAccountType(CashAccount16 account) {
        if (account.getTp() != null) {
            if (account.getTp().getChoice1().getPrtry() != null) {
                return account.getTp().getChoice1().getPrtry().getValue();
            }
            if (account.getTp().getChoice1().getCd() != null) {
                return account.getTp().getChoice1().getCd().getValue();
            }
        }
        return null;
    }

    private static PaymentTypeInformation19 getPaymentTypeInfo(SEPAPaymentData firstPayment) {
        String instructionPriority;
        CategoryPurpose1Choice ctgyPurp;
        LocalInstrument2Choice lclInstrm;
        PaymentTypeInformation19 pmtTpInf = null;
        ServiceLevel8Choice svcLvl = SEPAExtractorV3Iso.getServiceLevel(firstPayment.getServiceLevel());
        if (svcLvl != null) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation19();
            }
            pmtTpInf.setSvcLvl(svcLvl);
        }
        if ((lclInstrm = SEPAExtractorV3Iso.getLocalInstrument(firstPayment.getLocalInstrument())) != null) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation19();
            }
            pmtTpInf.setLclInstrm(lclInstrm);
        }
        if ((ctgyPurp = SEPAExtractorV3Iso.getPaymentCategory(firstPayment.getPaymentCategory())) != null) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation19();
            }
            pmtTpInf.setCtgyPurp(ctgyPurp);
        }
        if ((instructionPriority = StringUtils.checkNullAndTrim(firstPayment.getInstructionPriority())).length() > 0) {
            if (pmtTpInf == null) {
                pmtTpInf = new PaymentTypeInformation19();
            }
            pmtTpInf.setInstrPrty(new Priority2Code(instructionPriority));
        }
        return pmtTpInf;
    }

    private static List<CreditTransferTransactionInformation10> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransactionInformation10> transactions = new ArrayList<CreditTransferTransactionInformation10>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purposeCode;
            String ultimateCreditor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            PartyIdentification32 recipient = SEPAExtractorV3Iso.getParty(paymentData.getRecipient(), paymentData.getRecipientAddressData());
            CreditTransferTransactionInformation10 transaction = new CreditTransferTransactionInformation10(pmtId, SEPAExtractorV3Iso.getAmt(paymentData.getAmount(), paymentData.getCurrency(), paymentData.getCounterValueCurrency()));
            transaction.setCdtr(recipient);
            transaction.setCdtrAcct(SEPAExtractorV3Iso.getAccountId(paymentData.getRecipientIban()));
            transaction.setCdtrAgt(SEPAExtractorV3Iso.getCdtrAgt(paymentData));
            String ultimateDebitor = paymentData.getUltimateOriginator();
            if (ultimateDebitor != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPAExtractorV3Iso.getParty(ultimateDebitor));
            }
            if ((ultimateCreditor = paymentData.getUltimateRecipient()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPAExtractorV3Iso.getParty(ultimateCreditor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose2Choice(Purpose2Choice.Purpose2Choice_C1.fromCd(new ExternalPurpose1Code(purposeCode.trim()))));
            }
            for (RegReporting reporting : paymentData.getRegReportings()) {
                transaction.getRgltryRptgs().add(SEPAExtractorV3Iso.getRegulatoryReporting(reporting));
            }
            RemittanceInformation5 remittanceInfo = SEPAExtractorV3Iso.getRemittanceInformation(paymentData);
            if (remittanceInfo != null) {
                transaction.setRmtInf(remittanceInfo);
            }
            transaction.setChqInstr(SEPAExtractorV3Iso.getChqInstr(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static RegulatoryReporting3 getRegulatoryReporting(RegReporting reporting) {
        String indicator;
        RegulatoryReporting3 rr = new RegulatoryReporting3();
        RegulatoryAuthority2 regAuth = SEPAExtractorV3Iso.getRegAuthority(reporting.getAuthorityCountry(), reporting.getAuthorityName());
        if (regAuth != null) {
            rr.setAuthrty(regAuth);
        }
        if ((indicator = StringUtils.checkNullAndTrim(reporting.getCreditDebitIndicator())).length() > 0) {
            rr.setDbtCdtRptgInd(new RegulatoryReportingType1Code(indicator));
        }
        for (RegReportingDetail reportingDetail : reporting.getDetails()) {
            StructuredRegulatoryReporting3 srr = SEPAExtractorV3Iso.getRegulatoryReportingDetail(reportingDetail);
            if (srr == null) continue;
            rr.getDtlss().add(srr);
        }
        return rr;
    }

    private static RegulatoryAuthority2 getRegAuthority(String countryCode, String name) {
        String regAuthName;
        RegulatoryAuthority2 regAuth = null;
        if (countryCode != null && RegularExpressions.COUNTRY_CODE.matches(countryCode)) {
            regAuth = new RegulatoryAuthority2();
            regAuth.setCtry(new CountryCode(countryCode));
        }
        if ((regAuthName = StringUtils.checkNullAndTrim(name)).length() > 0) {
            if (regAuth == null) {
                regAuth = new RegulatoryAuthority2();
            }
            regAuth.setNm(new Max140Text(regAuthName));
        }
        return regAuth;
    }

    private static StructuredRegulatoryReporting3 getRegulatoryReportingDetail(RegReportingDetail detail) {
        String type;
        String code;
        StructuredRegulatoryReporting3 srr = null;
        if (detail.getAmount() != null && detail.getCurrency() != null) {
            srr = new StructuredRegulatoryReporting3();
            srr.setAmt(new ActiveOrHistoricCurrencyAndAmount(detail.getAmount(), new ActiveOrHistoricCurrencyCode(detail.getCurrency().getCurrencyCode())));
        }
        if ((code = StringUtils.checkNullAndTrim(detail.getCode())).length() > 0) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setCd(new Max10Text(code));
        }
        if (detail.getCountry() != null && RegularExpressions.COUNTRY_CODE.matches(detail.getCountry())) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setCtry(new CountryCode(detail.getCountry()));
        }
        if (detail.getDate() != null) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setDt(new ISODate(new YYMMDD(detail.getDate().getTime())));
        }
        if ((type = StringUtils.checkNullAndTrim(detail.getType())).length() > 0) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setTp(new Max35Text(type));
        }
        for (String inf : detail.getInfs()) {
            String info = StringUtils.checkNullAndTrim(inf);
            if (info.length() <= 0) continue;
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.getInfs().add(new Max35Text(inf));
        }
        return srr;
    }

    private static BranchAndFinancialInstitutionIdentification4 getCdtrAgt(SEPAPaymentData paymentData) {
        PostalAddress6 recipientBankAddress;
        String bankName;
        FinancialInstitutionIdentification7 finInstnId = new FinancialInstitutionIdentification7();
        boolean hasValues = false;
        String bankCode = StringUtils.checkNullAndTrim(paymentData.getRecipientBic());
        if (bankCode.length() > 0) {
            String clearingSystemId = StringUtils.checkNullAndTrim(paymentData.getRecipientClearingSystemId());
            if (clearingSystemId.length() > 0) {
                ClearingSystemMemberIdentification2 clrSysMmbId = new ClearingSystemMemberIdentification2(new Max35Text(bankCode));
                ExternalClearingSystemIdentification1Code clrSysCode = new ExternalClearingSystemIdentification1Code(clearingSystemId);
                clrSysMmbId.setClrSysId(new ClearingSystemIdentification2Choice(ClearingSystemIdentification2Choice.ClearingSystemIdentification2Choice_C1.fromCd(clrSysCode)));
                finInstnId.setClrSysMmbId(clrSysMmbId);
            } else if (RegularExpressions.BIC.matches(bankCode)) {
                finInstnId.setBIC(new BICIdentifier(bankCode));
            } else {
                finInstnId.setOthr(new GenericFinancialIdentification1(new Max35Text(bankCode)));
            }
            hasValues = true;
        }
        if ((bankName = StringUtils.checkNullAndTrim(paymentData.getRecipientBankName())).length() > 0) {
            finInstnId.setNm(new Max140Text(bankName));
            hasValues = true;
        }
        if ((recipientBankAddress = SEPAExtractorV3Iso.saveAddress(paymentData.getRecipientBankAddressData())) != null) {
            finInstnId.setPstlAdr(recipientBankAddress);
            hasValues = true;
        }
        if (hasValues) {
            return new BranchAndFinancialInstitutionIdentification4(finInstnId);
        }
        return null;
    }

    private static Cheque6 getChqInstr(SEPAPaymentData paymentData) {
        ChequeInstructionData chequeInstructionData = paymentData.getChequeInstructionData();
        if (chequeInstructionData != null) {
            String deliveryMethod;
            Cheque6 cheque = new Cheque6();
            String chequeType = StringUtils.checkNullAndTrim(chequeInstructionData.getChequeType());
            if (chequeType.length() > 0) {
                cheque.setChqTp(new ChequeType2Code(chequeType));
            }
            if ((deliveryMethod = chequeInstructionData.getDeliveryMethod()) != null && deliveryMethod.trim().length() > 0) {
                ChequeDeliveryMethod1Choice.ChequeDeliveryMethod1Choice_C1 choice1 = ChequeDeliveryMethod1Choice.ChequeDeliveryMethod1Choice_C1.fromCd(new ChequeDelivery1Code(deliveryMethod.trim()));
                cheque.setDlvryMtd(new ChequeDeliveryMethod1Choice(choice1));
            }
            cheque.setDlvrTo(SEPAExtractorV3Iso.getDlvrTo(chequeInstructionData.getDeliverToName(), chequeInstructionData.getDeliverToAddress()));
            return cheque;
        }
        return null;
    }

    private static NameAndAddress10 getDlvrTo(String name, AddressData addressData) {
        if (name != null && addressData != null) {
            return new NameAndAddress10(new Max140Text(name), SEPAExtractorV3Iso.saveAddress(addressData));
        }
        return null;
    }

    private static RemittanceInformation5 getRemittanceInformation(SEPAPaymentData paymentData) {
        RemittanceInformation5 remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            List<String> purposeLines;
            StructuredRemittanceInformation7 structured = null;
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                CreditorReferenceInformation2 cdtrRefInf = new CreditorReferenceInformation2();
                cdtrRefInf.setRef(new Max35Text(paymentData.getPurposeReference()));
                CreditorReferenceType2 tp = SEPAExtractorV3Iso.getPurposeReferenceType(paymentData);
                if (tp != null) {
                    cdtrRefInf.setTp(tp);
                }
                structured = new StructuredRemittanceInformation7();
                structured.setCdtrRefInf(cdtrRefInf);
            }
            if ((purposeLines = paymentData.getStructuredPurposeLines()).size() > 0) {
                if (structured == null) {
                    structured = new StructuredRemittanceInformation7();
                }
                for (String purposeLine : purposeLines) {
                    structured.getAddtlRmtInfs().add(new Max140Text(purposeLine));
                }
            }
            if (structured != null) {
                remittanceInfo = new RemittanceInformation5();
                remittanceInfo.getStrds().add(structured);
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformation5();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
            }
        }
        return remittanceInfo;
    }

    private static CreditorReferenceType2 getPurposeReferenceType(SEPAPaymentData paymentData) {
        CreditorReferenceType1Choice choice = null;
        String structuredTypeCode = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypeCode());
        if (structuredTypeCode.length() > 0) {
            DocumentType3Code code = new DocumentType3Code(structuredTypeCode);
            choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromCd(code));
        } else {
            String structuredTypePrtry = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypePrtry());
            if (structuredTypePrtry.length() > 0) {
                Max35Text prtry = new Max35Text(structuredTypePrtry);
                choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromPrtry(prtry));
            }
        }
        if (choice != null) {
            return new CreditorReferenceType2(choice);
        }
        return null;
    }

    private static void setPurposeInformation(RemittanceInformation5 rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            List<Max140Text> unstructuredLines = rmtInf.getUstrds();
            List<StructuredRemittanceInformation7> structuredInfoList = rmtInf.getStrds();
            if (unstructuredLines != null && unstructuredLines.size() > 0) {
                paymentData.setHasStructuredPurpose(false);
                StringBuilder sb = new StringBuilder();
                for (Max140Text purposeLine : unstructuredLines) {
                    String s = purposeLine.getValue();
                    paymentData.getUnstructuredPurposeLines().add(s);
                    sb.append(s);
                }
                paymentData.setPurpose(sb.toString());
            } else if (structuredInfoList != null && structuredInfoList.size() > 0) {
                CreditorReferenceInformation2 cdtrRefInf;
                paymentData.setHasStructuredPurpose(true);
                StructuredRemittanceInformation7 structuredInfo = structuredInfoList.get(0);
                List<Max140Text> purposeLines = structuredInfo.getAddtlRmtInfs();
                if (purposeLines.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (Max140Text purposeLine : purposeLines) {
                        String s = purposeLine.getValue();
                        paymentData.getStructuredPurposeLines().add(s);
                        sb.append(s);
                    }
                    paymentData.setPurpose(sb.toString());
                }
                if ((cdtrRefInf = structuredInfo.getCdtrRefInf()) != null) {
                    CreditorReferenceType2 tp;
                    if (cdtrRefInf.getRef() != null) {
                        paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                    }
                    if ((tp = cdtrRefInf.getTp()) != null) {
                        CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1 c = tp.getCdOrPrtry().getChoice1();
                        if (c.getCd() != null) {
                            paymentData.setPurposeReferenceTypeCode(c.getCd().getValue());
                        } else if (c.getPrtry() != null) {
                            paymentData.setPurposeReferenceTypePrtry(c.getPrtry().getValue());
                        }
                    }
                }
            }
        }
    }

    private static PartyIdentification32 getParty(String name) {
        return SEPAExtractorV3Iso.getParty(name, null);
    }

    private static PartyIdentification32 getParty(String name, AddressData addressData) {
        PostalAddress6 address;
        PartyIdentification32 party = new PartyIdentification32();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max140Text(name));
        }
        if ((address = SEPAExtractorV3Iso.saveAddress(addressData)) != null) {
            party.setPstlAdr(address);
        }
        return party;
    }

    private static PostalAddress6 saveAddress(AddressData addressData) {
        if (addressData != null) {
            PostalAddress6 pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            if (addressData.getDepartment() != null && !addressData.getDepartment().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setDept(new Max70Text(addressData.getDepartment()));
            }
            if (addressData.getSubDepartment() != null && !addressData.getSubDepartment().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setSubDept(new Max70Text(addressData.getSubDepartment()));
            }
            if (addressData.getStreetName() != null && !addressData.getStreetName().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setStrtNm(new Max70Text(addressData.getStreetName()));
            }
            if (addressData.getBuildingNumber() != null && !addressData.getBuildingNumber().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setBldgNb(new Max16Text(addressData.getBuildingNumber()));
            }
            if (addressData.getPostCode() != null && !addressData.getPostCode().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setPstCd(new Max16Text(addressData.getPostCode()));
            }
            if (addressData.getTownName() != null && !addressData.getTownName().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setTwnNm(new Max35Text(addressData.getTownName()));
            }
            if (addressData.getCountrySubDivision() != null && !addressData.getCountrySubDivision().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setCtrySubDvsn(new Max35Text(addressData.getCountrySubDivision()));
            }
            return pstlAdr;
        }
        return null;
    }

    private static AddressData getAddressData(PostalAddress6 address) {
        String countrySubDivision;
        String townName;
        String postCode;
        String buildingNumber;
        String streetName;
        String subDept;
        AddressData addressData;
        CountryCode countryCode = address.getCtry();
        String countryString = null;
        if (countryCode != null) {
            countryString = countryCode.toString();
        }
        String addressLine1 = null;
        String addressLine2 = null;
        if (address.getAdrLines() != null && address.getAdrLines().size() > 0) {
            addressLine1 = SimpleStringElement.getValue(address.getAdrLines().get(0));
        }
        if (address.getAdrLines() != null && address.getAdrLines().size() > 1) {
            addressLine2 = SimpleStringElement.getValue(address.getAdrLines().get(1));
        }
        if ((addressData = AddressData.getStructuredAddress(addressLine1, addressLine2, countryString)) == null) {
            addressData = new AddressData();
        }
        if (countryString != null) {
            addressData.setCountry(countryString);
        }
        for (Max70Text line : address.getAdrLines()) {
            addressData.getAddressLines().add(line.getValue());
        }
        String dept = SimpleStringElement.getValue(address.getDept());
        if (dept != null && !dept.isEmpty()) {
            addressData.setDepartment(dept);
        }
        if ((subDept = SimpleStringElement.getValue(address.getSubDept())) != null && !subDept.isEmpty()) {
            addressData.setSubDepartment(subDept);
        }
        if ((streetName = SimpleStringElement.getValue(address.getStrtNm())) != null && !streetName.isEmpty()) {
            addressData.setStreetName(streetName);
        }
        if ((buildingNumber = SimpleStringElement.getValue(address.getBldgNb())) != null && !buildingNumber.isEmpty()) {
            addressData.setBuildingNumber(buildingNumber);
        }
        if ((postCode = SimpleStringElement.getValue(address.getPstCd())) != null && !postCode.isEmpty()) {
            addressData.setPostCode(postCode);
        }
        if ((townName = SimpleStringElement.getValue(address.getTwnNm())) != null && !townName.isEmpty()) {
            addressData.setTownName(townName);
        }
        if ((countrySubDivision = SimpleStringElement.getValue(address.getCtrySubDvsn())) != null && !countrySubDivision.isEmpty()) {
            addressData.setCountrySubDivision(countrySubDivision);
        }
        return addressData;
    }

    private static BranchAndFinancialInstitutionIdentification4 getBankId(String bic) {
        FinancialInstitutionIdentification7 id = new FinancialInstitutionIdentification7();
        if (bic != null && bic.trim().length() >= 8) {
            id.setBIC(new BICIdentifier(bic.trim()));
        } else {
            id.setOthr(new GenericFinancialIdentification1(new Max35Text("NOTPROVIDED")));
        }
        return new BranchAndFinancialInstitutionIdentification4(id);
    }

    private static CashAccount16 getAccountId(String iban) {
        String accountNumber = StringUtils.checkNullAndTrim(iban);
        if (accountNumber.length() > 0) {
            AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = null;
            c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification4Choice.AccountIdentification4Choice_C1.fromIBAN(new IBAN2007Identifier(iban)) : AccountIdentification4Choice.AccountIdentification4Choice_C1.fromOthr(new GenericAccountIdentification1(new Max34Text(iban)));
            return new CashAccount16(new AccountIdentification4Choice(c1));
        }
        return null;
    }

    private static AmountType3Choice getAmt(BigDecimal amount, Currency currency, Currency counterValueCurrency) {
        AmountType3Choice.AmountType3Choice_C1 c1;
        ActiveOrHistoricCurrencyCode ccy = new ActiveOrHistoricCurrencyCode(currency.getCurrencyCode());
        ActiveOrHistoricCurrencyAndAmount amt = new ActiveOrHistoricCurrencyAndAmount(amount, ccy);
        if (counterValueCurrency != null) {
            ActiveOrHistoricCurrencyCode counterValueCcy = new ActiveOrHistoricCurrencyCode(counterValueCurrency.getCurrencyCode());
            c1 = AmountType3Choice.AmountType3Choice_C1.fromEqvtAmt(new EquivalentAmount2(amt, counterValueCcy));
        } else {
            c1 = AmountType3Choice.AmountType3Choice_C1.fromInstdAmt(amt);
        }
        return new AmountType3Choice(c1);
    }
}

