/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.ch.pain0010010302.AccountIdentification4Choice_CH;
import de.businesslogics.format.ch.pain0010010302.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.ch.pain0010010302.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.ch.pain0010010302.AmountType3Choice;
import de.businesslogics.format.ch.pain0010010302.BICIdentifier;
import de.businesslogics.format.ch.pain0010010302.BatchBookingIndicator;
import de.businesslogics.format.ch.pain0010010302.BranchAndFinancialInstitutionIdentification4_CH;
import de.businesslogics.format.ch.pain0010010302.BranchAndFinancialInstitutionIdentification4_CH_BicOrClrId;
import de.businesslogics.format.ch.pain0010010302.CashAccount16_CH_Id;
import de.businesslogics.format.ch.pain0010010302.CashAccount16_CH_IdTpCcy;
import de.businesslogics.format.ch.pain0010010302.CashAccountType2;
import de.businesslogics.format.ch.pain0010010302.CashAccountType4Code;
import de.businesslogics.format.ch.pain0010010302.CategoryPurpose1_CH_Code;
import de.businesslogics.format.ch.pain0010010302.ChargeBearerType1Code;
import de.businesslogics.format.ch.pain0010010302.Cheque6_CH;
import de.businesslogics.format.ch.pain0010010302.ChequeDelivery1Code;
import de.businesslogics.format.ch.pain0010010302.ChequeDeliveryMethod1Choice;
import de.businesslogics.format.ch.pain0010010302.ChequeType2Code;
import de.businesslogics.format.ch.pain0010010302.ClearingSystemIdentification2Choice;
import de.businesslogics.format.ch.pain0010010302.ClearingSystemMemberIdentification2;
import de.businesslogics.format.ch.pain0010010302.CountryCode;
import de.businesslogics.format.ch.pain0010010302.CreditTransferTransactionInformation10_CH;
import de.businesslogics.format.ch.pain0010010302.CreditorReferenceInformation2;
import de.businesslogics.format.ch.pain0010010302.CreditorReferenceType1Choice;
import de.businesslogics.format.ch.pain0010010302.CreditorReferenceType2;
import de.businesslogics.format.ch.pain0010010302.CustomerCreditTransferInitiationV03_CH;
import de.businesslogics.format.ch.pain0010010302.DecimalNumber;
import de.businesslogics.format.ch.pain0010010302.Document;
import de.businesslogics.format.ch.pain0010010302.DocumentType3Code;
import de.businesslogics.format.ch.pain0010010302.EquivalentAmount2;
import de.businesslogics.format.ch.pain0010010302.ExternalCategoryPurpose1Code;
import de.businesslogics.format.ch.pain0010010302.ExternalClearingSystemIdentification1Code;
import de.businesslogics.format.ch.pain0010010302.ExternalLocalInstrument1Code;
import de.businesslogics.format.ch.pain0010010302.ExternalPurpose1Code;
import de.businesslogics.format.ch.pain0010010302.ExternalServiceLevel1Code;
import de.businesslogics.format.ch.pain0010010302.FinancialInstitutionIdentification7_CH;
import de.businesslogics.format.ch.pain0010010302.FinancialInstitutionIdentification7_CH_BicOrClrId;
import de.businesslogics.format.ch.pain0010010302.GenericAccountIdentification1_CH;
import de.businesslogics.format.ch.pain0010010302.GenericFinancialIdentification1_CH;
import de.businesslogics.format.ch.pain0010010302.GroupHeader32_CH;
import de.businesslogics.format.ch.pain0010010302.IBAN2007Identifier;
import de.businesslogics.format.ch.pain0010010302.ISODate;
import de.businesslogics.format.ch.pain0010010302.ISODateTime;
import de.businesslogics.format.ch.pain0010010302.LocalInstrument2Choice;
import de.businesslogics.format.ch.pain0010010302.Max10Text;
import de.businesslogics.format.ch.pain0010010302.Max140Text;
import de.businesslogics.format.ch.pain0010010302.Max15NumericText;
import de.businesslogics.format.ch.pain0010010302.Max16Text;
import de.businesslogics.format.ch.pain0010010302.Max34Text;
import de.businesslogics.format.ch.pain0010010302.Max35Text;
import de.businesslogics.format.ch.pain0010010302.Max35Text_Swift;
import de.businesslogics.format.ch.pain0010010302.Max70Text;
import de.businesslogics.format.ch.pain0010010302.PartyIdentification32_CH;
import de.businesslogics.format.ch.pain0010010302.PartyIdentification32_CH_Name;
import de.businesslogics.format.ch.pain0010010302.PartyIdentification32_CH_NameAndId;
import de.businesslogics.format.ch.pain0010010302.PaymentIdentification1;
import de.businesslogics.format.ch.pain0010010302.PaymentInstructionInformation3_CH;
import de.businesslogics.format.ch.pain0010010302.PaymentMethod3Code;
import de.businesslogics.format.ch.pain0010010302.PaymentTypeInformation19_CH;
import de.businesslogics.format.ch.pain0010010302.PostalAddress6_CH;
import de.businesslogics.format.ch.pain0010010302.Priority2Code;
import de.businesslogics.format.ch.pain0010010302.Purpose2_CH_Code;
import de.businesslogics.format.ch.pain0010010302.RegulatoryAuthority2;
import de.businesslogics.format.ch.pain0010010302.RegulatoryReporting3;
import de.businesslogics.format.ch.pain0010010302.RegulatoryReportingType1Code;
import de.businesslogics.format.ch.pain0010010302.RemittanceInformation5_CH;
import de.businesslogics.format.ch.pain0010010302.ServiceLevel8Choice;
import de.businesslogics.format.ch.pain0010010302.StructuredRegulatoryReporting3;
import de.businesslogics.format.ch.pain0010010302.StructuredRemittanceInformation7;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.ChequeInstructionData;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.RegReporting;
import de.businesslogics.format.sepa.RegReportingDetail;
import de.businesslogics.format.sepa.SEPAAccountType;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV3Ch {
    public static boolean WRITE_CATEGORY = true;
    public static boolean WRITE_CHARGE_BEARER = true;

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        CustomerCreditTransferInitiationV03_CH ccti = document.getCstmrCdtTrfInitn();
        GroupHeader32_CH grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstructionInformation3_CH p : ccti.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            SEPAExtractorV3Ch.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (CreditTransferTransactionInformation10_CH c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV3Ch.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V30Ch);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerCreditTransferInitiationV03_CH ccti = document.getCstmrCdtTrfInitn();
        GroupHeader32_CH grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation3_CH p : ccti.getPmtInfs()) {
            for (CreditTransferTransactionInformation10_CH c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV3Ch.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformation3_CH p, CreditTransferTransactionInformation10_CH t) {
        AccountNumberInfo recipAccNumberInfo;
        PartyIdentification32_CH debtor = p.getDbtr();
        String origName = SimpleStringElement.getNonNullValue(debtor.getNm());
        String origAccNumber = null;
        boolean isOrigIban = true;
        CashAccount16_CH_IdTpCcy originatorAccount = p.getDbtrAcct();
        AccountNumberInfo origAccNumberInfo = SEPAExtractorV3Ch.getAccountNumberInfo(originatorAccount.getId().getChoice1());
        if (origAccNumberInfo != null) {
            origAccNumber = origAccNumberInfo.getAccountNumber();
            isOrigIban = origAccNumberInfo.isFromIbanTag();
        }
        String origBankCode = SEPAExtractorV3Ch.getBankIdentifier(p.getDbtrAgt().getFinInstnId());
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        PartyIdentification32_CH_Name creditor = t.getCdtr();
        String recip = "";
        if (creditor != null) {
            recip = SimpleStringElement.getNonNullValue(creditor.getNm());
        }
        String recipAccNumber = null;
        boolean isRecipIban = true;
        if (t.getCdtrAcct() != null && (recipAccNumberInfo = SEPAExtractorV3Ch.getAccountNumberInfo(t.getCdtrAcct().getId().getChoice1())) != null) {
            recipAccNumber = recipAccNumberInfo.getAccountNumber();
            isRecipIban = recipAccNumberInfo.isFromIbanTag();
        }
        String recipBIC = null;
        FinancialInstitutionIdentification7_CH recipientBankIdentification = null;
        if (t.getCdtrAgt() != null) {
            recipientBankIdentification = t.getCdtrAgt().getFinInstnId();
            recipBIC = SEPAExtractorV3Ch.getRecipientBIC(recipientBankIdentification);
        }
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPAExtractorV3Ch.getCurrencyAndAmount(t.getAmt().getChoice1());
        Currency counterValueCurrency = SEPAExtractorV3Ch.getCounterValueCurrency(t.getAmt().getChoice1());
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        PaymentTypeInformation19_CH pmtTpInfLF = p.getPmtTpInf();
        PaymentTypeInformation19_CH pmtTpInfTX = t.getPmtTpInf();
        String paymentCategory = null;
        String serviceLevel = null;
        if (pmtTpInfLF != null) {
            paymentCategory = SEPAExtractorV3Ch.getPaymentCategory(pmtTpInfLF.getCtgyPurp());
            serviceLevel = SEPAExtractorV3Ch.getServiceLevel(pmtTpInfLF.getSvcLvl());
        } else if (pmtTpInfTX != null) {
            if (paymentCategory == null) {
                paymentCategory = SEPAExtractorV3Ch.getPaymentCategory(pmtTpInfTX.getCtgyPurp());
            }
            if (serviceLevel == null) {
                serviceLevel = SEPAExtractorV3Ch.getServiceLevel(pmtTpInfTX.getSvcLvl());
            }
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBIC, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()), executionDate, null, paymentCategory, endToEndId, instructionId, serviceLevel);
        paymentData.setIsOriginatorIban(isOrigIban);
        paymentData.setIsRecipientIban(isRecipIban);
        paymentData.setCounterValueCurrency(counterValueCurrency);
        paymentData.setAccountCurrency(originatorAccount.getCcy() != null ? Currency.getInstance(originatorAccount.getCcy().getValue()) : null);
        paymentData.setOriginatorAccountType(SEPAExtractorV3Ch.getAccountType(originatorAccount));
        if (p.getChrgBr() != null) {
            paymentData.setChargeBearer(p.getChrgBr().getValue());
        } else {
            paymentData.setChargeBearer(null);
        }
        paymentData.setPaymentMethod(p.getPmtMtd().getValue());
        String localInstrument = null;
        String instructionPriority = null;
        if (pmtTpInfLF != null) {
            localInstrument = SEPAExtractorV3Ch.getLocalInstrument(pmtTpInfLF.getLclInstrm());
            instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfLF.getInstrPrty());
        } else if (pmtTpInfTX != null) {
            localInstrument = SEPAExtractorV3Ch.getLocalInstrument(pmtTpInfTX.getLclInstrm());
            instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfTX.getInstrPrty());
        }
        paymentData.setLocalInstrument(localInstrument);
        paymentData.setInstructionPriority(instructionPriority);
        if (t.getPurp() != null && t.getPurp().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        if (debtor.getPstlAdr() != null) {
            paymentData.setOriginatorAddressData(SEPAExtractorV3Ch.getAddressData(debtor.getPstlAdr()));
        }
        if (creditor != null && creditor.getPstlAdr() != null) {
            paymentData.setRecipientAddressData(SEPAExtractorV3Ch.getAddressData(creditor.getPstlAdr()));
        }
        SEPAExtractorV3Ch.setPurposeInformation(t.getRmtInf(), paymentData);
        if (recipientBankIdentification != null) {
            SEPAExtractorV3Ch.loadOtherRecipientBankData(recipientBankIdentification, paymentData);
        }
        SEPAExtractorV3Ch.loadChequeInstructionData(t.getChqInstr(), paymentData);
        List<RegulatoryReporting3> rptgs = t.getRgltryRptgs();
        if (rptgs != null) {
            for (RegulatoryReporting3 rptg : rptgs) {
                paymentData.addRegReporting(SEPAExtractorV3Ch.getRegReporting(rptg));
            }
        }
        return paymentData;
    }

    private static RegReporting getRegReporting(RegulatoryReporting3 rptg) {
        RegReporting reporting = new RegReporting();
        if (rptg != null) {
            List<StructuredRegulatoryReporting3> dtls;
            RegulatoryReportingType1Code code = rptg.getDbtCdtRptgInd();
            if (code != null) {
                reporting.setCreditDebitIndicator(code.getValue());
            }
            if (rptg.getAuthrty() != null) {
                if (rptg.getAuthrty().getNm() != null) {
                    reporting.setAuthorityName(rptg.getAuthrty().getNm().getValue());
                }
                if (rptg.getAuthrty().getCtry() != null) {
                    reporting.setAuthorityCountry(rptg.getAuthrty().getCtry().getValue());
                }
            }
            if ((dtls = rptg.getDtlss()) != null) {
                for (StructuredRegulatoryReporting3 dtl : dtls) {
                    reporting.addDetail(SEPAExtractorV3Ch.getRegReportingDetail(dtl));
                }
            }
        }
        return reporting;
    }

    private static RegReportingDetail getRegReportingDetail(StructuredRegulatoryReporting3 rptg) {
        RegReportingDetail detail = new RegReportingDetail();
        if (rptg != null) {
            if (rptg.getAmt() != null) {
                detail.setAmount(rptg.getAmt().getValue());
            }
            if (rptg.getCd() != null) {
                detail.setCode(rptg.getCd().getValue());
            }
            if (rptg.getCtry() != null) {
                detail.setCountry(rptg.getCtry().getValue());
            }
            if (rptg.getDt() != null) {
                detail.setDate(rptg.getDt().getDate());
            }
            if (rptg.getTp() != null) {
                detail.setType(rptg.getTp().getValue());
            }
            if (rptg.getInfs() != null) {
                for (Max35Text inf : rptg.getInfs()) {
                    detail.addInf(inf.getValue());
                }
            }
        }
        return detail;
    }

    public static String getPaymentCategory(CategoryPurpose1_CH_Code choice) {
        if (choice != null) {
            return SimpleStringElement.getNonNullValue(choice.getCd());
        }
        return null;
    }

    private static CategoryPurpose1_CH_Code getPaymentCategory(String paymentCategory) {
        String value = StringUtils.checkNullAndTrim(paymentCategory);
        if (value.length() > 0) {
            ExternalCategoryPurpose1Code cd = new ExternalCategoryPurpose1Code(value);
            return new CategoryPurpose1_CH_Code(cd);
        }
        return null;
    }

    public static String getServiceLevel(ServiceLevel8Choice choice) {
        if (choice != null) {
            return SimpleStringElement.getNonNullValue(choice.getChoice1().getCd());
        }
        return null;
    }

    private static ServiceLevel8Choice getServiceLevel(String serviceLevel) {
        String value = StringUtils.checkNullAndTrim(serviceLevel);
        if (value.length() > 0) {
            return new ServiceLevel8Choice(ServiceLevel8Choice.ServiceLevel8Choice_C1.fromCd(new ExternalServiceLevel1Code(value)));
        }
        return null;
    }

    public static String getLocalInstrument(LocalInstrument2Choice lclInstrm) {
        if (lclInstrm != null) {
            LocalInstrument2Choice.LocalInstrument2Choice_C1 choice = lclInstrm.getChoice1();
            if (choice.getCd() != null) {
                return choice.getCd().getValue();
            }
            if (choice.getPrtry() != null) {
                return choice.getPrtry().getValue();
            }
        }
        return null;
    }

    private static LocalInstrument2Choice getLocalInstrument(String localInstrument) {
        String value = StringUtils.checkNullAndTrim(localInstrument);
        if (value.length() > 0) {
            if (SEPALocalInstrument.isProprietaryValue(value)) {
                return new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromPrtry(new Max35Text(value)));
            }
            return new LocalInstrument2Choice(LocalInstrument2Choice.LocalInstrument2Choice_C1.fromCd(new ExternalLocalInstrument1Code(value)));
        }
        return null;
    }

    protected static AccountNumberInfo getAccountNumberInfo(AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1 choice) {
        if (choice.getIBAN() != null) {
            return new AccountNumberInfo(choice.getIBAN().getValue(), true);
        }
        if (choice.getOthr() != null) {
            return new AccountNumberInfo(choice.getOthr().getId().getValue(), false);
        }
        return null;
    }

    protected static String getBankIdentifier(FinancialInstitutionIdentification7_CH_BicOrClrId choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        if (choice.getClrSysMmbId() != null) {
            return choice.getClrSysMmbId().getMmbId().getValue();
        }
        return null;
    }

    private static String getRecipientBIC(FinancialInstitutionIdentification7_CH finInstnId) {
        if (finInstnId.getBIC() != null) {
            return finInstnId.getBIC().getValue();
        }
        return null;
    }

    private static void loadOtherRecipientBankData(FinancialInstitutionIdentification7_CH finInstnId, SEPAPaymentData paymentData) {
        boolean bicIsMissing;
        boolean bl = bicIsMissing = finInstnId.getBIC() == null;
        if (finInstnId.getNm() != null) {
            paymentData.setRecipientBankName(finInstnId.getNm().getValue());
        }
        if (bicIsMissing) {
            String otherId;
            ClearingSystemMemberIdentification2 clrSysMbId = finInstnId.getClrSysMmbId();
            if (clrSysMbId != null) {
                if (clrSysMbId.getClrSysId() != null) {
                    ClearingSystemIdentification2Choice.ClearingSystemIdentification2Choice_C1 choice = clrSysMbId.getClrSysId().getChoice1();
                    if (choice.getCd() != null) {
                        paymentData.setRecipientClearingSystemId(choice.getCd().getValue());
                    } else if (choice.getPrtry() != null) {
                        paymentData.setRecipientClearingSystemId(choice.getPrtry().getValue());
                    }
                }
                paymentData.setRecipientBic(clrSysMbId.getMmbId().getValue());
            } else if (finInstnId.getOthr() != null && !"NOTPROVIDED".equals(otherId = finInstnId.getOthr().getId().getValue())) {
                paymentData.setRecipientBic(otherId);
            }
        }
        if (finInstnId.getPstlAdr() != null) {
            paymentData.setRecipientBankAddressData(SEPAExtractorV3Ch.getAddressData(finInstnId.getPstlAdr()));
        }
    }

    private static void loadChequeInstructionData(Cheque6_CH cheque, SEPAPaymentData paymentData) {
        if (cheque != null) {
            ChequeInstructionData checkInstructionData = new ChequeInstructionData();
            if (cheque.getChqTp() != null) {
                checkInstructionData.setChequeType(cheque.getChqTp().getValue());
            }
            if (cheque.getDlvryMtd() != null) {
                ChequeDelivery1Code deliveryCode = cheque.getDlvryMtd().getChoice1().getCd();
                if (deliveryCode != null) {
                    checkInstructionData.setDeliveryMethod(deliveryCode.getValue());
                } else {
                    Max35Text deliveryText = cheque.getDlvryMtd().getChoice1().getPrtry();
                    if (deliveryText != null) {
                        checkInstructionData.setDeliveryMethod(deliveryText.getValue());
                    }
                }
            }
            paymentData.setChequeInstructionData(checkInstructionData);
        }
    }

    protected static ActiveOrHistoricCurrencyAndAmount getCurrencyAndAmount(AmountType3Choice.AmountType3Choice_C1 choice) {
        if (choice.getInstdAmt() != null) {
            return choice.getInstdAmt();
        }
        if (choice.getEqvtAmt() != null) {
            return choice.getEqvtAmt().getAmt();
        }
        return null;
    }

    private static Currency getCounterValueCurrency(AmountType3Choice.AmountType3Choice_C1 choice) {
        if (choice.getEqvtAmt() != null) {
            return Currency.getInstance(choice.getEqvtAmt().getCcyOfTrf().getValue());
        }
        return null;
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformation3_CH logicalFile = SEPAExtractorV3Ch.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeader32_CH grpHdr = SEPAExtractorV3Ch.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerCreditTransferInitiationV03_CH cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV03_CH(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformation3_CH> logicalFiles = new ArrayList<PaymentInstructionInformation3_CH>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV3Ch.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeader32_CH grpHdr = SEPAExtractorV3Ch.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        return new Document(new CustomerCreditTransferInitiationV03_CH(grpHdr, logicalFiles));
    }

    private static GroupHeader32_CH getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        GroupHeader32_CH grpHdr = new GroupHeader32_CH(new Max35Text_Swift(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), SEPAExtractorV3Ch.getParty2(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformation3_CH getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        String chargeBearer;
        SEPAPaymentData firstPayment = paymentList.get(0);
        PaymentMethod3Code paymentMethod = new PaymentMethod3Code(SEPAExtractorV3Ch.getPaymentMethodCode(firstPayment));
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentification32_CH originator = SEPAExtractorV3Ch.getParty(firstPayment.getOriginator(), firstPayment.getOriginatorAddressData());
        BranchAndFinancialInstitutionIdentification4_CH_BicOrClrId originatorBank = SEPAExtractorV3Ch.getBankId(firstPayment.getOriginatorBic());
        CashAccount16_CH_IdTpCcy originatorAccount = SEPAExtractorV3Ch.getOriginatorAccountId(firstPayment.getOriginatorIban());
        SEPAExtractorV3Ch.setAccountCurrencyAndType(originatorAccount, firstPayment.getAccountCurrency(), firstPayment.getOriginatorAccountType());
        PaymentInstructionInformation3_CH logicalFile = new PaymentInstructionInformation3_CH(new Max35Text_Swift(logicalFileId), paymentMethod, executionDate, originator, originatorAccount, originatorBank);
        logicalFile.setCdtTrfTxInfs(SEPAExtractorV3Ch.getTransactions(logicalFileId, paymentList));
        BigDecimal controlSum = BigDecimal.ZERO;
        for (SEPAPaymentData p : paymentList) {
            controlSum = controlSum.add(p.getAmount());
        }
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(paymentList.size())));
        PaymentTypeInformation19_CH paymentType = SEPAExtractorV3Ch.getPaymentTypeInfo(firstPayment);
        if (paymentType != null) {
            logicalFile.setPmtTpInf(paymentType);
        }
        if (WRITE_CHARGE_BEARER && (chargeBearer = StringUtils.checkNullAndTrim(firstPayment.getChargeBearer())).length() > 0) {
            logicalFile.setChrgBr(new ChargeBearerType1Code(chargeBearer));
        }
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return logicalFile;
    }

    private static String getPaymentMethodCode(SEPAPaymentData firstPayment) {
        String paymentMethod = firstPayment.getPaymentMethod();
        if (paymentMethod != null && paymentMethod.trim().length() > 0) {
            return paymentMethod.trim();
        }
        return SEPAPaymentMethod.TRF.name();
    }

    private static void setAccountCurrencyAndType(CashAccount16_CH_IdTpCcy account, Currency currency, String type) {
        if (currency != null) {
            account.setCcy(new ActiveOrHistoricCurrencyCode(currency.getCurrencyCode()));
        }
        if ((type = StringUtils.checkNullAndTrim(type)).length() > 0) {
            if (SEPAAccountType.isProprietaryValue(type)) {
                account.setTp(new CashAccountType2(CashAccountType2.CashAccountType2_C1.fromPrtry(new Max35Text(type))));
            } else {
                account.setTp(new CashAccountType2(CashAccountType2.CashAccountType2_C1.fromCd(new CashAccountType4Code(type))));
            }
        }
    }

    private static String getAccountType(CashAccount16_CH_IdTpCcy account) {
        if (account.getTp() != null) {
            if (account.getTp().getChoice1().getPrtry() != null) {
                return account.getTp().getChoice1().getPrtry().getValue();
            }
            if (account.getTp().getChoice1().getCd() != null) {
                return account.getTp().getChoice1().getCd().getValue();
            }
        }
        return null;
    }

    private static PaymentTypeInformation19_CH getPaymentTypeInfo(SEPAPaymentData firstPayment) {
        CategoryPurpose1_CH_Code ctgyPurp;
        LocalInstrument2Choice lclInstrm;
        String instructionPriority;
        PaymentTypeInformation19_CH paymentType = null;
        ServiceLevel8Choice svcLvl = SEPAExtractorV3Ch.getServiceLevel(firstPayment.getServiceLevel());
        if (svcLvl != null) {
            if (paymentType == null) {
                paymentType = new PaymentTypeInformation19_CH();
            }
            paymentType.setSvcLvl(svcLvl);
        }
        if ((instructionPriority = StringUtils.checkNullAndTrim(firstPayment.getInstructionPriority())).length() > 0) {
            if (paymentType == null) {
                paymentType = new PaymentTypeInformation19_CH();
            }
            paymentType.setInstrPrty(new Priority2Code(instructionPriority));
        }
        if ((lclInstrm = SEPAExtractorV3Ch.getLocalInstrument(firstPayment.getLocalInstrument())) != null) {
            if (paymentType == null) {
                paymentType = new PaymentTypeInformation19_CH();
            }
            paymentType.setLclInstrm(lclInstrm);
        }
        if (WRITE_CATEGORY && (ctgyPurp = SEPAExtractorV3Ch.getPaymentCategory(firstPayment.getPaymentCategory())) != null) {
            if (paymentType == null) {
                paymentType = new PaymentTypeInformation19_CH();
            }
            paymentType.setCtgyPurp(ctgyPurp);
        }
        return paymentType;
    }

    private static List<CreditTransferTransactionInformation10_CH> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransactionInformation10_CH> transactions = new ArrayList<CreditTransferTransactionInformation10_CH>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purposeCode;
            String ultimateCreditor;
            String ultimateDebitor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new Max35Text_Swift((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new Max35Text_Swift(instructionId));
            }
            PartyIdentification32_CH_Name recipient = new PartyIdentification32_CH_Name(new Max70Text(paymentData.getRecipient()));
            PostalAddress6_CH recipientAddress = SEPAExtractorV3Ch.saveAddress(paymentData.getRecipientAddressData());
            if (recipientAddress != null) {
                recipient.setPstlAdr(recipientAddress);
            }
            CashAccount16_CH_Id recipientIban = SEPAExtractorV3Ch.getRecipientAccountId(paymentData.getRecipientIban());
            CreditTransferTransactionInformation10_CH transaction = new CreditTransferTransactionInformation10_CH(pmtId, SEPAExtractorV3Ch.getAmt(paymentData.getAmount(), paymentData.getCurrency(), paymentData.getCounterValueCurrency()));
            transaction.setCdtr(recipient);
            transaction.setCdtrAcct(recipientIban);
            BranchAndFinancialInstitutionIdentification4_CH cdtrAgt = SEPAExtractorV3Ch.getCdtrAgt(paymentData);
            if (cdtrAgt != null) {
                transaction.setCdtrAgt(cdtrAgt);
            }
            if ((ultimateDebitor = paymentData.getUltimateOriginator()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPAExtractorV3Ch.getParty(ultimateDebitor, null));
            }
            if ((ultimateCreditor = paymentData.getUltimateRecipient()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(new PartyIdentification32_CH_Name(new Max70Text(ultimateCreditor)));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose2_CH_Code(new ExternalPurpose1Code(purposeCode.trim())));
            }
            for (RegReporting reporting : paymentData.getRegReportings()) {
                transaction.getRgltryRptgs().add(SEPAExtractorV3Ch.getRegulatoryReporting(reporting));
            }
            RemittanceInformation5_CH remittanceInfo = SEPAExtractorV3Ch.getRemittanceInformation(paymentData);
            if (remittanceInfo != null) {
                transaction.setRmtInf(remittanceInfo);
            }
            transaction.setChqInstr(SEPAExtractorV3Ch.getChqInstr(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static RegulatoryReporting3 getRegulatoryReporting(RegReporting reporting) {
        String indicator;
        RegulatoryReporting3 rr = new RegulatoryReporting3();
        RegulatoryAuthority2 regAuth = SEPAExtractorV3Ch.getRegAuthority(reporting.getAuthorityCountry(), reporting.getAuthorityName());
        if (regAuth != null) {
            rr.setAuthrty(regAuth);
        }
        if ((indicator = StringUtils.checkNullAndTrim(reporting.getCreditDebitIndicator())).length() > 0) {
            rr.setDbtCdtRptgInd(new RegulatoryReportingType1Code(indicator));
        }
        for (RegReportingDetail reportingDetail : reporting.getDetails()) {
            StructuredRegulatoryReporting3 srr = SEPAExtractorV3Ch.getRegulatoryReportingDetail(reportingDetail);
            if (srr == null) continue;
            rr.getDtlss().add(srr);
        }
        return rr;
    }

    private static RegulatoryAuthority2 getRegAuthority(String countryCode, String name) {
        String regAuthName;
        RegulatoryAuthority2 regAuth = null;
        if (countryCode != null && RegularExpressions.COUNTRY_CODE.matches(countryCode)) {
            regAuth = new RegulatoryAuthority2();
            regAuth.setCtry(new CountryCode(countryCode));
        }
        if ((regAuthName = StringUtils.checkNullAndTrim(name)).length() > 0) {
            if (regAuth == null) {
                regAuth = new RegulatoryAuthority2();
            }
            regAuth.setNm(new Max140Text(regAuthName));
        }
        return regAuth;
    }

    private static StructuredRegulatoryReporting3 getRegulatoryReportingDetail(RegReportingDetail detail) {
        String type;
        String code;
        StructuredRegulatoryReporting3 srr = null;
        if (detail.getAmount() != null && detail.getCurrency() != null) {
            srr = new StructuredRegulatoryReporting3();
            srr.setAmt(new ActiveOrHistoricCurrencyAndAmount(detail.getAmount(), new ActiveOrHistoricCurrencyCode(detail.getCurrency().getCurrencyCode())));
        }
        if ((code = StringUtils.checkNullAndTrim(detail.getCode())).length() > 0) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setCd(new Max10Text(code));
        }
        if (detail.getCountry() != null && RegularExpressions.COUNTRY_CODE.matches(detail.getCountry())) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setCtry(new CountryCode(detail.getCountry()));
        }
        if (detail.getDate() != null) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setDt(new ISODate(new YYMMDD(detail.getDate().getTime())));
        }
        if ((type = StringUtils.checkNullAndTrim(detail.getType())).length() > 0) {
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.setTp(new Max35Text(type));
        }
        for (String inf : detail.getInfs()) {
            String info = StringUtils.checkNullAndTrim(inf);
            if (info.length() <= 0) continue;
            if (srr == null) {
                srr = new StructuredRegulatoryReporting3();
            }
            srr.getInfs().add(new Max35Text(inf));
        }
        return srr;
    }

    private static BranchAndFinancialInstitutionIdentification4_CH getCdtrAgt(SEPAPaymentData paymentData) {
        PostalAddress6_CH recipientBankAddress;
        String bankName;
        FinancialInstitutionIdentification7_CH finInstnId = new FinancialInstitutionIdentification7_CH();
        boolean hasValues = false;
        String bankCode = StringUtils.checkNullAndTrim(paymentData.getRecipientBic());
        if (bankCode.length() > 0) {
            String clearingSystemId = StringUtils.checkNullAndTrim(paymentData.getRecipientClearingSystemId());
            if (clearingSystemId.length() > 0) {
                ClearingSystemMemberIdentification2 clrSysMmbId = new ClearingSystemMemberIdentification2(new Max35Text(bankCode));
                ExternalClearingSystemIdentification1Code clrSysCode = new ExternalClearingSystemIdentification1Code(clearingSystemId);
                clrSysMmbId.setClrSysId(new ClearingSystemIdentification2Choice(ClearingSystemIdentification2Choice.ClearingSystemIdentification2Choice_C1.fromCd(clrSysCode)));
                finInstnId.setClrSysMmbId(clrSysMmbId);
            } else if (RegularExpressions.BIC.matches(bankCode)) {
                finInstnId.setBIC(new BICIdentifier(bankCode));
            } else {
                finInstnId.setOthr(new GenericFinancialIdentification1_CH(new Max35Text(bankCode)));
            }
            hasValues = true;
        }
        if ((bankName = StringUtils.checkNullAndTrim(paymentData.getRecipientBankName())).length() > 0) {
            finInstnId.setNm(new Max70Text(bankName));
            hasValues = true;
        }
        if ((recipientBankAddress = SEPAExtractorV3Ch.saveAddress(paymentData.getRecipientBankAddressData())) != null) {
            finInstnId.setPstlAdr(recipientBankAddress);
            hasValues = true;
        }
        if (hasValues) {
            return new BranchAndFinancialInstitutionIdentification4_CH(finInstnId);
        }
        return null;
    }

    private static Cheque6_CH getChqInstr(SEPAPaymentData paymentData) {
        ChequeInstructionData chequeInstructionData = paymentData.getChequeInstructionData();
        if (chequeInstructionData != null) {
            String deliveryMethod;
            Cheque6_CH cheque = new Cheque6_CH();
            String chequeType = StringUtils.checkNullAndTrim(chequeInstructionData.getChequeType());
            if (chequeType.length() > 0) {
                cheque.setChqTp(new ChequeType2Code(chequeType));
            }
            if ((deliveryMethod = StringUtils.checkNullAndTrim(chequeInstructionData.getDeliveryMethod())).length() > 0) {
                ChequeDeliveryMethod1Choice.ChequeDeliveryMethod1Choice_C1 choice1 = ChequeDeliveryMethod1Choice.ChequeDeliveryMethod1Choice_C1.fromCd(new ChequeDelivery1Code(deliveryMethod));
                cheque.setDlvryMtd(new ChequeDeliveryMethod1Choice(choice1));
            }
            return cheque;
        }
        return null;
    }

    private static RemittanceInformation5_CH getRemittanceInformation(SEPAPaymentData paymentData) {
        RemittanceInformation5_CH remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            List<String> purposeLines;
            StructuredRemittanceInformation7 structured = null;
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                CreditorReferenceInformation2 cdtrRefInf = new CreditorReferenceInformation2();
                cdtrRefInf.setRef(new Max35Text(paymentData.getPurposeReference()));
                CreditorReferenceType2 tp = SEPAExtractorV3Ch.getPurposeReferenceType(paymentData);
                if (tp != null) {
                    cdtrRefInf.setTp(tp);
                }
                structured = new StructuredRemittanceInformation7();
                structured.setCdtrRefInf(cdtrRefInf);
            }
            if ((purposeLines = paymentData.getStructuredPurposeLines()).size() > 0) {
                if (structured == null) {
                    structured = new StructuredRemittanceInformation7();
                }
                for (String purposeLine : purposeLines) {
                    structured.getAddtlRmtInfs().add(new Max140Text(purposeLine));
                }
            }
            if (structured != null) {
                remittanceInfo = new RemittanceInformation5_CH();
                remittanceInfo.setStrd(structured);
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformation5_CH();
                remittanceInfo.setUstrd(new Max140Text(purpose));
            }
        }
        return remittanceInfo;
    }

    private static CreditorReferenceType2 getPurposeReferenceType(SEPAPaymentData paymentData) {
        CreditorReferenceType1Choice choice = null;
        String structuredTypeCode = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypeCode());
        if (structuredTypeCode.length() > 0) {
            DocumentType3Code code = new DocumentType3Code(structuredTypeCode);
            choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromCd(code));
        } else {
            String structuredTypePrtry = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypePrtry());
            if (structuredTypePrtry.length() > 0) {
                Max35Text prtry = new Max35Text(structuredTypePrtry);
                choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromPrtry(prtry));
            }
        }
        if (choice != null) {
            return new CreditorReferenceType2(choice);
        }
        return null;
    }

    private static void setPurposeInformation(RemittanceInformation5_CH rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            if (rmtInf.getUstrd() != null) {
                paymentData.setHasStructuredPurpose(false);
                paymentData.setPurpose(rmtInf.getUstrd().getValue());
            } else if (rmtInf.getStrd() != null) {
                CreditorReferenceInformation2 cdtrRefInf;
                paymentData.setHasStructuredPurpose(true);
                List<Max140Text> purposeLines = rmtInf.getStrd().getAddtlRmtInfs();
                if (purposeLines.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (Max140Text purposeLine : purposeLines) {
                        String s = purposeLine.getValue();
                        paymentData.getStructuredPurposeLines().add(s);
                        sb.append(s);
                    }
                    paymentData.setPurpose(sb.toString());
                }
                if ((cdtrRefInf = rmtInf.getStrd().getCdtrRefInf()) != null) {
                    CreditorReferenceType2 tp;
                    if (cdtrRefInf.getRef() != null) {
                        paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                    }
                    if ((tp = cdtrRefInf.getTp()) != null) {
                        CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1 c = tp.getCdOrPrtry().getChoice1();
                        if (c.getCd() != null) {
                            paymentData.setPurposeReferenceTypeCode(c.getCd().getValue());
                        } else if (c.getPrtry() != null) {
                            paymentData.setPurposeReferenceTypePrtry(c.getPrtry().getValue());
                        }
                    }
                }
            }
        }
    }

    private static PartyIdentification32_CH_NameAndId getParty2(String name) {
        PartyIdentification32_CH_NameAndId party = new PartyIdentification32_CH_NameAndId();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max70Text(name));
        }
        return party;
    }

    private static PartyIdentification32_CH getParty(String name, AddressData addressData) {
        PartyIdentification32_CH party = new PartyIdentification32_CH();
        party.setNm(new Max70Text(name));
        PostalAddress6_CH address = SEPAExtractorV3Ch.saveAddress(addressData);
        if (address != null) {
            party.setPstlAdr(address);
        }
        return party;
    }

    private static PostalAddress6_CH saveAddress(AddressData addressData) {
        if (addressData != null) {
            String s;
            PostalAddress6_CH pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getDepartment())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setDept(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getSubDepartment())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setSubDept(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getStreetName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setStrtNm(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getBuildingNumber())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setBldgNb(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getPostCode())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setPstCd(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getTownName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setTwnNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getCountrySubDivision())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6_CH();
                }
                pstlAdr.setCtrySubDvsn(new Max35Text(s));
            }
            return pstlAdr;
        }
        return null;
    }

    private static AddressData getAddressData(PostalAddress6_CH address) {
        AddressData addressData = new AddressData();
        CountryCode countryCode = address.getCtry();
        if (countryCode != null) {
            addressData.setCountry(countryCode.getValue());
        }
        for (Max70Text line : address.getAdrLines()) {
            addressData.getAddressLines().add(line.getValue());
        }
        addressData.setDepartment(SimpleStringElement.getValue(address.getDept()));
        addressData.setSubDepartment(SimpleStringElement.getValue(address.getSubDept()));
        addressData.setStreetName(SimpleStringElement.getValue(address.getStrtNm()));
        addressData.setBuildingNumber(SimpleStringElement.getValue(address.getBldgNb()));
        addressData.setPostCode(SimpleStringElement.getValue(address.getPstCd()));
        addressData.setTownName(SimpleStringElement.getValue(address.getTwnNm()));
        addressData.setCountrySubDivision(SimpleStringElement.getValue(address.getCtrySubDvsn()));
        return addressData;
    }

    private static BranchAndFinancialInstitutionIdentification4_CH_BicOrClrId getBankId(String bic) {
        FinancialInstitutionIdentification7_CH_BicOrClrId id = new FinancialInstitutionIdentification7_CH_BicOrClrId();
        if (bic != null && bic.trim().length() >= 8) {
            id.setBIC(new BICIdentifier(bic.trim()));
        } else {
            id.setClrSysMmbId(new ClearingSystemMemberIdentification2(new Max35Text("NOTPROVIDED")));
        }
        return new BranchAndFinancialInstitutionIdentification4_CH_BicOrClrId(id);
    }

    private static CashAccount16_CH_IdTpCcy getOriginatorAccountId(String iban) {
        AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1 c1 = null;
        c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1.fromIBAN(new IBAN2007Identifier(iban)) : AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1.fromOthr(new GenericAccountIdentification1_CH(new Max34Text(iban)));
        AccountIdentification4Choice_CH c2 = new AccountIdentification4Choice_CH(c1);
        return new CashAccount16_CH_IdTpCcy(c2);
    }

    private static CashAccount16_CH_Id getRecipientAccountId(String iban) {
        String accountNumber = StringUtils.checkNullAndTrim(iban);
        if (accountNumber.length() > 0) {
            AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1 c1 = null;
            c1 = IbanUtil.checkIbanPattern(accountNumber) ? AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1.fromIBAN(new IBAN2007Identifier(accountNumber)) : AccountIdentification4Choice_CH.AccountIdentification4Choice_CH_C1.fromOthr(new GenericAccountIdentification1_CH(new Max34Text(accountNumber)));
            return new CashAccount16_CH_Id(new AccountIdentification4Choice_CH(c1));
        }
        return null;
    }

    private static AmountType3Choice getAmt(BigDecimal amount, Currency currency, Currency counterValueCurrency) {
        AmountType3Choice.AmountType3Choice_C1 c1;
        ActiveOrHistoricCurrencyCode ccy = new ActiveOrHistoricCurrencyCode(currency.getCurrencyCode());
        ActiveOrHistoricCurrencyAndAmount amt = new ActiveOrHistoricCurrencyAndAmount(amount, ccy);
        if (counterValueCurrency != null) {
            ActiveOrHistoricCurrencyCode counterValueCcy = new ActiveOrHistoricCurrencyCode(counterValueCurrency.getCurrencyCode());
            c1 = AmountType3Choice.AmountType3Choice_C1.fromEqvtAmt(new EquivalentAmount2(amt, counterValueCcy));
        } else {
            c1 = AmountType3Choice.AmountType3Choice_C1.fromInstdAmt(amt);
        }
        return new AmountType3Choice(c1);
    }
}

