/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.pain00100203.AccountIdentificationSEPA;
import de.businesslogics.format.sepa.pain00100203.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.sepa.pain00100203.ActiveOrHistoricCurrencyCodeEUR;
import de.businesslogics.format.sepa.pain00100203.AmountTypeSEPA;
import de.businesslogics.format.sepa.pain00100203.BICIdentifier;
import de.businesslogics.format.sepa.pain00100203.BatchBookingIndicator;
import de.businesslogics.format.sepa.pain00100203.BranchAndFinancialInstitutionIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100203.CashAccountSEPA1;
import de.businesslogics.format.sepa.pain00100203.CashAccountSEPA2;
import de.businesslogics.format.sepa.pain00100203.CategoryPurposeSEPA;
import de.businesslogics.format.sepa.pain00100203.ChargeBearerTypeSEPACode;
import de.businesslogics.format.sepa.pain00100203.CreditTransferTransactionInformationSCT;
import de.businesslogics.format.sepa.pain00100203.CustomerCreditTransferInitiationV03;
import de.businesslogics.format.sepa.pain00100203.DecimalNumber;
import de.businesslogics.format.sepa.pain00100203.Document;
import de.businesslogics.format.sepa.pain00100203.ExternalCategoryPurpose1Code;
import de.businesslogics.format.sepa.pain00100203.ExternalPurpose1Code;
import de.businesslogics.format.sepa.pain00100203.FinancialInstitutionIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100203.GroupHeaderSCT;
import de.businesslogics.format.sepa.pain00100203.IBAN2007Identifier;
import de.businesslogics.format.sepa.pain00100203.ISODate;
import de.businesslogics.format.sepa.pain00100203.ISODateTime;
import de.businesslogics.format.sepa.pain00100203.Max140Text;
import de.businesslogics.format.sepa.pain00100203.Max15NumericText;
import de.businesslogics.format.sepa.pain00100203.Max70Text;
import de.businesslogics.format.sepa.pain00100203.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100203.PartyIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00100203.PaymentIdentificationSEPA;
import de.businesslogics.format.sepa.pain00100203.PaymentInstructionInformationSCT;
import de.businesslogics.format.sepa.pain00100203.PaymentMethodSCTCode;
import de.businesslogics.format.sepa.pain00100203.PaymentTypeInformationSCT1;
import de.businesslogics.format.sepa.pain00100203.PurposeSEPA;
import de.businesslogics.format.sepa.pain00100203.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.pain00100203.RestrictedIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00100203.ServiceLevelSEPA;
import de.businesslogics.format.sepa.pain00100203.ServiceLevelSEPACode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV3 {
    public static XMLDate getDateSRZ(Document document) {
        return document.getCstmrCdtTrfInitn().getPmtInfs().get(0).getReqdExctnDt();
    }

    protected static List<SEPAPaymentData> getPaymentsFromCCT(Document document) {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        CustomerCreditTransferInitiationV03 pain00100202 = document.getCstmrCdtTrfInitn();
        String msgId = pain00100202.getGrpHdr().getMsgId().getValue();
        String initParty = pain00100202.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSCT p : pain00100202.getPmtInfs()) {
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV3.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFilesFromCCT(Document document) {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        CustomerCreditTransferInitiationV03 pain00100202 = document.getCstmrCdtTrfInitn();
        String msgId = pain00100202.getGrpHdr().getMsgId().getValue();
        String initParty = pain00100202.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSCT p : pain00100202.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(p.getPmtInfId().getValue(), msgId);
            SEPAExtractorV3.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV3.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V25);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    private static SEPAPaymentData getPaymentDataFromCCT(String msgId, String initParty, PaymentInstructionInformationSCT p, CreditTransferTransactionInformationSCT c) {
        String orig = p.getDbtr().getNm().getValue();
        String origIban = p.getDbtrAcct().getId().getIBAN().getValue();
        String origBic = p.getDbtrAgt().getFinInstnId().getBIC().getValue();
        String ultimateOrig = null;
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(p.getUltmtDbtr().getNm());
        } else if (c.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(c.getUltmtDbtr().getNm());
        }
        String recip = c.getCdtr().getNm().getValue();
        String recipIban = c.getCdtrAcct().getId().getIBAN().getValue();
        String recipBic = c.getCdtrAgt().getFinInstnId().getBIC().getValue();
        String ultimateRecip = null;
        if (c.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getValue(c.getUltmtCdtr().getNm());
        }
        BigDecimal amount = c.getAmt().getInstdAmt().getValue();
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String purpose = null;
        purpose = c.getRmtInf() != null && c.getRmtInf().getChoice1() != null && c.getRmtInf().getChoice1().getUstrd() != null ? c.getRmtInf().getChoice1().getUstrd().getValue() : "";
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null && p.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getCd().getValue();
        } else if (c.getPmtTpInf() != null && c.getPmtTpInf().getCtgyPurp() != null && c.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = c.getPmtTpInf().getCtgyPurp().getCd().getValue();
        }
        String endToEndId = c.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = null;
        instructionId = c.getPmtId().getInstrId() != null ? c.getPmtId().getInstrId().getValue() : "";
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, purpose, paymentCategory, endToEndId, instructionId);
        PurposeSEPA purposeCode = c.getPurp();
        if (purposeCode != null) {
            paymentData.setPurposeCode(purposeCode.getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        return paymentData;
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformationSCT logicalFile = SEPAExtractorV3.getLogicalFile("TempMessageId", paymentData.displayAsSingleBooking() ? Boolean.FALSE : null, paymentList);
        GroupHeaderSCT grpHdr = SEPAExtractorV3.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerCreditTransferInitiationV03 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV03(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSCT> logicalFiles = new ArrayList<PaymentInstructionInformationSCT>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                if (paymentList.get(0).displayAsSingleBooking()) {
                    btchBookg = Boolean.FALSE;
                }
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if ("NOTPROVIDED".equals(messageId)) {
                logicalFiles.add(SEPAExtractorV3.getLogicalFile(messageId, btchBookg, paymentList));
            } else {
                if (pmtInfId == null) {
                    pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
                }
                logicalFiles.add(SEPAExtractorV3.getLogicalFile(pmtInfId, btchBookg, paymentList));
            }
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeaderSCT grpHdr = SEPAExtractorV3.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        CustomerCreditTransferInitiationV03 cstmrCdtTrfInitn = new CustomerCreditTransferInitiationV03(grpHdr);
        for (PaymentInstructionInformationSCT logicalFile : logicalFiles) {
            cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        }
        return new Document(cstmrCdtTrfInitn);
    }

    private static GroupHeaderSCT getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        PartyIdentificationSEPA1 initgPty = new PartyIdentificationSEPA1();
        if (initiatingParty != null && !initiatingParty.isEmpty()) {
            initgPty.setNm(new Max70Text(initiatingParty));
        }
        GroupHeaderSCT grpHdr = new GroupHeaderSCT(new RestrictedIdentificationSEPA1(messageId), new ISODateTime(), new Max15NumericText(String.valueOf(totalCountTransactions)), initgPty);
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformationSCT getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSEPA2 originator = new PartyIdentificationSEPA2(new Max70Text(firstPayment.getOriginator()));
        CashAccountSEPA1 originatorIban = new CashAccountSEPA1(new AccountIdentificationSEPA(new IBAN2007Identifier(firstPayment.getOriginatorIban())));
        BranchAndFinancialInstitutionIdentificationSEPA1 originatorBic = new BranchAndFinancialInstitutionIdentificationSEPA1(new FinancialInstitutionIdentificationSEPA1(new BICIdentifier(firstPayment.getOriginatorBic())));
        PaymentInstructionInformationSCT logicalFile = new PaymentInstructionInformationSCT(new RestrictedIdentificationSEPA1(logicalFileId), new PaymentMethodSCTCode(GeneralSEPAExtractor.TRF), executionDate, originator, originatorIban, originatorBic);
        PaymentTypeInformationSCT1 category = new PaymentTypeInformationSCT1(new ServiceLevelSEPA(new ServiceLevelSEPACode(GeneralSEPAExtractor.SEPA)));
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            category.setCtgyPurp(new CategoryPurposeSEPA(new ExternalCategoryPurpose1Code(categoryPurpose)));
        }
        logicalFile.setPmtTpInf(category);
        logicalFile.setChrgBr(new ChargeBearerTypeSEPACode(SEPAFeeType.SLEV.name()));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        BigDecimal controlSum = BigDecimal.ZERO;
        for (CreditTransferTransactionInformationSCT transaction : SEPAExtractorV3.getTransactions(logicalFileId, paymentList)) {
            logicalFile.getCdtTrfTxInfs().add(transaction);
            controlSum = controlSum.add(transaction.getAmt().getInstdAmt().getValue());
        }
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(logicalFile.getCdtTrfTxInfs().size())));
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        return logicalFile;
    }

    private static List<CreditTransferTransactionInformationSCT> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransactionInformationSCT> transactions = new ArrayList<CreditTransferTransactionInformationSCT>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String purposeCode;
            String ultimateRecipient;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = "NOTPROVIDED".equals(logicalFileId) ? "NOTPROVIDED" : logicalFileId + "-" + transactionId++;
            }
            PaymentIdentificationSEPA pmtId = new PaymentIdentificationSEPA(new RestrictedIdentificationSEPA1((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new RestrictedIdentificationSEPA1(instructionId));
            }
            AmountTypeSEPA amount = new AmountTypeSEPA(new ActiveOrHistoricCurrencyAndAmountSEPA(paymentData.getAmount(), new ActiveOrHistoricCurrencyCodeEUR("EUR")));
            PartyIdentificationSEPA2 recipient = new PartyIdentificationSEPA2(new Max70Text(paymentData.getRecipient()));
            CashAccountSEPA2 recipientIban = new CashAccountSEPA2(new AccountIdentificationSEPA(new IBAN2007Identifier(paymentData.getRecipientIban())));
            BranchAndFinancialInstitutionIdentificationSEPA1 recipientBic = new BranchAndFinancialInstitutionIdentificationSEPA1(new FinancialInstitutionIdentificationSEPA1(new BICIdentifier(paymentData.getRecipientBic())));
            CreditTransferTransactionInformationSCT transaction = new CreditTransferTransactionInformationSCT(pmtId, amount, recipientBic, recipient, recipientIban);
            String ultimateOriginator = paymentData.getUltimateOriginator();
            if (ultimateOriginator != null && ultimateOriginator.length() > 0) {
                PartyIdentificationSEPA1 ultimateOrig = new PartyIdentificationSEPA1();
                ultimateOrig.setNm(new Max70Text(ultimateOriginator));
                transaction.setUltmtDbtr(ultimateOrig);
            }
            if ((ultimateRecipient = paymentData.getUltimateRecipient()) != null && ultimateRecipient.length() > 0) {
                PartyIdentificationSEPA1 ultimateRecip = new PartyIdentificationSEPA1();
                ultimateRecip.setNm(new Max70Text(ultimateRecipient));
                transaction.setUltmtCdtr(ultimateRecip);
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new PurposeSEPA(new ExternalPurpose1Code(purposeCode.trim())));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                RemittanceInformationSEPA1Choice rmtInf = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromUstrd(new Max140Text(purpose)));
                transaction.setRmtInf(rmtInf);
            }
            transactions.add(transaction);
        }
        return transactions;
    }
}

