/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.sepa.CurrencyAndAmount;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.stuzza.pain00100102at02.AmountType2Choice;
import de.businesslogics.format.stuzza.pain00100102at02.CreditTransferTransactionInformation1;
import de.businesslogics.format.stuzza.pain00100102at02.Document;
import de.businesslogics.format.stuzza.pain00100102at02.FinancialInstitutionIdentification5Choice;
import de.businesslogics.format.stuzza.pain00100102at02.GroupHeader1;
import de.businesslogics.format.stuzza.pain00100102at02.Pain_001_001_02;
import de.businesslogics.format.stuzza.pain00100102at02.PaymentInstructionInformation1;
import de.businesslogics.format.stuzza.pain00100102at02.RB32_AccountIdentification3Choice;
import de.businesslogics.format.stuzza.pain00100102at02.RB32_RemittanceInformation1;
import de.businesslogics.util.Currency;
import java.util.ArrayList;
import java.util.List;

public class SEPAExtractorV2Stuzza {
    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        Pain_001_001_02 pain00100202 = document.getPain_001_001_02();
        GroupHeader1 grpHdr = pain00100202.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstructionInformation1 p : pain00100202.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            for (CreditTransferTransactionInformation1 c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV2Stuzza.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        return logicalFiles;
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        Pain_001_001_02 pain00100202 = document.getPain_001_001_02();
        GroupHeader1 grpHdr = pain00100202.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = null;
        if (grpHdr.getInitgPty().getNm() != null) {
            initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        }
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation1 p : pain00100202.getPmtInfs()) {
            for (CreditTransferTransactionInformation1 c : p.getCdtTrfTxInfs()) {
                SEPAPaymentData paymentData = SEPAExtractorV2Stuzza.getPaymentData(msgId, initParty, p, c);
                if (initParty == null) {
                    paymentData.setInitiatingParty(paymentData.getOriginator());
                }
                payments.add(paymentData);
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformation1 p, CreditTransferTransactionInformation1 t) {
        String origName = SimpleStringElement.getNonNullValue(p.getDbtr().getNm());
        String origAccNumber = SEPAExtractorV2Stuzza.getAccountIdentifier(p.getDbtrAcct().getId());
        String origBankCode = SEPAExtractorV2Stuzza.getBankIdentifier(p.getDbtrAgt().getFinInstnId().getChoice1());
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        String recip = "";
        if (t.getCdtr() != null) {
            recip = SimpleStringElement.getNonNullValue(t.getCdtr().getNm());
        }
        String recipAccNumber = SEPAExtractorV2Stuzza.getAccountIdentifier(t.getCdtrAcct().getId());
        String recipBankCode = SEPAExtractorV2Stuzza.getBankIdentifier(t.getCdtrAgt().getFinInstnId().getChoice1());
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        CurrencyAndAmount ccyAndAmt = SEPAExtractorV2Stuzza.getCurrencyAndAmount(t.getAmt().getChoice1());
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String purpose = SEPAExtractorV2Stuzza.getPurpose(t.getRmtInf());
        String paymentCategory = "";
        if (p.getPmtTpInf() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(p.getPmtTpInf().getCtgyPurp());
        } else if (t.getPmtTpInf() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(t.getPmtTpInf().getCtgyPurp());
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBankCode, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getCurrencyCode()), executionDate, purpose, paymentCategory, endToEndId, instructionId);
        if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getChoice1().getCd().getValue());
        }
        return paymentData;
    }

    protected static String getAccountIdentifier(RB32_AccountIdentification3Choice choice) {
        if (choice.getIBAN() != null) {
            return choice.getIBAN().getValue();
        }
        return null;
    }

    protected static String getBankIdentifier(FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1 choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        return null;
    }

    protected static CurrencyAndAmount getCurrencyAndAmount(AmountType2Choice.AmountType2Choice_C1 choice) {
        AmountType2Choice.AmountType2Choice_C1.AmountType2Choice_C1_L1 instAmt = choice.getInstdAmt();
        if (instAmt != null) {
            return new CurrencyAndAmount(Currency.getInstance(instAmt.getCcy().getValue()), instAmt.getValue());
        }
        return null;
    }

    protected static String getPurpose(RB32_RemittanceInformation1 rmtInf) {
        if (rmtInf != null) {
            StringBuffer sb = new StringBuffer();
            RB32_RemittanceInformation1.RB32_RemittanceInformation1_C1 c = rmtInf.getChoice1();
            if (c.getUstrd() != null) {
                sb.append(SimpleStringElement.getNonNullValue(c.getUstrd()));
            } else if (c.getStrd() != null) {
                sb.append(SimpleStringElement.getNonNullValue(c.getStrd().getCdtrRefInf().getCdtrRef()));
            }
            return sb.toString();
        }
        return "";
    }
}

