/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.pain00100102.AccountIdentification3Choice;
import de.businesslogics.format.iso20022.pain00100102.AmountType2Choice;
import de.businesslogics.format.iso20022.pain00100102.BICIdentifier;
import de.businesslogics.format.iso20022.pain00100102.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00100102.BranchAndFinancialInstitutionIdentification3;
import de.businesslogics.format.iso20022.pain00100102.CashAccount7;
import de.businesslogics.format.iso20022.pain00100102.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00100102.ClearingSystemMemberIdentification3Choice;
import de.businesslogics.format.iso20022.pain00100102.CreditTransferTransactionInformation1;
import de.businesslogics.format.iso20022.pain00100102.CurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00100102.CurrencyCode;
import de.businesslogics.format.iso20022.pain00100102.DecimalNumber;
import de.businesslogics.format.iso20022.pain00100102.Document;
import de.businesslogics.format.iso20022.pain00100102.ExternalPurposeCode;
import de.businesslogics.format.iso20022.pain00100102.FinancialInstitutionIdentification5Choice;
import de.businesslogics.format.iso20022.pain00100102.GroupHeader1;
import de.businesslogics.format.iso20022.pain00100102.Grouping1Code;
import de.businesslogics.format.iso20022.pain00100102.IBANIdentifier;
import de.businesslogics.format.iso20022.pain00100102.ISODate;
import de.businesslogics.format.iso20022.pain00100102.ISODateTime;
import de.businesslogics.format.iso20022.pain00100102.Max140Text;
import de.businesslogics.format.iso20022.pain00100102.Max15NumericText;
import de.businesslogics.format.iso20022.pain00100102.Max34Text;
import de.businesslogics.format.iso20022.pain00100102.Max35Text;
import de.businesslogics.format.iso20022.pain00100102.Max70Text;
import de.businesslogics.format.iso20022.pain00100102.Pain_001_001_02;
import de.businesslogics.format.iso20022.pain00100102.PartyIdentification8;
import de.businesslogics.format.iso20022.pain00100102.PaymentCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00100102.PaymentIdentification1;
import de.businesslogics.format.iso20022.pain00100102.PaymentInstructionInformation1;
import de.businesslogics.format.iso20022.pain00100102.PaymentMethod3Code;
import de.businesslogics.format.iso20022.pain00100102.PaymentTypeInformation1;
import de.businesslogics.format.iso20022.pain00100102.Purpose1Choice;
import de.businesslogics.format.iso20022.pain00100102.RemittanceInformation1;
import de.businesslogics.format.iso20022.pain00100102.ServiceLevel1Code;
import de.businesslogics.format.iso20022.pain00100102.ServiceLevel2Choice;
import de.businesslogics.format.iso20022.pain00100102.SimpleIdentificationInformation2;
import de.businesslogics.format.iso20022.pain00100102.StructuredRemittanceInformation6;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV2Iso {
    private static final String MIXD = "MIXD";

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        Pain_001_001_02 pain00100202 = document.getPain_001_001_02();
        GroupHeader1 grpHdr = pain00100202.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstructionInformation1 p : pain00100202.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            for (CreditTransferTransactionInformation1 c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV2Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        return logicalFiles;
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        Pain_001_001_02 pain00100202 = document.getPain_001_001_02();
        GroupHeader1 grpHdr = pain00100202.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation1 p : pain00100202.getPmtInfs()) {
            for (CreditTransferTransactionInformation1 c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV2Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformation1 p, CreditTransferTransactionInformation1 t) {
        String origName = SimpleStringElement.getNonNullValue(p.getDbtr().getNm());
        String origAccNumber = SEPAExtractorV2Iso.getAccountIdentifier(p.getDbtrAcct().getId().getChoice1());
        String origBankCode = SEPAExtractorV2Iso.getBankIdentifier(p.getDbtrAgt().getFinInstnId().getChoice1());
        Currency accountCurrency = null;
        CurrencyCode ccy = p.getDbtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        String recip = "";
        if (t.getCdtr() != null) {
            recip = SimpleStringElement.getNonNullValue(t.getCdtr().getNm());
        }
        String recipAccNumber = SEPAExtractorV2Iso.getAccountIdentifier(t.getCdtrAcct().getId().getChoice1());
        String recipBankCode = SEPAExtractorV2Iso.getBankIdentifier(t.getCdtrAgt().getFinInstnId().getChoice1());
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        CurrencyAndAmount ccyAndAmt = SEPAExtractorV2Iso.getCurrencyAndAmount(t.getAmt().getChoice1());
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String purpose = SEPAExtractorV2Iso.getPurpose(t.getRmtInf());
        String paymentCategory = "";
        if (p.getPmtTpInf() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(p.getPmtTpInf().getCtgyPurp());
        } else if (t.getPmtTpInf() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(t.getPmtTpInf().getCtgyPurp());
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBankCode, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()), executionDate, purpose, paymentCategory, endToEndId, instructionId);
        paymentData.setAccountCurrency(accountCurrency);
        if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getChoice1().getCd().getValue());
        }
        return paymentData;
    }

    protected static String getAccountIdentifier(AccountIdentification3Choice.AccountIdentification3Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return choice.getIBAN().getValue();
        }
        if (choice.getPrtryAcct() != null) {
            return choice.getPrtryAcct().getId().getValue();
        }
        if (choice.getBBAN() != null) {
            return choice.getBBAN().getValue();
        }
        if (choice.getUPIC() != null) {
            return choice.getUPIC().getValue();
        }
        return null;
    }

    protected static String getBankIdentifier(FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1 choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        if (choice.getPrtryId() != null) {
            return choice.getPrtryId().getId().getValue();
        }
        if (choice.getClrSysMmbId() != null) {
            ClearingSystemMemberIdentification3Choice.ClearingSystemMemberIdentification3Choice_C1 c = choice.getClrSysMmbId().getChoice1();
            if (c.getId() != null) {
                return c.getId().getValue();
            }
            if (c.getPrtry() != null) {
                return c.getPrtry().getValue();
            }
            return null;
        }
        if (choice.getCmbndId() != null) {
            if (choice.getCmbndId().getBIC() != null) {
                return choice.getCmbndId().getBIC().getValue();
            }
            return null;
        }
        if (choice.getNmAndAdr() != null) {
            return choice.getNmAndAdr().getNm().getValue();
        }
        return null;
    }

    protected static CurrencyAndAmount getCurrencyAndAmount(AmountType2Choice.AmountType2Choice_C1 choice) {
        if (choice.getInstdAmt() != null) {
            return choice.getInstdAmt();
        }
        if (choice.getEqvtAmt() != null) {
            return choice.getEqvtAmt().getAmt();
        }
        return null;
    }

    protected static String getPurpose(RemittanceInformation1 rmtInf) {
        if (rmtInf != null) {
            StringBuilder sb = new StringBuilder();
            if (rmtInf.getUstrds().size() > 0) {
                for (Max140Text text : rmtInf.getUstrds()) {
                    sb.append(SimpleStringElement.getNonNullValue(text));
                }
            } else if (rmtInf.getStrds().size() > 0) {
                for (StructuredRemittanceInformation6 s : rmtInf.getStrds()) {
                    if (s.getRfrdDocInf() == null) continue;
                    sb.append(SimpleStringElement.getNonNullValue(s.getRfrdDocInf().getRfrdDocNb()));
                }
            }
            return sb.toString();
        }
        return "";
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        boolean displayAsSingleBooking = false;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformation1> logicalFiles = new ArrayList<PaymentInstructionInformation1>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            if (paymentList != null && paymentList.size() > 0) {
                SEPAPaymentData first = paymentList.get(0);
                pmtInfId = first.getPmtInfId();
                displayAsSingleBooking = first.displayAsSingleBooking();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV2Iso.getLogicalFile(pmtInfId, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        Boolean btchBookg = displayAsSingleBooking ? Boolean.FALSE : null;
        GroupHeader1 grpHdr = SEPAExtractorV2Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum, btchBookg);
        return new Document(new Pain_001_001_02(grpHdr, logicalFiles));
    }

    private static GroupHeader1 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum, Boolean btchBookg) {
        GroupHeader1 grpHdr = new GroupHeader1(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), new Grouping1Code(MIXD), SEPAExtractorV2Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        if (btchBookg != null) {
            grpHdr.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return grpHdr;
    }

    private static PaymentInstructionInformation1 getLogicalFile(String logicalFileId, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        PaymentMethod3Code paymentMethod = new PaymentMethod3Code(GeneralSEPAExtractor.TRF);
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentification8 originator = SEPAExtractorV2Iso.getParty(firstPayment.getOriginator());
        BranchAndFinancialInstitutionIdentification3 originatorBic = SEPAExtractorV2Iso.getBankId(firstPayment.getOriginatorBic());
        CashAccount7 originatorIban = SEPAExtractorV2Iso.getAccountId(firstPayment.getOriginatorIban());
        if (firstPayment.getAccountCurrency() != null) {
            originatorIban.setCcy(new CurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstructionInformation1 logicalFile = new PaymentInstructionInformation1(paymentMethod, executionDate, originator, originatorIban, originatorBic, SEPAExtractorV2Iso.getTransactions(logicalFileId, paymentList));
        logicalFile.setPmtInfId(new Max35Text(logicalFileId));
        String categoryPurpose = firstPayment.getPaymentCategory();
        PaymentTypeInformation1 paymentType = new PaymentTypeInformation1();
        ServiceLevel1Code cd = new ServiceLevel1Code(firstPayment.getServiceLevel());
        ServiceLevel2Choice svcLvl = new ServiceLevel2Choice(ServiceLevel2Choice.ServiceLevel2Choice_C1.fromCd(cd));
        paymentType.setChoice1(PaymentTypeInformation1.PaymentTypeInformation1_C1.fromSvcLvl(svcLvl));
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            paymentType.setCtgyPurp(new PaymentCategoryPurpose1Code(categoryPurpose));
        }
        logicalFile.setPmtTpInf(paymentType);
        logicalFile.setChrgBr(new ChargeBearerType1Code("SLEV"));
        return logicalFile;
    }

    private static List<CreditTransferTransactionInformation1> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransactionInformation1> transactions = new ArrayList<CreditTransferTransactionInformation1>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String purposeCode;
            String ultimateCreditor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            PartyIdentification8 recipient = SEPAExtractorV2Iso.getParty(paymentData.getRecipient());
            BranchAndFinancialInstitutionIdentification3 recipientBic = SEPAExtractorV2Iso.getBankId(paymentData.getRecipientBic());
            CashAccount7 recipientIban = SEPAExtractorV2Iso.getAccountId(paymentData.getRecipientIban());
            CreditTransferTransactionInformation1 transaction = new CreditTransferTransactionInformation1(pmtId, SEPAExtractorV2Iso.getInstdAmount(paymentData.getAmount(), paymentData.getCurrency()));
            transaction.setCdtr(recipient);
            transaction.setCdtrAcct(recipientIban);
            transaction.setCdtrAgt(recipientBic);
            String ultimateDebitor = paymentData.getUltimateOriginator();
            if (ultimateDebitor != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPAExtractorV2Iso.getParty(ultimateDebitor));
            }
            if ((ultimateCreditor = paymentData.getUltimateRecipient()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPAExtractorV2Iso.getParty(ultimateCreditor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose1Choice(Purpose1Choice.Purpose1Choice_C1.fromCd(new ExternalPurposeCode(purposeCode.trim()))));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                RemittanceInformation1 remittanceInfo = new RemittanceInformation1();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
                transaction.setRmtInf(remittanceInfo);
            }
            transactions.add(transaction);
        }
        return transactions;
    }

    private static PartyIdentification8 getParty(String name) {
        PartyIdentification8 party = new PartyIdentification8();
        party.setNm(new Max70Text(name));
        return party;
    }

    private static BranchAndFinancialInstitutionIdentification3 getBankId(String bic) {
        FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1 c1 = FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1.fromBIC(new BICIdentifier(bic));
        return new BranchAndFinancialInstitutionIdentification3(new FinancialInstitutionIdentification5Choice(c1));
    }

    private static CashAccount7 getAccountId(String iban) {
        AccountIdentification3Choice.AccountIdentification3Choice_C1 c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification3Choice.AccountIdentification3Choice_C1.fromIBAN(new IBANIdentifier(iban)) : AccountIdentification3Choice.AccountIdentification3Choice_C1.fromPrtryAcct(new SimpleIdentificationInformation2(new Max34Text(iban)));
        return new CashAccount7(new AccountIdentification3Choice(c1));
    }

    private static AmountType2Choice getInstdAmount(BigDecimal amt, Currency c) {
        CurrencyCode currency = new CurrencyCode(c.getCurrencyCode());
        CurrencyAndAmount ccyAndAmt = new CurrencyAndAmount(amt, currency);
        AmountType2Choice.AmountType2Choice_C1 c1 = AmountType2Choice.AmountType2Choice_C1.fromInstdAmt(ccyAndAmt);
        return new AmountType2Choice(c1);
    }
}

