/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.pain00100202.AccountIdentificationSCT;
import de.businesslogics.format.sepa.pain00100202.AmountTypeSCT;
import de.businesslogics.format.sepa.pain00100202.BICIdentifier;
import de.businesslogics.format.sepa.pain00100202.BatchBookingIndicator;
import de.businesslogics.format.sepa.pain00100202.BranchAndFinancialInstitutionIdentificationSCT;
import de.businesslogics.format.sepa.pain00100202.CashAccountSCT1;
import de.businesslogics.format.sepa.pain00100202.CashAccountSCT2;
import de.businesslogics.format.sepa.pain00100202.ChargeBearerTypeSCTCode;
import de.businesslogics.format.sepa.pain00100202.CreditTransferTransactionInformationSCT;
import de.businesslogics.format.sepa.pain00100202.CurrencyAndAmountSCT;
import de.businesslogics.format.sepa.pain00100202.DecimalNumber;
import de.businesslogics.format.sepa.pain00100202.Document;
import de.businesslogics.format.sepa.pain00100202.FinancialInstitutionIdentificationSCT;
import de.businesslogics.format.sepa.pain00100202.GroupHeaderSCT;
import de.businesslogics.format.sepa.pain00100202.Grouping1CodeSCT;
import de.businesslogics.format.sepa.pain00100202.IBANIdentifier;
import de.businesslogics.format.sepa.pain00100202.ISODate;
import de.businesslogics.format.sepa.pain00100202.ISODateTime;
import de.businesslogics.format.sepa.pain00100202.Max140Text;
import de.businesslogics.format.sepa.pain00100202.Max15NumericText;
import de.businesslogics.format.sepa.pain00100202.Max70Text;
import de.businesslogics.format.sepa.pain00100202.Pain_001_001_02;
import de.businesslogics.format.sepa.pain00100202.PartyIdentificationSCT1;
import de.businesslogics.format.sepa.pain00100202.PartyIdentificationSCT2;
import de.businesslogics.format.sepa.pain00100202.PaymentCategoryPurpose1Code;
import de.businesslogics.format.sepa.pain00100202.PaymentIdentification1;
import de.businesslogics.format.sepa.pain00100202.PaymentInstructionInformationSCT;
import de.businesslogics.format.sepa.pain00100202.PaymentMethodSCTCode;
import de.businesslogics.format.sepa.pain00100202.PaymentTypeInformationSCT1;
import de.businesslogics.format.sepa.pain00100202.RemittanceInformationSCTChoice;
import de.businesslogics.format.sepa.pain00100202.RestrictedIdentification1;
import de.businesslogics.format.sepa.pain00100202.RestrictedIdentification2;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractorV2 {
    private static final String MIXD = "MIXD";
    private static final Currency EUR = Currency.getInstance("EUR");

    public static XMLDate getDateSRZ(Document document) {
        return document.getPain_001_001_02().getPmtInfs().get(0).getReqdExctnDt();
    }

    public static List<SEPAPaymentData> getPaymentsFromCCT(InputStream is) throws IOException, SAXException {
        Document document = SEPAExtractorV2.getCCTDocument(is);
        return SEPAExtractorV2.getPaymentsFromCCT(document);
    }

    protected static List<SEPALogicalFile> getLogicalFilesFromCCT(Document document) {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        Pain_001_001_02 pain00100202 = document.getPain_001_001_02();
        String msgId = pain00100202.getGrpHdr().getMsgId().getValue();
        String initParty = pain00100202.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSCT p : pain00100202.getPmtInfs()) {
            String pmtInfId = p.getPmtInfId() != null ? p.getPmtInfId().getValue() : null;
            SEPALogicalFile logicalFile = new SEPALogicalFile(pmtInfId, msgId);
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractorV2.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V24);
        }
        return logicalFiles;
    }

    public static Document getCCTDocument(InputStream is) throws IOException, SAXException {
        return (Document)EbicsHandler.parse(is, new Document.Parser(null));
    }

    protected static List<SEPAPaymentData> getPaymentsFromCCT(Document document) {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        Pain_001_001_02 pain00100202 = document.getPain_001_001_02();
        String msgId = pain00100202.getGrpHdr().getMsgId().getValue();
        String initParty = pain00100202.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSCT p : pain00100202.getPmtInfs()) {
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorV2.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    public static SEPAPaymentData getPaymentFromCCT(Document document) throws Exception {
        List<SEPAPaymentData> payments = SEPAExtractorV2.getPaymentsFromCCT(document);
        if (payments != null && payments.size() == 1) {
            return payments.get(0);
        }
        throw new Exception("Payment file contains more than 1 payment");
    }

    private static SEPAPaymentData getPaymentDataFromCCT(String msgId, String initParty, PaymentInstructionInformationSCT p, CreditTransferTransactionInformationSCT c) {
        String orig = p.getDbtr().getNm().getValue();
        String origIban = p.getDbtrAcct().getId().getIBAN().getValue();
        String origBic = p.getDbtrAgt().getFinInstnId().getBIC().getValue();
        String ultimateOrig = null;
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(p.getUltmtDbtr().getNm());
        } else if (c.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(c.getUltmtDbtr().getNm());
        }
        String recip = c.getCdtr().getNm().getValue();
        String recipIban = c.getCdtrAcct().getId().getIBAN().getValue();
        String recipBic = c.getCdtrAgt().getFinInstnId().getBIC().getValue();
        String ultimateRecip = null;
        if (c.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getValue(c.getUltmtCdtr().getNm());
        }
        BigDecimal amount = c.getAmt().getInstdAmt().getValue();
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String purpose = c.getRmtInf() != null && c.getRmtInf().getUstrd() != null ? c.getRmtInf().getUstrd().getValue() : "";
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getValue();
        } else if (c.getPmtTpInf() != null && c.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = c.getPmtTpInf().getCtgyPurp().getValue();
        }
        String endToEndId = c.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = c.getPmtId().getInstrId() != null ? c.getPmtId().getInstrId().getValue() : "";
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, purpose, paymentCategory, endToEndId, instructionId);
    }

    public static Document getCreditDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        ArrayList<PaymentInstructionInformationSCT> logicalFiles = new ArrayList<PaymentInstructionInformationSCT>(1);
        logicalFiles.add(SEPAExtractorV2.getLogicalFile("TempMessageId", paymentList));
        GroupHeaderSCT grpHdr = SEPAExtractorV2.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount(), null);
        return new Document(new Pain_001_001_02(grpHdr, logicalFiles));
    }

    public static Document getCreditDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        boolean displayAsSingleBooking = false;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSCT> logicalFiles = new ArrayList<PaymentInstructionInformationSCT>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            if (paymentList != null && paymentList.size() > 0) {
                SEPAPaymentData first = paymentList.get(0);
                pmtInfId = first.getPmtInfId();
                displayAsSingleBooking = first.displayAsSingleBooking();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPAExtractorV2.getLogicalFile(pmtInfId, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        Boolean btchBookg = displayAsSingleBooking ? Boolean.FALSE : null;
        GroupHeaderSCT grpHdr = SEPAExtractorV2.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum, btchBookg);
        return new Document(new Pain_001_001_02(grpHdr, logicalFiles));
    }

    private static GroupHeaderSCT getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum, Boolean btchBookg) {
        PartyIdentificationSCT1 initParty = new PartyIdentificationSCT1();
        if (initiatingParty != null && !initiatingParty.isEmpty()) {
            initParty.setNm(new Max70Text(initiatingParty));
        }
        GroupHeaderSCT grpHdr = new GroupHeaderSCT(new RestrictedIdentification1(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), new Grouping1CodeSCT(MIXD), initParty);
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        if (btchBookg != null) {
            grpHdr.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return grpHdr;
    }

    private static PaymentInstructionInformationSCT getLogicalFile(String logicalFileId, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        PaymentMethodSCTCode paymentMethod = new PaymentMethodSCTCode(GeneralSEPAExtractor.TRF);
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSCT2 originator = new PartyIdentificationSCT2(new Max70Text(firstPayment.getOriginator()));
        BranchAndFinancialInstitutionIdentificationSCT originatorBic = new BranchAndFinancialInstitutionIdentificationSCT(new FinancialInstitutionIdentificationSCT(new BICIdentifier(firstPayment.getOriginatorBic())));
        CashAccountSCT1 originatorIban = new CashAccountSCT1(new AccountIdentificationSCT(new IBANIdentifier(firstPayment.getOriginatorIban())));
        PaymentInstructionInformationSCT logicalFile = new PaymentInstructionInformationSCT(paymentMethod, executionDate, originator, originatorIban, originatorBic, SEPAExtractorV2.getTransactions(logicalFileId, paymentList));
        logicalFile.setPmtInfId(new RestrictedIdentification2(logicalFileId));
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            logicalFile.setPmtTpInf(new PaymentTypeInformationSCT1(new PaymentCategoryPurpose1Code(categoryPurpose)));
        } else {
            logicalFile.setPmtTpInf(new PaymentTypeInformationSCT1());
        }
        logicalFile.setChrgBr(new ChargeBearerTypeSCTCode());
        return logicalFile;
    }

    private static List<CreditTransferTransactionInformationSCT> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<CreditTransferTransactionInformationSCT> transactions = new ArrayList<CreditTransferTransactionInformationSCT>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String ultimateCreditor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new RestrictedIdentification2((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new RestrictedIdentification1(instructionId));
            }
            AmountTypeSCT amount = new AmountTypeSCT(new CurrencyAndAmountSCT(paymentData.getAmount(), EUR));
            PartyIdentificationSCT2 recipient = new PartyIdentificationSCT2(new Max70Text(paymentData.getRecipient()));
            BranchAndFinancialInstitutionIdentificationSCT recipientBic = new BranchAndFinancialInstitutionIdentificationSCT(new FinancialInstitutionIdentificationSCT(new BICIdentifier(paymentData.getRecipientBic())));
            CashAccountSCT2 recipientIban = new CashAccountSCT2(new AccountIdentificationSCT(new IBANIdentifier(paymentData.getRecipientIban())));
            CreditTransferTransactionInformationSCT transaction = new CreditTransferTransactionInformationSCT(pmtId, amount, recipientBic, recipient, recipientIban);
            String ultimateDebitor = paymentData.getUltimateOriginator();
            if (ultimateDebitor != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(new PartyIdentificationSCT1(new Max70Text(ultimateDebitor)));
            }
            if ((ultimateCreditor = paymentData.getUltimateRecipient()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(new PartyIdentificationSCT1(new Max70Text(ultimateCreditor)));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                transaction.setRmtInf(new RemittanceInformationSCTChoice(new Max140Text(purpose)));
            }
            transactions.add(transaction);
        }
        return transactions;
    }

    public static List<PaymentInstructionInformationSCT> getPaymentFiles(InputStream in) throws SAXException, IOException {
        Document document = SEPAExtractorV2.getCCTDocument(in);
        Pain_001_001_02 pain = document.getPain_001_001_02();
        return pain.getPmtInfs();
    }

    public static Pain_001_001_02 createLogicalFile(List<Pain_001_001_02> payments) {
        PartyIdentificationSCT1 initgPty = null;
        PaymentInstructionInformationSCT logicalFile = null;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countMergedPayments = payments.size();
        for (int i = 0; i < countMergedPayments; ++i) {
            Pain_001_001_02 payment = payments.get(i);
            PaymentInstructionInformationSCT p = payment.getPmtInfs().get(0);
            if (i == 0) {
                initgPty = payment.getGrpHdr().getInitgPty();
                logicalFile = new PaymentInstructionInformationSCT(new PaymentMethodSCTCode(GeneralSEPAExtractor.TRF), p.getReqdExctnDt(), p.getDbtr(), p.getDbtrAcct(), p.getDbtrAgt(), new ArrayList<CreditTransferTransactionInformationSCT>());
                logicalFile.setPmtTpInf(p.getPmtTpInf());
                if (p.getChrgBr() != null) {
                    logicalFile.setChrgBr(p.getChrgBr());
                }
            }
            CreditTransferTransactionInformationSCT t = p.getCdtTrfTxInfs().get(0);
            logicalFile.getCdtTrfTxInfs().add(t);
            ctrlSum = ctrlSum.add(t.getAmt().getInstdAmt().getValue());
        }
        GroupHeaderSCT grpHdr = new GroupHeaderSCT(new RestrictedIdentification1("TempMessageId"), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(countMergedPayments)), new Grouping1CodeSCT(MIXD), initgPty);
        grpHdr.setCtrlSum(new DecimalNumber(ctrlSum));
        ArrayList<PaymentInstructionInformationSCT> pList = new ArrayList<PaymentInstructionInformationSCT>();
        pList.add(logicalFile);
        return new Pain_001_001_02(grpHdr, pList);
    }

    public static Document createDocument(List<Pain_001_001_02> logicalFiles, String msgId, String pmtInfIdPrefix) {
        ArrayList<PaymentInstructionInformationSCT> pmtInfs = new ArrayList<PaymentInstructionInformationSCT>();
        PartyIdentificationSCT1 initiatingParty = null;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countTransactions = 0;
        int i = 1;
        for (Pain_001_001_02 logicalFile : logicalFiles) {
            if (initiatingParty == null) {
                initiatingParty = logicalFile.getGrpHdr().getInitgPty();
            }
            ctrlSum = ctrlSum.add(logicalFile.getGrpHdr().getCtrlSum().getValue());
            countTransactions += Integer.parseInt(logicalFile.getGrpHdr().getNbOfTxs().getValue());
            PaymentInstructionInformationSCT pmtInf = logicalFile.getPmtInfs().get(0);
            pmtInf.setPmtInfId(new RestrictedIdentification2(pmtInfIdPrefix + i++));
            pmtInfs.add(pmtInf);
        }
        GroupHeaderSCT grpHdr = new GroupHeaderSCT(new RestrictedIdentification1(msgId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(countTransactions)), new Grouping1CodeSCT(MIXD), initiatingParty);
        grpHdr.setCtrlSum(new DecimalNumber(ctrlSum));
        return new Document(new Pain_001_001_02(grpHdr, pmtInfs));
    }
}

