/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.dk33.pain00100103.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.dk33.pain00100103.CashAccountSEPA1;
import de.businesslogics.format.dk33.pain00100103.CategoryPurposeSEPA;
import de.businesslogics.format.dk33.pain00100103.CountryCode;
import de.businesslogics.format.dk33.pain00100103.CreditTransferTransactionInformationSCT;
import de.businesslogics.format.dk33.pain00100103.CreditorReferenceInformationSEPA1;
import de.businesslogics.format.dk33.pain00100103.CustomerCreditTransferInitiationV03;
import de.businesslogics.format.dk33.pain00100103.Document;
import de.businesslogics.format.dk33.pain00100103.FinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.dk33.pain00100103.GroupHeaderSCT;
import de.businesslogics.format.dk33.pain00100103.LocalInstrumentSEPA;
import de.businesslogics.format.dk33.pain00100103.Max140Text;
import de.businesslogics.format.dk33.pain00100103.Max70Text;
import de.businesslogics.format.dk33.pain00100103.PartyIdentificationSEPA2;
import de.businesslogics.format.dk33.pain00100103.PaymentIdentificationSEPA;
import de.businesslogics.format.dk33.pain00100103.PaymentInstructionInformationSCT;
import de.businesslogics.format.dk33.pain00100103.PaymentTypeInformationSCT1;
import de.businesslogics.format.dk33.pain00100103.PaymentTypeInformationSCT2;
import de.businesslogics.format.dk33.pain00100103.PostalAddressSEPA;
import de.businesslogics.format.dk33.pain00100103.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.util.Currency;
import java.util.ArrayList;
import java.util.List;

public class SEPAExtractorDk33 {
    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerCreditTransferInitiationV03 ccti = document.getCstmrCdtTrfInitn();
        GroupHeaderSCT grpHdr = ccti.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformationSCT p : ccti.getPmtInfs()) {
            for (CreditTransferTransactionInformationSCT c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractorDk33.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformationSCT p, CreditTransferTransactionInformationSCT t) {
        PaymentIdentificationSEPA pmtId;
        String endToEndId;
        PartyIdentificationSEPA2 debtor = p.getDbtr();
        String origName = SimpleStringElement.getNonNullValue(debtor.getNm());
        CashAccountSEPA1 originatorAccount = p.getDbtrAcct();
        String origAccNumber = originatorAccount.getId().getIBAN().getValue();
        String origBankCode = SEPAExtractorDk33.getBankIdentifier(p.getDbtrAgt().getFinInstnId().getChoice1());
        String ultimateOrig = "";
        if (p.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtDbtr().getNm());
        } else if (t.getUltmtDbtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        PartyIdentificationSEPA2 creditor = t.getCdtr();
        String recipName = SimpleStringElement.getNonNullValue(creditor.getNm());
        String recipAccNumber = t.getCdtrAcct().getId().getIBAN().getValue();
        String recipBIC = null;
        if (t.getCdtrAgt() != null) {
            recipBIC = t.getCdtrAgt().getFinInstnId().getBIC().getValue();
        }
        String ultimateRecip = "";
        if (t.getUltmtCdtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmountSEPA ccyAndAmt = t.getAmt().getInstdAmt();
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        PaymentTypeInformationSCT1 pmtTpInfLF = p.getPmtTpInf();
        PaymentTypeInformationSCT2 pmtTpInfTX = t.getPmtTpInf();
        String paymentCategory = null;
        String serviceLevel = null;
        if (pmtTpInfLF != null) {
            paymentCategory = SEPAExtractorDk33.getPaymentCategory(pmtTpInfLF.getCtgyPurp());
            serviceLevel = pmtTpInfLF.getSvcLvl().getCd().getValue();
        }
        if (pmtTpInfTX != null) {
            if (paymentCategory == null) {
                paymentCategory = SEPAExtractorDk33.getPaymentCategory(pmtTpInfTX.getCtgyPurp());
            }
            if (serviceLevel == null) {
                serviceLevel = pmtTpInfTX.getSvcLvl().getCd().getValue();
            }
        }
        if ("NOTPROVIDED".equals(endToEndId = (pmtId = t.getPmtId()).getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(pmtId.getInstrId());
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recipName, recipAccNumber, recipBIC, ultimateRecip, ccyAndAmt.getValue(), Currency.getInstance(ccyAndAmt.getCcy().getValue()), executionDate, null, paymentCategory, endToEndId, instructionId, serviceLevel);
        paymentData.setAccountCurrency(originatorAccount.getCcy() != null ? Currency.getInstance(originatorAccount.getCcy().getValue()) : null);
        if (debtor.getPstlAdr() != null) {
            paymentData.setOriginatorAddressData(SEPAExtractorDk33.getAddressData(debtor.getPstlAdr()));
        }
        if (creditor.getPstlAdr() != null) {
            paymentData.setRecipientAddressData(SEPAExtractorDk33.getAddressData(creditor.getPstlAdr()));
        }
        paymentData.setPaymentMethod(p.getPmtMtd().getValue());
        String localInstrument = null;
        String instructionPriority = null;
        if (pmtTpInfLF != null) {
            localInstrument = SEPAExtractorDk33.getLocalInstrument(pmtTpInfLF.getLclInstrm());
            instructionPriority = SimpleStringElement.getNonNullValue(pmtTpInfLF.getInstrPrty());
        }
        if (pmtTpInfTX != null && localInstrument == null) {
            localInstrument = SEPAExtractorDk33.getLocalInstrument(pmtTpInfTX.getLclInstrm());
        }
        paymentData.setLocalInstrument(localInstrument);
        paymentData.setInstructionPriority(instructionPriority);
        if (t.getPurp() != null) {
            paymentData.setPurposeCode(t.getPurp().getCd().getValue());
        }
        if (p.getChrgBr() != null) {
            paymentData.setChargeBearer(p.getChrgBr().getValue());
        } else if (t.getChrgBr() != null) {
            paymentData.setChargeBearer(t.getChrgBr().getValue());
        } else {
            paymentData.setChargeBearer(null);
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        SEPAExtractorDk33.setPurposeInformation(t.getRmtInf(), paymentData);
        return paymentData;
    }

    private static String getBankIdentifier(FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1 choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        return null;
    }

    private static String getPaymentCategory(CategoryPurposeSEPA choice) {
        if (choice != null) {
            return choice.getCd().getValue();
        }
        return null;
    }

    private static AddressData getAddressData(PostalAddressSEPA address) {
        AddressData addressData = new AddressData();
        CountryCode countryCode = address.getCtry();
        if (countryCode != null) {
            addressData.setCountry(countryCode.getValue());
        }
        for (Max70Text line : address.getAdrLines()) {
            addressData.getAddressLines().add(line.getValue());
        }
        return addressData;
    }

    private static String getLocalInstrument(LocalInstrumentSEPA choice) {
        if (choice != null) {
            return choice.getCd().getValue();
        }
        return null;
    }

    private static void setPurposeInformation(RemittanceInformationSEPA1Choice rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            CreditorReferenceInformationSEPA1 cdtrRefInf;
            Max140Text unstructuredLine = rmtInf.getChoice1().getUstrd();
            if (unstructuredLine != null) {
                paymentData.setHasStructuredPurpose(false);
                paymentData.getUnstructuredPurposeLines().add(unstructuredLine.getValue());
                paymentData.setPurpose(unstructuredLine.getValue());
            } else if (rmtInf.getChoice1().getStrd() != null && (cdtrRefInf = rmtInf.getChoice1().getStrd().getCdtrRefInf()) != null) {
                paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                paymentData.setPurposeReferenceTypeCode(cdtrRefInf.getTp().getCdOrPrtry().getCd().getValue());
            }
        }
    }
}

