/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.AccountIdentification2;
import de.businesslogics.format.sepa.AmountType3;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.CreditTransferTransactionInformation2;
import de.businesslogics.format.sepa.CreditTransferTransactionInformation5;
import de.businesslogics.format.sepa.DirectDebitTransaction4;
import de.businesslogics.format.sepa.DirectDebitTransactionInformation2;
import de.businesslogics.format.sepa.DirectDebitTransactionInformation4;
import de.businesslogics.format.sepa.EuroMax9Amount;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.FinancialInstitutionIdentification4;
import de.businesslogics.format.sepa.GroupHeader20;
import de.businesslogics.format.sepa.MandateRelatedInformation4;
import de.businesslogics.format.sepa.Max140Text;
import de.businesslogics.format.sepa.Pain00100102;
import de.businesslogics.format.sepa.Pain00100102ConSepade;
import de.businesslogics.format.sepa.Pain00100102Document;
import de.businesslogics.format.sepa.Pain00100102Grp;
import de.businesslogics.format.sepa.Pain00100102GrpDocument;
import de.businesslogics.format.sepa.Pain00800101;
import de.businesslogics.format.sepa.Pain00800101ConSepade;
import de.businesslogics.format.sepa.Pain00800101Document;
import de.businesslogics.format.sepa.PartyIdentification11;
import de.businesslogics.format.sepa.PartyIdentification20;
import de.businesslogics.format.sepa.PartyIdentification21;
import de.businesslogics.format.sepa.PartyIdentification22;
import de.businesslogics.format.sepa.PartyIdentification23;
import de.businesslogics.format.sepa.PartyPrivate1;
import de.businesslogics.format.sepa.PaymentIdentification1_Ebics23;
import de.businesslogics.format.sepa.PaymentInstructionInformation3;
import de.businesslogics.format.sepa.PaymentInstructionInformation4;
import de.businesslogics.format.sepa.PaymentInstructionInformation5;
import de.businesslogics.format.sepa.PaymentTypeInformation8;
import de.businesslogics.format.sepa.PersonIdentification4;
import de.businesslogics.format.sepa.RemittanceInformation3;
import de.businesslogics.format.sepa.RestrictedIdentification2_Ebics23;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SequenceType1Code;
import de.businesslogics.format.sepa.pain00800101grp.Pain00800101Grp;
import de.businesslogics.format.sepa.pain00800101grp.Pain00800101GrpDocument;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPAExtractor {
    private static final String NOTPROVIDED = "NOTPROVIDED";

    public static XMLDate getDateSRZ(Pain00800101Document document) {
        return document.getPain00800101().getPmtInf().getReqdColltnDt();
    }

    public static XMLDate getDateSRZ(Pain00100102Document document) {
        return document.getPain00100102().getPmtInf().getReqdExctnDt();
    }

    public static List<SEPAPaymentData> getPaymentsFromCCM(InputStream is) throws IOException, SAXException {
        return SEPAExtractor.getPaymentsFromCCM(SEPAExtractor.getCCMDocument(is));
    }

    public static Pain00100102Document getCCMDocument(InputStream is) throws IOException, SAXException {
        return (Pain00100102Document)EbicsHandler.parse(is, new Pain00100102Document.Parser(null));
    }

    private static List<SEPAPaymentData> getPaymentsFromCCM(Pain00100102Document document) {
        Pain00100102 pain00100102 = document.getPain00100102();
        String msgId = pain00100102.getGrpHdr().getMsgId();
        String initParty = pain00100102.getGrpHdr().getInitgPty().getNm();
        PaymentInstructionInformation4 p = pain00100102.getPmtInf();
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (CreditTransferTransactionInformation2 c : p.getCdtTrfTxInfs()) {
            payments.add(SEPAExtractor.getPaymentDataFromCCM(msgId, initParty, p, c));
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentDataFromCCM(String msgId, String initParty, PaymentInstructionInformation4 p, CreditTransferTransactionInformation2 c) {
        String orig = p.getDbtr().getNm();
        String origIban = p.getDbtrAcct().getId().getIban();
        String origBic = p.getDbtrAgt().getFinInstnId().getBic();
        String recip = c.getCdtr().getNm();
        String recipIban = c.getCdtrAcct().getId().getIban();
        String recipBic = c.getCdtrAgt().getFinInstnId().getBic();
        BigDecimal amount = c.getAmt().getInstdAmt().getAmount();
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String purpose = null;
        purpose = c.getRmtInf() != null && c.getRmtInf().getUstrd() != null ? c.getRmtInf().getUstrd().getValue() : "";
        String endToEndId = c.getPmtId().getEndToEndId();
        if (NOTPROVIDED.equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = c.getPmtId().getInstrId();
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, null, recip, recipIban, recipBic, null, amount, executionDate, purpose, null, endToEndId, instructionId);
    }

    public static Pain00100102Document getCCMDocument(SEPAPaymentData paymentData) throws IOException, SAXException {
        String endToEndId = paymentData.getEndToEndId();
        PaymentIdentification1_Ebics23 pmtId = null;
        pmtId = endToEndId == null || endToEndId.length() == 0 ? new PaymentIdentification1_Ebics23(NOTPROVIDED) : new PaymentIdentification1_Ebics23(endToEndId);
        pmtId.setInstrId(paymentData.getInstructionId());
        AmountType3 amt = new AmountType3(new EuroMax9Amount(paymentData.getAmount()));
        FinancialInstitution2 cdtrAgt = new FinancialInstitution2(new FinancialInstitutionIdentification4(paymentData.getRecipientBic()));
        PartyIdentification21 cdtr = new PartyIdentification21(paymentData.getRecipient());
        CashAccount8 cdtrAcct = new CashAccount8(new AccountIdentification2(paymentData.getRecipientIban()));
        CreditTransferTransactionInformation2 cti = new CreditTransferTransactionInformation2(pmtId, amt, cdtrAgt, cdtr, cdtrAcct);
        String purpose = paymentData.getPurpose();
        if (purpose != null && purpose.length() > 0) {
            cti.setRmtInf(new RemittanceInformation3(new Max140Text(purpose)));
        }
        ArrayList<CreditTransferTransactionInformation2> cdtTrfTxInfs = new ArrayList<CreditTransferTransactionInformation2>(1);
        cdtTrfTxInfs.add(cti);
        XMLDate reqdExctnDt = new XMLDate(new YYMMDD(paymentData.getExecutionDate().getTime()));
        PartyIdentification23 dbtr = new PartyIdentification23(paymentData.getOriginator());
        CashAccount8 dbtrAcct = new CashAccount8(new AccountIdentification2(paymentData.getOriginatorIban()));
        FinancialInstitution2 dbtrAgt = new FinancialInstitution2(new FinancialInstitutionIdentification4(paymentData.getOriginatorBic()));
        PaymentInstructionInformation4 pmtInf = new PaymentInstructionInformation4(reqdExctnDt, dbtr, dbtrAcct, dbtrAgt, cdtTrfTxInfs);
        PartyIdentification20 initgPty = new PartyIdentification20(paymentData.getInitiatingParty());
        GroupHeader20 grpHdr = new GroupHeader20("TempMessageId", new Date(), 1L, initgPty);
        grpHdr.setCtrlSum(paymentData.getAmount());
        Pain00100102 pain00100102 = new Pain00100102(grpHdr, pmtInf);
        return new Pain00100102Document(pain00100102);
    }

    public static SEPAPaymentData getPaymentFromCCM(Pain00100102Document document) {
        Pain00100102 pain00100102 = document.getPain00100102();
        String msgId = pain00100102.getGrpHdr().getMsgId();
        String initParty = pain00100102.getGrpHdr().getInitgPty().getNm();
        PaymentInstructionInformation4 p = pain00100102.getPmtInf();
        CreditTransferTransactionInformation2 c = p.getCdtTrfTxInfs().get(0);
        return SEPAExtractor.getPaymentDataFromCCM(msgId, initParty, p, c);
    }

    public static List<SEPAPaymentData> getPaymentsFromCCC(InputStream is) throws IOException, SAXException {
        return SEPAExtractor.getPaymentsFromCCC(SEPAExtractor.getCCCDocument(is));
    }

    private static Pain00100102ConSepade getCCCDocument(InputStream is) throws IOException, SAXException {
        return (Pain00100102ConSepade)EbicsHandler.parse(is, new Pain00100102ConSepade.Parser(null));
    }

    private static List<SEPAPaymentData> getPaymentsFromCCC(Pain00100102ConSepade document) {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (Pain00100102ConSepade.Msg message : document.getMsg()) {
            payments.addAll(SEPAExtractor.getPaymentsFromCCM(message.getDocument()));
        }
        return payments;
    }

    public static List<SEPAPaymentData> getPaymentsFromCCT(InputStream is) throws IOException, SAXException {
        return SEPAExtractor.getPaymentsFromCCT(SEPAExtractor.getCCTDocument(is));
    }

    private static Pain00100102GrpDocument getCCTDocument(InputStream is) throws IOException, SAXException {
        return (Pain00100102GrpDocument)EbicsHandler.parse(is, new Pain00100102GrpDocument.Parser(null));
    }

    protected static List<SEPAPaymentData> getPaymentsFromCCT(Pain00100102GrpDocument document) {
        Pain00100102Grp pain00100102Grp = document.getPain00100102();
        String msgId = pain00100102Grp.getGrpHdr().getMsgId();
        String initParty = pain00100102Grp.getGrpHdr().getInitgPty().getNm();
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation3 p : pain00100102Grp.getPmtInf()) {
            for (CreditTransferTransactionInformation5 c : p.getCdtTrfTxInfs()) {
                payments.add(SEPAExtractor.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFilesFromCCT(Pain00100102GrpDocument document) {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        Pain00100102Grp pain00100102Grp = document.getPain00100102();
        String msgId = pain00100102Grp.getGrpHdr().getMsgId();
        String initParty = pain00100102Grp.getGrpHdr().getInitgPty().getNm();
        for (PaymentInstructionInformation3 p : pain00100102Grp.getPmtInf()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(p.getPmtInfId(), msgId);
            for (CreditTransferTransactionInformation5 c : p.getCdtTrfTxInfs()) {
                logicalFile.getTransactions().add(SEPAExtractor.getPaymentDataFromCCT(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        return logicalFiles;
    }

    private static SEPAPaymentData getPaymentDataFromCCT(String msgId, String initParty, PaymentInstructionInformation3 p, CreditTransferTransactionInformation5 c) {
        String orig = p.getDbtr().getNm();
        String origIban = p.getDbtrAcct().getId().getIban();
        String origBic = p.getDbtrAgt().getFinInstnId().getBic();
        String recip = c.getCdtr().getNm();
        String recipIban = c.getCdtrAcct().getId().getIban();
        String recipBic = c.getCdtrAgt().getFinInstnId().getBic();
        BigDecimal amount = c.getAmt().getInstdAmt().getAmount();
        YYMMDD executionDate = p.getReqdExctnDt().getDate();
        String purpose = null;
        purpose = c.getRmtInf() != null && c.getRmtInf().getUstrd() != null ? c.getRmtInf().getUstrd().getValue() : "";
        String endToEndId = c.getPmtId().getEndToEndId();
        if (NOTPROVIDED.equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = c.getPmtId().getInstrId();
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, null, recip, recipIban, recipBic, null, amount, executionDate, purpose, null, endToEndId, instructionId);
    }

    public static List<SEPAPaymentData> getPaymentsFromCDM(InputStream is) throws IOException, SAXException {
        return SEPAExtractor.getPaymentsFromCDM(SEPAExtractor.getCDMDocument(is));
    }

    public static Pain00800101Document getCDMDocument(InputStream is) throws IOException, SAXException {
        return (Pain00800101Document)EbicsHandler.parse(is, new Pain00800101Document.Parser(null));
    }

    private static List<SEPAPaymentData> getPaymentsFromCDM(Pain00800101Document document) {
        Pain00800101 pain00800101 = document.getPain00800101();
        String msgId = pain00800101.getGrpHdr().getMsgId();
        String initParty = pain00800101.getGrpHdr().getInitgPty().getNm();
        PaymentInstructionInformation5 p = pain00800101.getPmtInf();
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (DirectDebitTransactionInformation2 ddti : p.getDrctDbtTxInfs()) {
            payments.add(SEPAExtractor.getPaymentDataFromCDM(msgId, initParty, p, ddti));
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentDataFromCDM(String msgId, String initParty, PaymentInstructionInformation5 p, DirectDebitTransactionInformation2 ddti) {
        String orig = p.getCdtr().getNm();
        String origIban = p.getCdtrAcct().getId().getIban();
        String origBic = p.getCdtrAgt().getFinInstnId().getBic();
        String recip = ddti.getDbtr().getNm();
        String recipIban = ddti.getDbtrAcct().getId().getIban();
        String recipBic = ddti.getDbtrAgt().getFinInstnId().getBic();
        BigDecimal amount = ddti.getInstdAmt().getAmount();
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String purpose = null;
        purpose = ddti.getRmtInf() != null && ddti.getRmtInf().getUstrd() != null ? ddti.getRmtInf().getUstrd().getValue() : "";
        String endToEndId = ddti.getPmtId().getEndToEndId();
        if (NOTPROVIDED.equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = ddti.getPmtId().getInstrId();
        String sequenceType = p.getPmtTpInf().getSeqTp().getValue();
        String creditorId = ddti.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthrId().getId();
        String mandateId = ddti.getDrctDbtTx().getMndtRltdInf().getMndtId();
        YYMMDD mandateSignDate = ddti.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr().getDate();
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, null, recip, recipIban, recipBic, null, amount, executionDate, purpose, null, endToEndId, instructionId, null, sequenceType, creditorId, mandateId, mandateSignDate);
    }

    public static Pain00800101Document getCDMDocument(SEPAPaymentData paymentData) {
        String endToEndId = paymentData.getEndToEndId();
        PaymentIdentification1_Ebics23 pmtId = null;
        pmtId = endToEndId == null || endToEndId.length() == 0 ? new PaymentIdentification1_Ebics23(NOTPROVIDED) : new PaymentIdentification1_Ebics23(endToEndId);
        pmtId.setInstrId(paymentData.getInstructionId());
        EuroMax9Amount amt = new EuroMax9Amount(paymentData.getAmount());
        FinancialInstitution2 dbtrAgt = new FinancialInstitution2(new FinancialInstitutionIdentification4(paymentData.getRecipientBic()));
        PartyIdentification23 dbtr = new PartyIdentification23(paymentData.getRecipient());
        CashAccount8 dbtrAcct = new CashAccount8(new AccountIdentification2(paymentData.getRecipientIban()));
        MandateRelatedInformation4 mndtRltdInf = new MandateRelatedInformation4(paymentData.getMandateId(), new XMLDate(new YYMMDD(paymentData.getMandateSignDate().getTime())));
        RestrictedIdentification2_Ebics23 othrId = new RestrictedIdentification2_Ebics23(paymentData.getCreditorId());
        PersonIdentification4 pi = new PersonIdentification4(othrId);
        PartyPrivate1 prvtId = new PartyPrivate1(pi);
        PartyIdentification11 cdtrSchmeId = new PartyIdentification11(prvtId);
        DirectDebitTransaction4 drctDbtTx = new DirectDebitTransaction4(mndtRltdInf, cdtrSchmeId);
        DirectDebitTransactionInformation2 cti = new DirectDebitTransactionInformation2(pmtId, amt, drctDbtTx, dbtrAgt, dbtr, dbtrAcct);
        String purpose = paymentData.getPurpose();
        if (purpose != null && purpose.length() > 0) {
            cti.setRmtInf(new RemittanceInformation3(new Max140Text(purpose)));
        }
        ArrayList<DirectDebitTransactionInformation2> cdtTrfTxInfs = new ArrayList<DirectDebitTransactionInformation2>(1);
        cdtTrfTxInfs.add(cti);
        PaymentTypeInformation8 pmtTpInf = new PaymentTypeInformation8(SEPAExtractor.getSequenceType(paymentData.getSequenceType()));
        CashAccount8 cdtrAcct = new CashAccount8(new AccountIdentification2(paymentData.getOriginatorIban()));
        FinancialInstitution2 cdtrAgt = new FinancialInstitution2(new FinancialInstitutionIdentification4(paymentData.getOriginatorBic()));
        XMLDate reqdColltnDt = new XMLDate(new YYMMDD(paymentData.getExecutionDate().getTime()));
        PartyIdentification22 cdtr = new PartyIdentification22(paymentData.getOriginator());
        PaymentInstructionInformation5 pmtInf = new PaymentInstructionInformation5(pmtTpInf, reqdColltnDt, cdtr, cdtrAcct, cdtrAgt, cdtTrfTxInfs);
        PartyIdentification20 initgPty = new PartyIdentification20(paymentData.getInitiatingParty());
        GroupHeader20 grpHdr = new GroupHeader20("TempMessageId", new Date(), 1L, initgPty);
        grpHdr.setCtrlSum(paymentData.getAmount());
        Pain00800101 pain00800101 = new Pain00800101(grpHdr, pmtInf);
        return new Pain00800101Document(pain00800101);
    }

    private static SequenceType1Code getSequenceType(String sequenceType) {
        if ("FRST".equals(sequenceType)) {
            return SequenceType1Code.FRST;
        }
        if ("RCUR".equals(sequenceType)) {
            return SequenceType1Code.RCUR;
        }
        if ("FNAL".equals(sequenceType)) {
            return SequenceType1Code.FNAL;
        }
        return SequenceType1Code.OOFF;
    }

    public static SEPAPaymentData getPaymentFromCDM(Pain00800101Document document) {
        Pain00800101 pain00800101 = document.getPain00800101();
        String msgId = pain00800101.getGrpHdr().getMsgId();
        String initParty = pain00800101.getGrpHdr().getInitgPty().getNm();
        PaymentInstructionInformation5 p = pain00800101.getPmtInf();
        DirectDebitTransactionInformation2 ddti = p.getDrctDbtTxInfs().get(0);
        return SEPAExtractor.getPaymentDataFromCDM(msgId, initParty, p, ddti);
    }

    public static List<SEPAPaymentData> getPaymentsFromCDC(InputStream is) throws IOException, SAXException {
        return SEPAExtractor.getPaymentsFromCDC(SEPAExtractor.getCDCDocument(is));
    }

    private static Pain00800101ConSepade getCDCDocument(InputStream is) throws IOException, SAXException {
        return (Pain00800101ConSepade)EbicsHandler.parse(is, new Pain00800101ConSepade.Parser(null));
    }

    private static List<SEPAPaymentData> getPaymentsFromCDC(Pain00800101ConSepade document) {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (Pain00800101ConSepade.Msg message : document.getMsg()) {
            payments.addAll(SEPAExtractor.getPaymentsFromCDM(message.getDocument()));
        }
        return payments;
    }

    public static List<SEPAPaymentData> getPaymentsFromCDD(InputStream is) throws IOException, SAXException {
        return SEPAExtractor.getPaymentsFromCDD(SEPAExtractor.getCDDDocument(is));
    }

    private static Pain00800101GrpDocument getCDDDocument(InputStream is) throws IOException, SAXException {
        return (Pain00800101GrpDocument)EbicsHandler.parse(is, new Pain00800101GrpDocument.Parser(null));
    }

    private static List<SEPAPaymentData> getPaymentsFromCDD(Pain00800101GrpDocument document) {
        Pain00800101Grp pain00800101Grp = document.getPain00800101();
        String msgId = pain00800101Grp.getGrpHdr().getMsgId();
        String initParty = pain00800101Grp.getGrpHdr().getInitgPty().getNm();
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (de.businesslogics.format.sepa.pain00800101grp.PaymentInstructionInformation4 p : pain00800101Grp.getPmtInf()) {
            for (DirectDebitTransactionInformation4 c : p.getDrctDbtTxInfs()) {
                payments.add(SEPAExtractor.getPaymentDataFromCDD(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentDataFromCDD(String msgId, String initParty, de.businesslogics.format.sepa.pain00800101grp.PaymentInstructionInformation4 p, DirectDebitTransactionInformation4 ddti) {
        String orig = p.getCdtr().getNm();
        String origIban = p.getCdtrAcct().getId().getIban();
        String origBic = p.getCdtrAgt().getFinInstnId().getBic();
        String recip = ddti.getDbtr().getNm();
        String recipIban = ddti.getDbtrAcct().getId().getIban();
        String recipBic = ddti.getDbtrAgt().getFinInstnId().getBic();
        BigDecimal amount = ddti.getInstdAmt().getAmount();
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String purpose = null;
        purpose = ddti.getRmtInf() != null && ddti.getRmtInf().getUstrd() != null ? ddti.getRmtInf().getUstrd().getValue() : "";
        String endToEndId = ddti.getPmtId().getEndToEndId();
        if (NOTPROVIDED.equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = ddti.getPmtId().getInstrId();
        String sequenceType = p.getPmtTpInf().getSeqTp().getValue();
        String creditorId = ddti.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthrId().getId();
        String mandateId = ddti.getDrctDbtTx().getMndtRltdInf().getMndtId();
        YYMMDD mandateSignDate = ddti.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr().getDate();
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, null, recip, recipIban, recipBic, null, amount, executionDate, purpose, null, endToEndId, instructionId, null, sequenceType, creditorId, mandateId, mandateSignDate);
    }
}

