/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.iso20022.pain00800108.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00800108.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00800108.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.iso20022.pain00800108.AmendmentInformationDetails13;
import de.businesslogics.format.iso20022.pain00800108.BICFIDec2014Identifier;
import de.businesslogics.format.iso20022.pain00800108.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00800108.BranchAndFinancialInstitutionIdentification6;
import de.businesslogics.format.iso20022.pain00800108.CashAccount38;
import de.businesslogics.format.iso20022.pain00800108.CategoryPurpose1Choice;
import de.businesslogics.format.iso20022.pain00800108.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00800108.CountryCode;
import de.businesslogics.format.iso20022.pain00800108.CreditorReferenceInformation2;
import de.businesslogics.format.iso20022.pain00800108.CreditorReferenceType1Choice;
import de.businesslogics.format.iso20022.pain00800108.CreditorReferenceType2;
import de.businesslogics.format.iso20022.pain00800108.CustomerDirectDebitInitiationV08;
import de.businesslogics.format.iso20022.pain00800108.DecimalNumber;
import de.businesslogics.format.iso20022.pain00800108.DirectDebitTransaction10;
import de.businesslogics.format.iso20022.pain00800108.DirectDebitTransactionInformation23;
import de.businesslogics.format.iso20022.pain00800108.Document;
import de.businesslogics.format.iso20022.pain00800108.DocumentType3Code;
import de.businesslogics.format.iso20022.pain00800108.ExternalCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00800108.ExternalLocalInstrument1Code;
import de.businesslogics.format.iso20022.pain00800108.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.pain00800108.ExternalServiceLevel1Code;
import de.businesslogics.format.iso20022.pain00800108.FinancialInstitutionIdentification18;
import de.businesslogics.format.iso20022.pain00800108.GenericAccountIdentification1;
import de.businesslogics.format.iso20022.pain00800108.GenericFinancialIdentification1;
import de.businesslogics.format.iso20022.pain00800108.GenericPersonIdentification1;
import de.businesslogics.format.iso20022.pain00800108.GroupHeader83;
import de.businesslogics.format.iso20022.pain00800108.IBAN2007Identifier;
import de.businesslogics.format.iso20022.pain00800108.ISODate;
import de.businesslogics.format.iso20022.pain00800108.ISODateTime;
import de.businesslogics.format.iso20022.pain00800108.LEIIdentifier;
import de.businesslogics.format.iso20022.pain00800108.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00800108.MandateRelatedInformation14;
import de.businesslogics.format.iso20022.pain00800108.Max140Text;
import de.businesslogics.format.iso20022.pain00800108.Max15NumericText;
import de.businesslogics.format.iso20022.pain00800108.Max16Text;
import de.businesslogics.format.iso20022.pain00800108.Max34Text;
import de.businesslogics.format.iso20022.pain00800108.Max35Text;
import de.businesslogics.format.iso20022.pain00800108.Max70Text;
import de.businesslogics.format.iso20022.pain00800108.OrganisationIdentification29;
import de.businesslogics.format.iso20022.pain00800108.Party38Choice;
import de.businesslogics.format.iso20022.pain00800108.PartyIdentification135;
import de.businesslogics.format.iso20022.pain00800108.PaymentIdentification6;
import de.businesslogics.format.iso20022.pain00800108.PaymentInstruction29;
import de.businesslogics.format.iso20022.pain00800108.PaymentMethod2Code;
import de.businesslogics.format.iso20022.pain00800108.PaymentTypeInformation29;
import de.businesslogics.format.iso20022.pain00800108.PersonIdentification13;
import de.businesslogics.format.iso20022.pain00800108.PersonIdentificationSchemeName1Choice;
import de.businesslogics.format.iso20022.pain00800108.PostalAddress24;
import de.businesslogics.format.iso20022.pain00800108.Purpose2Choice;
import de.businesslogics.format.iso20022.pain00800108.RemittanceInformation16;
import de.businesslogics.format.iso20022.pain00800108.SequenceType3Code;
import de.businesslogics.format.iso20022.pain00800108.ServiceLevel8Choice;
import de.businesslogics.format.iso20022.pain00800108.StructuredRemittanceInformation16;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV8Iso {
    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        CustomerDirectDebitInitiationV08 cddi = document.getCstmrDrctDbtInitn();
        GroupHeader83 grpHdr = cddi.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstruction29 p : cddi.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            SEPADebitExtractorV8Iso.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (DirectDebitTransactionInformation23 c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV8Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.Iso00800108);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerDirectDebitInitiationV08 cddi = document.getCstmrDrctDbtInitn();
        GroupHeader83 grpHdr = cddi.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstruction29 p : cddi.getPmtInfs()) {
            for (DirectDebitTransactionInformation23 c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV8Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstruction29 p, DirectDebitTransactionInformation23 t) {
        AmendmentInformationDetails13 amendmentInfo;
        MandateRelatedInformation14 mandateInfo;
        PartyIdentification135 creditor = p.getCdtr();
        String orig = SimpleStringElement.getNonNullValue(creditor.getNm());
        String origAccNumber = null;
        boolean isOrigIban = true;
        AccountNumberInfo origAccNumberInfo = SEPADebitExtractorV8Iso.getAccountNumberInfo(p.getCdtrAcct().getId().getChoice1());
        if (origAccNumberInfo != null) {
            origAccNumber = origAccNumberInfo.getAccountNumber();
            isOrigIban = origAccNumberInfo.isFromIbanTag();
        }
        String origBankCode = SEPADebitExtractorV8Iso.getBankIdentifier(p.getCdtrAgt().getFinInstnId());
        Currency accountCurrency = SEPADebitExtractorV8Iso.getCurrency(p.getCdtrAcct().getCcy());
        String ultimateOrig = "";
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        PartyIdentification135 debtor = t.getDbtr();
        String recip = SimpleStringElement.getNonNullValue(debtor.getNm());
        String recipAccNumber = null;
        boolean isRecipIban = true;
        AccountNumberInfo recipAccNumberInfo = SEPADebitExtractorV8Iso.getAccountNumberInfo(t.getDbtrAcct().getId().getChoice1());
        if (recipAccNumberInfo != null) {
            recipAccNumber = recipAccNumberInfo.getAccountNumber();
            isRecipIban = recipAccNumberInfo.isFromIbanTag();
        }
        String recipBankCode = SEPADebitExtractorV8Iso.getBankIdentifier(t.getDbtrAgt().getFinInstnId());
        String ultimateRecip = "";
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmount ccyAndAmt = t.getInstdAmt();
        BigDecimal amount = ccyAndAmt.getValue();
        Currency currency = Currency.getInstance(ccyAndAmt.getCcy().getValue());
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String paymentCategory = "";
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(p.getPmtTpInf().getCtgyPurp().getChoice1().getCd());
        } else if (t.getPmtTpInf() != null && t.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(t.getPmtTpInf().getCtgyPurp().getChoice1().getCd());
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        String debitType = "";
        String sequenceType = "";
        PaymentTypeInformation29 pmtTpInf = t.getPmtTpInf();
        if (pmtTpInf == null) {
            pmtTpInf = p.getPmtTpInf();
        }
        if (pmtTpInf != null) {
            debitType = SEPADebitExtractorV8Iso.getDebitType(pmtTpInf);
            sequenceType = SimpleStringElement.getNonNullValue(pmtTpInf.getSeqTp());
        }
        String creditorId = null;
        creditorId = t.getDrctDbtTx() != null && t.getDrctDbtTx().getCdtrSchmeId() != null ? SEPADebitExtractorV8Iso.getCreditorId(t.getDrctDbtTx().getCdtrSchmeId()) : (p.getCdtrSchmeId() != null ? SEPADebitExtractorV8Iso.getCreditorId(p.getCdtrSchmeId()) : "");
        String mandateId = "";
        YYMMDD mandateSignDate = null;
        MandateRelatedInformation14 mandateRelatedInformation14 = mandateInfo = t.getDrctDbtTx() != null ? t.getDrctDbtTx().getMndtRltdInf() : null;
        if (mandateInfo != null) {
            mandateId = SimpleStringElement.getNonNullValue(mandateInfo.getMndtId());
            if (mandateInfo.getDtOfSgntr() != null) {
                mandateSignDate = mandateInfo.getDtOfSgntr().getDate();
            }
        }
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBankCode, ultimateRecip, amount, currency, executionDate, null, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        paymentData.setIsOriginatorIban(isOrigIban);
        paymentData.setIsRecipientIban(isRecipIban);
        paymentData.setOriginatorLei(SEPADebitExtractorV8Iso.getLegalEntityIdentifier(creditor.getId()));
        paymentData.setRecipientLei(SEPADebitExtractorV8Iso.getLegalEntityIdentifier(debtor.getId()));
        paymentData.setAccountCurrency(accountCurrency);
        if (mandateInfo != null && mandateInfo.getAmdmntInd() != null && mandateInfo.getAmdmntInd().booleanValue() && (amendmentInfo = mandateInfo.getAmdmntInfDtls()) != null) {
            if (amendmentInfo.getOrgnlCdtrSchmeId() != null) {
                PersonIdentification13 prvtId;
                if (amendmentInfo.getOrgnlCdtrSchmeId().getNm() != null) {
                    paymentData.setOriginalCreditor(amendmentInfo.getOrgnlCdtrSchmeId().getNm().getValue());
                }
                if (amendmentInfo.getOrgnlCdtrSchmeId().getId() != null && (prvtId = amendmentInfo.getOrgnlCdtrSchmeId().getId().getChoice1().getPrvtId()) != null && prvtId.getOthrs().size() > 0) {
                    prvtId.getOthrs().get(0).getId();
                    paymentData.setOriginalCreditorId(prvtId.getOthrs().get(0).getId().getValue());
                }
            }
            if (amendmentInfo.getOrgnlMndtId() != null) {
                paymentData.setOriginalMandateId(amendmentInfo.getOrgnlMndtId().getValue());
            }
            if (amendmentInfo.getOrgnlDbtrAcct() != null) {
                AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = amendmentInfo.getOrgnlDbtrAcct().getId().getChoice1();
                if (c1.getIBAN() != null) {
                    paymentData.setOriginalRecipientIban(c1.getIBAN().getValue());
                } else {
                    paymentData.setRecipientAccountHasChanged(true);
                }
            } else if (amendmentInfo.getOrgnlDbtrAgt() != null) {
                FinancialInstitutionIdentification18 financialInstitution = amendmentInfo.getOrgnlDbtrAgt().getFinInstnId();
                if (financialInstitution.getBICFI() != null) {
                    paymentData.setOriginalRecipientBic(financialInstitution.getBICFI().getValue());
                } else {
                    paymentData.setRecipientBankHasChanged(true);
                }
            }
        }
        SEPADebitExtractorV8Iso.setPurposeInformation(t.getRmtInf(), paymentData);
        if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getChoice1().getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        paymentData.setOriginatorAddressData(SEPADebitExtractorV8Iso.getAddress(creditor.getPstlAdr()));
        paymentData.setRecipientAddressData(SEPADebitExtractorV8Iso.getAddress(debtor.getPstlAdr()));
        return paymentData;
    }

    private static String getLegalEntityIdentifier(Party38Choice choice) {
        LEIIdentifier lei;
        OrganisationIdentification29 orgId;
        if (choice != null && (orgId = choice.getChoice1().getOrgId()) != null && (lei = orgId.getLEI()) != null) {
            return lei.getValue();
        }
        return null;
    }

    public static AccountNumberInfo getAccountNumberInfo(AccountIdentification4Choice.AccountIdentification4Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return new AccountNumberInfo(choice.getIBAN().getValue(), true);
        }
        if (choice.getOthr() != null) {
            return new AccountNumberInfo(choice.getOthr().getId().getValue(), false);
        }
        return null;
    }

    public static String getBankIdentifier(FinancialInstitutionIdentification18 choice) {
        if (choice.getBICFI() != null) {
            return choice.getBICFI().getValue();
        }
        if (choice.getOthr() != null) {
            String othrId = choice.getOthr().getId().getValue();
            if ("NOTPROVIDED".equals(othrId)) {
                return "";
            }
            return othrId;
        }
        return null;
    }

    public static XMLDate getDateSRZ(Document document) {
        PaymentInstruction29 pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return pmtInf.getReqdColltnDt();
    }

    public static GeneralSEPAWriter.DebitType getDebitType(Document document) {
        PaymentInstruction29 pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return GeneralSEPAWriter.DebitType.valueOf(SEPADebitExtractorV8Iso.getDebitType(pmtInf.getPmtTpInf()));
    }

    public static String getDebitType(PaymentTypeInformation29 pmtTpInf) {
        if (pmtTpInf != null && pmtTpInf.getLclInstrm() != null) {
            return SimpleStringElement.getNonNullValue(pmtTpInf.getLclInstrm().getChoice1().getCd());
        }
        return "";
    }

    private static Currency getCurrency(ActiveOrHistoricCurrencyCode ccy) {
        if (ccy != null) {
            return Currency.getInstance(ccy.getValue());
        }
        return null;
    }

    private static String getCreditorId(PartyIdentification135 cdtrSchmeId) {
        PersonIdentification13 prvtId;
        if (cdtrSchmeId != null && cdtrSchmeId.getId() != null && (prvtId = cdtrSchmeId.getId().getChoice1().getPrvtId()) != null && prvtId.getOthrs().size() > 0) {
            return SimpleStringElement.getNonNullValue(prvtId.getOthrs().get(0).getId());
        }
        return "";
    }

    private static void setPurposeInformation(RemittanceInformation16 rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            List<Max140Text> unstructuredLines = rmtInf.getUstrds();
            List<StructuredRemittanceInformation16> structuredInfoList = rmtInf.getStrds();
            if (unstructuredLines != null && unstructuredLines.size() > 0) {
                paymentData.setHasStructuredPurpose(false);
                StringBuilder sb = new StringBuilder();
                for (Max140Text purposeLine : unstructuredLines) {
                    String s = purposeLine.getValue();
                    paymentData.getUnstructuredPurposeLines().add(s);
                    sb.append(s);
                }
                paymentData.setPurpose(sb.toString());
            } else if (structuredInfoList != null && structuredInfoList.size() > 0) {
                CreditorReferenceInformation2 cdtrRefInf;
                paymentData.setHasStructuredPurpose(true);
                StructuredRemittanceInformation16 structuredInfo = structuredInfoList.get(0);
                List<Max140Text> purposeLines = structuredInfo.getAddtlRmtInfs();
                if (purposeLines.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (Max140Text purposeLine : purposeLines) {
                        String s = purposeLine.getValue();
                        paymentData.getStructuredPurposeLines().add(s);
                        sb.append(s);
                    }
                    paymentData.setPurpose(sb.toString());
                }
                if ((cdtrRefInf = structuredInfo.getCdtrRefInf()) != null) {
                    CreditorReferenceType2 tp;
                    if (cdtrRefInf.getRef() != null) {
                        paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                    }
                    if ((tp = cdtrRefInf.getTp()) != null) {
                        CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1 c = tp.getCdOrPrtry().getChoice1();
                        if (c.getCd() != null) {
                            paymentData.setPurposeReferenceTypeCode(c.getCd().getValue());
                        } else if (c.getPrtry() != null) {
                            paymentData.setPurposeReferenceTypePrtry(c.getPrtry().getValue());
                        }
                    }
                }
            }
        }
    }

    public static Document getDebitDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstruction29 logicalFile = SEPADebitExtractorV8Iso.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeader83 grpHdr = SEPADebitExtractorV8Iso.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerDirectDebitInitiationV08 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV08(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstruction29> logicalFiles = new ArrayList<PaymentInstruction29>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV8Iso.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeader83 grpHdr = SEPADebitExtractorV8Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        CustomerDirectDebitInitiationV08 cddi = new CustomerDirectDebitInitiationV08(grpHdr);
        cddi.getPmtInfs().addAll(logicalFiles);
        return new Document(cddi);
    }

    private static GroupHeader83 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        GroupHeader83 grpHdr = new GroupHeader83(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), SEPADebitExtractorV8Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstruction29 getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        PostalAddress24 pstlAdr;
        SEPAPaymentData firstPayment = paymentList.get(0);
        ISODate execDate = SEPADebitExtractorV8Iso.getDate(firstPayment.getExecutionDate());
        PartyIdentification135 cdtr = SEPADebitExtractorV8Iso.getParty(firstPayment.getOriginator(), firstPayment.getOriginatorLei());
        CashAccount38 cdtrAcct = SEPADebitExtractorV8Iso.getAccountId(firstPayment.getOriginatorIban());
        BranchAndFinancialInstitutionIdentification6 cdtrAgt = SEPADebitExtractorV8Iso.getBankId(firstPayment.getOriginatorBic());
        if (firstPayment.getAccountCurrency() != null) {
            cdtrAcct.setCcy(new ActiveOrHistoricCurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstruction29 logicalFile = new PaymentInstruction29(new Max35Text(logicalFileId), new PaymentMethod2Code("DD"), execDate, cdtr, cdtrAcct, cdtrAgt);
        logicalFile.getDrctDbtTxInfs().addAll(SEPADebitExtractorV8Iso.getTransactions(logicalFileId, paymentList));
        BigDecimal controlSum = BigDecimal.ZERO;
        for (SEPAPaymentData p : paymentList) {
            controlSum = controlSum.add(p.getAmount());
        }
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(paymentList.size())));
        logicalFile.setPmtTpInf(SEPADebitExtractorV8Iso.getPaymentTypeInfo(firstPayment.getDebitType(), firstPayment.getSequenceType(), firstPayment.getPaymentCategory()));
        String creditorId = firstPayment.getCreditorId();
        if (creditorId != null && creditorId.trim().length() > 0) {
            logicalFile.setCdtrSchmeId(SEPADebitExtractorV8Iso.getPartyFromId(creditorId.trim()));
        }
        logicalFile.setChrgBr(new ChargeBearerType1Code("SLEV"));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        if ((pstlAdr = SEPADebitExtractorV8Iso.saveAddress(firstPayment.getOriginatorAddressData())) != null) {
            cdtr.setPstlAdr(pstlAdr);
        }
        return logicalFile;
    }

    private static PaymentTypeInformation29 getPaymentTypeInfo(String debitType, String sequenceType, String paymentCategory) {
        PaymentTypeInformation29 pmtTpInf = new PaymentTypeInformation29();
        LocalInstrument2Choice choice = SEPADebitExtractorV8Iso.getDebitType(debitType);
        if (choice != null) {
            pmtTpInf.setLclInstrm(choice);
        }
        pmtTpInf.setSeqTp(SEPADebitExtractorV8Iso.getSequenceType(sequenceType));
        ServiceLevel8Choice svcLvl = new ServiceLevel8Choice(ServiceLevel8Choice.ServiceLevel8Choice_C1.fromCd(new ExternalServiceLevel1Code(GeneralSEPAExtractor.SEPA)));
        pmtTpInf.getSvcLvls().add(svcLvl);
        if (paymentCategory != null && paymentCategory.length() > 0) {
            ExternalCategoryPurpose1Code cd = new ExternalCategoryPurpose1Code(paymentCategory);
            CategoryPurpose1Choice.CategoryPurpose1Choice_C1 c1 = CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromCd(cd);
            pmtTpInf.setCtgyPurp(new CategoryPurpose1Choice(c1));
        }
        return pmtTpInf;
    }

    private static List<DirectDebitTransactionInformation23> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformation23> transactions = new ArrayList<DirectDebitTransactionInformation23>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purposeCode;
            String ultimateDebitor;
            String ultimateCreditor;
            DirectDebitTransaction10 mandateInfo;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification6 pmtId = new PaymentIdentification6(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.trim().length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPADebitExtractorV8Iso.getCurrencyAndAmount(paymentData.getAmount(), paymentData.getCurrency());
            PartyIdentification135 dbtr = SEPADebitExtractorV8Iso.getParty(paymentData.getRecipient(), paymentData.getRecipientLei());
            BranchAndFinancialInstitutionIdentification6 dbtrAgt = SEPADebitExtractorV8Iso.getBankId(paymentData.getRecipientBic());
            CashAccount38 dbtrAcct = SEPADebitExtractorV8Iso.getAccountId(paymentData.getRecipientIban());
            DirectDebitTransactionInformation23 transaction = new DirectDebitTransactionInformation23(pmtId, ccyAndAmt, dbtrAgt, dbtr, dbtrAcct);
            PostalAddress24 pstlAdr = SEPADebitExtractorV8Iso.saveAddress(paymentData.getRecipientAddressData());
            if (pstlAdr != null) {
                dbtr.setPstlAdr(pstlAdr);
            }
            if ((mandateInfo = SEPADebitExtractorV8Iso.getMandateInfo(paymentData.getMandateId(), paymentData.getMandateSignDate())) != null) {
                transaction.setDrctDbtTx(mandateInfo);
            }
            if ((ultimateCreditor = paymentData.getUltimateOriginator()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPADebitExtractorV8Iso.getParty(ultimateCreditor));
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPADebitExtractorV8Iso.getParty(ultimateDebitor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose2Choice(Purpose2Choice.Purpose2Choice_C1.fromCd(new ExternalPurpose1Code(purposeCode.trim()))));
            }
            transaction.setRmtInf(SEPADebitExtractorV8Iso.getRemittanceInfo(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static RemittanceInformation16 getRemittanceInfo(SEPAPaymentData paymentData) {
        RemittanceInformation16 remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            List<String> purposeLines;
            StructuredRemittanceInformation16 structured = null;
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                CreditorReferenceInformation2 cdtrRefInf = new CreditorReferenceInformation2();
                cdtrRefInf.setRef(new Max35Text(paymentData.getPurposeReference()));
                CreditorReferenceType2 tp = SEPADebitExtractorV8Iso.getPurposeReferenceType(paymentData);
                if (tp != null) {
                    cdtrRefInf.setTp(tp);
                }
                structured = new StructuredRemittanceInformation16();
                structured.setCdtrRefInf(cdtrRefInf);
            }
            if ((purposeLines = paymentData.getStructuredPurposeLines()).size() > 0) {
                if (structured == null) {
                    structured = new StructuredRemittanceInformation16();
                }
                for (String purposeLine : purposeLines) {
                    structured.getAddtlRmtInfs().add(new Max140Text(purposeLine));
                }
            }
            if (structured != null) {
                remittanceInfo = new RemittanceInformation16();
                remittanceInfo.getStrds().add(structured);
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformation16();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
            }
        }
        return remittanceInfo;
    }

    private static CreditorReferenceType2 getPurposeReferenceType(SEPAPaymentData paymentData) {
        CreditorReferenceType1Choice choice = null;
        String structuredTypeCode = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypeCode());
        if (structuredTypeCode.length() > 0) {
            DocumentType3Code code = new DocumentType3Code(structuredTypeCode);
            choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromCd(code));
        } else {
            String structuredTypePrtry = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypePrtry());
            if (structuredTypePrtry.length() > 0) {
                Max35Text prtry = new Max35Text(structuredTypePrtry);
                choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromPrtry(prtry));
            }
        }
        if (choice != null) {
            return new CreditorReferenceType2(choice);
        }
        return null;
    }

    private static DirectDebitTransaction10 getMandateInfo(String mandateId, Date mandateSignDate) {
        MandateRelatedInformation14 mndtRltdInf = null;
        if (mandateId != null && mandateId.trim().length() > 0) {
            mndtRltdInf = new MandateRelatedInformation14();
            mndtRltdInf.setMndtId(new Max35Text(mandateId.trim()));
        }
        if (mandateSignDate != null) {
            if (mndtRltdInf == null) {
                mndtRltdInf = new MandateRelatedInformation14();
            }
            mndtRltdInf.setDtOfSgntr(SEPADebitExtractorV8Iso.getDate(mandateSignDate));
        }
        if (mndtRltdInf != null) {
            DirectDebitTransaction10 drctDbtTx = new DirectDebitTransaction10();
            drctDbtTx.setMndtRltdInf(mndtRltdInf);
            return drctDbtTx;
        }
        return null;
    }

    private static PartyIdentification135 getParty(String name) {
        return SEPADebitExtractorV8Iso.getParty(name, null);
    }

    private static PartyIdentification135 getParty(String name, String legalEntityIdentifier) {
        String lei;
        PartyIdentification135 party = new PartyIdentification135();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max140Text(name));
        }
        if (!(lei = StringUtils.checkNullAndTrim(legalEntityIdentifier)).isEmpty()) {
            OrganisationIdentification29 orgId = new OrganisationIdentification29();
            orgId.setLEI(new LEIIdentifier(legalEntityIdentifier));
            party.setId(new Party38Choice(Party38Choice.Party38Choice_C1.fromOrgId(orgId)));
        }
        return party;
    }

    private static PartyIdentification135 getPartyFromId(String id) {
        GenericPersonIdentification1 othr = new GenericPersonIdentification1(new Max35Text(id));
        othr.setSchmeNm(new PersonIdentificationSchemeName1Choice(PersonIdentificationSchemeName1Choice.PersonIdentificationSchemeName1Choice_C1.fromPrtry(new Max35Text(GeneralSEPAExtractor.SEPA))));
        PersonIdentification13 prvtId = new PersonIdentification13();
        prvtId.getOthrs().add(othr);
        PartyIdentification135 party = new PartyIdentification135();
        party.setId(new Party38Choice(Party38Choice.Party38Choice_C1.fromPrvtId(prvtId)));
        return party;
    }

    private static BranchAndFinancialInstitutionIdentification6 getBankId(String bic) {
        FinancialInstitutionIdentification18 id = new FinancialInstitutionIdentification18();
        if (bic != null && bic.trim().length() >= 8) {
            id.setBICFI(new BICFIDec2014Identifier(bic.trim()));
        } else {
            id.setOthr(new GenericFinancialIdentification1(new Max35Text("NOTPROVIDED")));
        }
        return new BranchAndFinancialInstitutionIdentification6(id);
    }

    private static CashAccount38 getAccountId(String iban) {
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = null;
        c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification4Choice.AccountIdentification4Choice_C1.fromIBAN(new IBAN2007Identifier(iban)) : AccountIdentification4Choice.AccountIdentification4Choice_C1.fromOthr(new GenericAccountIdentification1(new Max34Text(iban)));
        return new CashAccount38(new AccountIdentification4Choice(c1));
    }

    private static ActiveOrHistoricCurrencyAndAmount getCurrencyAndAmount(BigDecimal amt, Currency c) {
        ActiveOrHistoricCurrencyCode ccy = new ActiveOrHistoricCurrencyCode(c.getCurrencyCode());
        return new ActiveOrHistoricCurrencyAndAmount(amt, ccy);
    }

    public static ISODate getDate(Date date) {
        return new ISODate(new YYMMDD(date.getTime()));
    }

    private static LocalInstrument2Choice getDebitType(String debitType) {
        if (debitType != null && debitType.length() > 0) {
            ExternalLocalInstrument1Code code = new ExternalLocalInstrument1Code(debitType);
            LocalInstrument2Choice.LocalInstrument2Choice_C1 c1 = LocalInstrument2Choice.LocalInstrument2Choice_C1.fromCd(code);
            return new LocalInstrument2Choice(c1);
        }
        return null;
    }

    private static SequenceType3Code getSequenceType(String seqType) {
        if ("FRST".equals(seqType)) {
            return new SequenceType3Code("FRST");
        }
        if ("RCUR".equals(seqType)) {
            return new SequenceType3Code("RCUR");
        }
        if ("FNAL".equals(seqType)) {
            return new SequenceType3Code("FNAL");
        }
        if ("RPRE".equals(seqType)) {
            return new SequenceType3Code("RPRE");
        }
        return new SequenceType3Code("OOFF");
    }

    private static AddressData getAddress(PostalAddress24 address) {
        if (address != null) {
            AddressData addressData = new AddressData();
            for (Max70Text line : address.getAdrLines()) {
                addressData.getAddressLines().add(line.getValue());
            }
            CountryCode countryCode = address.getCtry();
            if (countryCode != null) {
                addressData.setCountry(countryCode.getValue());
            }
            addressData.setDepartment(SimpleStringElement.getValue(address.getDept()));
            addressData.setSubDepartment(SimpleStringElement.getValue(address.getSubDept()));
            addressData.setStreetName(SimpleStringElement.getValue(address.getStrtNm()));
            addressData.setBuildingNumber(SimpleStringElement.getValue(address.getBldgNb()));
            addressData.setPostCode(SimpleStringElement.getValue(address.getPstCd()));
            addressData.setTownName(SimpleStringElement.getValue(address.getTwnNm()));
            addressData.setCountrySubDivision(SimpleStringElement.getValue(address.getCtrySubDvsn()));
            addressData.setBuildingName(SimpleStringElement.getValue(address.getBldgNm()));
            addressData.setFloor(SimpleStringElement.getValue(address.getFlr()));
            addressData.setRoom(SimpleStringElement.getValue(address.getRoom()));
            addressData.setPostBox(SimpleStringElement.getValue(address.getPstBx()));
            addressData.setTownLocationName(SimpleStringElement.getValue(address.getTwnLctnNm()));
            addressData.setDistrictName(SimpleStringElement.getValue(address.getDstrctNm()));
            return addressData;
        }
        return null;
    }

    private static PostalAddress24 saveAddress(AddressData addressData) {
        if (addressData != null) {
            String s;
            PostalAddress24 pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getDepartment())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setDept(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getSubDepartment())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setSubDept(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getStreetName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setStrtNm(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getBuildingNumber())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setBldgNb(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getPostCode())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setPstCd(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getTownName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setTwnNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getCountrySubDivision())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setCtrySubDvsn(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getBuildingName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setBldgNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getFloor())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setFlr(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getRoom())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setRoom(new Max70Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getPostBox())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setPstBx(new Max16Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getTownLocationName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setTwnLctnNm(new Max35Text(s));
            }
            if ((s = StringUtils.checkNullAndTrim(addressData.getDistrictName())).length() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress24();
                }
                pstlAdr.setDstrctNm(new Max35Text(s));
            }
            if (pstlAdr != null && (pstlAdr.getCtry() == null || pstlAdr.getTwnNm() == null)) {
                return null;
            }
            return pstlAdr;
        }
        return null;
    }
}

