/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.LocalInstrumentCodeSDD;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.pain00800102.AccountIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800102.AccountIdentificationSEPAMandate;
import de.businesslogics.format.sepa.pain00800102.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.sepa.pain00800102.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.sepa.pain00800102.ActiveOrHistoricCurrencyCodeEUR;
import de.businesslogics.format.sepa.pain00800102.AmendmentInformationDetailsSDD;
import de.businesslogics.format.sepa.pain00800102.BICIdentifier;
import de.businesslogics.format.sepa.pain00800102.BatchBookingIndicator;
import de.businesslogics.format.sepa.pain00800102.BranchAndFinancialInstitutionIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800102.BranchAndFinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800102.CashAccountSEPA1;
import de.businesslogics.format.sepa.pain00800102.CashAccountSEPA2;
import de.businesslogics.format.sepa.pain00800102.CashAccountSEPAMandate;
import de.businesslogics.format.sepa.pain00800102.CategoryPurposeSEPA;
import de.businesslogics.format.sepa.pain00800102.ChargeBearerTypeSEPACode;
import de.businesslogics.format.sepa.pain00800102.CountryCode;
import de.businesslogics.format.sepa.pain00800102.CreditorReferenceInformationSEPA1;
import de.businesslogics.format.sepa.pain00800102.CreditorReferenceTypeCodeSEPA;
import de.businesslogics.format.sepa.pain00800102.CreditorReferenceTypeSEPA;
import de.businesslogics.format.sepa.pain00800102.CustomerDirectDebitInitiationV02;
import de.businesslogics.format.sepa.pain00800102.DecimalNumber;
import de.businesslogics.format.sepa.pain00800102.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800102.DirectDebitTransactionSDD;
import de.businesslogics.format.sepa.pain00800102.Document;
import de.businesslogics.format.sepa.pain00800102.DocumentType3CodeSEPA;
import de.businesslogics.format.sepa.pain00800102.ExternalCategoryPurpose1Code;
import de.businesslogics.format.sepa.pain00800102.ExternalLocalInstrument1Code;
import de.businesslogics.format.sepa.pain00800102.ExternalPurpose1Code;
import de.businesslogics.format.sepa.pain00800102.ExternalServiceLevel1Code;
import de.businesslogics.format.sepa.pain00800102.FinancialInstitutionIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800102.FinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800102.GenericAccountIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800102.GroupHeaderSDD;
import de.businesslogics.format.sepa.pain00800102.IBAN2007Identifier;
import de.businesslogics.format.sepa.pain00800102.ISODate;
import de.businesslogics.format.sepa.pain00800102.ISODateTime;
import de.businesslogics.format.sepa.pain00800102.IdentificationSchemeNameSEPA;
import de.businesslogics.format.sepa.pain00800102.LocalInstrumentSEPA;
import de.businesslogics.format.sepa.pain00800102.MandateRelatedInformationSDD;
import de.businesslogics.format.sepa.pain00800102.Max140Text;
import de.businesslogics.format.sepa.pain00800102.Max15NumericText;
import de.businesslogics.format.sepa.pain00800102.Max35Text;
import de.businesslogics.format.sepa.pain00800102.Max70Text;
import de.businesslogics.format.sepa.pain00800102.OthrIdentification;
import de.businesslogics.format.sepa.pain00800102.OthrIdentificationCode;
import de.businesslogics.format.sepa.pain00800102.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800102.PartyIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800102.PartyIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800102.PartyIdentificationSEPA4;
import de.businesslogics.format.sepa.pain00800102.PartyIdentificationSEPA5;
import de.businesslogics.format.sepa.pain00800102.PartySEPA2;
import de.businesslogics.format.sepa.pain00800102.PaymentIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800102.PaymentInstructionInformationSDD;
import de.businesslogics.format.sepa.pain00800102.PaymentMethod2Code;
import de.businesslogics.format.sepa.pain00800102.PaymentTypeInformationSDD;
import de.businesslogics.format.sepa.pain00800102.PersonIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800102.PostalAddressSEPA;
import de.businesslogics.format.sepa.pain00800102.PurposeSEPA;
import de.businesslogics.format.sepa.pain00800102.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.pain00800102.RestrictedIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800102.RestrictedPersonIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800102.RestrictedPersonIdentificationSchemeNameSEPA;
import de.businesslogics.format.sepa.pain00800102.RestrictedPersonIdentifierSEPA;
import de.businesslogics.format.sepa.pain00800102.RestrictedSMNDACode;
import de.businesslogics.format.sepa.pain00800102.SequenceType1Code;
import de.businesslogics.format.sepa.pain00800102.ServiceLevel;
import de.businesslogics.format.sepa.pain00800102.StructuredRemittanceInformationSEPA1;
import de.businesslogics.format.sepa.pain00800102.TrueFalseIndicator;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV5 {
    public static GeneralSEPAWriter.DebitType getDebitType(Document document) {
        PaymentInstructionInformationSDD pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return GeneralSEPAWriter.DebitType.valueOf(pmtInf.getPmtTpInf().getLclInstrm().getCd().getValue());
    }

    public static XMLDate getDateSRZ(Document document) {
        PaymentInstructionInformationSDD pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return pmtInf.getReqdColltnDt();
    }

    protected static List<SEPAPaymentData> getPayments(Document document) throws IOException, SAXException {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        CustomerDirectDebitInitiationV02 pain00800201 = document.getCstmrDrctDbtInitn();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInfs()) {
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV5.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) throws IOException, SAXException {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        CustomerDirectDebitInitiationV02 pain00800201 = document.getCstmrDrctDbtInitn();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInfs()) {
            String pmtInfId = "";
            if (p.getPmtInfId() != null) {
                pmtInfId = p.getPmtInfId().getValue();
            }
            SEPALogicalFile logicalFile = new SEPALogicalFile(pmtInfId, msgId);
            SEPADebitExtractorV5.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV5.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V30);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformationSDD p, DirectDebitTransactionInformationSDD t) {
        PurposeSEPA purposeCode;
        AmendmentInformationDetailsSDD amendmentInfo;
        String endToEndId;
        PartyIdentificationSEPA5 creditor = p.getCdtr();
        String orig = creditor.getNm().getValue();
        String origIban = p.getCdtrAcct().getId().getIBAN().getValue();
        Currency accountCurrency = null;
        ActiveOrHistoricCurrencyCode ccy = p.getCdtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String origBic = "";
        BICIdentifier bic = p.getCdtrAgt().getFinInstnId().getChoice1().getBIC();
        if (bic != null) {
            origBic = bic.getValue();
        }
        String ultimateOrig = null;
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(t.getUltmtCdtr().getNm());
        }
        PartyIdentificationSEPA2 debtor = t.getDbtr();
        String recip = debtor.getNm().getValue();
        String recipIban = t.getDbtrAcct().getId().getIBAN().getValue();
        String recipBic = "";
        BICIdentifier bic2 = t.getDbtrAgt().getFinInstnId().getChoice1().getBIC();
        if (bic2 != null) {
            recipBic = bic2.getValue();
        }
        String ultimateRecip = null;
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getValue(t.getUltmtDbtr().getNm());
        }
        BigDecimal amount = t.getInstdAmt().getValue();
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null && p.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getCd().getValue();
        }
        if ("NOTPROVIDED".equals(endToEndId = t.getPmtId().getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = null;
        instructionId = t.getPmtId().getInstrId() != null ? t.getPmtId().getInstrId().getValue() : "";
        String debitType = p.getPmtTpInf().getLclInstrm().getCd().getValue();
        String sequenceType = p.getPmtTpInf().getSeqTp().getValue();
        DirectDebitTransactionSDD ddt = t.getDrctDbtTx();
        String creditorId = null;
        creditorId = ddt.getCdtrSchmeId() != null ? ddt.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : (p.getCdtrSchmeId() != null ? p.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : "");
        MandateRelatedInformationSDD mandateInfo = ddt.getMndtRltdInf();
        String mandateId = mandateInfo.getMndtId().getValue();
        YYMMDD mandateSignDate = mandateInfo.getDtOfSgntr().getDate();
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, null, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        paymentData.setAccountCurrency(accountCurrency);
        if (mandateInfo.getAmdmntInd() != null && mandateInfo.getAmdmntInd().booleanValue() && (amendmentInfo = mandateInfo.getAmdmntInfDtls()) != null) {
            if (amendmentInfo.getOrgnlCdtrSchmeId() != null) {
                if (amendmentInfo.getOrgnlCdtrSchmeId().getNm() != null) {
                    paymentData.setOriginalCreditor(amendmentInfo.getOrgnlCdtrSchmeId().getNm().getValue());
                }
                if (amendmentInfo.getOrgnlCdtrSchmeId().getId() != null) {
                    paymentData.setOriginalCreditorId(amendmentInfo.getOrgnlCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue());
                }
            }
            if (amendmentInfo.getOrgnlMndtId() != null) {
                paymentData.setOriginalMandateId(amendmentInfo.getOrgnlMndtId().getValue());
            }
            if (amendmentInfo.getOrgnlDbtrAcct() != null) {
                AccountIdentificationSEPAMandate.AccountIdentificationSEPAMandate_C1 c1 = amendmentInfo.getOrgnlDbtrAcct().getId().getChoice1();
                if (c1.getIBAN() != null) {
                    paymentData.setOriginalRecipientIban(c1.getIBAN().getValue());
                } else {
                    paymentData.setRecipientAccountHasChanged(true);
                }
            } else if (amendmentInfo.getOrgnlDbtrAgt() != null) {
                paymentData.setOriginalRecipientBic(amendmentInfo.getOrgnlDbtrAgt().getFinInstnId().getBIC().getValue());
            }
        }
        if ((purposeCode = t.getPurp()) != null) {
            paymentData.setPurposeCode(purposeCode.getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        paymentData.setOriginatorAddressData(SEPADebitExtractorV5.getAddress(creditor.getPstlAdr()));
        paymentData.setRecipientAddressData(SEPADebitExtractorV5.getAddress(debtor.getPstlAdr()));
        SEPADebitExtractorV5.setPurposeInformation(t.getRmtInf(), paymentData);
        return paymentData;
    }

    public static Document getDebitDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformationSDD logicalFile = SEPADebitExtractorV5.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeaderSDD grpHdr = SEPADebitExtractorV5.getGroupHeader(new ISODateTime(new Date()), "TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        return SEPADebitExtractorV5.getDebitDocument(new ISODateTime(new Date()), messageId, initiatingParty, paymentLists);
    }

    public static Document getDebitDocument(ISODateTime creationDate, String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSDD> logicalFiles = new ArrayList<PaymentInstructionInformationSDD>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV5.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeaderSDD grpHdr = SEPADebitExtractorV5.getGroupHeader(creationDate, messageId, initiatingParty, totalCountTransactions, ctrlSum);
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        for (PaymentInstructionInformationSDD logicalFile : logicalFiles) {
            cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        }
        return new Document(cstmrCdtTrfInitn);
    }

    private static GroupHeaderSDD getGroupHeader(ISODateTime creationDate, String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        PartyIdentificationSEPA1 initParty = new PartyIdentificationSEPA1();
        if (initiatingParty != null && !initiatingParty.isEmpty()) {
            initParty.setNm(new Max70Text(initiatingParty));
        }
        GroupHeaderSDD grpHdr = new GroupHeaderSDD(new RestrictedIdentificationSEPA1(messageId), creationDate, new Max15NumericText(String.valueOf(totalCountTransactions)), initParty);
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformationSDD getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        LocalInstrumentSEPA debitType = "B2B".equals(firstPayment.getDebitType()) ? new LocalInstrumentSEPA(new ExternalLocalInstrument1Code(LocalInstrumentCodeSDD.B2B.getValue())) : ("CORE".equals(firstPayment.getDebitType()) ? new LocalInstrumentSEPA(new ExternalLocalInstrument1Code(LocalInstrumentCodeSDD.CORE.getValue())) : new LocalInstrumentSEPA(new ExternalLocalInstrument1Code(LocalInstrumentCodeSDD.COR1.getValue())));
        String seqType = firstPayment.getSequenceType();
        SequenceType1Code sequenceType = "FRST".equals(seqType) ? new SequenceType1Code("FRST") : ("RCUR".equals(seqType) ? new SequenceType1Code("RCUR") : ("FNAL".equals(seqType) ? new SequenceType1Code("FNAL") : new SequenceType1Code("OOFF")));
        PaymentTypeInformationSDD pmtTpInf = new PaymentTypeInformationSDD(new ServiceLevel(new ExternalServiceLevel1Code(GeneralSEPAExtractor.SEPA)), debitType, sequenceType);
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            pmtTpInf.setCtgyPurp(new CategoryPurposeSEPA(new ExternalCategoryPurpose1Code(categoryPurpose)));
        }
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSEPA5 originator = new PartyIdentificationSEPA5(new Max70Text(firstPayment.getOriginator()));
        PostalAddressSEPA pstlAdr = SEPADebitExtractorV5.saveAddress(firstPayment.getOriginatorAddressData());
        if (pstlAdr != null) {
            originator.setPstlAdr(pstlAdr);
        }
        CashAccountSEPA1 originatorIban = new CashAccountSEPA1(new AccountIdentificationSEPA(new IBAN2007Identifier(firstPayment.getOriginatorIban())));
        if (firstPayment.getAccountCurrency() != null) {
            originatorIban.setCcy(new ActiveOrHistoricCurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstructionInformationSDD logicalFile = new PaymentInstructionInformationSDD(new RestrictedIdentificationSEPA1(logicalFileId), new PaymentMethod2Code("DD"), pmtTpInf, executionDate, originator, originatorIban, SEPADebitExtractorV5.getBankId(firstPayment.getOriginatorBic()));
        logicalFile.setChrgBr(new ChargeBearerTypeSEPACode(SEPAFeeType.SLEV.name()));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        BigDecimal controlSum = BigDecimal.ZERO;
        for (DirectDebitTransactionInformationSDD t : SEPADebitExtractorV5.getTransactions(logicalFileId, paymentList)) {
            logicalFile.getDrctDbtTxInfs().add(t);
            controlSum = controlSum.add(t.getInstdAmt().getValue());
        }
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(logicalFile.getDrctDbtTxInfs().size())));
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        return logicalFile;
    }

    private static BranchAndFinancialInstitutionIdentificationSEPA3 getBankId(String bic) {
        FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1 c = null;
        c = bic != null && bic.trim().length() >= 8 ? FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1.fromBIC(new BICIdentifier(bic.trim())) : FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1.fromOthr(new OthrIdentification(new OthrIdentificationCode("NOTPROVIDED")));
        return new BranchAndFinancialInstitutionIdentificationSEPA3(new FinancialInstitutionIdentificationSEPA3(c));
    }

    private static List<DirectDebitTransactionInformationSDD> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformationSDD> transactions = new ArrayList<DirectDebitTransactionInformationSDD>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purposeCode;
            String ultimateDebitor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentificationSEPA pmtId = new PaymentIdentificationSEPA(new RestrictedIdentificationSEPA1((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new RestrictedIdentificationSEPA1(instructionId));
            }
            ActiveOrHistoricCurrencyAndAmountSEPA amount = new ActiveOrHistoricCurrencyAndAmountSEPA(paymentData.getAmount(), new ActiveOrHistoricCurrencyCodeEUR("EUR"));
            PartyIdentificationSEPA2 recipient = new PartyIdentificationSEPA2(new Max70Text(paymentData.getRecipient()));
            PostalAddressSEPA pstlAdr = SEPADebitExtractorV5.saveAddress(paymentData.getRecipientAddressData());
            if (pstlAdr != null) {
                recipient.setPstlAdr(pstlAdr);
            }
            CashAccountSEPA2 recipientIban = new CashAccountSEPA2(new AccountIdentificationSEPA(new IBAN2007Identifier(paymentData.getRecipientIban())));
            RestrictedIdentificationSEPA1 mndtId = new RestrictedIdentificationSEPA1(paymentData.getMandateId());
            ISODate dtOfSgntr = new ISODate(new YYMMDD(paymentData.getMandateSignDate().getTime()));
            MandateRelatedInformationSDD mndtRltdInf = new MandateRelatedInformationSDD(mndtId, dtOfSgntr);
            if (paymentData.hasModifiedMandate()) {
                AmendmentInformationDetailsSDD am = new AmendmentInformationDetailsSDD();
                String originalCreditor = paymentData.getOriginalCreditor();
                String originalCreditorId = paymentData.getOriginalCreditorId();
                if (originalCreditor != null || originalCreditorId != null) {
                    PartyIdentificationSEPA4 origcdtrSchmeId = new PartyIdentificationSEPA4();
                    if (originalCreditor != null) {
                        origcdtrSchmeId.setNm(new Max70Text(originalCreditor));
                    }
                    if (originalCreditorId != null) {
                        RestrictedPersonIdentifierSEPA cid = new RestrictedPersonIdentifierSEPA(originalCreditorId);
                        RestrictedPersonIdentificationSEPA personId = new RestrictedPersonIdentificationSEPA(cid, new RestrictedPersonIdentificationSchemeNameSEPA(new IdentificationSchemeNameSEPA(GeneralSEPAExtractor.SEPA)));
                        origcdtrSchmeId.setId(new PartySEPA2(new PersonIdentificationSEPA2(personId)));
                    }
                    am.setOrgnlCdtrSchmeId(origcdtrSchmeId);
                }
                if (paymentData.getOriginalMandateId() != null) {
                    RestrictedIdentificationSEPA1 origmndtId = new RestrictedIdentificationSEPA1(paymentData.getOriginalMandateId());
                    am.setOrgnlMndtId(origmndtId);
                }
                if (paymentData.recipientAccountHasChanged() || paymentData.recipientBankHasChanged()) {
                    GenericAccountIdentificationSEPA smnda = new GenericAccountIdentificationSEPA(new RestrictedSMNDACode("SMNDA"));
                    am.setOrgnlDbtrAcct(new CashAccountSEPAMandate(new AccountIdentificationSEPAMandate(AccountIdentificationSEPAMandate.AccountIdentificationSEPAMandate_C1.fromOthr(smnda))));
                } else if (paymentData.getOriginalRecipientIban() != null) {
                    IBAN2007Identifier iban = new IBAN2007Identifier(paymentData.getOriginalRecipientIban());
                    am.setOrgnlDbtrAcct(new CashAccountSEPAMandate(new AccountIdentificationSEPAMandate(AccountIdentificationSEPAMandate.AccountIdentificationSEPAMandate_C1.fromIBAN(iban))));
                } else if (paymentData.getOriginalRecipientBic() != null) {
                    BICIdentifier bic = new BICIdentifier(paymentData.getOriginalRecipientBic());
                    am.setOrgnlDbtrAgt(new BranchAndFinancialInstitutionIdentificationSEPA2(new FinancialInstitutionIdentificationSEPA2(bic)));
                }
                mndtRltdInf.setAmdmntInfDtls(am);
                mndtRltdInf.setAmdmntInd(new TrueFalseIndicator(true));
            }
            DirectDebitTransactionSDD drctDbtTx = new DirectDebitTransactionSDD(mndtRltdInf);
            RestrictedPersonIdentifierSEPA cid = new RestrictedPersonIdentifierSEPA(paymentData.getCreditorId());
            RestrictedPersonIdentificationSEPA personId = new RestrictedPersonIdentificationSEPA(cid, new RestrictedPersonIdentificationSchemeNameSEPA(new IdentificationSchemeNameSEPA(GeneralSEPAExtractor.SEPA)));
            PartyIdentificationSEPA3 cdtrSchmeId = new PartyIdentificationSEPA3(new PartySEPA2(new PersonIdentificationSEPA2(personId)));
            drctDbtTx.setCdtrSchmeId(cdtrSchmeId);
            DirectDebitTransactionInformationSDD transaction = new DirectDebitTransactionInformationSDD(pmtId, amount, drctDbtTx, SEPADebitExtractorV5.getBankId(paymentData.getRecipientBic()), recipient, recipientIban);
            String ultimateCreditor = paymentData.getUltimateOriginator();
            if (ultimateCreditor != null && ultimateCreditor.length() > 0) {
                PartyIdentificationSEPA1 ultmtCdtr = new PartyIdentificationSEPA1();
                ultmtCdtr.setNm(new Max70Text(ultimateCreditor));
                transaction.setUltmtCdtr(ultmtCdtr);
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                PartyIdentificationSEPA1 ultmtDbtr = new PartyIdentificationSEPA1();
                ultmtDbtr.setNm(new Max70Text(ultimateDebitor));
                transaction.setUltmtDbtr(ultmtDbtr);
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new PurposeSEPA(new ExternalPurpose1Code(purposeCode.trim())));
            }
            transaction.setRmtInf(SEPADebitExtractorV5.getRemittanceInformation(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static void setPurposeInformation(RemittanceInformationSEPA1Choice rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            if (rmtInf.getChoice1().getUstrd() != null) {
                paymentData.setPurpose(rmtInf.getChoice1().getUstrd().getValue());
            } else if (rmtInf.getChoice1().getStrd() != null && rmtInf.getChoice1().getStrd().getCdtrRefInf() != null) {
                CreditorReferenceInformationSEPA1 strctRmtInf = rmtInf.getChoice1().getStrd().getCdtrRefInf();
                paymentData.setHasStructuredPurpose(true);
                paymentData.setPurposeReference(strctRmtInf.getRef().getValue());
                paymentData.setPurposeReferenceTypeCode(strctRmtInf.getTp().getCdOrPrtry().getCd().getValue());
            }
        }
    }

    private static RemittanceInformationSEPA1Choice getRemittanceInformation(SEPAPaymentData paymentData) {
        RemittanceInformationSEPA1Choice remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                DocumentType3CodeSEPA documentTypeCode = new DocumentType3CodeSEPA("SCOR");
                CreditorReferenceTypeCodeSEPA cdtrReferenceTypeCode = new CreditorReferenceTypeCodeSEPA(documentTypeCode);
                CreditorReferenceTypeSEPA cdtrReferenceType = new CreditorReferenceTypeSEPA(cdtrReferenceTypeCode);
                CreditorReferenceInformationSEPA1 cdtrReference = new CreditorReferenceInformationSEPA1(cdtrReferenceType, new Max35Text(purposeReference));
                StructuredRemittanceInformationSEPA1 structured = new StructuredRemittanceInformationSEPA1();
                structured.setCdtrRefInf(cdtrReference);
                remittanceInfo = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromStrd(structured));
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromUstrd(new Max140Text(purpose)));
            }
        }
        return remittanceInfo;
    }

    private static AddressData getAddress(PostalAddressSEPA address) {
        if (address != null) {
            AddressData addressData = new AddressData();
            for (Max70Text line : address.getAdrLines()) {
                addressData.getAddressLines().add(line.getValue());
            }
            CountryCode countryCode = address.getCtry();
            if (countryCode != null) {
                addressData.setCountry(countryCode.getValue());
            }
            return addressData;
        }
        return null;
    }

    private static PostalAddressSEPA saveAddress(AddressData addressData) {
        if (addressData != null) {
            PostalAddressSEPA pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddressSEPA();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddressSEPA();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            return pstlAdr;
        }
        return null;
    }
}

