/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.LocalInstrumentCodeSDD;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.pain00800302.AccountIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800302.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.sepa.pain00800302.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.sepa.pain00800302.ActiveOrHistoricCurrencyCodeEUR;
import de.businesslogics.format.sepa.pain00800302.AmendmentInformationDetailsSDD;
import de.businesslogics.format.sepa.pain00800302.BICIdentifier;
import de.businesslogics.format.sepa.pain00800302.BatchBookingIndicator;
import de.businesslogics.format.sepa.pain00800302.BranchAndFinancialInstitutionIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800302.BranchAndFinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800302.CashAccountSEPA1;
import de.businesslogics.format.sepa.pain00800302.CashAccountSEPA2;
import de.businesslogics.format.sepa.pain00800302.CategoryPurposeSEPA;
import de.businesslogics.format.sepa.pain00800302.ChargeBearerTypeSEPACode;
import de.businesslogics.format.sepa.pain00800302.CountryCode;
import de.businesslogics.format.sepa.pain00800302.CustomerDirectDebitInitiationV02;
import de.businesslogics.format.sepa.pain00800302.DecimalNumber;
import de.businesslogics.format.sepa.pain00800302.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800302.DirectDebitTransactionSDD;
import de.businesslogics.format.sepa.pain00800302.Document;
import de.businesslogics.format.sepa.pain00800302.ExternalCategoryPurpose1Code;
import de.businesslogics.format.sepa.pain00800302.ExternalLocalInstrument1Code;
import de.businesslogics.format.sepa.pain00800302.ExternalPurpose1Code;
import de.businesslogics.format.sepa.pain00800302.ExternalServiceLevel1Code;
import de.businesslogics.format.sepa.pain00800302.FinancialInstitutionIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800302.FinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800302.GroupHeaderSDD;
import de.businesslogics.format.sepa.pain00800302.IBAN2007Identifier;
import de.businesslogics.format.sepa.pain00800302.ISODate;
import de.businesslogics.format.sepa.pain00800302.ISODateTime;
import de.businesslogics.format.sepa.pain00800302.IdentificationSchemeNameSEPA;
import de.businesslogics.format.sepa.pain00800302.LocalInstrumentSEPA;
import de.businesslogics.format.sepa.pain00800302.MandateRelatedInformationSDD;
import de.businesslogics.format.sepa.pain00800302.Max140Text;
import de.businesslogics.format.sepa.pain00800302.Max15NumericText;
import de.businesslogics.format.sepa.pain00800302.Max70Text;
import de.businesslogics.format.sepa.pain00800302.OthrIdentification;
import de.businesslogics.format.sepa.pain00800302.OthrIdentificationCode;
import de.businesslogics.format.sepa.pain00800302.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800302.PartyIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800302.PartyIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800302.PartyIdentificationSEPA4;
import de.businesslogics.format.sepa.pain00800302.PartyIdentificationSEPA5;
import de.businesslogics.format.sepa.pain00800302.PartySEPA2;
import de.businesslogics.format.sepa.pain00800302.PaymentIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800302.PaymentInstructionInformationSDD;
import de.businesslogics.format.sepa.pain00800302.PaymentMethod2Code;
import de.businesslogics.format.sepa.pain00800302.PaymentTypeInformationSDD;
import de.businesslogics.format.sepa.pain00800302.PersonIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800302.PostalAddressSEPA;
import de.businesslogics.format.sepa.pain00800302.PurposeSEPA;
import de.businesslogics.format.sepa.pain00800302.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.pain00800302.RestrictedFinancialIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800302.RestrictedIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800302.RestrictedIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800302.RestrictedPersonIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800302.RestrictedPersonIdentificationSchemeNameSEPA;
import de.businesslogics.format.sepa.pain00800302.RestrictedPersonIdentifierSEPA;
import de.businesslogics.format.sepa.pain00800302.RestrictedSMNDACode;
import de.businesslogics.format.sepa.pain00800302.SequenceType1Code;
import de.businesslogics.format.sepa.pain00800302.ServiceLevelSEPA;
import de.businesslogics.format.sepa.pain00800302.TrueFalseIndicator;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV4 {
    public static GeneralSEPAWriter.DebitType getDebitType(Document document) {
        PaymentInstructionInformationSDD pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return GeneralSEPAWriter.DebitType.valueOf(pmtInf.getPmtTpInf().getLclInstrm().getCd().getValue());
    }

    public static XMLDate getDateSRZ(Document document) {
        PaymentInstructionInformationSDD pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return pmtInf.getReqdColltnDt();
    }

    protected static List<SEPAPaymentData> getPayments(Document document) throws IOException, SAXException {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        CustomerDirectDebitInitiationV02 pain00800201 = document.getCstmrDrctDbtInitn();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInfs()) {
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV4.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) throws IOException, SAXException {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        CustomerDirectDebitInitiationV02 pain00800201 = document.getCstmrDrctDbtInitn();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInfs()) {
            String pmtInfId = "";
            if (p.getPmtInfId() != null) {
                pmtInfId = p.getPmtInfId().getValue();
            }
            SEPALogicalFile logicalFile = new SEPALogicalFile(pmtInfId, msgId);
            SEPADebitExtractorV4.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV4.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V27);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformationSDD p, DirectDebitTransactionInformationSDD t) {
        PurposeSEPA purposeCode;
        AmendmentInformationDetailsSDD amendmentInfo;
        String endToEndId;
        PartyIdentificationSEPA5 creditor = p.getCdtr();
        String orig = creditor.getNm().getValue();
        String origIban = p.getCdtrAcct().getId().getIBAN().getValue();
        Currency accountCurrency = null;
        ActiveOrHistoricCurrencyCode ccy = p.getCdtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String origBic = "";
        BICIdentifier bic = p.getCdtrAgt().getFinInstnId().getChoice1().getBIC();
        if (bic != null) {
            origBic = bic.getValue();
        }
        String ultimateOrig = null;
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(t.getUltmtCdtr().getNm());
        }
        PartyIdentificationSEPA2 debtor = t.getDbtr();
        String recip = debtor.getNm().getValue();
        String recipIban = t.getDbtrAcct().getId().getIBAN().getValue();
        String recipBic = "";
        BICIdentifier bic2 = t.getDbtrAgt().getFinInstnId().getChoice1().getBIC();
        if (bic2 != null) {
            recipBic = bic2.getValue();
        }
        String ultimateRecip = null;
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getValue(t.getUltmtDbtr().getNm());
        }
        BigDecimal amount = t.getInstdAmt().getValue();
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String purpose = null;
        purpose = t.getRmtInf() != null && t.getRmtInf().getChoice1() != null && t.getRmtInf().getChoice1().getUstrd() != null ? t.getRmtInf().getChoice1().getUstrd().getValue() : "";
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null && p.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getCd().getValue();
        }
        if ("NOTPROVIDED".equals(endToEndId = t.getPmtId().getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = null;
        instructionId = t.getPmtId().getInstrId() != null ? t.getPmtId().getInstrId().getValue() : "";
        String debitType = p.getPmtTpInf().getLclInstrm().getCd().getValue();
        String sequenceType = p.getPmtTpInf().getSeqTp().getValue();
        DirectDebitTransactionSDD ddt = t.getDrctDbtTx();
        String creditorId = null;
        creditorId = ddt.getCdtrSchmeId() != null ? ddt.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : (p.getCdtrSchmeId() != null ? p.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : "");
        MandateRelatedInformationSDD mandateInfo = ddt.getMndtRltdInf();
        String mandateId = mandateInfo.getMndtId().getValue();
        YYMMDD mandateSignDate = mandateInfo.getDtOfSgntr().getDate();
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, purpose, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        paymentData.setAccountCurrency(accountCurrency);
        if (mandateInfo.getAmdmntInd() != null && mandateInfo.getAmdmntInd().booleanValue() && (amendmentInfo = mandateInfo.getAmdmntInfDtls()) != null) {
            if (amendmentInfo.getOrgnlCdtrSchmeId() != null) {
                if (amendmentInfo.getOrgnlCdtrSchmeId().getNm() != null) {
                    paymentData.setOriginalCreditor(amendmentInfo.getOrgnlCdtrSchmeId().getNm().getValue());
                }
                if (amendmentInfo.getOrgnlCdtrSchmeId().getId() != null) {
                    paymentData.setOriginalCreditorId(amendmentInfo.getOrgnlCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue());
                }
            }
            if (amendmentInfo.getOrgnlMndtId() != null) {
                paymentData.setOriginalMandateId(amendmentInfo.getOrgnlMndtId().getValue());
            }
            if (amendmentInfo.getOrgnlDbtrAgt() != null) {
                paymentData.setRecipientBankHasChanged(true);
                paymentData.setRecipientAccountHasChanged(true);
            } else if (amendmentInfo.getOrgnlDbtrAcct() != null) {
                paymentData.setOriginalRecipientIban(amendmentInfo.getOrgnlDbtrAcct().getId().getIBAN().getValue());
                paymentData.setRecipientAccountHasChanged(true);
            }
        }
        if ((purposeCode = t.getPurp()) != null) {
            paymentData.setPurposeCode(purposeCode.getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        paymentData.setOriginatorAddressData(SEPADebitExtractorV4.getAddress(creditor.getPstlAdr()));
        paymentData.setRecipientAddressData(SEPADebitExtractorV4.getAddress(debtor.getPstlAdr()));
        return paymentData;
    }

    public static Document getDebitDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformationSDD logicalFile = SEPADebitExtractorV4.getLogicalFile("TempMessageId", paymentData.displayAsSingleBooking() ? Boolean.FALSE : null, paymentList);
        GroupHeaderSDD grpHdr = SEPADebitExtractorV4.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSDD> logicalFiles = new ArrayList<PaymentInstructionInformationSDD>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                if (paymentList.get(0).displayAsSingleBooking()) {
                    btchBookg = Boolean.FALSE;
                }
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV4.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeaderSDD grpHdr = SEPADebitExtractorV4.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        for (PaymentInstructionInformationSDD logicalFile : logicalFiles) {
            cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        }
        return new Document(cstmrCdtTrfInitn);
    }

    private static GroupHeaderSDD getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        PartyIdentificationSEPA1 initParty = new PartyIdentificationSEPA1();
        if (initiatingParty != null && !initiatingParty.isEmpty()) {
            initParty.setNm(new Max70Text(initiatingParty));
        }
        GroupHeaderSDD grpHdr = new GroupHeaderSDD(new RestrictedIdentificationSEPA1(messageId), new ISODateTime(), new Max15NumericText(String.valueOf(totalCountTransactions)), initParty);
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformationSDD getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        PostalAddressSEPA pstlAdr;
        SEPAPaymentData firstPayment = paymentList.get(0);
        LocalInstrumentSEPA debitType = "B2B".equals(firstPayment.getDebitType()) ? new LocalInstrumentSEPA(new ExternalLocalInstrument1Code(LocalInstrumentCodeSDD.B2B.getValue())) : ("CORE".equals(firstPayment.getDebitType()) ? new LocalInstrumentSEPA(new ExternalLocalInstrument1Code(LocalInstrumentCodeSDD.CORE.getValue())) : new LocalInstrumentSEPA(new ExternalLocalInstrument1Code(LocalInstrumentCodeSDD.COR1.getValue())));
        String seqType = firstPayment.getSequenceType();
        SequenceType1Code sequenceType = "FRST".equals(seqType) ? new SequenceType1Code("FRST") : ("RCUR".equals(seqType) ? new SequenceType1Code("RCUR") : ("FNAL".equals(seqType) ? new SequenceType1Code("FNAL") : new SequenceType1Code("OOFF")));
        PaymentTypeInformationSDD pmtTpInf = new PaymentTypeInformationSDD(new ServiceLevelSEPA(new ExternalServiceLevel1Code(GeneralSEPAExtractor.SEPA)), debitType, sequenceType);
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            pmtTpInf.setCtgyPurp(new CategoryPurposeSEPA(new ExternalCategoryPurpose1Code(categoryPurpose)));
        }
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSEPA5 originator = new PartyIdentificationSEPA5(new Max70Text(firstPayment.getOriginator()));
        CashAccountSEPA1 originatorIban = new CashAccountSEPA1(new AccountIdentificationSEPA(new IBAN2007Identifier(firstPayment.getOriginatorIban())));
        if (firstPayment.getAccountCurrency() != null) {
            originatorIban.setCcy(new ActiveOrHistoricCurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstructionInformationSDD logicalFile = new PaymentInstructionInformationSDD(new RestrictedIdentificationSEPA1(logicalFileId), new PaymentMethod2Code("DD"), pmtTpInf, executionDate, originator, originatorIban, SEPADebitExtractorV4.getBankId(firstPayment.getOriginatorBic()));
        logicalFile.setChrgBr(new ChargeBearerTypeSEPACode(SEPAFeeType.SLEV.name()));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        if ((pstlAdr = SEPADebitExtractorV4.saveAddress(firstPayment.getOriginatorAddressData())) != null) {
            originator.setPstlAdr(pstlAdr);
        }
        BigDecimal controlSum = BigDecimal.ZERO;
        for (DirectDebitTransactionInformationSDD t : SEPADebitExtractorV4.getTransactions(logicalFileId, paymentList)) {
            logicalFile.getDrctDbtTxInfs().add(t);
            controlSum = controlSum.add(t.getInstdAmt().getValue());
        }
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(logicalFile.getDrctDbtTxInfs().size())));
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        return logicalFile;
    }

    private static BranchAndFinancialInstitutionIdentificationSEPA3 getBankId(String bic) {
        FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1 c = null;
        c = bic != null && bic.trim().length() >= 8 ? FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1.fromBIC(new BICIdentifier(bic.trim())) : FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1.fromOthr(new OthrIdentification(new OthrIdentificationCode("NOTPROVIDED")));
        return new BranchAndFinancialInstitutionIdentificationSEPA3(new FinancialInstitutionIdentificationSEPA3(c));
    }

    private static List<DirectDebitTransactionInformationSDD> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformationSDD> transactions = new ArrayList<DirectDebitTransactionInformationSDD>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String purposeCode;
            String ultimateDebitor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentificationSEPA pmtId = new PaymentIdentificationSEPA(new RestrictedIdentificationSEPA1((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new RestrictedIdentificationSEPA1(instructionId));
            }
            ActiveOrHistoricCurrencyAndAmountSEPA amount = new ActiveOrHistoricCurrencyAndAmountSEPA(paymentData.getAmount(), new ActiveOrHistoricCurrencyCodeEUR("EUR"));
            PartyIdentificationSEPA2 recipient = new PartyIdentificationSEPA2(new Max70Text(paymentData.getRecipient()));
            PostalAddressSEPA pstlAdr = SEPADebitExtractorV4.saveAddress(paymentData.getRecipientAddressData());
            if (pstlAdr != null) {
                recipient.setPstlAdr(pstlAdr);
            }
            CashAccountSEPA2 recipientIban = new CashAccountSEPA2(new AccountIdentificationSEPA(new IBAN2007Identifier(paymentData.getRecipientIban())));
            RestrictedIdentificationSEPA2 mndtId = new RestrictedIdentificationSEPA2(paymentData.getMandateId());
            ISODate dtOfSgntr = new ISODate(new YYMMDD(paymentData.getMandateSignDate().getTime()));
            MandateRelatedInformationSDD mndtRltdInf = new MandateRelatedInformationSDD(mndtId, dtOfSgntr);
            String originalCreditor = paymentData.getOriginalCreditor();
            String originalCreditorId = paymentData.getOriginalCreditorId();
            if (originalCreditor != null || originalCreditorId != null || paymentData.getOriginalMandateId() != null || paymentData.recipientBankHasChanged() || paymentData.getOriginalRecipientIban() != null) {
                AmendmentInformationDetailsSDD am = new AmendmentInformationDetailsSDD();
                if (originalCreditor != null || originalCreditorId != null) {
                    PartyIdentificationSEPA4 origcdtrSchmeId = new PartyIdentificationSEPA4();
                    if (originalCreditor != null) {
                        origcdtrSchmeId.setNm(new Max70Text(originalCreditor));
                    }
                    if (originalCreditorId != null) {
                        RestrictedPersonIdentifierSEPA cid = new RestrictedPersonIdentifierSEPA(originalCreditorId);
                        RestrictedPersonIdentificationSEPA personId = new RestrictedPersonIdentificationSEPA(cid, new RestrictedPersonIdentificationSchemeNameSEPA(new IdentificationSchemeNameSEPA(GeneralSEPAExtractor.SEPA)));
                        origcdtrSchmeId.setId(new PartySEPA2(new PersonIdentificationSEPA2(personId)));
                    }
                    am.setOrgnlCdtrSchmeId(origcdtrSchmeId);
                }
                if (paymentData.getOriginalMandateId() != null) {
                    RestrictedIdentificationSEPA2 origmndtId = new RestrictedIdentificationSEPA2(paymentData.getOriginalMandateId());
                    am.setOrgnlMndtId(origmndtId);
                }
                if (paymentData.recipientBankHasChanged()) {
                    am.setOrgnlDbtrAgt(new BranchAndFinancialInstitutionIdentificationSEPA2(new FinancialInstitutionIdentificationSEPA2(new RestrictedFinancialIdentificationSEPA(new RestrictedSMNDACode("SMNDA")))));
                } else if (paymentData.getOriginalRecipientIban() != null) {
                    CashAccountSEPA2 origrecipientIban = new CashAccountSEPA2(new AccountIdentificationSEPA(new IBAN2007Identifier(paymentData.getOriginalRecipientIban())));
                    am.setOrgnlDbtrAcct(origrecipientIban);
                }
                mndtRltdInf.setAmdmntInfDtls(am);
                mndtRltdInf.setAmdmntInd(new TrueFalseIndicator(true));
            }
            DirectDebitTransactionSDD drctDbtTx = new DirectDebitTransactionSDD(mndtRltdInf);
            RestrictedPersonIdentifierSEPA cid = new RestrictedPersonIdentifierSEPA(paymentData.getCreditorId());
            RestrictedPersonIdentificationSEPA personId = new RestrictedPersonIdentificationSEPA(cid, new RestrictedPersonIdentificationSchemeNameSEPA(new IdentificationSchemeNameSEPA(GeneralSEPAExtractor.SEPA)));
            PartyIdentificationSEPA3 cdtrSchmeId = new PartyIdentificationSEPA3(new PartySEPA2(new PersonIdentificationSEPA2(personId)));
            drctDbtTx.setCdtrSchmeId(cdtrSchmeId);
            DirectDebitTransactionInformationSDD transaction = new DirectDebitTransactionInformationSDD(pmtId, amount, drctDbtTx, SEPADebitExtractorV4.getBankId(paymentData.getRecipientBic()), recipient, recipientIban);
            String ultimateCreditor = paymentData.getUltimateOriginator();
            if (ultimateCreditor != null && ultimateCreditor.length() > 0) {
                PartyIdentificationSEPA1 ultmtCdtr = new PartyIdentificationSEPA1();
                ultmtCdtr.setNm(new Max70Text(ultimateCreditor));
                transaction.setUltmtCdtr(ultmtCdtr);
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                PartyIdentificationSEPA1 ultmtDbtr = new PartyIdentificationSEPA1();
                ultmtDbtr.setNm(new Max70Text(ultimateDebitor));
                transaction.setUltmtDbtr(ultmtDbtr);
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new PurposeSEPA(new ExternalPurpose1Code(purposeCode.trim())));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                RemittanceInformationSEPA1Choice rmtInf = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromUstrd(new Max140Text(purpose)));
                transaction.setRmtInf(rmtInf);
            }
            transactions.add(transaction);
        }
        return transactions;
    }

    private static AddressData getAddress(PostalAddressSEPA address) {
        if (address != null) {
            AddressData addressData = new AddressData();
            for (Max70Text line : address.getAdrLines()) {
                addressData.getAddressLines().add(line.getValue());
            }
            CountryCode countryCode = address.getCtry();
            if (countryCode != null) {
                addressData.setCountry(countryCode.getValue());
            }
            return addressData;
        }
        return null;
    }

    private static PostalAddressSEPA saveAddress(AddressData addressData) {
        if (addressData != null) {
            PostalAddressSEPA pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddressSEPA();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddressSEPA();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            return pstlAdr;
        }
        return null;
    }
}

