/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.iso20022.pain00800102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.pain00800102.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00800102.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.iso20022.pain00800102.AmendmentInformationDetails6;
import de.businesslogics.format.iso20022.pain00800102.BICIdentifier;
import de.businesslogics.format.iso20022.pain00800102.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00800102.BranchAndFinancialInstitutionIdentification4;
import de.businesslogics.format.iso20022.pain00800102.CashAccount16;
import de.businesslogics.format.iso20022.pain00800102.CategoryPurpose1Choice;
import de.businesslogics.format.iso20022.pain00800102.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00800102.CountryCode;
import de.businesslogics.format.iso20022.pain00800102.CreditorReferenceInformation2;
import de.businesslogics.format.iso20022.pain00800102.CreditorReferenceType1Choice;
import de.businesslogics.format.iso20022.pain00800102.CreditorReferenceType2;
import de.businesslogics.format.iso20022.pain00800102.CustomerDirectDebitInitiationV02;
import de.businesslogics.format.iso20022.pain00800102.DecimalNumber;
import de.businesslogics.format.iso20022.pain00800102.DirectDebitTransaction6;
import de.businesslogics.format.iso20022.pain00800102.DirectDebitTransactionInformation9;
import de.businesslogics.format.iso20022.pain00800102.Document;
import de.businesslogics.format.iso20022.pain00800102.DocumentType3Code;
import de.businesslogics.format.iso20022.pain00800102.ExternalCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00800102.ExternalLocalInstrument1Code;
import de.businesslogics.format.iso20022.pain00800102.ExternalPurpose1Code;
import de.businesslogics.format.iso20022.pain00800102.ExternalServiceLevel1Code;
import de.businesslogics.format.iso20022.pain00800102.FinancialInstitutionIdentification7;
import de.businesslogics.format.iso20022.pain00800102.GenericAccountIdentification1;
import de.businesslogics.format.iso20022.pain00800102.GenericFinancialIdentification1;
import de.businesslogics.format.iso20022.pain00800102.GenericPersonIdentification1;
import de.businesslogics.format.iso20022.pain00800102.GroupHeader39;
import de.businesslogics.format.iso20022.pain00800102.IBAN2007Identifier;
import de.businesslogics.format.iso20022.pain00800102.ISODate;
import de.businesslogics.format.iso20022.pain00800102.ISODateTime;
import de.businesslogics.format.iso20022.pain00800102.LocalInstrument2Choice;
import de.businesslogics.format.iso20022.pain00800102.MandateRelatedInformation6;
import de.businesslogics.format.iso20022.pain00800102.Max140Text;
import de.businesslogics.format.iso20022.pain00800102.Max15NumericText;
import de.businesslogics.format.iso20022.pain00800102.Max16Text;
import de.businesslogics.format.iso20022.pain00800102.Max34Text;
import de.businesslogics.format.iso20022.pain00800102.Max35Text;
import de.businesslogics.format.iso20022.pain00800102.Max70Text;
import de.businesslogics.format.iso20022.pain00800102.Party6Choice;
import de.businesslogics.format.iso20022.pain00800102.PartyIdentification32;
import de.businesslogics.format.iso20022.pain00800102.PaymentIdentification1;
import de.businesslogics.format.iso20022.pain00800102.PaymentInstructionInformation4;
import de.businesslogics.format.iso20022.pain00800102.PaymentMethod2Code;
import de.businesslogics.format.iso20022.pain00800102.PaymentTypeInformation20;
import de.businesslogics.format.iso20022.pain00800102.PersonIdentification5;
import de.businesslogics.format.iso20022.pain00800102.PersonIdentificationSchemeName1Choice;
import de.businesslogics.format.iso20022.pain00800102.PostalAddress6;
import de.businesslogics.format.iso20022.pain00800102.Purpose2Choice;
import de.businesslogics.format.iso20022.pain00800102.RemittanceInformation5;
import de.businesslogics.format.iso20022.pain00800102.SequenceType1Code;
import de.businesslogics.format.iso20022.pain00800102.ServiceLevel8Choice;
import de.businesslogics.format.iso20022.pain00800102.StructuredRemittanceInformation7;
import de.businesslogics.format.sepa.AccountNumberInfo;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV3Iso {
    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        CustomerDirectDebitInitiationV02 cddi = document.getCstmrDrctDbtInitn();
        GroupHeader39 grpHdr = cddi.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstructionInformation4 p : cddi.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            SEPADebitExtractorV3Iso.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (DirectDebitTransactionInformation9 c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV3Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V25Iso);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerDirectDebitInitiationV02 cddi = document.getCstmrDrctDbtInitn();
        GroupHeader39 grpHdr = cddi.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation4 p : cddi.getPmtInfs()) {
            for (DirectDebitTransactionInformation9 c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV3Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformation4 p, DirectDebitTransactionInformation9 t) {
        AmendmentInformationDetails6 amendmentInfo;
        MandateRelatedInformation6 mandateInfo;
        PartyIdentification32 creditor = p.getCdtr();
        String orig = SimpleStringElement.getNonNullValue(creditor.getNm());
        String origAccNumber = null;
        boolean isOrigIban = true;
        AccountNumberInfo origAccNumberInfo = SEPADebitExtractorV3Iso.getAccountNumberInfo(p.getCdtrAcct().getId().getChoice1());
        if (origAccNumberInfo != null) {
            origAccNumber = origAccNumberInfo.getAccountNumber();
            isOrigIban = origAccNumberInfo.isFromIbanTag();
        }
        String origBankCode = SEPADebitExtractorV3Iso.getBankIdentifier(p.getCdtrAgt().getFinInstnId());
        Currency accountCurrency = null;
        ActiveOrHistoricCurrencyCode ccy = p.getCdtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String ultimateOrig = "";
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        PartyIdentification32 debtor = t.getDbtr();
        String recip = SimpleStringElement.getNonNullValue(debtor.getNm());
        String recipAccNumber = null;
        boolean isRecipIban = true;
        AccountNumberInfo recipAccNumberInfo = SEPADebitExtractorV3Iso.getAccountNumberInfo(t.getDbtrAcct().getId().getChoice1());
        if (recipAccNumberInfo != null) {
            recipAccNumber = recipAccNumberInfo.getAccountNumber();
            isRecipIban = recipAccNumberInfo.isFromIbanTag();
        }
        String recipBankCode = SEPADebitExtractorV3Iso.getBankIdentifier(t.getDbtrAgt().getFinInstnId());
        String ultimateRecip = "";
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmount ccyAndAmt = t.getInstdAmt();
        BigDecimal amount = ccyAndAmt.getValue();
        Currency currency = Currency.getInstance(ccyAndAmt.getCcy().getValue());
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String paymentCategory = "";
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(p.getPmtTpInf().getCtgyPurp().getChoice1().getCd());
        } else if (t.getPmtTpInf() != null && t.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(t.getPmtTpInf().getCtgyPurp().getChoice1().getCd());
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        String debitType = "";
        String sequenceType = "";
        PaymentTypeInformation20 pmtTpInf = t.getPmtTpInf();
        if (pmtTpInf == null) {
            pmtTpInf = p.getPmtTpInf();
        }
        if (pmtTpInf != null) {
            debitType = SEPADebitExtractorV3Iso.getDebitType(pmtTpInf);
            sequenceType = SimpleStringElement.getNonNullValue(pmtTpInf.getSeqTp());
        }
        String creditorId = null;
        creditorId = t.getDrctDbtTx() != null && t.getDrctDbtTx().getCdtrSchmeId() != null ? SEPADebitExtractorV3Iso.getCreditorId(t.getDrctDbtTx().getCdtrSchmeId()) : (p.getCdtrSchmeId() != null ? SEPADebitExtractorV3Iso.getCreditorId(p.getCdtrSchmeId()) : "");
        String mandateId = "";
        YYMMDD mandateSignDate = null;
        MandateRelatedInformation6 mandateRelatedInformation6 = mandateInfo = t.getDrctDbtTx() != null ? t.getDrctDbtTx().getMndtRltdInf() : null;
        if (mandateInfo != null) {
            mandateId = SimpleStringElement.getNonNullValue(mandateInfo.getMndtId());
            if (mandateInfo.getDtOfSgntr() != null) {
                mandateSignDate = mandateInfo.getDtOfSgntr().getDate();
            }
        }
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBankCode, ultimateRecip, amount, currency, executionDate, null, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        paymentData.setIsOriginatorIban(isOrigIban);
        paymentData.setIsRecipientIban(isRecipIban);
        paymentData.setAccountCurrency(accountCurrency);
        if (mandateInfo != null && mandateInfo.getAmdmntInd() != null && mandateInfo.getAmdmntInd().booleanValue() && (amendmentInfo = mandateInfo.getAmdmntInfDtls()) != null) {
            if (amendmentInfo.getOrgnlCdtrSchmeId() != null) {
                PersonIdentification5 prvtId;
                if (amendmentInfo.getOrgnlCdtrSchmeId().getNm() != null) {
                    paymentData.setOriginalCreditor(amendmentInfo.getOrgnlCdtrSchmeId().getNm().getValue());
                }
                if (amendmentInfo.getOrgnlCdtrSchmeId().getId() != null && (prvtId = amendmentInfo.getOrgnlCdtrSchmeId().getId().getChoice1().getPrvtId()) != null && prvtId.getOthrs().size() > 0) {
                    prvtId.getOthrs().get(0).getId();
                    paymentData.setOriginalCreditorId(prvtId.getOthrs().get(0).getId().getValue());
                }
            }
            if (amendmentInfo.getOrgnlMndtId() != null) {
                paymentData.setOriginalMandateId(amendmentInfo.getOrgnlMndtId().getValue());
            }
            if (amendmentInfo.getOrgnlDbtrAcct() != null) {
                AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = amendmentInfo.getOrgnlDbtrAcct().getId().getChoice1();
                if (c1.getIBAN() != null) {
                    paymentData.setOriginalRecipientIban(c1.getIBAN().getValue());
                } else {
                    paymentData.setRecipientAccountHasChanged(true);
                }
            } else if (amendmentInfo.getOrgnlDbtrAgt() != null) {
                FinancialInstitutionIdentification7 financialInstitution = amendmentInfo.getOrgnlDbtrAgt().getFinInstnId();
                if (financialInstitution.getBIC() != null) {
                    paymentData.setOriginalRecipientBic(financialInstitution.getBIC().getValue());
                } else {
                    paymentData.setRecipientBankHasChanged(true);
                }
            }
        }
        SEPADebitExtractorV3Iso.setPurposeInformation(t.getRmtInf(), paymentData);
        if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getChoice1().getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        paymentData.setOriginatorAddressData(SEPADebitExtractorV3Iso.getAddress(creditor.getPstlAdr()));
        paymentData.setRecipientAddressData(SEPADebitExtractorV3Iso.getAddress(debtor.getPstlAdr()));
        return paymentData;
    }

    public static AccountNumberInfo getAccountNumberInfo(AccountIdentification4Choice.AccountIdentification4Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return new AccountNumberInfo(choice.getIBAN().getValue(), true);
        }
        if (choice.getOthr() != null) {
            return new AccountNumberInfo(choice.getOthr().getId().getValue(), false);
        }
        return null;
    }

    public static String getBankIdentifier(FinancialInstitutionIdentification7 choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        if (choice.getOthr() != null) {
            String othrId = choice.getOthr().getId().getValue();
            if ("NOTPROVIDED".equals(othrId)) {
                return "";
            }
            return othrId;
        }
        return null;
    }

    public static String getDebitType(PaymentTypeInformation20 pmtTpInf) {
        if (pmtTpInf != null && pmtTpInf.getLclInstrm() != null) {
            return SimpleStringElement.getNonNullValue(pmtTpInf.getLclInstrm().getChoice1().getCd());
        }
        return "";
    }

    private static String getCreditorId(PartyIdentification32 cdtrSchmeId) {
        PersonIdentification5 prvtId;
        if (cdtrSchmeId != null && cdtrSchmeId.getId() != null && (prvtId = cdtrSchmeId.getId().getChoice1().getPrvtId()) != null && prvtId.getOthrs().size() > 0) {
            return SimpleStringElement.getNonNullValue(prvtId.getOthrs().get(0).getId());
        }
        return "";
    }

    private static void setPurposeInformation(RemittanceInformation5 rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            List<Max140Text> unstructuredLines = rmtInf.getUstrds();
            List<StructuredRemittanceInformation7> structuredInfoList = rmtInf.getStrds();
            if (unstructuredLines != null && unstructuredLines.size() > 0) {
                paymentData.setHasStructuredPurpose(false);
                StringBuilder sb = new StringBuilder();
                for (Max140Text purposeLine : unstructuredLines) {
                    String s = purposeLine.getValue();
                    paymentData.getUnstructuredPurposeLines().add(s);
                    sb.append(s);
                }
                paymentData.setPurpose(sb.toString());
            } else if (structuredInfoList != null && structuredInfoList.size() > 0) {
                CreditorReferenceInformation2 cdtrRefInf;
                paymentData.setHasStructuredPurpose(true);
                StructuredRemittanceInformation7 structuredInfo = structuredInfoList.get(0);
                List<Max140Text> purposeLines = structuredInfo.getAddtlRmtInfs();
                if (purposeLines.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (Max140Text purposeLine : purposeLines) {
                        String s = purposeLine.getValue();
                        paymentData.getStructuredPurposeLines().add(s);
                        sb.append(s);
                    }
                    paymentData.setPurpose(sb.toString());
                }
                if ((cdtrRefInf = structuredInfo.getCdtrRefInf()) != null) {
                    CreditorReferenceType2 tp;
                    if (cdtrRefInf.getRef() != null) {
                        paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                    }
                    if ((tp = cdtrRefInf.getTp()) != null) {
                        CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1 c = tp.getCdOrPrtry().getChoice1();
                        if (c.getCd() != null) {
                            paymentData.setPurposeReferenceTypeCode(c.getCd().getValue());
                        } else if (c.getPrtry() != null) {
                            paymentData.setPurposeReferenceTypePrtry(c.getPrtry().getValue());
                        }
                    }
                }
            }
        }
    }

    public static Document getDebitDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformation4 logicalFile = SEPADebitExtractorV3Iso.getLogicalFile("TempMessageId", paymentData.getBatchBooking(), paymentList);
        GroupHeader39 grpHdr = SEPADebitExtractorV3Iso.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformation4> logicalFiles = new ArrayList<PaymentInstructionInformation4>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                btchBookg = paymentList.get(0).getBatchBooking();
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV3Iso.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeader39 grpHdr = SEPADebitExtractorV3Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        return new Document(new CustomerDirectDebitInitiationV02(grpHdr, logicalFiles));
    }

    private static GroupHeader39 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        GroupHeader39 grpHdr = new GroupHeader39(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), SEPADebitExtractorV3Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformation4 getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        PostalAddress6 pstlAdr;
        SEPAPaymentData firstPayment = paymentList.get(0);
        ISODate execDate = SEPADebitExtractorV3Iso.getDate(firstPayment.getExecutionDate());
        PartyIdentification32 cdtr = SEPADebitExtractorV3Iso.getParty(firstPayment.getOriginator());
        CashAccount16 cdtrAcct = SEPADebitExtractorV3Iso.getAccountId(firstPayment.getOriginatorIban());
        BranchAndFinancialInstitutionIdentification4 cdtrAgt = SEPADebitExtractorV3Iso.getBankId(firstPayment.getOriginatorBic());
        if (firstPayment.getAccountCurrency() != null) {
            cdtrAcct.setCcy(new ActiveOrHistoricCurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstructionInformation4 logicalFile = new PaymentInstructionInformation4(new Max35Text(logicalFileId), new PaymentMethod2Code("DD"), execDate, cdtr, cdtrAcct, cdtrAgt, SEPADebitExtractorV3Iso.getTransactions(logicalFileId, paymentList));
        BigDecimal controlSum = BigDecimal.ZERO;
        for (SEPAPaymentData p : paymentList) {
            controlSum = controlSum.add(p.getAmount());
        }
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(paymentList.size())));
        logicalFile.setPmtTpInf(SEPADebitExtractorV3Iso.getPaymentTypeInfo(firstPayment.getDebitType(), firstPayment.getSequenceType(), firstPayment.getPaymentCategory()));
        String creditorId = firstPayment.getCreditorId();
        if (creditorId != null && creditorId.trim().length() > 0) {
            logicalFile.setCdtrSchmeId(SEPADebitExtractorV3Iso.getPartyFromId(creditorId.trim()));
        }
        logicalFile.setChrgBr(new ChargeBearerType1Code("SLEV"));
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        if ((pstlAdr = SEPADebitExtractorV3Iso.saveAddress(firstPayment.getOriginatorAddressData())) != null) {
            cdtr.setPstlAdr(pstlAdr);
        }
        return logicalFile;
    }

    private static PaymentTypeInformation20 getPaymentTypeInfo(String debitType, String sequenceType, String paymentCategory) {
        PaymentTypeInformation20 pmtTpInf = new PaymentTypeInformation20();
        LocalInstrument2Choice choice = SEPADebitExtractorV3Iso.getDebitType(debitType);
        if (choice != null) {
            pmtTpInf.setLclInstrm(choice);
        }
        pmtTpInf.setSeqTp(SEPADebitExtractorV3Iso.getSequenceType(sequenceType));
        ServiceLevel8Choice svcLvl = new ServiceLevel8Choice(ServiceLevel8Choice.ServiceLevel8Choice_C1.fromCd(new ExternalServiceLevel1Code(GeneralSEPAExtractor.SEPA)));
        pmtTpInf.setSvcLvl(svcLvl);
        if (paymentCategory != null && paymentCategory.length() > 0) {
            ExternalCategoryPurpose1Code cd = new ExternalCategoryPurpose1Code(paymentCategory);
            CategoryPurpose1Choice.CategoryPurpose1Choice_C1 c1 = CategoryPurpose1Choice.CategoryPurpose1Choice_C1.fromCd(cd);
            pmtTpInf.setCtgyPurp(new CategoryPurpose1Choice(c1));
        }
        return pmtTpInf;
    }

    private static List<DirectDebitTransactionInformation9> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformation9> transactions = new ArrayList<DirectDebitTransactionInformation9>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purposeCode;
            String ultimateDebitor;
            String ultimateCreditor;
            DirectDebitTransaction6 mandateInfo;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.trim().length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            ActiveOrHistoricCurrencyAndAmount ccyAndAmt = SEPADebitExtractorV3Iso.getCurrencyAndAmount(paymentData.getAmount(), paymentData.getCurrency());
            PartyIdentification32 dbtr = SEPADebitExtractorV3Iso.getParty(paymentData.getRecipient());
            BranchAndFinancialInstitutionIdentification4 dbtrAgt = SEPADebitExtractorV3Iso.getBankId(paymentData.getRecipientBic());
            CashAccount16 dbtrAcct = SEPADebitExtractorV3Iso.getAccountId(paymentData.getRecipientIban());
            DirectDebitTransactionInformation9 transaction = new DirectDebitTransactionInformation9(pmtId, ccyAndAmt, dbtrAgt, dbtr, dbtrAcct);
            PostalAddress6 pstlAdr = SEPADebitExtractorV3Iso.saveAddress(paymentData.getRecipientAddressData());
            if (pstlAdr != null) {
                dbtr.setPstlAdr(pstlAdr);
            }
            if ((mandateInfo = SEPADebitExtractorV3Iso.getMandateInfo(paymentData.getMandateId(), paymentData.getMandateSignDate())) != null) {
                transaction.setDrctDbtTx(mandateInfo);
            }
            if ((ultimateCreditor = paymentData.getUltimateOriginator()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPADebitExtractorV3Iso.getParty(ultimateCreditor));
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPADebitExtractorV3Iso.getParty(ultimateDebitor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose2Choice(Purpose2Choice.Purpose2Choice_C1.fromCd(new ExternalPurpose1Code(purposeCode.trim()))));
            }
            transaction.setRmtInf(SEPADebitExtractorV3Iso.getRemittanceInfo(paymentData));
            transactions.add(transaction);
        }
        return transactions;
    }

    private static RemittanceInformation5 getRemittanceInfo(SEPAPaymentData paymentData) {
        RemittanceInformation5 remittanceInfo = null;
        if (paymentData.hasStructuredPurpose()) {
            List<String> purposeLines;
            StructuredRemittanceInformation7 structured = null;
            String purposeReference = StringUtils.checkNullAndTrim(paymentData.getPurposeReference());
            if (purposeReference.length() > 0) {
                CreditorReferenceInformation2 cdtrRefInf = new CreditorReferenceInformation2();
                cdtrRefInf.setRef(new Max35Text(paymentData.getPurposeReference()));
                CreditorReferenceType2 tp = SEPADebitExtractorV3Iso.getPurposeReferenceType(paymentData);
                if (tp != null) {
                    cdtrRefInf.setTp(tp);
                }
                structured = new StructuredRemittanceInformation7();
                structured.setCdtrRefInf(cdtrRefInf);
            }
            if ((purposeLines = paymentData.getStructuredPurposeLines()).size() > 0) {
                if (structured == null) {
                    structured = new StructuredRemittanceInformation7();
                }
                for (String purposeLine : purposeLines) {
                    structured.getAddtlRmtInfs().add(new Max140Text(purposeLine));
                }
            }
            if (structured != null) {
                remittanceInfo = new RemittanceInformation5();
                remittanceInfo.getStrds().add(structured);
            }
        } else {
            String purpose = StringUtils.checkNullAndTrim(paymentData.getPurpose());
            if (purpose.length() > 0) {
                remittanceInfo = new RemittanceInformation5();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
            }
        }
        return remittanceInfo;
    }

    private static CreditorReferenceType2 getPurposeReferenceType(SEPAPaymentData paymentData) {
        CreditorReferenceType1Choice choice = null;
        String structuredTypeCode = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypeCode());
        if (structuredTypeCode.length() > 0) {
            DocumentType3Code code = new DocumentType3Code(structuredTypeCode);
            choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromCd(code));
        } else {
            String structuredTypePrtry = StringUtils.checkNullAndTrim(paymentData.getPurposeReferenceTypePrtry());
            if (structuredTypePrtry.length() > 0) {
                Max35Text prtry = new Max35Text(structuredTypePrtry);
                choice = new CreditorReferenceType1Choice(CreditorReferenceType1Choice.CreditorReferenceType1Choice_C1.fromPrtry(prtry));
            }
        }
        if (choice != null) {
            return new CreditorReferenceType2(choice);
        }
        return null;
    }

    private static DirectDebitTransaction6 getMandateInfo(String mandateId, Date mandateSignDate) {
        MandateRelatedInformation6 mndtRltdInf = null;
        if (mandateId != null && mandateId.trim().length() > 0) {
            mndtRltdInf = new MandateRelatedInformation6();
            mndtRltdInf.setMndtId(new Max35Text(mandateId.trim()));
        }
        if (mandateSignDate != null) {
            if (mndtRltdInf == null) {
                mndtRltdInf = new MandateRelatedInformation6();
            }
            mndtRltdInf.setDtOfSgntr(SEPADebitExtractorV3Iso.getDate(mandateSignDate));
        }
        if (mndtRltdInf != null) {
            DirectDebitTransaction6 drctDbtTx = new DirectDebitTransaction6();
            drctDbtTx.setMndtRltdInf(mndtRltdInf);
            return drctDbtTx;
        }
        return null;
    }

    private static PartyIdentification32 getParty(String name) {
        PartyIdentification32 party = new PartyIdentification32();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max140Text(name));
        }
        return party;
    }

    private static PartyIdentification32 getPartyFromId(String id) {
        GenericPersonIdentification1 othr = new GenericPersonIdentification1(new Max35Text(id));
        othr.setSchmeNm(new PersonIdentificationSchemeName1Choice(PersonIdentificationSchemeName1Choice.PersonIdentificationSchemeName1Choice_C1.fromPrtry(new Max35Text(GeneralSEPAExtractor.SEPA))));
        PersonIdentification5 prvtId = new PersonIdentification5();
        prvtId.getOthrs().add(othr);
        PartyIdentification32 party = new PartyIdentification32();
        party.setId(new Party6Choice(Party6Choice.Party6Choice_C1.fromPrvtId(prvtId)));
        return party;
    }

    private static BranchAndFinancialInstitutionIdentification4 getBankId(String bic) {
        FinancialInstitutionIdentification7 id = new FinancialInstitutionIdentification7();
        if (bic != null && bic.trim().length() >= 8) {
            id.setBIC(new BICIdentifier(bic.trim()));
        } else {
            id.setOthr(new GenericFinancialIdentification1(new Max35Text("NOTPROVIDED")));
        }
        return new BranchAndFinancialInstitutionIdentification4(id);
    }

    private static CashAccount16 getAccountId(String iban) {
        AccountIdentification4Choice.AccountIdentification4Choice_C1 c1 = null;
        c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification4Choice.AccountIdentification4Choice_C1.fromIBAN(new IBAN2007Identifier(iban)) : AccountIdentification4Choice.AccountIdentification4Choice_C1.fromOthr(new GenericAccountIdentification1(new Max34Text(iban)));
        return new CashAccount16(new AccountIdentification4Choice(c1));
    }

    private static ActiveOrHistoricCurrencyAndAmount getCurrencyAndAmount(BigDecimal amt, Currency c) {
        ActiveOrHistoricCurrencyCode ccy = new ActiveOrHistoricCurrencyCode(c.getCurrencyCode());
        return new ActiveOrHistoricCurrencyAndAmount(amt, ccy);
    }

    public static ISODate getDate(Date date) {
        return new ISODate(new YYMMDD(date.getTime()));
    }

    private static LocalInstrument2Choice getDebitType(String debitType) {
        if (debitType != null && debitType.length() > 0) {
            ExternalLocalInstrument1Code code = new ExternalLocalInstrument1Code(debitType);
            LocalInstrument2Choice.LocalInstrument2Choice_C1 c1 = LocalInstrument2Choice.LocalInstrument2Choice_C1.fromCd(code);
            return new LocalInstrument2Choice(c1);
        }
        return null;
    }

    private static SequenceType1Code getSequenceType(String seqType) {
        if ("FRST".equals(seqType)) {
            return new SequenceType1Code("FRST");
        }
        if ("RCUR".equals(seqType)) {
            return new SequenceType1Code("RCUR");
        }
        if ("FNAL".equals(seqType)) {
            return new SequenceType1Code("FNAL");
        }
        return new SequenceType1Code("OOFF");
    }

    private static AddressData getAddress(PostalAddress6 address) {
        if (address != null) {
            AddressData addressData = new AddressData();
            for (Max70Text line : address.getAdrLines()) {
                addressData.getAddressLines().add(line.getValue());
            }
            CountryCode countryCode = address.getCtry();
            if (countryCode != null) {
                addressData.setCountry(countryCode.getValue());
            }
            addressData.setDepartment(SimpleStringElement.getValue(address.getDept()));
            addressData.setSubDepartment(SimpleStringElement.getValue(address.getSubDept()));
            addressData.setStreetName(SimpleStringElement.getValue(address.getStrtNm()));
            addressData.setBuildingNumber(SimpleStringElement.getValue(address.getBldgNb()));
            addressData.setPostCode(SimpleStringElement.getValue(address.getPstCd()));
            addressData.setTownName(SimpleStringElement.getValue(address.getTwnNm()));
            addressData.setCountrySubDivision(SimpleStringElement.getValue(address.getCtrySubDvsn()));
            return addressData;
        }
        return null;
    }

    private static PostalAddress6 saveAddress(AddressData addressData) {
        if (addressData != null) {
            PostalAddress6 pstlAdr = null;
            String countryCode = addressData.getCountry();
            if (countryCode != null && countryCode.trim().length() == 2) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setCtry(new CountryCode(countryCode.trim()));
            }
            if (addressData.getAddressLines().size() > 0) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                for (String line : addressData.getAddressLines()) {
                    pstlAdr.getAdrLines().add(new Max70Text(line));
                }
            }
            if (addressData.getDepartment() != null && !addressData.getDepartment().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setDept(new Max70Text(addressData.getDepartment()));
            }
            if (addressData.getSubDepartment() != null && !addressData.getSubDepartment().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setSubDept(new Max70Text(addressData.getSubDepartment()));
            }
            if (addressData.getStreetName() != null && !addressData.getStreetName().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setStrtNm(new Max70Text(addressData.getStreetName()));
            }
            if (addressData.getBuildingNumber() != null && !addressData.getBuildingNumber().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setBldgNb(new Max16Text(addressData.getBuildingNumber()));
            }
            if (addressData.getPostCode() != null && !addressData.getPostCode().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setPstCd(new Max16Text(addressData.getPostCode()));
            }
            if (addressData.getTownName() != null && !addressData.getTownName().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setTwnNm(new Max35Text(addressData.getTownName()));
            }
            if (addressData.getCountrySubDivision() != null && !addressData.getCountrySubDivision().isEmpty()) {
                if (pstlAdr == null) {
                    pstlAdr = new PostalAddress6();
                }
                pstlAdr.setCtrySubDvsn(new Max35Text(addressData.getCountrySubDivision()));
            }
            return pstlAdr;
        }
        return null;
    }
}

