/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.pain00800202.AccountIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800202.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.sepa.pain00800202.ActiveOrHistoricCurrencyCodeEUR;
import de.businesslogics.format.sepa.pain00800202.BICIdentifier;
import de.businesslogics.format.sepa.pain00800202.BatchBookingIndicator;
import de.businesslogics.format.sepa.pain00800202.BranchAndFinancialInstitutionIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800202.CashAccountSEPA1;
import de.businesslogics.format.sepa.pain00800202.CashAccountSEPA2;
import de.businesslogics.format.sepa.pain00800202.CategoryPurposeSEPA;
import de.businesslogics.format.sepa.pain00800202.ChargeBearerTypeSEPACode;
import de.businesslogics.format.sepa.pain00800202.CustomerDirectDebitInitiationV02;
import de.businesslogics.format.sepa.pain00800202.DecimalNumber;
import de.businesslogics.format.sepa.pain00800202.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800202.DirectDebitTransactionSDD;
import de.businesslogics.format.sepa.pain00800202.Document;
import de.businesslogics.format.sepa.pain00800202.ExternalCategoryPurpose1Code;
import de.businesslogics.format.sepa.pain00800202.ExternalPurpose1Code;
import de.businesslogics.format.sepa.pain00800202.FinancialInstitutionIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800202.GroupHeaderSDD;
import de.businesslogics.format.sepa.pain00800202.IBAN2007Identifier;
import de.businesslogics.format.sepa.pain00800202.ISODate;
import de.businesslogics.format.sepa.pain00800202.ISODateTime;
import de.businesslogics.format.sepa.pain00800202.IdentificationSchemeNameSEPA;
import de.businesslogics.format.sepa.pain00800202.LocalInstrumentSEPA;
import de.businesslogics.format.sepa.pain00800202.LocalInstrumentSEPACode;
import de.businesslogics.format.sepa.pain00800202.MandateRelatedInformationSDD;
import de.businesslogics.format.sepa.pain00800202.Max140Text;
import de.businesslogics.format.sepa.pain00800202.Max15NumericText;
import de.businesslogics.format.sepa.pain00800202.Max70Text;
import de.businesslogics.format.sepa.pain00800202.PartyIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800202.PartyIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800202.PartyIdentificationSEPA3;
import de.businesslogics.format.sepa.pain00800202.PartyIdentificationSEPA5;
import de.businesslogics.format.sepa.pain00800202.PartySEPA2;
import de.businesslogics.format.sepa.pain00800202.PaymentIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800202.PaymentInstructionInformationSDD;
import de.businesslogics.format.sepa.pain00800202.PaymentMethod2Code;
import de.businesslogics.format.sepa.pain00800202.PaymentTypeInformationSDD;
import de.businesslogics.format.sepa.pain00800202.PersonIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800202.PurposeSEPA;
import de.businesslogics.format.sepa.pain00800202.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.pain00800202.RestrictedIdentificationSEPA1;
import de.businesslogics.format.sepa.pain00800202.RestrictedIdentificationSEPA2;
import de.businesslogics.format.sepa.pain00800202.RestrictedPersonIdentificationSEPA;
import de.businesslogics.format.sepa.pain00800202.RestrictedPersonIdentificationSchemeNameSEPA;
import de.businesslogics.format.sepa.pain00800202.RestrictedPersonIdentifierSEPA;
import de.businesslogics.format.sepa.pain00800202.SequenceType1Code;
import de.businesslogics.format.sepa.pain00800202.ServiceLevelSEPA;
import de.businesslogics.format.sepa.pain00800202.ServiceLevelSEPACode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV3 {
    public static GeneralSEPAWriter.DebitType getDebitType(Document document) {
        PaymentInstructionInformationSDD pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return GeneralSEPAWriter.DebitType.valueOf(pmtInf.getPmtTpInf().getLclInstrm().getCd().getValue());
    }

    public static XMLDate getDateSRZ(Document document) {
        PaymentInstructionInformationSDD pmtInf = document.getCstmrDrctDbtInitn().getPmtInfs().get(0);
        return pmtInf.getReqdColltnDt();
    }

    protected static List<SEPAPaymentData> getPayments(Document document) throws IOException, SAXException {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        CustomerDirectDebitInitiationV02 pain00800201 = document.getCstmrDrctDbtInitn();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInfs()) {
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV3.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) throws IOException, SAXException {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        CustomerDirectDebitInitiationV02 pain00800201 = document.getCstmrDrctDbtInitn();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm().getValue();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInfs()) {
            String pmtInfId = "";
            if (p.getPmtInfId() != null) {
                pmtInfId = p.getPmtInfId().getValue();
            }
            SEPALogicalFile logicalFile = new SEPALogicalFile(pmtInfId, msgId);
            SEPADebitExtractorV3.setAdditionalFields(logicalFile, p.getNbOfTxs(), p.getCtrlSum());
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV3.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V25);
        }
        return logicalFiles;
    }

    private static void setAdditionalFields(SEPALogicalFile logicalFile, Max15NumericText nbOfTxs, DecimalNumber ctrlSum) {
        if (nbOfTxs != null) {
            logicalFile.setNbOfTxs(Long.parseLong(nbOfTxs.getValue()));
        }
        if (ctrlSum != null) {
            logicalFile.setCtrlSum(ctrlSum.getValue());
        }
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformationSDD p, DirectDebitTransactionInformationSDD t) {
        String endToEndId;
        String orig = p.getCdtr().getNm().getValue();
        String origIban = p.getCdtrAcct().getId().getIBAN().getValue();
        String origBic = p.getCdtrAgt().getFinInstnId().getBIC().getValue();
        String ultimateOrig = null;
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getValue(t.getUltmtCdtr().getNm());
        }
        String recip = t.getDbtr().getNm().getValue();
        String recipIban = t.getDbtrAcct().getId().getIBAN().getValue();
        String recipBic = t.getDbtrAgt().getFinInstnId().getBIC().getValue();
        String ultimateRecip = null;
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getValue(t.getUltmtDbtr().getNm());
        }
        BigDecimal amount = t.getInstdAmt().getValue();
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String purpose = null;
        purpose = t.getRmtInf() != null && t.getRmtInf().getChoice1() != null && t.getRmtInf().getChoice1().getUstrd() != null ? t.getRmtInf().getChoice1().getUstrd().getValue() : "";
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null && p.getPmtTpInf().getCtgyPurp().getCd() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getCd().getValue();
        }
        if ("NOTPROVIDED".equals(endToEndId = t.getPmtId().getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = null;
        instructionId = t.getPmtId().getInstrId() != null ? t.getPmtId().getInstrId().getValue() : "";
        String debitType = p.getPmtTpInf().getLclInstrm().getCd().getValue();
        String sequenceType = p.getPmtTpInf().getSeqTp().getValue();
        DirectDebitTransactionSDD ddt = t.getDrctDbtTx();
        String creditorId = null;
        creditorId = ddt.getCdtrSchmeId() != null ? ddt.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : (p.getCdtrSchmeId() != null ? p.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : "");
        String mandateId = ddt.getMndtRltdInf().getMndtId().getValue();
        YYMMDD mandateSignDate = ddt.getMndtRltdInf().getDtOfSgntr().getDate();
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, purpose, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        PurposeSEPA purposeCode = t.getPurp();
        if (purposeCode != null) {
            paymentData.setPurposeCode(purposeCode.getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        return paymentData;
    }

    public static Document getDebitDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        PaymentInstructionInformationSDD logicalFile = SEPADebitExtractorV3.getLogicalFile("TempMessageId", paymentData.displayAsSingleBooking() ? Boolean.FALSE : null, paymentList);
        GroupHeaderSDD grpHdr = SEPADebitExtractorV3.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount());
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        return new Document(cstmrCdtTrfInitn);
    }

    public static Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSDD> logicalFiles = new ArrayList<PaymentInstructionInformationSDD>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            Boolean btchBookg = null;
            if (paymentList != null && paymentList.size() > 0) {
                if (paymentList.get(0).displayAsSingleBooking()) {
                    btchBookg = Boolean.FALSE;
                }
                pmtInfId = paymentList.get(0).getPmtInfId();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV3.getLogicalFile(pmtInfId, btchBookg, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        GroupHeaderSDD grpHdr = SEPADebitExtractorV3.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum);
        CustomerDirectDebitInitiationV02 cstmrCdtTrfInitn = new CustomerDirectDebitInitiationV02(grpHdr);
        for (PaymentInstructionInformationSDD logicalFile : logicalFiles) {
            cstmrCdtTrfInitn.getPmtInfs().add(logicalFile);
        }
        return new Document(cstmrCdtTrfInitn);
    }

    private static GroupHeaderSDD getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum) {
        PartyIdentificationSEPA1 initParty = new PartyIdentificationSEPA1();
        if (messageId != null && !messageId.isEmpty()) {
            initParty.setNm(new Max70Text(initiatingParty));
        }
        GroupHeaderSDD grpHdr = new GroupHeaderSDD(new RestrictedIdentificationSEPA1(messageId), new ISODateTime(), new Max15NumericText(String.valueOf(totalCountTransactions)), initParty);
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        return grpHdr;
    }

    private static PaymentInstructionInformationSDD getLogicalFile(String logicalFileId, Boolean btchBookg, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        LocalInstrumentSEPA debitType = "B2B".equals(firstPayment.getDebitType()) ? new LocalInstrumentSEPA(new LocalInstrumentSEPACode("B2B")) : new LocalInstrumentSEPA(new LocalInstrumentSEPACode("CORE"));
        String seqType = firstPayment.getSequenceType();
        SequenceType1Code sequenceType = "FRST".equals(seqType) ? new SequenceType1Code("FRST") : ("RCUR".equals(seqType) ? new SequenceType1Code("RCUR") : ("FNAL".equals(seqType) ? new SequenceType1Code("FNAL") : new SequenceType1Code("OOFF")));
        PaymentTypeInformationSDD pmtTpInf = new PaymentTypeInformationSDD(new ServiceLevelSEPA(new ServiceLevelSEPACode(GeneralSEPAExtractor.SEPA)), debitType, sequenceType);
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            pmtTpInf.setCtgyPurp(new CategoryPurposeSEPA(new ExternalCategoryPurpose1Code(categoryPurpose)));
        }
        ISODate executionDate = new ISODate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSEPA5 originator = new PartyIdentificationSEPA5(new Max70Text(firstPayment.getOriginator()));
        CashAccountSEPA1 originatorIban = new CashAccountSEPA1(new AccountIdentificationSEPA(new IBAN2007Identifier(firstPayment.getOriginatorIban())));
        BranchAndFinancialInstitutionIdentificationSEPA1 originatorBic = new BranchAndFinancialInstitutionIdentificationSEPA1(new FinancialInstitutionIdentificationSEPA1(new BICIdentifier(firstPayment.getOriginatorBic())));
        PaymentInstructionInformationSDD logicalFile = new PaymentInstructionInformationSDD(new RestrictedIdentificationSEPA1(logicalFileId), new PaymentMethod2Code(GeneralSEPAExtractor.DD), pmtTpInf, executionDate, originator, originatorIban, originatorBic);
        logicalFile.setChrgBr(new ChargeBearerTypeSEPACode(SEPAFeeType.SLEV.name()));
        BigDecimal controlSum = BigDecimal.ZERO;
        if (btchBookg != null) {
            logicalFile.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        for (DirectDebitTransactionInformationSDD t : SEPADebitExtractorV3.getTransactions(logicalFileId, paymentList)) {
            logicalFile.getDrctDbtTxInfs().add(t);
            controlSum = controlSum.add(t.getInstdAmt().getValue());
        }
        logicalFile.setNbOfTxs(new Max15NumericText(String.valueOf(logicalFile.getDrctDbtTxInfs().size())));
        logicalFile.setCtrlSum(new DecimalNumber(controlSum));
        return logicalFile;
    }

    private static List<DirectDebitTransactionInformationSDD> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformationSDD> transactions = new ArrayList<DirectDebitTransactionInformationSDD>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String purposeCode;
            String ultimateDebitor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentificationSEPA pmtId = new PaymentIdentificationSEPA(new RestrictedIdentificationSEPA1((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.length() > 0) {
                pmtId.setInstrId(new RestrictedIdentificationSEPA1(instructionId));
            }
            ActiveOrHistoricCurrencyAndAmountSEPA amount = new ActiveOrHistoricCurrencyAndAmountSEPA(paymentData.getAmount(), new ActiveOrHistoricCurrencyCodeEUR("EUR"));
            PartyIdentificationSEPA2 recipient = new PartyIdentificationSEPA2(new Max70Text(paymentData.getRecipient()));
            CashAccountSEPA2 recipientIban = new CashAccountSEPA2(new AccountIdentificationSEPA(new IBAN2007Identifier(paymentData.getRecipientIban())));
            BranchAndFinancialInstitutionIdentificationSEPA1 recipientBic = new BranchAndFinancialInstitutionIdentificationSEPA1(new FinancialInstitutionIdentificationSEPA1(new BICIdentifier(paymentData.getRecipientBic())));
            RestrictedIdentificationSEPA2 mndtId = new RestrictedIdentificationSEPA2(paymentData.getMandateId());
            ISODate dtOfSgntr = new ISODate(new YYMMDD(paymentData.getMandateSignDate().getTime()));
            MandateRelatedInformationSDD mndtRltdInf = new MandateRelatedInformationSDD(mndtId, dtOfSgntr);
            DirectDebitTransactionSDD drctDbtTx = new DirectDebitTransactionSDD(mndtRltdInf);
            RestrictedPersonIdentifierSEPA cid = new RestrictedPersonIdentifierSEPA(paymentData.getCreditorId());
            RestrictedPersonIdentificationSEPA personId = new RestrictedPersonIdentificationSEPA(cid, new RestrictedPersonIdentificationSchemeNameSEPA(new IdentificationSchemeNameSEPA(GeneralSEPAExtractor.SEPA)));
            PartyIdentificationSEPA3 cdtrSchmeId = new PartyIdentificationSEPA3(new PartySEPA2(new PersonIdentificationSEPA2(personId)));
            drctDbtTx.setCdtrSchmeId(cdtrSchmeId);
            DirectDebitTransactionInformationSDD transaction = new DirectDebitTransactionInformationSDD(pmtId, amount, drctDbtTx, recipientBic, recipient, recipientIban);
            String ultimateCreditor = paymentData.getUltimateOriginator();
            if (ultimateCreditor != null && ultimateCreditor.length() > 0) {
                PartyIdentificationSEPA1 ultmtCdtr = new PartyIdentificationSEPA1();
                ultmtCdtr.setNm(new Max70Text(ultimateCreditor));
                transaction.setUltmtCdtr(ultmtCdtr);
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                PartyIdentificationSEPA1 ultmtDbtr = new PartyIdentificationSEPA1();
                ultmtDbtr.setNm(new Max70Text(ultimateDebitor));
                transaction.setUltmtDbtr(ultmtDbtr);
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new PurposeSEPA(new ExternalPurpose1Code(purposeCode.trim())));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                RemittanceInformationSEPA1Choice rmtInf = new RemittanceInformationSEPA1Choice(RemittanceInformationSEPA1Choice.RemittanceInformationSEPA1Choice_C1.fromUstrd(new Max140Text(purpose)));
                transaction.setRmtInf(rmtInf);
            }
            transactions.add(transaction);
        }
        return transactions;
    }
}

