/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.ChoiceList;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.iso20022.pain00800101.AccountIdentification3Choice;
import de.businesslogics.format.iso20022.pain00800101.BICIdentifier;
import de.businesslogics.format.iso20022.pain00800101.BatchBookingIndicator;
import de.businesslogics.format.iso20022.pain00800101.BranchAndFinancialInstitutionIdentification3;
import de.businesslogics.format.iso20022.pain00800101.CashAccount7;
import de.businesslogics.format.iso20022.pain00800101.ChargeBearerType1Code;
import de.businesslogics.format.iso20022.pain00800101.ClearingSystemMemberIdentification3Choice;
import de.businesslogics.format.iso20022.pain00800101.CurrencyAndAmount;
import de.businesslogics.format.iso20022.pain00800101.CurrencyCode;
import de.businesslogics.format.iso20022.pain00800101.DecimalNumber;
import de.businesslogics.format.iso20022.pain00800101.DirectDebitTransaction1;
import de.businesslogics.format.iso20022.pain00800101.DirectDebitTransactionInformation1;
import de.businesslogics.format.iso20022.pain00800101.Document;
import de.businesslogics.format.iso20022.pain00800101.ExternalLocalInstrumentCode;
import de.businesslogics.format.iso20022.pain00800101.ExternalPurposeCode;
import de.businesslogics.format.iso20022.pain00800101.FinancialInstitutionIdentification5Choice;
import de.businesslogics.format.iso20022.pain00800101.GenericIdentification4;
import de.businesslogics.format.iso20022.pain00800101.GroupHeader1;
import de.businesslogics.format.iso20022.pain00800101.Grouping1Code;
import de.businesslogics.format.iso20022.pain00800101.IBANIdentifier;
import de.businesslogics.format.iso20022.pain00800101.ISODate;
import de.businesslogics.format.iso20022.pain00800101.ISODateTime;
import de.businesslogics.format.iso20022.pain00800101.LocalInstrument1Choice;
import de.businesslogics.format.iso20022.pain00800101.MandateRelatedInformation1;
import de.businesslogics.format.iso20022.pain00800101.Max140Text;
import de.businesslogics.format.iso20022.pain00800101.Max15NumericText;
import de.businesslogics.format.iso20022.pain00800101.Max34Text;
import de.businesslogics.format.iso20022.pain00800101.Max35Text;
import de.businesslogics.format.iso20022.pain00800101.Max70Text;
import de.businesslogics.format.iso20022.pain00800101.Pain_008_001_01;
import de.businesslogics.format.iso20022.pain00800101.Party2Choice;
import de.businesslogics.format.iso20022.pain00800101.PartyIdentification8;
import de.businesslogics.format.iso20022.pain00800101.PaymentCategoryPurpose1Code;
import de.businesslogics.format.iso20022.pain00800101.PaymentIdentification1;
import de.businesslogics.format.iso20022.pain00800101.PaymentInstructionInformation2;
import de.businesslogics.format.iso20022.pain00800101.PaymentMethod2Code;
import de.businesslogics.format.iso20022.pain00800101.PaymentTypeInformation2;
import de.businesslogics.format.iso20022.pain00800101.PersonIdentification3;
import de.businesslogics.format.iso20022.pain00800101.Purpose1Choice;
import de.businesslogics.format.iso20022.pain00800101.RemittanceInformation1;
import de.businesslogics.format.iso20022.pain00800101.SequenceType1Code;
import de.businesslogics.format.iso20022.pain00800101.ServiceLevel2Code;
import de.businesslogics.format.iso20022.pain00800101.ServiceLevel3Choice;
import de.businesslogics.format.iso20022.pain00800101.SimpleIdentificationInformation2;
import de.businesslogics.format.iso20022.pain00800101.StructuredRemittanceInformation6;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV2Iso {
    private static final String MIXD = "MIXD";

    protected static List<SEPALogicalFile> getLogicalFiles(Document document) {
        Pain_008_001_01 pain00800101 = document.getPain_008_001_01();
        GroupHeader1 grpHdr = pain00800101.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        for (PaymentInstructionInformation2 p : pain00800101.getPmtInfs()) {
            SEPALogicalFile logicalFile = new SEPALogicalFile(SimpleStringElement.getNonNullValue(p.getPmtInfId()), msgId);
            for (DirectDebitTransactionInformation1 c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV2Iso.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        return logicalFiles;
    }

    protected static List<SEPAPaymentData> getPayments(Document document) {
        Pain_008_001_01 pain00800101 = document.getPain_008_001_01();
        GroupHeader1 grpHdr = pain00800101.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformation2 p : pain00800101.getPmtInfs()) {
            for (DirectDebitTransactionInformation1 c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV2Iso.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformation2 p, DirectDebitTransactionInformation1 t) {
        String orig = SimpleStringElement.getNonNullValue(p.getCdtr().getNm());
        String origAccNumber = SEPADebitExtractorV2Iso.getAccountIdentifier(p.getCdtrAcct().getId().getChoice1());
        String origBankCode = SEPADebitExtractorV2Iso.getBankIdentifier(p.getCdtrAgt().getFinInstnId().getChoice1());
        Currency accountCurrency = null;
        CurrencyCode ccy = p.getCdtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String ultimateOrig = "";
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        String recip = SimpleStringElement.getNonNullValue(t.getDbtr().getNm());
        String recipAccNumber = SEPADebitExtractorV2Iso.getAccountIdentifier(t.getDbtrAcct().getId().getChoice1());
        String recipBankCode = SEPADebitExtractorV2Iso.getBankIdentifier(t.getDbtrAgt().getFinInstnId().getChoice1());
        String ultimateRecip = "";
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        CurrencyAndAmount ccyAndAmt = t.getInstdAmt();
        BigDecimal amount = ccyAndAmt.getValue();
        Currency currency = Currency.getInstance(ccyAndAmt.getCcy().getValue());
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String purpose = SEPADebitExtractorV2Iso.getPurpose(t.getRmtInf());
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        String paymentCategory = "";
        String debitType = "";
        String sequenceType = "";
        PaymentTypeInformation2 pmtTpInf = p.getPmtTpInf();
        if (pmtTpInf != null) {
            paymentCategory = SimpleStringElement.getNonNullValue(pmtTpInf.getCtgyPurp());
            debitType = SEPADebitExtractorV2Iso.getDebitType(pmtTpInf);
            sequenceType = SimpleStringElement.getNonNullValue(pmtTpInf.getSeqTp());
        }
        String creditorId = "";
        String mandateId = "";
        YYMMDD mandateSignDate = null;
        DirectDebitTransaction1 ddt = t.getDrctDbtTx();
        if (ddt != null) {
            creditorId = SEPADebitExtractorV2Iso.getCreditorId(ddt.getCdtrSchmeId());
            if (ddt.getMndtRltdInf() != null) {
                mandateId = SimpleStringElement.getNonNullValue(ddt.getMndtRltdInf().getMndtId());
                if (ddt.getMndtRltdInf().getDtOfSgntr() != null) {
                    mandateSignDate = ddt.getMndtRltdInf().getDtOfSgntr().getDate();
                }
            }
        }
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, orig, origAccNumber, origBankCode, ultimateOrig, recip, recipAccNumber, recipBankCode, ultimateRecip, amount, currency, executionDate, purpose, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        paymentData.setAccountCurrency(accountCurrency);
        if (t.getPurp() != null && t.getPurp().getChoice1().getCd() != null) {
            paymentData.setPurposeCode(t.getPurp().getChoice1().getCd().getValue());
        }
        return paymentData;
    }

    public static String getAccountIdentifier(AccountIdentification3Choice.AccountIdentification3Choice_C1 choice) {
        if (choice.getIBAN() != null) {
            return choice.getIBAN().getValue();
        }
        if (choice.getPrtryAcct() != null) {
            return choice.getPrtryAcct().getId().getValue();
        }
        if (choice.getBBAN() != null) {
            return choice.getBBAN().getValue();
        }
        if (choice.getUPIC() != null) {
            return choice.getUPIC().getValue();
        }
        return null;
    }

    public static String getBankIdentifier(FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1 choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        if (choice.getPrtryId() != null) {
            return choice.getPrtryId().getId().getValue();
        }
        if (choice.getClrSysMmbId() != null) {
            ClearingSystemMemberIdentification3Choice.ClearingSystemMemberIdentification3Choice_C1 c = choice.getClrSysMmbId().getChoice1();
            if (c.getId() != null) {
                return c.getId().getValue();
            }
            if (c.getPrtry() != null) {
                return c.getPrtry().getValue();
            }
            return null;
        }
        if (choice.getCmbndId() != null) {
            if (choice.getCmbndId().getBIC() != null) {
                return choice.getCmbndId().getBIC().getValue();
            }
            return null;
        }
        if (choice.getNmAndAdr() != null) {
            return choice.getNmAndAdr().getNm().getValue();
        }
        return null;
    }

    public static String getDebitType(PaymentTypeInformation2 pmtTpInf) {
        if (pmtTpInf != null && pmtTpInf.getLclInstrm() != null) {
            return SimpleStringElement.getNonNullValue(pmtTpInf.getLclInstrm().getChoice1().getCd());
        }
        return "";
    }

    private static String getCreditorId(PartyIdentification8 cdtrSchmeId) {
        GenericIdentification4 othrId;
        ChoiceList<PersonIdentification3> prvtIds;
        if (cdtrSchmeId != null && cdtrSchmeId.getId() != null && (prvtIds = cdtrSchmeId.getId().getChoice1().getPrvtIds()) != null && prvtIds.size() > 0 && (othrId = ((PersonIdentification3)prvtIds.get(0)).getChoice1().getOthrId()) != null) {
            return SimpleStringElement.getNonNullValue(othrId.getId());
        }
        return "";
    }

    protected static String getPurpose(RemittanceInformation1 rmtInf) {
        if (rmtInf != null) {
            StringBuilder sb = new StringBuilder();
            if (rmtInf.getUstrds().size() > 0) {
                for (Max140Text text : rmtInf.getUstrds()) {
                    sb.append(SimpleStringElement.getNonNullValue(text));
                }
            } else if (rmtInf.getStrds().size() > 0) {
                for (StructuredRemittanceInformation6 s : rmtInf.getStrds()) {
                    if (s.getRfrdDocInf() == null) continue;
                    sb.append(SimpleStringElement.getNonNullValue(s.getRfrdDocInf().getRfrdDocNb()));
                }
            }
            return sb.toString();
        }
        return "";
    }

    public static Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        boolean displayAsSingleBooking = false;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformation2> logicalFiles = new ArrayList<PaymentInstructionInformation2>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            if (paymentList != null && paymentList.size() > 0) {
                SEPAPaymentData first = paymentList.get(0);
                pmtInfId = first.getPmtInfId();
                displayAsSingleBooking = first.displayAsSingleBooking();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV2Iso.getLogicalFile(pmtInfId, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        Boolean btchBookg = displayAsSingleBooking ? Boolean.FALSE : null;
        GroupHeader1 grpHdr = SEPADebitExtractorV2Iso.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum, btchBookg);
        return new Document(new Pain_008_001_01(grpHdr, logicalFiles));
    }

    private static GroupHeader1 getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum, Boolean btchBookg) {
        GroupHeader1 grpHdr = new GroupHeader1(new Max35Text(messageId), new ISODateTime(new Date()), new Max15NumericText(String.valueOf(totalCountTransactions)), new Grouping1Code(MIXD), SEPADebitExtractorV2Iso.getParty(initiatingParty));
        grpHdr.setCtrlSum(new DecimalNumber(controlSum));
        if (btchBookg != null) {
            grpHdr.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return grpHdr;
    }

    private static PaymentInstructionInformation2 getLogicalFile(String logicalFileId, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        ISODate execDate = SEPADebitExtractorV2Iso.getDate(firstPayment.getExecutionDate());
        PartyIdentification8 cdtr = SEPADebitExtractorV2Iso.getParty(firstPayment.getOriginator());
        CashAccount7 cdtrAcct = SEPADebitExtractorV2Iso.getAccountId(firstPayment.getOriginatorIban());
        BranchAndFinancialInstitutionIdentification3 cdtrAgt = SEPADebitExtractorV2Iso.getBankId(firstPayment.getOriginatorBic());
        if (firstPayment.getAccountCurrency() != null) {
            cdtrAcct.setCcy(new CurrencyCode(firstPayment.getAccountCurrency().getCurrencyCode()));
        }
        PaymentInstructionInformation2 logicalFile = new PaymentInstructionInformation2(new PaymentMethod2Code("DD"), execDate, cdtr, cdtrAcct, cdtrAgt, SEPADebitExtractorV2Iso.getTransactions(logicalFileId, paymentList));
        logicalFile.setPmtTpInf(SEPADebitExtractorV2Iso.getPaymentTypeInfo(firstPayment.getDebitType(), firstPayment.getSequenceType(), firstPayment.getPaymentCategory()));
        logicalFile.setPmtInfId(new Max35Text(logicalFileId));
        logicalFile.setChrgBr(new ChargeBearerType1Code("SLEV"));
        return logicalFile;
    }

    private static PaymentTypeInformation2 getPaymentTypeInfo(String debitType, String sequenceType, String paymentCategory) {
        PaymentTypeInformation2 pmtTpInf = new PaymentTypeInformation2();
        ServiceLevel2Code cd = new ServiceLevel2Code(GeneralSEPAExtractor.SEPA);
        ServiceLevel3Choice svcLvl = new ServiceLevel3Choice(ServiceLevel3Choice.ServiceLevel3Choice_C1.fromCd(cd));
        pmtTpInf.setChoice1(PaymentTypeInformation2.PaymentTypeInformation2_C1.fromSvcLvl(svcLvl));
        LocalInstrument1Choice choice = SEPADebitExtractorV2Iso.getDebitType(debitType);
        if (choice != null) {
            pmtTpInf.setLclInstrm(choice);
        }
        pmtTpInf.setSeqTp(SEPADebitExtractorV2Iso.getSequenceType(sequenceType));
        if (paymentCategory != null && paymentCategory.length() > 0) {
            pmtTpInf.setCtgyPurp(new PaymentCategoryPurpose1Code(paymentCategory));
        }
        return pmtTpInf;
    }

    private static List<DirectDebitTransactionInformation1> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformation1> transactions = new ArrayList<DirectDebitTransactionInformation1>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String purpose;
            String purposeCode;
            String ultimateDebitor;
            String ultimateCreditor;
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new Max35Text((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.trim().length() > 0) {
                pmtId.setInstrId(new Max35Text(instructionId));
            }
            CurrencyAndAmount ccyAndAmt = SEPADebitExtractorV2Iso.getCurrencyAndAmount(paymentData.getAmount(), paymentData.getCurrency());
            PartyIdentification8 dbtr = SEPADebitExtractorV2Iso.getParty(paymentData.getRecipient());
            BranchAndFinancialInstitutionIdentification3 dbtrAgt = SEPADebitExtractorV2Iso.getBankId(paymentData.getRecipientBic());
            CashAccount7 dbtrAcct = SEPADebitExtractorV2Iso.getAccountId(paymentData.getRecipientIban());
            DirectDebitTransactionInformation1 transaction = new DirectDebitTransactionInformation1(pmtId, ccyAndAmt, dbtrAgt, dbtr, dbtrAcct);
            String creditorId = paymentData.getCreditorId();
            String mandateId = paymentData.getMandateId();
            Date mandateSignDate = paymentData.getMandateSignDate();
            if (creditorId != null && creditorId.trim().length() > 0 && mandateId != null && mandateId.trim().length() > 0 && mandateSignDate != null) {
                transaction.setDrctDbtTx(SEPADebitExtractorV2Iso.getMandateInfo(creditorId.trim(), mandateId.trim(), mandateSignDate));
            }
            if ((ultimateCreditor = paymentData.getUltimateOriginator()) != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(SEPADebitExtractorV2Iso.getParty(ultimateCreditor));
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(SEPADebitExtractorV2Iso.getParty(ultimateDebitor));
            }
            if ((purposeCode = paymentData.getPurposeCode()) != null && purposeCode.trim().length() > 0) {
                transaction.setPurp(new Purpose1Choice(Purpose1Choice.Purpose1Choice_C1.fromCd(new ExternalPurposeCode(purposeCode.trim()))));
            }
            if ((purpose = paymentData.getPurpose()) != null && purpose.length() > 0) {
                RemittanceInformation1 remittanceInfo = new RemittanceInformation1();
                remittanceInfo.getUstrds().add(new Max140Text(purpose));
                transaction.setRmtInf(remittanceInfo);
            }
            transactions.add(transaction);
        }
        return transactions;
    }

    private static DirectDebitTransaction1 getMandateInfo(String creditorId, String mandateId, Date mandateSignDate) {
        DirectDebitTransaction1 drctDbtTx = new DirectDebitTransaction1();
        drctDbtTx.setCdtrSchmeId(SEPADebitExtractorV2Iso.getPartyFromId(creditorId));
        MandateRelatedInformation1 mndtRltdInf = new MandateRelatedInformation1();
        mndtRltdInf.setDtOfSgntr(SEPADebitExtractorV2Iso.getDate(mandateSignDate));
        mndtRltdInf.setMndtId(new Max35Text(mandateId));
        drctDbtTx.setMndtRltdInf(mndtRltdInf);
        return drctDbtTx;
    }

    private static PartyIdentification8 getParty(String name) {
        PartyIdentification8 party = new PartyIdentification8();
        if (name != null && !name.isEmpty()) {
            party.setNm(new Max70Text(name));
        }
        return party;
    }

    private static PartyIdentification8 getPartyFromId(String id) {
        GenericIdentification4 othrId = new GenericIdentification4(new Max35Text(id), new Max35Text(GeneralSEPAExtractor.SEPA));
        ChoiceList<PersonIdentification3> prvtIds = new ChoiceList<PersonIdentification3>(PersonIdentification3.class, "PrvtId");
        prvtIds.add(new PersonIdentification3(PersonIdentification3.PersonIdentification3_C1.fromOthrId(othrId)));
        PartyIdentification8 party = new PartyIdentification8();
        party.setId(new Party2Choice(Party2Choice.Party2Choice_C1.fromPrvtIds(prvtIds)));
        return party;
    }

    private static BranchAndFinancialInstitutionIdentification3 getBankId(String bic) {
        FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1 c1 = FinancialInstitutionIdentification5Choice.FinancialInstitutionIdentification5Choice_C1.fromBIC(new BICIdentifier(bic));
        return new BranchAndFinancialInstitutionIdentification3(new FinancialInstitutionIdentification5Choice(c1));
    }

    private static CashAccount7 getAccountId(String iban) {
        AccountIdentification3Choice.AccountIdentification3Choice_C1 c1 = IbanUtil.checkIbanPattern(iban) ? AccountIdentification3Choice.AccountIdentification3Choice_C1.fromIBAN(new IBANIdentifier(iban)) : AccountIdentification3Choice.AccountIdentification3Choice_C1.fromPrtryAcct(new SimpleIdentificationInformation2(new Max34Text(iban)));
        return new CashAccount7(new AccountIdentification3Choice(c1));
    }

    private static CurrencyAndAmount getCurrencyAndAmount(BigDecimal amt, Currency c) {
        CurrencyCode currency = new CurrencyCode(c.getCurrencyCode());
        return new CurrencyAndAmount(amt, currency);
    }

    public static ISODate getDate(Date date) {
        return new ISODate(new YYMMDD(date.getTime()));
    }

    private static LocalInstrument1Choice getDebitType(String debitType) {
        if (debitType != null && debitType.length() > 0) {
            ExternalLocalInstrumentCode code = new ExternalLocalInstrumentCode(debitType);
            LocalInstrument1Choice.LocalInstrument1Choice_C1 c1 = LocalInstrument1Choice.LocalInstrument1Choice_C1.fromCd(code);
            return new LocalInstrument1Choice(c1);
        }
        return null;
    }

    private static SequenceType1Code getSequenceType(String seqType) {
        if ("FRST".equals(seqType)) {
            return new SequenceType1Code("FRST");
        }
        if ("RCUR".equals(seqType)) {
            return new SequenceType1Code("RCUR");
        }
        if ("FNAL".equals(seqType)) {
            return new SequenceType1Code("FNAL");
        }
        return new SequenceType1Code("OOFF");
    }
}

