/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.AccountIdentificationSDD;
import de.businesslogics.format.sepa.BatchBookingIndicator;
import de.businesslogics.format.sepa.CashAccountSDD1;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.GroupHeaderSDD;
import de.businesslogics.format.sepa.Grouping1CodeSDD;
import de.businesslogics.format.sepa.LocalInstrumentCodeSDD;
import de.businesslogics.format.sepa.LocalInstrumentSDD;
import de.businesslogics.format.sepa.Max140Text;
import de.businesslogics.format.sepa.PaymentCategoryPurpose1Code;
import de.businesslogics.format.sepa.PaymentIdentification1;
import de.businesslogics.format.sepa.PaymentTypeInformationSDD;
import de.businesslogics.format.sepa.RestrictedIdentification1;
import de.businesslogics.format.sepa.RestrictedIdentification2;
import de.businesslogics.format.sepa.RestrictedIdentification3;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SequenceType1Code;
import de.businesslogics.format.sepa.pain00800201.BranchAndFinancialInstitutionIdentificationSDD1;
import de.businesslogics.format.sepa.pain00800201.CashAccountSDD2;
import de.businesslogics.format.sepa.pain00800201.ChargeBearerTypeSDDCode;
import de.businesslogics.format.sepa.pain00800201.CurrencyAndAmountSDD;
import de.businesslogics.format.sepa.pain00800201.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.sepa.pain00800201.DirectDebitTransactionSDD;
import de.businesslogics.format.sepa.pain00800201.FinancialInstitutionIdentificationSDD1;
import de.businesslogics.format.sepa.pain00800201.GenericIdentificationSDD;
import de.businesslogics.format.sepa.pain00800201.MandateRelatedInformationSDD;
import de.businesslogics.format.sepa.pain00800201.Pain00800101;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Document;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD1;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD2;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD3;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD4;
import de.businesslogics.format.sepa.pain00800201.PartySDD;
import de.businesslogics.format.sepa.pain00800201.PaymentInstructionInformationSDD;
import de.businesslogics.format.sepa.pain00800201.PersonIdentificationSDD2;
import de.businesslogics.format.sepa.pain00800201.RemittanceInformationSDDChoice;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPADebitExtractorV2 {
    private static final Currency EUR = Currency.getInstance("EUR");

    public static XMLDate getDateSRZ(Pain00800201Document document) {
        return document.getPain00800101().getPmtInf().get(0).getReqdColltnDt();
    }

    public static GeneralSEPAWriter.DebitType getDebitType(Pain00800201Document document) {
        return GeneralSEPAWriter.DebitType.valueOf(document.getPain00800101().getPmtInf().get(0).getPmtTpInf().getLclInstrm().getCd().getValue());
    }

    public static List<SEPAPaymentData> getPayments(InputStream is) throws IOException, SAXException {
        Pain00800201Document document = SEPADebitExtractorV2.getPain00800201Document(is);
        return SEPADebitExtractorV2.getPayments(document);
    }

    public static Pain00800201Document getPain00800201Document(InputStream is) throws IOException, SAXException {
        return (Pain00800201Document)EbicsHandler.parse(is, new Pain00800201Document.Parser(null));
    }

    protected static List<SEPAPaymentData> getPayments(Pain00800201Document document) {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        Pain00800101 pain00800201 = document.getPain00800101();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInf()) {
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorV2.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    protected static List<SEPALogicalFile> getLogicalFiles(Pain00800201Document document) {
        ArrayList<SEPALogicalFile> logicalFiles = new ArrayList<SEPALogicalFile>();
        Pain00800101 pain00800201 = document.getPain00800101();
        String msgId = pain00800201.getGrpHdr().getMsgId().getValue();
        String initParty = pain00800201.getGrpHdr().getInitgPty().getNm();
        for (PaymentInstructionInformationSDD p : pain00800201.getPmtInf()) {
            String pmtInfId = "";
            if (p.getPmtInfId() != null) {
                pmtInfId = p.getPmtInfId().getValue();
            }
            SEPALogicalFile logicalFile = new SEPALogicalFile(pmtInfId, msgId);
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                logicalFile.getTransactions().add(SEPADebitExtractorV2.getPaymentData(msgId, initParty, p, c));
            }
            logicalFiles.add(logicalFile);
        }
        for (SEPALogicalFile f : logicalFiles) {
            f.setVersion(GeneralSEPAWriter.Version.V24);
        }
        return logicalFiles;
    }

    public static SEPAPaymentData getPayment(Pain00800201Document document) throws Exception {
        List<SEPAPaymentData> payments = SEPADebitExtractorV2.getPayments(document);
        if (payments != null && payments.size() == 1) {
            return payments.get(0);
        }
        throw new Exception("Payment file contains more than 1 payment");
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformationSDD p, DirectDebitTransactionInformationSDD t) {
        String endToEndId;
        String orig = p.getCdtr().getNm();
        String origIban = p.getCdtrAcct().getId().getIban();
        String origBic = p.getCdtrAgt().getFinInstnId().getBic();
        String ultimateOrig = null;
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = p.getUltmtCdtr().getNm();
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = t.getUltmtCdtr().getNm();
        }
        String recip = t.getDbtr().getNm();
        String recipIban = t.getDbtrAcct().getId().getIban();
        String recipBic = t.getDbtrAgt().getFinInstnId().getBic();
        String ultimateRecip = null;
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = t.getUltmtDbtr().getNm();
        }
        BigDecimal amount = t.getInstdAmt().getAmount();
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String purpose = t.getRmtInf() != null && t.getRmtInf().getUstrd() != null ? t.getRmtInf().getUstrd().getValue() : "";
        String paymentCategory = null;
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getValue();
        }
        if ("NOTPROVIDED".equals(endToEndId = t.getPmtId().getEndToEndId().getValue())) {
            endToEndId = "";
        }
        String instructionId = t.getPmtId().getInstrId() != null ? t.getPmtId().getInstrId().getValue() : "";
        String debitType = p.getPmtTpInf().getLclInstrm().getCd().getValue();
        String sequenceType = p.getPmtTpInf().getSeqTp().getValue();
        DirectDebitTransactionSDD ddt = t.getDrctDbtTx();
        String creditorId = ddt.getCdtrSchmeId().getId().getPrvtId().getOthrId().getId().getValue();
        String mandateId = ddt.getMndtRltdInf().getMndtId().getValue();
        YYMMDD mandateSignDate = ddt.getMndtRltdInf().getDtOfSgntr().getDate();
        return new SEPAPaymentData(msgId, initParty, orig, origIban, origBic, ultimateOrig, recip, recipIban, recipBic, ultimateRecip, amount, executionDate, purpose, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
    }

    public static Pain00800201Document getDebitDocument(SEPAPaymentData paymentData) throws IOException {
        ArrayList<SEPAPaymentData> paymentList = new ArrayList<SEPAPaymentData>(1);
        paymentList.add(paymentData);
        ArrayList<PaymentInstructionInformationSDD> logicalFiles = new ArrayList<PaymentInstructionInformationSDD>(1);
        logicalFiles.add(SEPADebitExtractorV2.getLogicalFile("TempMessageId", paymentList));
        GroupHeaderSDD grpHdr = SEPADebitExtractorV2.getGroupHeader("TempMessageId", paymentData.getInitiatingParty(), 1L, paymentData.getAmount(), null);
        return new Pain00800201Document(new Pain00800101(grpHdr, logicalFiles));
    }

    public static Pain00800201Document getDebitDocument(String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        int totalCountTransactions = 0;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        boolean displayAsSingleBooking = false;
        int countLogicalFiles = paymentLists.size();
        ArrayList<PaymentInstructionInformationSDD> logicalFiles = new ArrayList<PaymentInstructionInformationSDD>(countLogicalFiles);
        for (int i = 0; i < countLogicalFiles; ++i) {
            List<SEPAPaymentData> paymentList = paymentLists.get(i);
            String pmtInfId = null;
            if (paymentList != null && paymentList.size() > 0) {
                SEPAPaymentData first = paymentList.get(0);
                pmtInfId = first.getPmtInfId();
                displayAsSingleBooking = first.displayAsSingleBooking();
            }
            if (pmtInfId == null) {
                pmtInfId = GeneralSEPAWriter.buildPmtInfId(messageId, i + 1, paymentList.size());
            }
            logicalFiles.add(SEPADebitExtractorV2.getLogicalFile(pmtInfId, paymentList));
            totalCountTransactions += paymentList.size();
            for (SEPAPaymentData payment : paymentList) {
                ctrlSum = ctrlSum.add(payment.getAmount());
            }
        }
        Boolean btchBookg = displayAsSingleBooking ? Boolean.FALSE : null;
        GroupHeaderSDD grpHdr = SEPADebitExtractorV2.getGroupHeader(messageId, initiatingParty, totalCountTransactions, ctrlSum, btchBookg);
        return new Pain00800201Document(new Pain00800101(grpHdr, logicalFiles));
    }

    private static GroupHeaderSDD getGroupHeader(String messageId, String initiatingParty, long totalCountTransactions, BigDecimal controlSum, Boolean btchBookg) {
        PartyIdentificationSDD1 initParty = new PartyIdentificationSDD1(initiatingParty);
        GroupHeaderSDD grpHdr = new GroupHeaderSDD(new RestrictedIdentification1(messageId), new Date(), totalCountTransactions, initParty, Grouping1CodeSDD.MIXD);
        grpHdr.setCtrlSum(controlSum);
        if (btchBookg != null) {
            grpHdr.setBtchBookg(new BatchBookingIndicator(btchBookg));
        }
        return grpHdr;
    }

    private static PaymentInstructionInformationSDD getLogicalFile(String logicalFileId, List<SEPAPaymentData> paymentList) {
        SEPAPaymentData firstPayment = paymentList.get(0);
        LocalInstrumentCodeSDD debitType = "B2B".equals(firstPayment.getDebitType()) ? LocalInstrumentCodeSDD.B2B : LocalInstrumentCodeSDD.CORE;
        String seqType = firstPayment.getSequenceType();
        SequenceType1Code sequenceType = "FRST".equals(seqType) ? SequenceType1Code.FRST : ("RCUR".equals(seqType) ? SequenceType1Code.RCUR : ("FNAL".equals(seqType) ? SequenceType1Code.FNAL : SequenceType1Code.OOFF));
        PaymentTypeInformationSDD pmtTpInf = new PaymentTypeInformationSDD(new LocalInstrumentSDD(debitType), sequenceType);
        String categoryPurpose = firstPayment.getPaymentCategory();
        if (categoryPurpose != null && categoryPurpose.length() > 0) {
            pmtTpInf.setCtgyPurp(PaymentCategoryPurpose1Code.getCode(categoryPurpose));
        }
        XMLDate execDate = new XMLDate(new YYMMDD(firstPayment.getExecutionDate().getTime()));
        PartyIdentificationSDD2 cdtr = new PartyIdentificationSDD2(firstPayment.getOriginator());
        CashAccountSDD1 cdtrAcct = new CashAccountSDD1(new AccountIdentificationSDD(firstPayment.getOriginatorIban()));
        BranchAndFinancialInstitutionIdentificationSDD1 cdtrAgt = new BranchAndFinancialInstitutionIdentificationSDD1(new FinancialInstitutionIdentificationSDD1(firstPayment.getOriginatorBic()));
        PaymentInstructionInformationSDD logicalFile = new PaymentInstructionInformationSDD(null, pmtTpInf, execDate, cdtr, cdtrAcct, cdtrAgt, SEPADebitExtractorV2.getTransactions(logicalFileId, paymentList));
        logicalFile.setPmtInfId(new RestrictedIdentification1(logicalFileId));
        logicalFile.setChrgBr(ChargeBearerTypeSDDCode.SLEV);
        return logicalFile;
    }

    private static List<DirectDebitTransactionInformationSDD> getTransactions(String logicalFileId, List<SEPAPaymentData> paymentList) {
        ArrayList<DirectDebitTransactionInformationSDD> transactions = new ArrayList<DirectDebitTransactionInformationSDD>(paymentList.size());
        int transactionId = 1;
        for (SEPAPaymentData paymentData : paymentList) {
            String ultimateDebitor;
            MandateRelatedInformationSDD mndtRltdInf = new MandateRelatedInformationSDD(new RestrictedIdentification1(paymentData.getMandateId()), new XMLDate(new YYMMDD(paymentData.getMandateSignDate().getTime())));
            PartyIdentificationSDD4 cdtrSchmeId = new PartyIdentificationSDD4(new PartySDD(new PersonIdentificationSDD2(new GenericIdentificationSDD(new RestrictedIdentification3(paymentData.getCreditorId())))));
            DirectDebitTransactionSDD ddt = new DirectDebitTransactionSDD(mndtRltdInf, cdtrSchmeId);
            Object endToEndId = paymentData.getEndToEndId();
            if (endToEndId == null || ((String)endToEndId).length() == 0 || ((String)endToEndId).startsWith("TempMessageId")) {
                endToEndId = logicalFileId + "-" + transactionId++;
            }
            PaymentIdentification1 pmtId = new PaymentIdentification1(new RestrictedIdentification2((String)endToEndId));
            String instructionId = paymentData.getInstructionId();
            if (instructionId != null && instructionId.trim().length() > 0) {
                pmtId.setInstrId(new RestrictedIdentification1(instructionId));
            }
            CurrencyAndAmountSDD amt = new CurrencyAndAmountSDD(EUR, paymentData.getAmount());
            BranchAndFinancialInstitutionIdentificationSDD1 dbtrAgt = new BranchAndFinancialInstitutionIdentificationSDD1(new FinancialInstitutionIdentificationSDD1(paymentData.getRecipientBic()));
            CashAccountSDD2 dbtrAcct = new CashAccountSDD2(new AccountIdentificationSDD(paymentData.getRecipientIban()));
            PartyIdentificationSDD3 dbtr = new PartyIdentificationSDD3(paymentData.getRecipient());
            RemittanceInformationSDDChoice rmtInf = null;
            String purpose = paymentData.getPurpose();
            if (purpose != null && purpose.trim().length() > 0) {
                rmtInf = new RemittanceInformationSDDChoice(new Max140Text(purpose));
            }
            DirectDebitTransactionInformationSDD transaction = new DirectDebitTransactionInformationSDD(pmtId, amt, ddt, dbtrAgt, dbtr, dbtrAcct, rmtInf);
            String ultimateCreditor = paymentData.getUltimateOriginator();
            if (ultimateCreditor != null && ultimateCreditor.length() > 0) {
                transaction.setUltmtCdtr(new PartyIdentificationSDD1(ultimateCreditor));
            }
            if ((ultimateDebitor = paymentData.getUltimateRecipient()) != null && ultimateDebitor.length() > 0) {
                transaction.setUltmtDbtr(new PartyIdentificationSDD1(ultimateDebitor));
            }
            transactions.add(transaction);
        }
        return transactions;
    }

    public static List<PaymentInstructionInformationSDD> getPaymentFiles(InputStream in) throws SAXException, IOException {
        Pain00800201Document document = SEPADebitExtractorV2.getPain00800201Document(in);
        Pain00800101 pain = document.getPain00800101();
        return pain.getPmtInf();
    }

    public static Pain00800101 createLogicalFile(List<Pain00800101> payments) {
        PartyIdentificationSDD1 initgPty = null;
        PaymentInstructionInformationSDD logicalFile = null;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        int countMergedPayments = payments.size();
        for (int i = 0; i < countMergedPayments; ++i) {
            Pain00800101 payment = payments.get(i);
            PaymentInstructionInformationSDD p = payment.getPmtInf().get(0);
            if (i == 0) {
                initgPty = payment.getGrpHdr().getInitgPty();
                logicalFile = new PaymentInstructionInformationSDD(null, p.getPmtTpInf(), p.getReqdColltnDt(), p.getCdtr(), p.getCdtrAcct(), p.getCdtrAgt(), new ArrayList<DirectDebitTransactionInformationSDD>());
                logicalFile.setChrgBr(p.getChrgBr());
            }
            DirectDebitTransactionInformationSDD t = p.getDrctDbtTxInfs().get(0);
            logicalFile.getDrctDbtTxInfs().add(t);
            ctrlSum = ctrlSum.add(t.getInstdAmt().getAmount());
        }
        GroupHeaderSDD grpHdr = new GroupHeaderSDD(new RestrictedIdentification1("TempMessageId"), new Date(), countMergedPayments, initgPty, Grouping1CodeSDD.MIXD);
        grpHdr.setCtrlSum(ctrlSum);
        ArrayList<PaymentInstructionInformationSDD> logicalFiles = new ArrayList<PaymentInstructionInformationSDD>();
        logicalFiles.add(logicalFile);
        return new Pain00800101(grpHdr, logicalFiles);
    }

    public static Pain00800201Document createDocument(List<Pain00800101> logicalFiles, String msgId, String pmtInfIdPrefix) {
        ArrayList<PaymentInstructionInformationSDD> pmtInfs = new ArrayList<PaymentInstructionInformationSDD>();
        PartyIdentificationSDD1 initiatingParty = null;
        BigDecimal ctrlSum = BigDecimal.ZERO;
        long countTransactions = 0L;
        int i = 1;
        for (Pain00800101 logicalFile : logicalFiles) {
            if (initiatingParty == null) {
                initiatingParty = logicalFile.getGrpHdr().getInitgPty();
            }
            ctrlSum = ctrlSum.add(logicalFile.getGrpHdr().getCtrlSum());
            countTransactions += logicalFile.getGrpHdr().getNbOfTxs();
            PaymentInstructionInformationSDD pmtInf = logicalFile.getPmtInf().get(0);
            pmtInf.setPmtInfId(new RestrictedIdentification1(pmtInfIdPrefix + i++));
            pmtInfs.add(pmtInf);
        }
        GroupHeaderSDD grpHdr = new GroupHeaderSDD(new RestrictedIdentification1(msgId), new Date(), countTransactions, initiatingParty, Grouping1CodeSDD.MIXD);
        grpHdr.setCtrlSum(ctrlSum);
        return new Pain00800201Document(new Pain00800101(grpHdr, pmtInfs));
    }
}

