/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.dk33.pain00800102.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.businesslogics.format.dk33.pain00800102.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.dk33.pain00800102.AmendmentInformationDetailsSDD;
import de.businesslogics.format.dk33.pain00800102.CashAccountSEPA1;
import de.businesslogics.format.dk33.pain00800102.CountryCode;
import de.businesslogics.format.dk33.pain00800102.CreditorReferenceInformationSEPA1;
import de.businesslogics.format.dk33.pain00800102.CustomerDirectDebitInitiationV02;
import de.businesslogics.format.dk33.pain00800102.DirectDebitTransactionInformationSDD;
import de.businesslogics.format.dk33.pain00800102.Document;
import de.businesslogics.format.dk33.pain00800102.FinancialInstitutionIdentificationSEPA3;
import de.businesslogics.format.dk33.pain00800102.GroupHeaderSDD;
import de.businesslogics.format.dk33.pain00800102.IBAN2007Identifier;
import de.businesslogics.format.dk33.pain00800102.MandateRelatedInformationSDD;
import de.businesslogics.format.dk33.pain00800102.Max140Text;
import de.businesslogics.format.dk33.pain00800102.Max70Text;
import de.businesslogics.format.dk33.pain00800102.PartyIdentificationSEPA2;
import de.businesslogics.format.dk33.pain00800102.PartyIdentificationSEPA5;
import de.businesslogics.format.dk33.pain00800102.PartySEPA2;
import de.businesslogics.format.dk33.pain00800102.PaymentInstructionInformationSDD;
import de.businesslogics.format.dk33.pain00800102.PaymentTypeInformationSDD;
import de.businesslogics.format.dk33.pain00800102.PostalAddressSEPA;
import de.businesslogics.format.dk33.pain00800102.RemittanceInformationSEPA1Choice;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SEPADebitExtractorDk33 {
    protected static List<SEPAPaymentData> getPayments(Document document) {
        CustomerDirectDebitInitiationV02 cddi = document.getCstmrDrctDbtInitn();
        GroupHeaderSDD grpHdr = cddi.getGrpHdr();
        String msgId = grpHdr.getMsgId().getValue();
        String initParty = SimpleStringElement.getNonNullValue(grpHdr.getInitgPty().getNm());
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        for (PaymentInstructionInformationSDD p : cddi.getPmtInfs()) {
            for (DirectDebitTransactionInformationSDD c : p.getDrctDbtTxInfs()) {
                payments.add(SEPADebitExtractorDk33.getPaymentData(msgId, initParty, p, c));
            }
        }
        return payments;
    }

    private static SEPAPaymentData getPaymentData(String msgId, String initParty, PaymentInstructionInformationSDD p, DirectDebitTransactionInformationSDD t) {
        AmendmentInformationDetailsSDD amendmentInfo;
        PartyIdentificationSEPA5 creditor = p.getCdtr();
        String origName = SimpleStringElement.getNonNullValue(creditor.getNm());
        CashAccountSEPA1 originatorAccount = p.getCdtrAcct();
        String origAccNumber = originatorAccount.getId().getIBAN().getValue();
        String origBankCode = SEPADebitExtractorDk33.getBankIdentifier(p.getCdtrAgt().getFinInstnId().getChoice1());
        Currency accountCurrency = null;
        ActiveOrHistoricCurrencyCode ccy = p.getCdtrAcct().getCcy();
        if (ccy != null) {
            accountCurrency = Currency.getInstance(ccy.getValue());
        }
        String ultimateOrig = "";
        if (p.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(p.getUltmtCdtr().getNm());
        } else if (t.getUltmtCdtr() != null) {
            ultimateOrig = SimpleStringElement.getNonNullValue(t.getUltmtCdtr().getNm());
        }
        PartyIdentificationSEPA2 debtor = t.getDbtr();
        String recipName = SimpleStringElement.getNonNullValue(debtor.getNm());
        String recipAccNumber = t.getDbtrAcct().getId().getIBAN().getValue();
        String recipBankCode = SEPADebitExtractorDk33.getBankIdentifier(t.getDbtrAgt().getFinInstnId().getChoice1());
        String ultimateRecip = "";
        if (t.getUltmtDbtr() != null) {
            ultimateRecip = SimpleStringElement.getNonNullValue(t.getUltmtDbtr().getNm());
        }
        ActiveOrHistoricCurrencyAndAmountSEPA ccyAndAmt = t.getInstdAmt();
        BigDecimal amount = ccyAndAmt.getValue();
        Currency currency = Currency.getInstance(ccyAndAmt.getCcy().getValue());
        YYMMDD executionDate = p.getReqdColltnDt().getDate();
        String paymentCategory = "";
        if (p.getPmtTpInf() != null && p.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = p.getPmtTpInf().getCtgyPurp().getCd().getValue();
        } else if (t.getPmtTpInf() != null && t.getPmtTpInf().getCtgyPurp() != null) {
            paymentCategory = t.getPmtTpInf().getCtgyPurp().getCd().getValue();
        }
        String endToEndId = t.getPmtId().getEndToEndId().getValue();
        if ("NOTPROVIDED".equals(endToEndId)) {
            endToEndId = "";
        }
        String instructionId = SimpleStringElement.getNonNullValue(t.getPmtId().getInstrId());
        String debitType = "";
        String sequenceType = "";
        PaymentTypeInformationSDD pmtTpInf = t.getPmtTpInf();
        if (pmtTpInf == null) {
            pmtTpInf = p.getPmtTpInf();
        }
        if (pmtTpInf != null) {
            debitType = pmtTpInf.getLclInstrm().getCd().getValue();
            sequenceType = pmtTpInf.getSeqTp().getValue();
        }
        String creditorId = null;
        creditorId = t.getDrctDbtTx().getCdtrSchmeId() != null ? t.getDrctDbtTx().getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : (p.getCdtrSchmeId() != null ? p.getCdtrSchmeId().getId().getPrvtId().getOthr().getId().getValue() : "");
        MandateRelatedInformationSDD mandateInfo = t.getDrctDbtTx().getMndtRltdInf();
        String mandateId = mandateInfo.getMndtId().getValue();
        YYMMDD mandateSignDate = mandateInfo.getDtOfSgntr().getDate();
        SEPAPaymentData paymentData = new SEPAPaymentData(msgId, initParty, origName, origAccNumber, origBankCode, ultimateOrig, recipName, recipAccNumber, recipBankCode, ultimateRecip, amount, currency, executionDate, null, paymentCategory, endToEndId, instructionId, debitType, sequenceType, creditorId, mandateId, mandateSignDate);
        paymentData.setAccountCurrency(accountCurrency);
        if (mandateInfo.getAmdmntInd() != null && mandateInfo.getAmdmntInd().booleanValue() && (amendmentInfo = mandateInfo.getAmdmntInfDtls()) != null) {
            if (amendmentInfo.getOrgnlCdtrSchmeId() != null) {
                PartySEPA2 originalCreditorId;
                if (amendmentInfo.getOrgnlCdtrSchmeId().getNm() != null) {
                    paymentData.setOriginalCreditor(amendmentInfo.getOrgnlCdtrSchmeId().getNm().getValue());
                }
                if ((originalCreditorId = amendmentInfo.getOrgnlCdtrSchmeId().getId()) != null) {
                    paymentData.setOriginalCreditorId(originalCreditorId.getPrvtId().getOthr().getId().getValue());
                }
            }
            if (amendmentInfo.getOrgnlMndtId() != null) {
                paymentData.setOriginalMandateId(amendmentInfo.getOrgnlMndtId().getValue());
            }
            if (amendmentInfo.getOrgnlDbtrAcct() != null) {
                IBAN2007Identifier iban = amendmentInfo.getOrgnlDbtrAcct().getId().getChoice1().getIBAN();
                if (iban != null) {
                    paymentData.setOriginalRecipientIban(iban.getValue());
                } else {
                    paymentData.setRecipientAccountHasChanged(true);
                }
            } else if (amendmentInfo.getOrgnlDbtrAgt() != null) {
                paymentData.setOriginalRecipientBic(amendmentInfo.getOrgnlDbtrAgt().getFinInstnId().getBIC().getValue());
            }
        }
        SEPADebitExtractorDk33.setPurposeInformation(t.getRmtInf(), paymentData);
        if (t.getPurp() != null) {
            paymentData.setPurposeCode(t.getPurp().getCd().getValue());
        }
        if (p.getBtchBookg() != null) {
            paymentData.setDisplayAsSingleBooking(!p.getBtchBookg().booleanValue());
        } else {
            paymentData.setDisplayAsSingleBooking(false);
        }
        if (creditor.getPstlAdr() != null) {
            paymentData.setOriginatorAddressData(SEPADebitExtractorDk33.getAddressData(creditor.getPstlAdr()));
        }
        if (debtor.getPstlAdr() != null) {
            paymentData.setRecipientAddressData(SEPADebitExtractorDk33.getAddressData(debtor.getPstlAdr()));
        }
        return paymentData;
    }

    private static String getBankIdentifier(FinancialInstitutionIdentificationSEPA3.FinancialInstitutionIdentificationSEPA3_C1 choice) {
        if (choice.getBIC() != null) {
            return choice.getBIC().getValue();
        }
        return null;
    }

    private static AddressData getAddressData(PostalAddressSEPA address) {
        AddressData addressData = new AddressData();
        CountryCode countryCode = address.getCtry();
        if (countryCode != null) {
            addressData.setCountry(countryCode.getValue());
        }
        for (Max70Text line : address.getAdrLines()) {
            addressData.getAddressLines().add(line.getValue());
        }
        return addressData;
    }

    private static void setPurposeInformation(RemittanceInformationSEPA1Choice rmtInf, SEPAPaymentData paymentData) {
        if (rmtInf != null) {
            CreditorReferenceInformationSEPA1 cdtrRefInf;
            Max140Text unstructuredLine = rmtInf.getChoice1().getUstrd();
            if (unstructuredLine != null) {
                paymentData.setHasStructuredPurpose(false);
                paymentData.getUnstructuredPurposeLines().add(unstructuredLine.getValue());
                paymentData.setPurpose(unstructuredLine.getValue());
            } else if (rmtInf.getChoice1().getStrd() != null && (cdtrRefInf = rmtInf.getChoice1().getStrd().getCdtrRefInf()) != null) {
                paymentData.setPurposeReference(cdtrRefInf.getRef().getValue());
                paymentData.setPurposeReferenceTypeCode(cdtrRefInf.getTp().getCdOrPrtry().getCd().getValue());
            }
        }
    }
}

