/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.iso20022.camt05500105.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.camt05500105.ActiveOrHistoricCurrencyAndAmount;
import de.businesslogics.format.iso20022.camt05500105.ActiveOrHistoricCurrencyCode;
import de.businesslogics.format.iso20022.camt05500105.BICFIIdentifier;
import de.businesslogics.format.iso20022.camt05500105.BranchAndFinancialInstitutionIdentification5;
import de.businesslogics.format.iso20022.camt05500105.CancellationReason14Choice;
import de.businesslogics.format.iso20022.camt05500105.CancellationReason5Code;
import de.businesslogics.format.iso20022.camt05500105.Case3;
import de.businesslogics.format.iso20022.camt05500105.CaseAssignment3;
import de.businesslogics.format.iso20022.camt05500105.CashAccount24;
import de.businesslogics.format.iso20022.camt05500105.CustomerPaymentCancellationRequestV05;
import de.businesslogics.format.iso20022.camt05500105.DecimalNumber;
import de.businesslogics.format.iso20022.camt05500105.Document;
import de.businesslogics.format.iso20022.camt05500105.FinancialInstitutionIdentification8;
import de.businesslogics.format.iso20022.camt05500105.GenericOrganisationIdentification1;
import de.businesslogics.format.iso20022.camt05500105.GroupCancellationIndicator;
import de.businesslogics.format.iso20022.camt05500105.IBAN2007Identifier;
import de.businesslogics.format.iso20022.camt05500105.ISODate;
import de.businesslogics.format.iso20022.camt05500105.ISODateTime;
import de.businesslogics.format.iso20022.camt05500105.MandateRelatedInformation10;
import de.businesslogics.format.iso20022.camt05500105.Max105Text;
import de.businesslogics.format.iso20022.camt05500105.Max140Text;
import de.businesslogics.format.iso20022.camt05500105.Max15NumericText;
import de.businesslogics.format.iso20022.camt05500105.Max35Text;
import de.businesslogics.format.iso20022.camt05500105.OrganisationIdentification8;
import de.businesslogics.format.iso20022.camt05500105.OriginalGroupInformation3;
import de.businesslogics.format.iso20022.camt05500105.OriginalPaymentInstruction15;
import de.businesslogics.format.iso20022.camt05500105.OriginalTransactionReference22;
import de.businesslogics.format.iso20022.camt05500105.Party11Choice;
import de.businesslogics.format.iso20022.camt05500105.Party12Choice;
import de.businesslogics.format.iso20022.camt05500105.PartyIdentification43;
import de.businesslogics.format.iso20022.camt05500105.PaymentCancellationReason2;
import de.businesslogics.format.iso20022.camt05500105.PaymentTransaction61;
import de.businesslogics.format.iso20022.camt05500105.UnderlyingTransaction12;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class SEPACallbackGenerator {
    public static void createCamt055Callback(String callbackMessageId, CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, SEPALogicalFile logicalFile, List<SEPAPaymentData> payments, OutputStream out) throws IOException, SAXException {
        SEPACallbackGenerator.createCamt055Callback(callbackMessageId, callbackReasonCode, additionalCallbackInfo, logicalFile, payments, null, out);
    }

    public static void createCamt055Callback(String callbackMessageId, CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, SEPALogicalFile logicalFile, List<SEPAPaymentData> payments, String originatorBic, OutputStream out) throws IOException, SAXException {
        Document document = SEPACallbackGenerator.createCamt055Document(callbackMessageId, callbackReasonCode, additionalCallbackInfo, logicalFile, payments, originatorBic);
        EbicsPrintStream eps = new EbicsPrintStream(out);
        eps.printOutPossibleRoot(document);
    }

    private static Document createCamt055Document(String callbackMessageId, CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, SEPALogicalFile logicalFile, List<SEPAPaymentData> payments, String originatorBic) {
        String messageName;
        SEPAPaymentData firstPayment = logicalFile.getTransactions().get(0);
        boolean isCredit = firstPayment.isCredit();
        if (callbackReasonCode == null) {
            callbackReasonCode = CallbackReasonCode.CUST;
        }
        String string = messageName = isCredit ? "pain.001" : "pain.008";
        if (PaymentUtils.isBundesbank(firstPayment.getOriginatorIban()) && SEPACallbackGenerator.isScheduledPayment(firstPayment)) {
            callbackReasonCode = null;
        }
        if (originatorBic == null) {
            originatorBic = firstPayment.getOriginatorBic();
        }
        CustomerPaymentCancellationRequestV05 request = new CustomerPaymentCancellationRequestV05(SEPACallbackGenerator.getAssignment(callbackMessageId, firstPayment.getOriginator(), originatorBic));
        request.getUndrlygs().add(SEPACallbackGenerator.getUnderlyingTransaction(SEPACallbackGenerator.getCallbackReferenceId(callbackMessageId), callbackReasonCode, additionalCallbackInfo, firstPayment.getOriginatorIban(), logicalFile.getPmtInfId(), logicalFile.getMsgId(), messageName, logicalFile.getNbOfTxs(), logicalFile.getCtrlSum(), payments));
        return new Document(request);
    }

    private static boolean isScheduledPayment(SEPAPaymentData payment) {
        Date executionDate = payment.getExecutionDate();
        if (executionDate != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(executionDate);
            return c.getTimeInMillis() > System.currentTimeMillis();
        }
        return false;
    }

    private static String getCallbackReferenceId(String callbackMessageId) {
        if (callbackMessageId.length() <= 33) {
            return callbackMessageId + "-1";
        }
        return callbackMessageId;
    }

    private static CaseAssignment3 getAssignment(String callbackMessageId, String originatorName, String originatorBic) {
        PartyIdentification43 originator = new PartyIdentification43();
        originator.setNm(new Max140Text(originatorName));
        Party12Choice assgnr = new Party12Choice(Party12Choice.Party12Choice_C1.fromPty(originator));
        FinancialInstitutionIdentification8 instituteId = new FinancialInstitutionIdentification8();
        instituteId.setBICFI(new BICFIIdentifier(originatorBic));
        BranchAndFinancialInstitutionIdentification5 institute = new BranchAndFinancialInstitutionIdentification5(instituteId);
        Party12Choice assgne = new Party12Choice(Party12Choice.Party12Choice_C1.fromAgt(institute));
        ISODateTime dateTime = new ISODateTime(new Date());
        return new CaseAssignment3(new Max35Text(callbackMessageId), assgnr, assgne, dateTime);
    }

    private static UnderlyingTransaction12 getUnderlyingTransaction(String callbackReferenceId, CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, String originatorIban, String logicalFileId, String messageId, String messageName, long nbOfTxs, BigDecimal ctrlSum, List<SEPAPaymentData> payments) {
        UnderlyingTransaction12 tx = new UnderlyingTransaction12();
        tx.getOrgnlPmtInfAndCxls().add(SEPACallbackGenerator.getCallbackInstruction(callbackReferenceId, callbackReasonCode, additionalCallbackInfo, originatorIban, logicalFileId, messageId, messageName, nbOfTxs, ctrlSum, payments));
        return tx;
    }

    private static OriginalPaymentInstruction15 getCallbackInstruction(String callbackReferenceId, CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, String originatorIban, String logicalFileId, String messageId, String messageName, long nbOfTxs, BigDecimal ctrlSum, List<SEPAPaymentData> payments) {
        OriginalPaymentInstruction15 paymentInstruction = new OriginalPaymentInstruction15(new Max35Text(logicalFileId));
        paymentInstruction.set_case(SEPACallbackGenerator.getCallbackCase(callbackReferenceId, originatorIban));
        paymentInstruction.setOrgnlGrpInf(new OriginalGroupInformation3(new Max35Text(messageId), new Max35Text(messageName)));
        if (nbOfTxs > 0L) {
            paymentInstruction.setNbOfTxs(new Max15NumericText(String.valueOf(nbOfTxs)));
        }
        if (ctrlSum != null) {
            paymentInstruction.setCtrlSum(new DecimalNumber(ctrlSum));
        }
        if (payments == null || payments.size() == 0) {
            paymentInstruction.setPmtInfCxl(new GroupCancellationIndicator(true));
            PaymentCancellationReason2 reason = SEPACallbackGenerator.getCallbackReason(callbackReasonCode, additionalCallbackInfo);
            if (reason != null) {
                paymentInstruction.getCxlRsnInfs().add(reason);
            }
        } else {
            paymentInstruction.setPmtInfCxl(new GroupCancellationIndicator(false));
            for (SEPAPaymentData payment : payments) {
                paymentInstruction.getTxInfs().add(SEPACallbackGenerator.getTransaction(callbackReasonCode, additionalCallbackInfo, payment));
            }
        }
        return paymentInstruction;
    }

    private static Case3 getCallbackCase(String callbackReferenceId, String originatorIban) {
        OrganisationIdentification8 orgId = new OrganisationIdentification8();
        orgId.getOthrs().add(new GenericOrganisationIdentification1(new Max35Text(originatorIban)));
        PartyIdentification43 creditor = new PartyIdentification43();
        creditor.setId(new Party11Choice(Party11Choice.Party11Choice_C1.fromOrgId(orgId)));
        return new Case3(new Max35Text(callbackReferenceId), new Party12Choice(Party12Choice.Party12Choice_C1.fromPty(creditor)));
    }

    private static PaymentCancellationReason2 getCallbackReason(CallbackReasonCode callbackReasonCode, String additionalCallbackInfo) {
        PaymentCancellationReason2 reason = null;
        if (callbackReasonCode != null) {
            reason = new PaymentCancellationReason2();
            if (CallbackReasonCode.AC03.equals((Object)callbackReasonCode) || CallbackReasonCode.AM09.equals((Object)callbackReasonCode)) {
                reason.setRsn(new CancellationReason14Choice(CancellationReason14Choice.CancellationReason14Choice_C1.fromPrtry(new Max35Text(callbackReasonCode.toString()))));
            } else {
                reason.setRsn(new CancellationReason14Choice(CancellationReason14Choice.CancellationReason14Choice_C1.fromCd(new CancellationReason5Code(callbackReasonCode.toString()))));
            }
        }
        if (additionalCallbackInfo != null && additionalCallbackInfo.trim().length() > 0) {
            if (reason == null) {
                reason = new PaymentCancellationReason2();
            }
            reason.getAddtlInfs().add(new Max105Text(additionalCallbackInfo.trim()));
        }
        return reason;
    }

    private static PaymentTransaction61 getTransaction(CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, SEPAPaymentData payment) {
        PaymentTransaction61 transaction = new PaymentTransaction61();
        if (payment.getInstructionId() != null && payment.getInstructionId().length() > 0) {
            transaction.setOrgnlInstrId(new Max35Text(payment.getInstructionId()));
        }
        if (payment.getEndToEndId() != null && payment.getEndToEndId().length() > 0) {
            transaction.setOrgnlEndToEndId(new Max35Text(payment.getEndToEndId()));
        }
        transaction.setOrgnlInstdAmt(new ActiveOrHistoricCurrencyAndAmount(payment.getAmount(), new ActiveOrHistoricCurrencyCode(payment.getCurrency().getCurrencyCode())));
        ISODate executionDate = new ISODate(new YYMMDD(payment.getExecutionDate().getTime()));
        if (payment.isCredit()) {
            transaction.setOrgnlReqdExctnDt(executionDate);
        } else {
            transaction.setOrgnlReqdColltnDt(executionDate);
        }
        PaymentCancellationReason2 reason = SEPACallbackGenerator.getCallbackReason(callbackReasonCode, additionalCallbackInfo);
        if (reason != null) {
            transaction.getCxlRsnInfs().add(reason);
        }
        transaction.setOrgnlTxRef(SEPACallbackGenerator.getTransactionReference(payment));
        return transaction;
    }

    private static OriginalTransactionReference22 getTransactionReference(SEPAPaymentData payment) {
        OriginalTransactionReference22 transactionReference = new OriginalTransactionReference22();
        PartyIdentification43 counterParty = new PartyIdentification43();
        counterParty.setNm(new Max140Text(payment.getRecipient()));
        CashAccount24 counterPartyAccount = null;
        String recipientIban = StringUtils.checkNullAndTrim(payment.getRecipientIban());
        if (recipientIban.length() > 0) {
            counterPartyAccount = new CashAccount24(new AccountIdentification4Choice(AccountIdentification4Choice.AccountIdentification4Choice_C1.fromIBAN(new IBAN2007Identifier(recipientIban))));
        }
        if (payment.isCredit()) {
            transactionReference.setCdtr(counterParty);
            transactionReference.setCdtrAcct(counterPartyAccount);
        } else {
            transactionReference.setDbtr(counterParty);
            transactionReference.setDbtrAcct(counterPartyAccount);
            MandateRelatedInformation10 mandateInfo = new MandateRelatedInformation10();
            mandateInfo.setMndtId(new Max35Text(payment.getMandateId()));
            transactionReference.setMndtRltdInf(mandateInfo);
        }
        return transactionReference;
    }

    public static enum CallbackReasonCode {
        TECH,
        CUST,
        DUPL,
        AC03,
        AM09;

    }
}

