/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public enum SEPAAccountType {
    CACC(false),
    CASH(false),
    CHAR(false),
    CISH(false),
    COMM(false),
    LOAN(false),
    MGLD(false),
    MOMA(false),
    NREX(false),
    ODFT(false),
    ONDP(false),
    SACC(false),
    SLRY(false),
    SVGS(false),
    TAXE(false),
    TRAS(false),
    NOA(true),
    SIA(true),
    CND(true),
    CWD(true);

    private boolean isProprietary;
    private static final Map<String, ResourceBundle> bundles;

    private SEPAAccountType(boolean isProprietary) {
        this.isProprietary = isProprietary;
    }

    public static boolean isProprietaryValue(String value) {
        try {
            SEPAAccountType accountType = SEPAAccountType.valueOf(value);
            if (accountType != null) {
                return accountType.isProprietary;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public static SEPAAccountType getSEPAAccountType(String value) {
        if (value == null) {
            return null;
        }
        try {
            return SEPAAccountType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String getDescription(String accountTypeString, Locale locale) {
        ResourceBundle bundle = bundles.get(locale.getLanguage());
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.SEPAAccountType", locale);
            bundles.put(locale.getLanguage(), bundle);
        }
        try {
            return bundle.getString("SEPAAccountType." + accountTypeString);
        }
        catch (MissingResourceException e) {
            return accountTypeString;
        }
    }

    static {
        bundles = new HashMap<String, ResourceBundle>();
    }
}

