/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.sepa.RejectedSEPALogicalFile;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.StatusTransactionInfo;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class RejectedSEPAOrder {
    private String orderType;
    private String orderNumber;
    private final String messageId;
    private final Date reportCreationDate;
    private final String originatorBic;
    private final String originalMessageId;
    private final String originalMessageName;
    private final int countTransactions;
    private final BigDecimal totalAmount;
    private final String statusCode;
    private final List<StatusReason> statusReasons;
    private final List<StatusTransactionInfo> groupStatusTransactionInfos = new ArrayList<StatusTransactionInfo>();
    private final Map<String, String> vopLegalInfoMap = new LinkedHashMap<String, String>();
    private List<RejectedSEPALogicalFile> rejectedLogicalFiles;

    RejectedSEPAOrder(String messageId, Date reportCreationDate, String originatorBic, String originalMessageId, String originalMessageName, BigDecimal totalAmount, int countTransactions, String statusCode, List<StatusReason> statusReasons) {
        this.messageId = messageId;
        this.reportCreationDate = reportCreationDate;
        this.originatorBic = originatorBic;
        this.countTransactions = countTransactions;
        this.totalAmount = totalAmount;
        this.originalMessageId = originalMessageId;
        this.originalMessageName = originalMessageName;
        this.statusCode = statusCode;
        this.statusReasons = statusReasons;
    }

    public List<StatusReason> getStatusReasons() {
        return this.statusReasons;
    }

    void setRejectedLogicalFiles(List<RejectedSEPALogicalFile> rejectedLogicalFiles) {
        this.rejectedLogicalFiles = rejectedLogicalFiles;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Date getReportCreationDate() {
        return this.reportCreationDate;
    }

    public String getOriginatorBic() {
        return this.originatorBic;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public String getOriginalMessageName() {
        return this.originalMessageName;
    }

    public int getCountTransactions() {
        return this.countTransactions;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public Currency getCurrency() {
        Currency found = null;
        boolean allSameCurrency = true;
        if (this.rejectedLogicalFiles != null) {
            for (RejectedSEPALogicalFile lf : this.rejectedLogicalFiles) {
                if (!allSameCurrency) continue;
                if (found == null) {
                    found = lf.getCurrency();
                    continue;
                }
                if (lf.getCurrency() == null || found.equals(lf.getCurrency())) continue;
                allSameCurrency = false;
                found = null;
            }
        }
        return found;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public List<RejectedSEPALogicalFile> getRejectedLogicalFiles() {
        return this.rejectedLogicalFiles;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void addGroupStatusTransactionInfo(StatusTransactionInfo statusTransactionInfo) {
        this.groupStatusTransactionInfos.add(statusTransactionInfo);
    }

    public List<StatusTransactionInfo> getGroupStatusTransactionInfos() {
        return this.groupStatusTransactionInfos;
    }

    public void addVopLegalInfo(String infoLine) {
        String statusCode = infoLine.substring(0, 4);
        infoLine = infoLine.substring(5);
        Object newInfo = this.vopLegalInfoMap.get(statusCode);
        newInfo = newInfo == null ? "" : (String)newInfo + "\n";
        this.vopLegalInfoMap.put(statusCode, (String)newInfo + infoLine);
    }

    public String getVopLegalInfo(String statusCode) {
        return this.vopLegalInfoMap.getOrDefault(statusCode, "");
    }

    public static String getDescription(String errorCode, Locale locale) {
        if (errorCode == null) {
            return null;
        }
        try {
            return ResourceBundle.getBundle("de.businesslogics.format.sepa.SEPACodes", locale).getString(errorCode);
        }
        catch (Exception e) {
            return errorCode;
        }
    }

    public static String getDescriptionFromTrxReasonInfo(String statusReasonInfo, Locale locale) {
        return RejectedSEPAOrder.getDescriptionFromTrxReasonInfo(statusReasonInfo, true, locale);
    }

    public static String getDescriptionFromTrxReasonInfo(String statusReasonInfo, boolean codeFirst, Locale locale) {
        String code;
        if (statusReasonInfo == null || statusReasonInfo.length() < 4) {
            return null;
        }
        String description = code = statusReasonInfo.substring(0, 4);
        if (!"NARR".equals(code)) {
            description = RejectedSEPAOrder.getDescription(code, locale);
        }
        if (code.equals(description)) {
            description = RejectedSEPAOrder.getAdditionalInfoFromTrxReasonInfo(statusReasonInfo);
        }
        if (description != null) {
            if (codeFirst) {
                return code + " (" + description + ")";
            }
            return description + " (" + code + ")";
        }
        return code;
    }

    public static String getAdditionalInfoFromTrxReasonInfo(String statusReasonInfo) {
        if (statusReasonInfo == null || statusReasonInfo.length() < 6) {
            return null;
        }
        if (statusReasonInfo.charAt(4) != '_') {
            return statusReasonInfo.replace('_', ' ');
        }
        return statusReasonInfo.substring(5).replace('_', ' ');
    }
}

