/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.format.sepa.RejectedSEPAPayment;
import de.businesslogics.format.sepa.StatusReason;
import de.businesslogics.format.sepa.StatusTransactionInfo;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RejectedSEPALogicalFile {
    private final String originalPmtInfId;
    private final int countTransactions;
    private final BigDecimal totalAmount;
    private final String statusCode;
    private String uniqueTransactionStatusCode;
    private final List<StatusReason> statusReasons;
    private final List<StatusTransactionInfo> statusTransactionInfos = new ArrayList<StatusTransactionInfo>();
    private final List<RejectedSEPAPayment> rejectedPaymentsWithoutIndividualStatusCode = new ArrayList<RejectedSEPAPayment>();
    private Map<String, List<RejectedSEPAPayment>> statusCodePaymentsMap = new LinkedHashMap<String, List<RejectedSEPAPayment>>();
    private final Map<String, StatusTransactionInfo> calculatedStatusTransactionInfoMap = new LinkedHashMap<String, StatusTransactionInfo>();
    private final Map<String, String> vopLegalInfoMap = new LinkedHashMap<String, String>();

    RejectedSEPALogicalFile(String originalPmtInfId, int countTransactions, BigDecimal amount, String statusCode, List<StatusReason> statusReasons) {
        this.originalPmtInfId = originalPmtInfId;
        this.countTransactions = countTransactions;
        this.totalAmount = amount;
        this.statusCode = statusCode;
        this.statusReasons = statusReasons;
    }

    void addPayment(RejectedSEPAPayment payment) {
        String statusCodePayment = payment.getStatusCode();
        if (statusCodePayment != null) {
            List<RejectedSEPAPayment> payments = this.statusCodePaymentsMap.get(statusCodePayment);
            if (payments == null) {
                payments = new ArrayList<RejectedSEPAPayment>();
                this.statusCodePaymentsMap.put(statusCodePayment, payments);
            }
            payments.add(payment);
        } else {
            this.rejectedPaymentsWithoutIndividualStatusCode.add(payment);
        }
        StatusTransactionInfo statementTransactionInfo = this.calculatedStatusTransactionInfoMap.get(statusCodePayment);
        if (statementTransactionInfo == null) {
            statementTransactionInfo = new StatusTransactionInfo(statusCodePayment);
            this.calculatedStatusTransactionInfoMap.put(statusCodePayment, statementTransactionInfo);
        }
        statementTransactionInfo.addPayment(payment.getPayment());
    }

    public String getLogicalFileId() {
        return this.originalPmtInfId;
    }

    public List<RejectedSEPAPayment> getRejectedPayments() {
        ArrayList<RejectedSEPAPayment> toReturn = new ArrayList<RejectedSEPAPayment>();
        for (Map.Entry<String, List<RejectedSEPAPayment>> entry : this.statusCodePaymentsMap.entrySet()) {
            toReturn.addAll((Collection<RejectedSEPAPayment>)entry.getValue());
        }
        toReturn.addAll(this.rejectedPaymentsWithoutIndividualStatusCode);
        return toReturn;
    }

    public List<RejectedSEPAPayment> getRejectedPaymentsWithoutIndividualStatusCode() {
        return this.rejectedPaymentsWithoutIndividualStatusCode;
    }

    public Map<String, List<RejectedSEPAPayment>> getStatusCodePaymentsMap() {
        return this.statusCodePaymentsMap;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public Currency getCurrency() {
        Currency found = null;
        boolean allSameCurrency = true;
        List<RejectedSEPAPayment> payments = this.getRejectedPayments();
        if (payments != null) {
            for (RejectedSEPAPayment payment : payments) {
                if (!allSameCurrency) continue;
                if (found == null) {
                    if (payment.getPayment() == null) continue;
                    found = payment.getPayment().getCurrency();
                    continue;
                }
                if (payment.getPayment() == null || payment.getPayment().getCurrency() == null || found.equals(payment.getPayment().getCurrency())) continue;
                allSameCurrency = false;
                found = null;
            }
        }
        return found;
    }

    public Currency getCurrency(String statusCode) {
        StatusTransactionInfo statusTransactionInfo = this.calculatedStatusTransactionInfoMap.get(statusCode);
        if (statusTransactionInfo != null && statusTransactionInfo.getCurrency() != null) {
            return statusTransactionInfo.getCurrency();
        }
        return null;
    }

    public BigDecimal getTotalAmount(String statusCode) {
        StatusTransactionInfo statusTransactionInfo = this.calculatedStatusTransactionInfoMap.get(statusCode);
        if (statusTransactionInfo != null) {
            return statusTransactionInfo.getTotalAmount();
        }
        return null;
    }

    public int getCountTransactions() {
        return this.countTransactions;
    }

    public String getStatusCode() {
        if (this.statusCode == null && this.statusTransactionInfos.size() == 1) {
            return this.statusTransactionInfos.get(0).getStatusCode();
        }
        return this.statusCode;
    }

    public String getUniqueTransactionStatusCode() {
        return this.uniqueTransactionStatusCode;
    }

    public void setUniqueTransactionStatusCode(String uniqueTransactionStatusCode) {
        this.uniqueTransactionStatusCode = uniqueTransactionStatusCode;
    }

    public List<StatusReason> getStatusReasons() {
        return this.statusReasons;
    }

    public void addStatusTransactionInfo(StatusTransactionInfo statusTransactionInfo) {
        this.statusTransactionInfos.add(statusTransactionInfo);
    }

    public List<StatusTransactionInfo> getStatusTransactionInfos() {
        return this.statusTransactionInfos;
    }

    public void addVopLegalInfo(String infoLine) {
        String statusCode = infoLine.substring(0, 4);
        infoLine = infoLine.substring(5);
        Object newInfo = this.vopLegalInfoMap.get(statusCode);
        newInfo = newInfo == null ? "" : (String)newInfo + "\n";
        this.vopLegalInfoMap.put(statusCode, (String)newInfo + infoLine);
    }

    public String getVopLegalInfo(String statusCode) {
        return this.vopLegalInfoMap.getOrDefault(statusCode, "");
    }
}

