/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.format.sepa.AddressType2Code;
import de.businesslogics.format.sepa.CountryCode;
import de.businesslogics.format.sepa.Max16Text;
import de.businesslogics.format.sepa.Max35Text;
import de.businesslogics.format.sepa.Max70Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.SAXException;

public class PostalAddress1
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private AddressType2Code adrTp;
    private List<String> adrLines = Collections.emptyList();
    private String strtNm;
    private String bldgNb;
    private String pstCd;
    private String twnNm;
    private String ctrySubDvsn;
    private CountryCode ctry;

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.adrTp != null) {
            this.adrTp.printOut("AdrTp", ps);
        }
        for (String s : this.adrLines) {
            ps.printStringElement("AdrLine", s);
        }
        if (this.strtNm != null) {
            ps.printStringElement("StrtNm", this.strtNm);
        }
        if (this.bldgNb != null) {
            ps.printStringElement("BldgNb", this.bldgNb);
        }
        if (this.pstCd != null) {
            ps.printStringElement("PstCd", this.pstCd);
        }
        if (this.twnNm != null) {
            ps.printStringElement("TwnNm", this.twnNm);
        }
        if (this.ctrySubDvsn != null) {
            ps.printStringElement("CtrySubDvsn", this.ctrySubDvsn);
        }
        this.ctry.printOut("Ctry", ps);
    }

    public static class Parser
    extends ElementParser {
        private final String URI;
        private final PostalAddress1 toReturn = new PostalAddress1();

        public Parser(String URI2) {
            super(0);
            this.toReturn.adrLines = new ArrayList<String>();
            this.URI = URI2;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (this.URI.equals(uri)) {
                if ("AdrTp".equals(localName) && this.allowChild(0)) {
                    return AddressType2Code.ADDR.createParser();
                }
                if ("AdrLine".equals(localName) && (this.currentChild == 1 && this.toReturn.adrLines.size() < 5 || this.allowChild(-1, 1))) {
                    return new Max70Text.Parser();
                }
                if ("StrtNm".equals(localName) && this.allowChild(-1, 2)) {
                    return new Max70Text.Parser();
                }
                if ("BldgNb".equals(localName) && this.allowChild(-1, 3)) {
                    return new Max16Text.Parser();
                }
                if ("PstCd".equals(localName) && this.allowChild(-1, 4)) {
                    return new Max16Text.Parser();
                }
                if ("TwnNm".equals(localName) && this.allowChild(-1, 5)) {
                    return new Max35Text.Parser();
                }
                if ("CtrySubDvsn".equals(localName) && this.allowChild(-1, 6)) {
                    return new Max35Text.Parser();
                }
                if ("Ctry".equals(localName) && this.allowChild(-1, 7)) {
                    return new CountryCode.Parser();
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.adrTp = (AddressType2Code)element;
                    break;
                }
                case 1: {
                    this.toReturn.adrLines.add(((Max70Text)element).getValue());
                    break;
                }
                case 2: {
                    this.toReturn.strtNm = ((Max70Text)element).getValue();
                    break;
                }
                case 3: {
                    this.toReturn.bldgNb = ((Max16Text)element).getValue();
                    break;
                }
                case 4: {
                    this.toReturn.pstCd = ((Max16Text)element).getValue();
                    break;
                }
                case 5: {
                    this.toReturn.twnNm = ((Max35Text)element).getValue();
                    break;
                }
                case 6: {
                    this.toReturn.ctrySubDvsn = ((Max35Text)element).getValue();
                    break;
                }
                case 7: {
                    this.toReturn.ctry = (CountryCode)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(7);
            return this.toReturn;
        }
    }
}

