/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.format.sepa.LocalInstrumentSDD;
import de.businesslogics.format.sepa.PaymentCategoryPurpose1Code;
import de.businesslogics.format.sepa.SequenceType1Code;
import de.businesslogics.format.sepa.pain00800201.ServiceLevelSDD;
import org.xml.sax.SAXException;

public class PaymentTypeInformationSDD
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private LocalInstrumentSDD lclInstrm;
    private SequenceType1Code seqTp;
    private PaymentCategoryPurpose1Code ctgyPurp;

    private PaymentTypeInformationSDD() {
    }

    public PaymentTypeInformationSDD(LocalInstrumentSDD lclInstrm, SequenceType1Code seqTp) {
        this.lclInstrm = lclInstrm;
        this.seqTp = seqTp;
    }

    public SequenceType1Code getSeqTp() {
        return this.seqTp;
    }

    public LocalInstrumentSDD getLclInstrm() {
        return this.lclInstrm;
    }

    public PaymentCategoryPurpose1Code getCtgyPurp() {
        return this.ctgyPurp;
    }

    public void setCtgyPurp(PaymentCategoryPurpose1Code ctgyPurp) {
        this.ctgyPurp = ctgyPurp;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ServiceLevelSDD.SEPA.printOut("SvcLvl", ps);
        this.lclInstrm.printOut("LclInstrm", ps);
        this.seqTp.printOut("SeqTp", ps);
        if (this.ctgyPurp != null) {
            this.ctgyPurp.printOut("CtgyPurp", ps);
        }
    }

    public static class Parser
    extends ElementParser {
        private final PaymentTypeInformationSDD toReturn = new PaymentTypeInformationSDD();
        private final String parentUri;

        public Parser(String uri) {
            super(0);
            this.parentUri = uri;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (this.parentUri.equals(uri)) {
                if ("SvcLvl".equals(localName) && this.allowChild(0)) {
                    return new ServiceLevelSDD.Parser(uri);
                }
                if ("LclInstrm".equals(localName) && this.allowChild(1)) {
                    return new LocalInstrumentSDD.Parser(uri);
                }
                if ("SeqTp".equals(localName) && this.allowChild(2)) {
                    return SequenceType1Code.FNAL.createParser();
                }
                if ("CtgyPurp".equals(localName) && this.allowChild(3)) {
                    return PaymentCategoryPurpose1Code.CASH.createParser();
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    break;
                }
                case 1: {
                    this.toReturn.lclInstrm = (LocalInstrumentSDD)element;
                    break;
                }
                case 2: {
                    this.toReturn.seqTp = (SequenceType1Code)element;
                    break;
                }
                case 3: {
                    this.toReturn.ctgyPurp = (PaymentCategoryPurpose1Code)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(2);
            return this.toReturn;
        }
    }
}

