/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.ChargeBearerType2Code;
import de.businesslogics.format.sepa.DirectDebitTransactionInformation2;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.Max35Text;
import de.businesslogics.format.sepa.Pain00800101Listener;
import de.businesslogics.format.sepa.PartyIdentification22;
import de.businesslogics.format.sepa.PaymentMethod2Code;
import de.businesslogics.format.sepa.PaymentTypeInformation8;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class PaymentInstructionInformation5
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String pmtInfId;
    private PaymentTypeInformation8 pmtTpInf;
    XMLDate reqdColltnDt;
    private PartyIdentification22 cdtr;
    private CashAccount8 cdtrAcct;
    private FinancialInstitution2 cdtrAgt;
    private List<DirectDebitTransactionInformation2> drctDbtTxInfs;

    private PaymentInstructionInformation5() {
    }

    public PaymentInstructionInformation5(PaymentTypeInformation8 pmtTpInf, XMLDate reqdColltnDt, PartyIdentification22 cdtr, CashAccount8 cdtrAcct, FinancialInstitution2 cdtrAgt, List<DirectDebitTransactionInformation2> drctDbtTxInfs) {
        this.pmtTpInf = pmtTpInf;
        this.reqdColltnDt = reqdColltnDt;
        this.cdtr = cdtr;
        this.cdtrAcct = cdtrAcct;
        this.cdtrAgt = cdtrAgt;
        this.drctDbtTxInfs = drctDbtTxInfs;
    }

    public PaymentTypeInformation8 getPmtTpInf() {
        return this.pmtTpInf;
    }

    public XMLDate getReqdColltnDt() {
        return this.reqdColltnDt;
    }

    public PartyIdentification22 getCdtr() {
        return this.cdtr;
    }

    public CashAccount8 getCdtrAcct() {
        return this.cdtrAcct;
    }

    public FinancialInstitution2 getCdtrAgt() {
        return this.cdtrAgt;
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public List<DirectDebitTransactionInformation2> getDrctDbtTxInfs() {
        return this.drctDbtTxInfs;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.pmtInfId != null) {
            ps.printStringElement("PmtInfId", this.pmtInfId);
        }
        PaymentMethod2Code.DD.printOut("PmtMtd", ps);
        this.pmtTpInf.printOut("PmtTpInf", ps);
        this.reqdColltnDt.printOut("ReqdColltnDt", ps);
        this.cdtr.printOut("Cdtr", ps);
        this.cdtrAcct.printOut("CdtrAcct", ps);
        this.cdtrAgt.printOut("CdtrAgt", ps);
        ChargeBearerType2Code.SLEV.printOut("ChrgBr", ps);
        for (DirectDebitTransactionInformation2 ddti : this.drctDbtTxInfs) {
            ddti.printOut("DrctDbtTxInf", ps);
        }
    }

    static class Parser
    extends ElementParser {
        PaymentInstructionInformation5 toReturn = new PaymentInstructionInformation5();
        final Pain00800101Listener listener;

        public Parser(Pain00800101Listener listener) {
            super(0);
            this.listener = listener;
            if (listener == null) {
                this.toReturn.drctDbtTxInfs = new ArrayList<DirectDebitTransactionInformation2>();
            }
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if ("urn:sepade:xsd:pain.008.001.01".equals(uri)) {
                if ("PmtInfId".equals(localName) && this.allowChild(0)) {
                    return new Max35Text.Parser();
                }
                if ("PmtMtd".equals(localName) && this.allowChild(-1, 1)) {
                    return PaymentMethod2Code.DD.createParser();
                }
                if ("PmtTpInf".equals(localName) && this.allowChild(2)) {
                    return new PaymentTypeInformation8.Parser();
                }
                if ("ReqdColltnDt".equals(localName) && this.allowChild(3)) {
                    return new XMLDate().createParser();
                }
                if ("Cdtr".equals(localName) && this.allowChild(4)) {
                    return new PartyIdentification22.Parser(uri);
                }
                if ("CdtrAcct".equals(localName) && this.allowChild(5)) {
                    return new CashAccount8.Parser(uri);
                }
                if ("CdtrAgt".equals(localName) && this.allowChild(6)) {
                    return new FinancialInstitution2.Parser(uri);
                }
                if ("ChrgBr".equals(localName) && this.allowChild(7)) {
                    return ChargeBearerType2Code.SLEV.createParser();
                }
                if ("DrctDbtTxInf".equals(localName) && (this.currentChild == 8 || this.allowChild(8))) {
                    return new DirectDebitTransactionInformation2.Parser();
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtInfId = ((Max35Text)element).getValue();
                    break;
                }
                case 2: {
                    this.toReturn.pmtTpInf = (PaymentTypeInformation8)element;
                    break;
                }
                case 3: {
                    this.toReturn.reqdColltnDt = (XMLDate)element;
                    break;
                }
                case 4: {
                    this.toReturn.cdtr = (PartyIdentification22)element;
                    break;
                }
                case 5: {
                    this.toReturn.cdtrAcct = (CashAccount8)element;
                    break;
                }
                case 6: {
                    this.toReturn.cdtrAgt = (FinancialInstitution2)element;
                    break;
                }
                case 8: {
                    if (this.listener != null) {
                        this.listener.handleTransaction((DirectDebitTransactionInformation2)element);
                        break;
                    }
                    this.toReturn.drctDbtTxInfs.add((DirectDebitTransactionInformation2)element);
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(8);
            return this.toReturn;
        }
    }
}

