/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.ChargeBearerType2Code;
import de.businesslogics.format.sepa.CreditTransferTransactionInformation2;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.Pain00100102Listener;
import de.businesslogics.format.sepa.PartyIdentification23;
import de.businesslogics.format.sepa.PaymentMethod5Code;
import de.businesslogics.format.sepa.PaymentTypeInformation7;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class PaymentInstructionInformation4
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String pmtInfId;
    XMLDate reqdExctnDt;
    private PartyIdentification23 dbtr;
    private CashAccount8 dbtrAcct;
    private FinancialInstitution2 dbtrAgt;
    private List<CreditTransferTransactionInformation2> cdtTrfTxInfs;

    private PaymentInstructionInformation4() {
    }

    public PaymentInstructionInformation4(XMLDate reqdExctnDt, PartyIdentification23 dbtr, CashAccount8 dbtrAcct, FinancialInstitution2 dbtrAgt, List<CreditTransferTransactionInformation2> cdtTrfTxInfs) {
        this.reqdExctnDt = reqdExctnDt;
        this.dbtr = dbtr;
        this.dbtrAcct = dbtrAcct;
        this.dbtrAgt = dbtrAgt;
        this.cdtTrfTxInfs = cdtTrfTxInfs;
    }

    public XMLDate getReqdExctnDt() {
        return this.reqdExctnDt;
    }

    public List<CreditTransferTransactionInformation2> getCdtTrfTxInfs() {
        return this.cdtTrfTxInfs;
    }

    public PaymentTypeInformation7 getPmtTpInf() {
        return PaymentTypeInformation7.SEPA;
    }

    public PartyIdentification23 getDbtr() {
        return this.dbtr;
    }

    public CashAccount8 getDbtrAcct() {
        return this.dbtrAcct;
    }

    public FinancialInstitution2 getDbtrAgt() {
        return this.dbtrAgt;
    }

    public ChargeBearerType2Code getChrgBr() {
        return ChargeBearerType2Code.SLEV;
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.pmtInfId != null) {
            ps.printStringElement("PmtInfId", this.pmtInfId);
        }
        PaymentMethod5Code.TRF.printOut("PmtMtd", ps);
        PaymentTypeInformation7.SEPA.printOut("PmtTpInf", ps);
        this.reqdExctnDt.printOut("ReqdExctnDt", ps);
        this.dbtr.printOut("Dbtr", ps);
        this.dbtrAcct.printOut("DbtrAcct", ps);
        this.dbtrAgt.printOut("DbtrAgt", ps);
        ChargeBearerType2Code.SLEV.printOut("ChrgBr", ps);
        for (CreditTransferTransactionInformation2 cdtTrfTxInf : this.cdtTrfTxInfs) {
            cdtTrfTxInf.printOut("CdtTrfTxInf", ps);
        }
    }

    static class Parser
    extends ElementParser {
        PaymentInstructionInformation4 toReturn = new PaymentInstructionInformation4();
        final Pain00100102Listener listener;

        public Parser(Pain00100102Listener listener) {
            super(0);
            this.listener = listener;
            if (listener == null) {
                this.toReturn.cdtTrfTxInfs = new ArrayList<CreditTransferTransactionInformation2>();
            }
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if ("urn:sepade:xsd:pain.001.001.02".equals(uri)) {
                if ("PmtInfId".equals(localName) && this.allowChild(0)) {
                    return new SimpleStringElement().createParser();
                }
                if ("PmtMtd".equals(localName) && this.allowChild(-1, 1)) {
                    return PaymentMethod5Code.TRF.createParser();
                }
                if ("PmtTpInf".equals(localName) && this.allowChild(2)) {
                    return new PaymentTypeInformation7.Parser(uri);
                }
                if ("ReqdExctnDt".equals(localName) && this.allowChild(3)) {
                    return new XMLDate().createParser();
                }
                if ("Dbtr".equals(localName) && this.allowChild(4)) {
                    return new PartyIdentification23.Parser(uri);
                }
                if ("DbtrAcct".equals(localName) && this.allowChild(5)) {
                    return new CashAccount8.Parser(uri);
                }
                if ("DbtrAgt".equals(localName) && this.allowChild(6)) {
                    return new FinancialInstitution2.Parser(uri);
                }
                if ("ChrgBr".equals(localName) && this.allowChild(7)) {
                    return ChargeBearerType2Code.SLEV.createParser();
                }
                if ("CdtTrfTxInf".equals(localName) && (this.currentChild == 8 || this.allowChild(8))) {
                    return new CreditTransferTransactionInformation2.Parser();
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtInfId = ((SimpleStringElement)element).getValue();
                    break;
                }
                case 3: {
                    this.toReturn.reqdExctnDt = (XMLDate)element;
                    break;
                }
                case 4: {
                    this.toReturn.dbtr = (PartyIdentification23)element;
                    break;
                }
                case 5: {
                    this.toReturn.dbtrAcct = (CashAccount8)element;
                    break;
                }
                case 6: {
                    this.toReturn.dbtrAgt = (FinancialInstitution2)element;
                    break;
                }
                case 8: {
                    if (this.listener != null) {
                        this.listener.handleTransaction((CreditTransferTransactionInformation2)element);
                        break;
                    }
                    this.toReturn.cdtTrfTxInfs.add((CreditTransferTransactionInformation2)element);
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(8);
            return this.toReturn;
        }
    }
}

