/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.ChargeBearerType2Code;
import de.businesslogics.format.sepa.CreditTransferTransactionInformation5;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.Max35Text;
import de.businesslogics.format.sepa.Pain00100102GrpListener;
import de.businesslogics.format.sepa.PartyIdentification21;
import de.businesslogics.format.sepa.PaymentMethod5Code;
import de.businesslogics.format.sepa.PaymentTypeInformation7;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class PaymentInstructionInformation3
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String pmtInfId;
    private PaymentTypeInformation7 pmtTpInf;
    XMLDate reqdExctnDt;
    private PartyIdentification21 dbtr;
    private CashAccount8 dbtrAcct;
    private FinancialInstitution2 dbtrAgt;
    private ChargeBearerType2Code chrgBr;
    private List<CreditTransferTransactionInformation5> cdtTrfTxInfs;

    private PaymentInstructionInformation3() {
        this.cdtTrfTxInfs = new ArrayList<CreditTransferTransactionInformation5>();
    }

    public PaymentInstructionInformation3(String pmtInfId, XMLDate reqdExctnDt, PartyIdentification21 dbtr, CashAccount8 dbtrAcct, FinancialInstitution2 dbtrAgt, List<CreditTransferTransactionInformation5> cdtTrfTxInfs) {
        this.pmtInfId = pmtInfId;
        this.reqdExctnDt = reqdExctnDt;
        this.dbtr = dbtr;
        this.dbtrAcct = dbtrAcct;
        this.dbtrAgt = dbtrAgt;
        this.cdtTrfTxInfs = cdtTrfTxInfs;
    }

    public XMLDate getReqdExctnDt() {
        return this.reqdExctnDt;
    }

    public PartyIdentification21 getDbtr() {
        return this.dbtr;
    }

    public CashAccount8 getDbtrAcct() {
        return this.dbtrAcct;
    }

    public FinancialInstitution2 getDbtrAgt() {
        return this.dbtrAgt;
    }

    public String getPmtInfId() {
        return this.pmtInfId;
    }

    public PaymentTypeInformation7 getPmtTpInf() {
        return this.pmtTpInf;
    }

    public void setPmtTpInf(PaymentTypeInformation7 pmtTpInf) {
        this.pmtTpInf = pmtTpInf;
    }

    public void setChrgBr(ChargeBearerType2Code chrgBr) {
        this.chrgBr = chrgBr;
    }

    public ChargeBearerType2Code getChrgBr() {
        return this.chrgBr;
    }

    public List<CreditTransferTransactionInformation5> getCdtTrfTxInfs() {
        return this.cdtTrfTxInfs;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.pmtInfId != null) {
            ps.printStringElement("PmtInfId", this.pmtInfId);
        }
        PaymentMethod5Code.TRF.printOut("PmtMtd", ps);
        ps.printOut("PmtTpInf", this.pmtTpInf);
        this.reqdExctnDt.printOut("ReqdExctnDt", ps);
        this.dbtr.printOut("Dbtr", ps);
        this.dbtrAcct.printOut("DbtrAcct", ps);
        this.dbtrAgt.printOut("DbtrAgt", ps);
        ps.printOut("ChrgBr", this.chrgBr);
        for (CreditTransferTransactionInformation5 cdtTrfTxInf : this.cdtTrfTxInfs) {
            cdtTrfTxInf.printOut("CdtTrfTxInf", ps);
        }
    }

    static class Parser
    extends ElementParser {
        PaymentInstructionInformation3 toReturn = new PaymentInstructionInformation3();
        final Pain00100102GrpListener listener;

        public Parser(Pain00100102GrpListener listener) {
            super(0);
            this.listener = listener;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if ("urn:sepade:xsd:pain.001.001.02.grp".equals(uri)) {
                if ("PmtInfId".equals(localName) && this.allowChild(0)) {
                    return new Max35Text.Parser();
                }
                if ("PmtMtd".equals(localName) && this.allowChild(-1, 1)) {
                    return PaymentMethod5Code.TRF.createParser();
                }
                if ("PmtTpInf".equals(localName) && this.allowChild(2)) {
                    return new PaymentTypeInformation7.Parser(uri);
                }
                if ("ReqdExctnDt".equals(localName) && this.allowChild(1, 3)) {
                    return new XMLDate().createParser();
                }
                if ("Dbtr".equals(localName) && this.allowChild(4)) {
                    return new PartyIdentification21.Parser(uri);
                }
                if ("DbtrAcct".equals(localName) && this.allowChild(5)) {
                    return new CashAccount8.Parser(uri);
                }
                if ("DbtrAgt".equals(localName) && this.allowChild(6)) {
                    return new FinancialInstitution2.Parser(uri);
                }
                if ("ChrgBr".equals(localName) && this.allowChild(7)) {
                    return ChargeBearerType2Code.SLEV.createParser();
                }
                if ("CdtTrfTxInf".equals(localName) && (this.currentChild == 8 || this.allowChild(6, 8))) {
                    return new CreditTransferTransactionInformation5.Parser();
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtInfId = ((SimpleStringElement)element).getValue();
                    break;
                }
                case 2: {
                    this.toReturn.pmtTpInf = (PaymentTypeInformation7)element;
                    break;
                }
                case 3: {
                    this.toReturn.reqdExctnDt = (XMLDate)element;
                    break;
                }
                case 4: {
                    this.toReturn.dbtr = (PartyIdentification21)element;
                    break;
                }
                case 5: {
                    this.toReturn.dbtrAcct = (CashAccount8)element;
                    break;
                }
                case 6: {
                    this.toReturn.dbtrAgt = (FinancialInstitution2)element;
                    break;
                }
                case 7: {
                    this.toReturn.chrgBr = (ChargeBearerType2Code)element;
                    break;
                }
                case 8: {
                    if (this.listener != null) {
                        this.listener.handleTransaction((CreditTransferTransactionInformation5)element);
                        break;
                    }
                    this.toReturn.cdtTrfTxInfs.add((CreditTransferTransactionInformation5)element);
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(8);
            return this.toReturn;
        }
    }
}

