/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.sepa.HashAlgorithm;
import de.businesslogics.format.sepa.HashSHA256;
import de.businesslogics.format.sepa.Max4Text;
import de.businesslogics.format.sepa.Min0Max22Text;
import de.businesslogics.format.sepa.Pain00800101ConListener;
import de.businesslogics.format.sepa.Pain00800101Document;
import de.businesslogics.format.sepa.Pain00800101Listener;
import de.businesslogics.format.sepa.TimeStampText;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class Pain00800101ConSepade
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    public static final String URI = "urn:sepade:xsd:pain.001.001.02.con";
    private ContainerId containerId;
    private TimeStamp creDtTm;
    private List<Msg> msg;

    private Pain00800101ConSepade() {
        this.msg = new ArrayList<Msg>();
    }

    public Pain00800101ConSepade(TimeStamp creDtTm, List<Msg> msg) {
        this.creDtTm = creDtTm;
        this.msg = msg;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public void setContainerID(ContainerId containerId) {
        this.containerId = containerId;
    }

    public TimeStamp getCreDtTm() {
        return this.creDtTm;
    }

    public List<Msg> getMsg() {
        return this.msg;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", URI);
        ps.addNamespaceDecl("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    @Override
    public String name() {
        return "sepade";
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.containerId != null) {
            this.containerId.printOut("ContainerId", ps);
        }
        this.creDtTm.printOut("CreDtTm", ps);
        for (Msg m : this.msg) {
            m.printOut("Msg", ps);
        }
    }

    public static class ContainerId
    extends EbicsElement {
        private static final long serialVersionUID = 1L;
        private String senderId;
        private String idType;
        private String timeStamp;

        private ContainerId() {
        }

        public ContainerId(String senderId, String idType, String timeStamp) {
            this.senderId = senderId;
            this.idType = idType;
            this.timeStamp = timeStamp;
        }

        public String getIdType() {
            return this.idType;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void printValue(EbicsPrintStream ps) {
            ps.printStringElement("SenderId", this.senderId);
            ps.printStringElement("IdType", this.idType);
            ps.printStringElement("TimeStamp", this.timeStamp);
        }

        private static class Parser
        extends ElementParser {
            ContainerId toReturn = new ContainerId();

            private Parser() {
                super(0);
            }

            @Override
            protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
                if (Pain00800101ConSepade.URI.equals(uri)) {
                    if ("SenderId".equals(localName) && this.allowChild(0)) {
                        return new Min0Max22Text.Parser();
                    }
                    if ("IdType".equals(localName) && this.allowChild(1)) {
                        return new Max4Text.Parser();
                    }
                    if ("TimeStamp".equals(localName) && this.allowChild(2)) {
                        return new TimeStampText.Parser();
                    }
                }
                return null;
            }

            @Override
            protected void endChild(EbicsElement element) {
                switch (this.currentChild) {
                    case 0: {
                        this.toReturn.senderId = ((Min0Max22Text)element).getValue();
                        break;
                    }
                    case 1: {
                        this.toReturn.idType = ((Max4Text)element).getValue();
                        break;
                    }
                    case 2: {
                        this.toReturn.timeStamp = ((TimeStampText)element).getValue();
                    }
                }
            }

            @Override
            protected EbicsElement endElement() throws SAXException {
                this.checkLastMandatory(2);
                return this.toReturn;
            }
        }
    }

    public static class Msg
    extends EbicsElement {
        private static final long serialVersionUID = 1L;
        private HashSHA256 hashValue;
        private HashAlgorithm hashAlgorithm;
        private Pain00800101Document document;

        public Msg(Pain00800101Document document) {
            this.document = document;
        }

        private Msg() {
        }

        public HashAlgorithm getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        public HashSHA256 getHashValue() {
            return this.hashValue;
        }

        public void setHashValue(HashSHA256 hashValue) {
            this.hashValue = hashValue;
        }

        public Pain00800101Document getDocument() {
            return this.document;
        }

        @Override
        public void printValue(EbicsPrintStream ps) {
            ps.println();
            if (this.hashValue != null) {
                this.hashValue.printOut("HashValue", ps);
            }
            if (this.hashAlgorithm != null) {
                this.hashAlgorithm.printOut("HashAlgorithm", ps);
            }
            this.document.addNamespaceDecls(ps);
            this.document.printOut("Document", ps);
        }

        private static class Parser
        extends ElementParser {
            private final Msg toReturn = new Msg();
            private final Pain00800101Listener listener;

            private Parser(Pain00800101Listener listener) {
                super(0);
                this.listener = listener;
            }

            @Override
            protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
                if (Pain00800101ConSepade.URI.equals(uri)) {
                    if ("HashValue".equals(localName) && this.allowChild(0)) {
                        return new HashSHA256.Parser();
                    }
                    if ("HashAlgorithm".equals(localName) && this.allowChild(-1, 1)) {
                        return HashAlgorithm.SHA256.createParser();
                    }
                }
                if ("urn:sepade:xsd:pain.008.001.01".equals(uri) && "Document".equals(localName) && this.allowChild(-1, 2)) {
                    return new Pain00800101Document.MyParser(this.listener);
                }
                return null;
            }

            @Override
            protected void endChild(EbicsElement element) {
                switch (this.currentChild) {
                    case 0: {
                        this.toReturn.hashValue = (HashSHA256)element;
                        break;
                    }
                    case 1: {
                        this.toReturn.hashAlgorithm = (HashAlgorithm)element;
                        break;
                    }
                    case 2: {
                        if (this.listener != null) break;
                        this.toReturn.document = (Pain00800101Document)element;
                    }
                }
            }

            @Override
            protected EbicsElement endElement() throws SAXException {
                this.checkLastMandatory(2);
                return this.toReturn;
            }
        }
    }

    private static class MyParser
    extends ElementParser {
        final Pain00800101ConListener listener;
        final Pain00800101ConSepade toReturn = new Pain00800101ConSepade();

        MyParser(Pain00800101ConListener listener) {
            super(0);
            this.listener = listener;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (Pain00800101ConSepade.URI.equals(uri)) {
                if ("ContainerId".equals(localName) && this.allowChild(0)) {
                    return new ContainerId.Parser();
                }
                if ("CreDtTm".equals(localName) && this.allowChild(-1, 1)) {
                    return new TimeStamp(null).createParser();
                }
                if ("Msg".equals(localName) && (this.currentChild == 2 || this.allowChild(2))) {
                    return new Msg.Parser(this.listener);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.containerId = (ContainerId)element;
                    break;
                }
                case 1: {
                    this.toReturn.creDtTm = (TimeStamp)element;
                    break;
                }
                case 2: {
                    if (this.listener == null) {
                        this.toReturn.msg.add((Msg)element);
                        break;
                    }
                    this.listener.endMsg((Msg)element);
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(2);
            return this.toReturn;
        }
    }

    public static class Parser
    extends ElementParser {
        final Pain00800101ConListener listener;

        public Parser(Pain00800101ConListener listener) {
            super(0);
            this.listener = listener;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (Pain00800101ConSepade.URI.equals(uri) && "sepade".equals(localName) && this.allowChild(0)) {
                return new MyParser(this.listener);
            }
            return null;
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(0);
            return null;
        }
    }
}

