/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.format.sepa.CCTTicketI;
import de.businesslogics.format.sepa.CreditTransferTransactionInformation5;
import de.businesslogics.format.sepa.PaymentInstructionInformation3;
import de.businesslogics.util.Currency;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Pain00100102GrpSingleTicket
implements CCTTicketI,
Serializable {
    private static final long serialVersionUID = 1L;
    private String paymentInformationIdentification;
    private String debitorBIC;
    private String debitorAccount;
    private String debitorName;
    private YYMMDD requestedExecutionDate;
    private BigDecimal ctrlSum;
    private int numberOfPayments;

    public void startPaymentInstructionInformation(PaymentInstructionInformation3 pmtInf) {
        this.ctrlSum = BigDecimal.ZERO;
        this.numberOfPayments = 0;
    }

    public void endPaymentInstructionInformation(PaymentInstructionInformation3 pmtInf) {
        this.paymentInformationIdentification = pmtInf.getPmtInfId();
        this.debitorBIC = pmtInf.getDbtrAgt().getFinInstnId().getBic();
        this.debitorAccount = pmtInf.getDbtrAcct().getId().getIban();
        this.debitorName = pmtInf.getDbtr().getNm();
        this.requestedExecutionDate = pmtInf.getReqdExctnDt().getDate();
    }

    @Override
    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    @Override
    public BigDecimal getGivenCtrlSum() {
        return null;
    }

    @Override
    public int getGivenNumberOfPayments() {
        return -1;
    }

    @Override
    public String getDebitorAccount() {
        return this.debitorAccount;
    }

    @Override
    public Currency getDebitorAccountCcy() {
        return Currency.getInstance("EUR");
    }

    @Override
    public String getDebitorBIC() {
        return this.debitorBIC;
    }

    @Override
    public String getDebitorName() {
        return this.debitorName;
    }

    @Override
    public int getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void handleTransaction(CreditTransferTransactionInformation5 crdt) {
        this.ctrlSum = this.ctrlSum.add(crdt.getAmt().getInstdAmt().getAmount());
        ++this.numberOfPayments;
    }

    @Override
    public void appendText(Locale locale, StringBuilder buffer) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.sepa.Sepa", locale);
        this.appendMost(bundle, locale, buffer);
        buffer.append(bundle.getString("MAIN_SEPARATOR"));
    }

    @Override
    public void appendMost(ResourceBundle bundle, Locale locale, StringBuilder buffer) {
        buffer.append(bundle.getString("MINOR_SEPARATOR"));
        buffer.append("\r\n");
        if (this.paymentInformationIdentification != null) {
            buffer.append(bundle.getString("SAMMLERREFERENZ"));
            buffer.append(this.paymentInformationIdentification);
            buffer.append("\r\n");
        }
        buffer.append(bundle.getString("BANK_CODE"));
        buffer.append(this.debitorBIC);
        buffer.append("\r\n");
        buffer.append(bundle.getString("KONTONUMMER"));
        buffer.append(this.debitorAccount);
        buffer.append("\r\n");
        Object s = bundle.getString("AUFTRAGGEBERDATEN") + this.debitorName;
        if (((String)s).length() > 72) {
            s = ((String)s).substring(0, 72);
        }
        buffer.append((String)s);
        buffer.append("\r\n");
        buffer.append(bundle.getString("ANZAHL_DER_ZAHLUNGSSAETZE"));
        buffer.append(this.numberOfPayments);
        buffer.append("\r\n");
        buffer.append(bundle.getString("SUMME_DER_BETRAEGE"));
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(locale));
        buffer.append(df.format(this.ctrlSum));
        buffer.append("\r\n");
        buffer.append(bundle.getString("AUSFUEHRUNGSTERMIN"));
        buffer.append(new SimpleDateFormat(bundle.getString("DATE_FORMAT")).format(this.requestedExecutionDate));
        buffer.append("\r\n");
    }

    @Override
    public String getPaymentInformationIdentification() {
        return this.paymentInformationIdentification;
    }

    @Override
    public YYMMDD getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }
}

