/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import java.io.IOException;
import java.io.InputStream;

public class MultipleInputStream
extends InputStream {
    private static final byte[] END_OF_COMMENT = new byte[]{45, 45, 62};
    private static final byte[] END_OF_CDATA = new byte[]{93, 93, 62};
    private static final byte[] END_OF_PROCESSING = new byte[]{63, 62};
    InputStream in;
    byte[] buffer = new byte[4096];
    int readPos;
    int writePos;
    int depth;
    int toSkip;
    private byte[] skipUntil;

    public MultipleInputStream(InputStream is) {
        this.in = is;
    }

    @Override
    public int read() throws IOException {
        int i;
        if (this.depth == -2) {
            return -1;
        }
        while (this.readPos + 9 > this.writePos && this.in != null) {
            if (this.readPos > 0) {
                System.arraycopy(this.buffer, this.readPos, this.buffer, 0, this.writePos - this.readPos);
                this.writePos -= this.readPos;
                this.readPos = 0;
            }
            if (this.in == null) continue;
            i = this.in.read(this.buffer, this.writePos, this.buffer.length - this.writePos);
            if (i < 0) {
                this.in.close();
                this.in = null;
                continue;
            }
            this.writePos += i;
        }
        if (this.skipUntil != null && this.readPos + this.skipUntil.length <= this.writePos) {
            i = this.skipUntil.length;
            while (--i >= 0 && this.skipUntil[i] == this.buffer[this.readPos + i]) {
            }
            if (i < 0) {
                this.toSkip = this.skipUntil.length;
                this.skipUntil = null;
            }
        }
        if (this.toSkip == 0 && this.readPos + 2 <= this.writePos) {
            if (this.buffer[this.readPos] == 60) {
                if (this.readPos + 4 <= this.writePos && this.buffer[this.readPos + 1] == 33 && this.buffer[this.readPos + 2] == 45 && this.buffer[this.readPos + 3] == 45) {
                    this.toSkip = 4;
                    this.skipUntil = END_OF_COMMENT;
                } else if (this.readPos + 9 <= this.writePos && this.buffer[this.readPos + 1] == 33 && this.buffer[this.readPos + 2] == 91 && this.buffer[this.readPos + 3] == 67 && this.buffer[this.readPos + 4] == 68 && this.buffer[this.readPos + 5] == 65 && this.buffer[this.readPos + 6] == 84 && this.buffer[this.readPos + 7] == 65 && this.buffer[this.readPos + 8] == 91) {
                    this.toSkip = 9;
                    this.skipUntil = END_OF_CDATA;
                } else if (this.readPos + 5 <= this.writePos && this.buffer[this.readPos + 1] == 63 && this.buffer[this.readPos + 2] == 120 && this.buffer[this.readPos + 3] == 109 && this.buffer[this.readPos + 4] == 108) {
                    this.toSkip = 5;
                    this.skipUntil = END_OF_PROCESSING;
                    if (this.depth == -1) {
                        this.depth = -2;
                        return -1;
                    }
                } else if (this.buffer[this.readPos + 1] == 63) {
                    this.toSkip = 2;
                    this.skipUntil = END_OF_PROCESSING;
                } else {
                    if (this.depth == -1) {
                        this.depth = -2;
                        return -1;
                    }
                    if (this.buffer[this.readPos + 1] == 47) {
                        --this.depth;
                        if (this.depth == 0) {
                            this.depth = -1;
                        }
                    } else {
                        ++this.depth;
                    }
                }
            } else if (this.buffer[this.readPos] == 47 && this.buffer[this.readPos + 1] == 62) {
                --this.depth;
                if (this.depth == 0) {
                    this.depth = -1;
                }
            }
        }
        if (this.readPos < this.writePos) {
            if (this.toSkip > 0) {
                --this.toSkip;
            }
            return this.buffer[this.readPos++] & 0xFF;
        }
        return -1;
    }

    public boolean reopen() throws IOException {
        if (this.depth != -2) {
            return false;
        }
        this.depth = 0;
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.depth != -2) {
            this.realClose();
        }
    }

    public void realClose() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }
}

