/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.DecimalElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.sepa.BatchBookingIndicator;
import de.businesslogics.format.sepa.Grouping1CodeSDD;
import de.businesslogics.format.sepa.RestrictedIdentification1;
import de.businesslogics.format.sepa.pain00800201.PartyIdentificationSDD1;
import java.math.BigDecimal;
import java.util.Date;
import org.xml.sax.SAXException;

public class GroupHeaderSDD
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private RestrictedIdentification1 msgId;
    private Date creDtTm;
    private BatchBookingIndicator btchBookg;
    private BigDecimal ctrlSum;
    private long nbOfTxs;
    private Grouping1CodeSDD grpg;
    private PartyIdentificationSDD1 initgPty;

    private GroupHeaderSDD() {
    }

    public GroupHeaderSDD(RestrictedIdentification1 msgId, Date creDtTm, long nbOfTxs, PartyIdentificationSDD1 initgPty, Grouping1CodeSDD grpg) {
        this.msgId = msgId;
        this.creDtTm = creDtTm;
        this.nbOfTxs = nbOfTxs;
        this.initgPty = initgPty;
        this.grpg = grpg;
    }

    public Date getCreDtTm() {
        return this.creDtTm;
    }

    public BatchBookingIndicator getBtchBookg() {
        return this.btchBookg;
    }

    public void setBtchBookg(BatchBookingIndicator btchBookg) {
        this.btchBookg = btchBookg;
    }

    public RestrictedIdentification1 getMsgId() {
        return this.msgId;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public void setCtrlSum(BigDecimal ctrlSum) {
        this.ctrlSum = ctrlSum;
    }

    public long getNbOfTxs() {
        return this.nbOfTxs;
    }

    public PartyIdentificationSDD1 getInitgPty() {
        return this.initgPty;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.msgId.printOut("MsgId", ps);
        TimeStamp.printOut(this.creDtTm, "CreDtTm", ps);
        if (this.btchBookg != null) {
            this.btchBookg.printOut("BtchBookg", ps);
        }
        ps.printStringElement("NbOfTxs", Long.toString(this.nbOfTxs));
        if (this.ctrlSum != null) {
            DecimalElement.printOut(this.ctrlSum, "CtrlSum", ps);
        }
        this.grpg.printOut("Grpg", ps);
        this.initgPty.printOut("InitgPty", ps);
    }

    public static class Parser
    extends ElementParser {
        public final GroupHeaderSDD toReturn = new GroupHeaderSDD();
        final String parentURI;

        public Parser(String parentURI) {
            super(0);
            this.parentURI = parentURI;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (this.parentURI.equals(uri)) {
                if ("MsgId".equals(localName) && this.allowChild(0)) {
                    return new RestrictedIdentification1.Parser();
                }
                if ("CreDtTm".equals(localName) && this.allowChild(1)) {
                    return new TimeStamp(null).createParser();
                }
                if ("BtchBookg".equals(localName) && this.allowChild(2)) {
                    return new BatchBookingIndicator().createParser();
                }
                if ("NbOfTxs".equals(localName) && this.allowChild(1, 3)) {
                    return new IntegerElement().createParser();
                }
                if ("CtrlSum".equals(localName) && this.allowChild(4)) {
                    return new DecimalElement().createParser();
                }
                if ("Grpg".equals(localName) && this.allowChild(3, 5)) {
                    return Grouping1CodeSDD.MIXD.createParser();
                }
                if ("InitgPty".equals(localName) && this.allowChild(6)) {
                    return new PartyIdentificationSDD1.Parser(uri);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.msgId = (RestrictedIdentification1)element;
                    break;
                }
                case 1: {
                    this.toReturn.creDtTm = ((TimeStamp)element).getDate();
                    break;
                }
                case 2: {
                    this.toReturn.btchBookg = (BatchBookingIndicator)element;
                    break;
                }
                case 3: {
                    this.toReturn.nbOfTxs = ((IntegerElement)element).longValue();
                    break;
                }
                case 4: {
                    this.toReturn.ctrlSum = ((DecimalElement)element).getValue();
                    break;
                }
                case 5: {
                    this.toReturn.grpg = (Grouping1CodeSDD)element;
                    break;
                }
                case 6: {
                    this.toReturn.initgPty = (PartyIdentificationSDD1)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(6);
            return this.toReturn;
        }
    }
}

