/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.DecimalElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.sepa.Grouping1Code;
import de.businesslogics.format.sepa.Max35Text;
import de.businesslogics.format.sepa.PartyIdentification13;
import java.math.BigDecimal;
import java.util.Date;
import org.xml.sax.SAXException;

public class GroupHeader24
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String msgId;
    private Date creDtTm;
    private BigDecimal ctrlSum;
    private long nbOfTxs;
    private Grouping1Code grpg;
    private PartyIdentification13 initgPty;

    private GroupHeader24() {
    }

    public GroupHeader24(String msgId, Date creDtTm, long nbOfTxs, PartyIdentification13 initgPty, Grouping1Code grpg) {
        this.msgId = msgId;
        this.creDtTm = creDtTm;
        this.nbOfTxs = nbOfTxs;
        this.initgPty = initgPty;
        this.grpg = grpg;
    }

    public Date getCreDtTm() {
        return this.creDtTm;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public void setCtrlSum(BigDecimal ctrlSum) {
        this.ctrlSum = ctrlSum;
    }

    public long getNbOfTxs() {
        return this.nbOfTxs;
    }

    public PartyIdentification13 getInitgPty() {
        return this.initgPty;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.printStringElement("MsgId", this.msgId);
        TimeStamp.printOut(this.creDtTm, "CreDtTm", ps);
        ps.printStringElement("NbOfTxs", Long.toString(this.nbOfTxs));
        if (this.ctrlSum != null) {
            DecimalElement.printOut(this.ctrlSum, "CtrlSum", ps);
        }
        this.grpg.printOut("Grpg", ps);
        this.initgPty.printOut("InitgPty", ps);
    }

    public static class Parser
    extends ElementParser {
        public final GroupHeader24 toReturn = new GroupHeader24();
        final String parentURI;

        public Parser(String parentURI) {
            super(0);
            this.parentURI = parentURI;
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if (this.parentURI.equals(uri)) {
                if ("MsgId".equals(localName) && this.allowChild(0)) {
                    return new Max35Text.Parser();
                }
                if ("CreDtTm".equals(localName) && this.allowChild(1)) {
                    return new TimeStamp(null).createParser();
                }
                if ("NbOfTxs".equals(localName) && this.allowChild(2)) {
                    return new IntegerElement().createParser();
                }
                if ("CtrlSum".equals(localName) && this.allowChild(3)) {
                    return new DecimalElement().createParser();
                }
                if ("Grpg".equals(localName) && this.allowChild(2, 4)) {
                    return Grouping1Code.GRPD.createParser();
                }
                if ("InitgPty".equals(localName) && this.allowChild(5)) {
                    return new PartyIdentification13.Parser(uri);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.msgId = ((Max35Text)element).getValue();
                    break;
                }
                case 1: {
                    this.toReturn.creDtTm = ((TimeStamp)element).getDate();
                    break;
                }
                case 2: {
                    this.toReturn.nbOfTxs = ((IntegerElement)element).longValue();
                    break;
                }
                case 3: {
                    this.toReturn.ctrlSum = ((DecimalElement)element).getValue();
                    break;
                }
                case 4: {
                    this.toReturn.grpg = (Grouping1Code)element;
                    break;
                }
                case 5: {
                    this.toReturn.initgPty = (PartyIdentification13)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(5);
            return this.toReturn;
        }
    }
}

