/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.DecimalElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.IntegerElement;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.sepa.Grouping2Code;
import de.businesslogics.format.sepa.PartyIdentification20;
import java.math.BigDecimal;
import java.util.Date;
import org.xml.sax.SAXException;

public class GroupHeader20
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String msgId;
    private Date creDtTm;
    private BigDecimal ctrlSum;
    private long nbOfTxs;
    private PartyIdentification20 initgPty;

    public GroupHeader20() {
    }

    public GroupHeader20(String msgId, Date creDtTm, long nbOfTxs, PartyIdentification20 initgPty) {
        this.msgId = msgId;
        this.creDtTm = creDtTm;
        this.nbOfTxs = nbOfTxs;
        this.initgPty = initgPty;
    }

    public Date getCreDtTm() {
        return this.creDtTm;
    }

    public void setCreDtTm(Date creDtTm) {
        this.creDtTm = creDtTm;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public BigDecimal getCtrlSum() {
        return this.ctrlSum;
    }

    public void setCtrlSum(BigDecimal ctrlSum) {
        this.ctrlSum = ctrlSum;
    }

    public long getNbOfTxs() {
        return this.nbOfTxs;
    }

    public void setNbOfTxs(long nbOfTxs) {
        this.nbOfTxs = nbOfTxs;
    }

    public PartyIdentification20 getInitgPty() {
        return this.initgPty;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.printStringElement("MsgId", this.msgId);
        TimeStamp.printOut(this.creDtTm, "CreDtTm", ps);
        ps.printStringElement("NbOfTxs", Long.toString(this.nbOfTxs));
        if (this.ctrlSum != null) {
            DecimalElement.printOut(this.ctrlSum, "CtrlSum", ps);
        }
        Grouping2Code.GRPD.printOut("Grpg", ps);
        this.initgPty.printOut("InitgPty", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("MsgId".equals(localName) && parser.allowChild(0)) {
                return new SimpleStringElement();
            }
            if ("CreDtTm".equals(localName) && parser.allowChild(1)) {
                return new TimeStamp();
            }
            if ("NbOfTxs".equals(localName) && parser.allowChild(2)) {
                return new IntegerElement();
            }
            if ("CtrlSum".equals(localName) && parser.allowChild(3)) {
                return new DecimalElement();
            }
            if ("Grpg".equals(localName) && parser.allowChild(2, 4)) {
                return Grouping2Code.GRPD;
            }
            if ("InitgPty".equals(localName) && parser.allowChild(5)) {
                this.initgPty = new PartyIdentification20();
                return this.initgPty;
            }
        }
        return null;
    }

    @Override
    protected void endChild(ElementParser parser, EbicsElement element) {
        switch (parser.getCurrentChild()) {
            case 0: {
                this.msgId = ((SimpleStringElement)element).getValue();
                break;
            }
            case 1: {
                this.creDtTm = ((TimeStamp)element).getDate();
                break;
            }
            case 2: {
                this.nbOfTxs = ((IntegerElement)element).longValue();
                break;
            }
            case 3: {
                this.ctrlSum = ((DecimalElement)element).getValue();
            }
        }
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(5);
    }
}

