/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.sepa.SEPADebitExtractorV2;
import de.businesslogics.format.sepa.SEPADebitExtractorV2Iso;
import de.businesslogics.format.sepa.SEPADebitExtractorV3;
import de.businesslogics.format.sepa.SEPADebitExtractorV3Iso;
import de.businesslogics.format.sepa.SEPADebitExtractorV4;
import de.businesslogics.format.sepa.SEPADebitExtractorV5;
import de.businesslogics.format.sepa.SEPADebitExtractorV8Iso;
import de.businesslogics.format.sepa.SEPAExtractorV2;
import de.businesslogics.format.sepa.SEPAExtractorV2Iso;
import de.businesslogics.format.sepa.SEPAExtractorV3;
import de.businesslogics.format.sepa.SEPAExtractorV3Ch;
import de.businesslogics.format.sepa.SEPAExtractorV3Iso;
import de.businesslogics.format.sepa.SEPAExtractorV4;
import de.businesslogics.format.sepa.SEPAExtractorV5;
import de.businesslogics.format.sepa.SEPAExtractorV8Iso;
import de.businesslogics.format.sepa.SEPAExtractorV9Iso;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.xml.sax.SAXException;

public class GeneralSEPAWriter {
    public static final Version DEFAULT_VERSION = Version.V30;
    public static final Version DEFAULT_CREDIT_VERSION = Version.Iso00100109;
    public static final Version DEFAULT_FOREIGN_VERSION = Version.Iso00100109;
    public static final Version DEFAULT_DEBIT_VERSION = Version.Iso00800108;
    private static boolean prettyXML = false;

    public static boolean isPrettyXML() {
        return prettyXML;
    }

    public static void setPrettyXML(boolean prettyXML) {
        GeneralSEPAWriter.prettyXML = prettyXML;
    }

    public static boolean isVersion30orNewer(Version version) {
        return !Version.V24.equals((Object)version) && !Version.V25.equals((Object)version) && !Version.V27.equals((Object)version) && !Version.V24Iso.equals((Object)version);
    }

    public static boolean allowDTAUSChars(Version version) {
        return !Version.V24.equals((Object)version) && !Version.V24Iso.equals((Object)version) && !Version.V25.equals((Object)version) && !Version.V25Iso.equals((Object)version);
    }

    public static boolean isCOR1Supported(Version version) {
        return Version.V27.equals((Object)version);
    }

    public static void write(Version version, SEPAPaymentData paymentData, OutputStream out) throws IOException {
        EbicsElement d = GeneralSEPAWriter.getDocument(version, paymentData);
        EbicsPrintStream eps = new EbicsPrintStream(out);
        eps.setPretty(prettyXML);
        eps.printOutPossibleRoot(d);
    }

    private static EbicsElement getDocument(Version version, SEPAPaymentData paymentData) throws IOException {
        if (paymentData.isCredit()) {
            if (Version.V30.equals((Object)version)) {
                return SEPAExtractorV5.getCreditDocument(paymentData);
            }
            if (Version.Iso00100108.equals((Object)version)) {
                return SEPAExtractorV8Iso.getCreditDocument(paymentData);
            }
            if (Version.Iso00100109.equals((Object)version)) {
                return SEPAExtractorV9Iso.getCreditDocument(paymentData);
            }
            if (Version.V25Iso.equals((Object)version)) {
                return SEPAExtractorV3Iso.getCreditDocument(paymentData);
            }
            if (Version.V25IsoATX.equals((Object)version)) {
                return SEPAExtractorV3Iso.getATXCreditDocument(paymentData);
            }
            if (Version.V30Ch.equals((Object)version)) {
                return SEPAExtractorV3Ch.getCreditDocument(paymentData);
            }
            if (Version.V25.equals((Object)version)) {
                return SEPAExtractorV3.getCreditDocument(paymentData);
            }
            if (Version.V24.equals((Object)version)) {
                return SEPAExtractorV2.getCreditDocument(paymentData);
            }
            return SEPAExtractorV4.getCreditDocument(paymentData);
        }
        if (Version.Iso00800108.equals((Object)version)) {
            return SEPADebitExtractorV8Iso.getDebitDocument(paymentData);
        }
        if (Version.V30.equals((Object)version)) {
            return SEPADebitExtractorV5.getDebitDocument(paymentData);
        }
        if (Version.V25Iso.equals((Object)version)) {
            return SEPADebitExtractorV3Iso.getDebitDocument(paymentData);
        }
        if (Version.V25.equals((Object)version)) {
            return SEPADebitExtractorV3.getDebitDocument(paymentData);
        }
        if (Version.V24.equals((Object)version)) {
            return SEPADebitExtractorV2.getDebitDocument(paymentData);
        }
        return SEPADebitExtractorV4.getDebitDocument(paymentData);
    }

    public static void write(Version version, boolean isCredit, String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists, OutputStream out) throws IOException, SAXException {
        EbicsElement d = GeneralSEPAWriter.getDocument(version, isCredit, messageId, initiatingParty, paymentLists);
        EbicsPrintStream eps = new EbicsPrintStream(out);
        eps.setPretty(prettyXML);
        eps.printOutPossibleRoot(d);
    }

    public static String buildPmtInfId(String baseId, int pos, int numberOfTransactions) {
        String appendix = "-" + pos + "-" + numberOfTransactions;
        if (baseId.length() + appendix.length() > 35) {
            return baseId.substring(0, 35 - appendix.length()) + "-" + pos;
        }
        return baseId + "-" + pos;
    }

    private static EbicsElement getDocument(Version version, boolean isCredit, String messageId, String initiatingParty, List<List<SEPAPaymentData>> paymentLists) throws IOException, SAXException {
        if (isCredit) {
            if (Version.V30.equals((Object)version)) {
                return SEPAExtractorV5.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.V25.equals((Object)version)) {
                return SEPAExtractorV3.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.V30Ch.equals((Object)version)) {
                return SEPAExtractorV3Ch.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.V24.equals((Object)version)) {
                return SEPAExtractorV2.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.V24Iso.equals((Object)version)) {
                return SEPAExtractorV2Iso.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.V25Iso.equals((Object)version)) {
                return SEPAExtractorV3Iso.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.V25IsoATX.equals((Object)version)) {
                return SEPAExtractorV3Iso.getATXCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.Iso00100108.equals((Object)version)) {
                return SEPAExtractorV8Iso.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            if (Version.Iso00100109.equals((Object)version)) {
                return SEPAExtractorV9Iso.getCreditDocument(messageId, initiatingParty, paymentLists);
            }
            return SEPAExtractorV4.getCreditDocument(messageId, initiatingParty, paymentLists);
        }
        if (Version.Iso00800108.equals((Object)version)) {
            return SEPADebitExtractorV8Iso.getDebitDocument(messageId, initiatingParty, paymentLists);
        }
        if (Version.V30.equals((Object)version)) {
            return SEPADebitExtractorV5.getDebitDocument(messageId, initiatingParty, paymentLists);
        }
        if (Version.V25.equals((Object)version)) {
            return SEPADebitExtractorV3.getDebitDocument(messageId, initiatingParty, paymentLists);
        }
        if (Version.V24.equals((Object)version)) {
            return SEPADebitExtractorV2.getDebitDocument(messageId, initiatingParty, paymentLists);
        }
        if (Version.V24Iso.equals((Object)version)) {
            return SEPADebitExtractorV2Iso.getDebitDocument(messageId, initiatingParty, paymentLists);
        }
        if (Version.V25Iso.equals((Object)version)) {
            return SEPADebitExtractorV3Iso.getDebitDocument(messageId, initiatingParty, paymentLists);
        }
        return SEPADebitExtractorV4.getDebitDocument(messageId, initiatingParty, paymentLists);
    }

    public static enum Version {
        V24(false),
        V25(false),
        V27(false),
        V24Iso(false),
        V25Iso(false),
        V30(false),
        V30Ch(false),
        Iso00100108(false),
        Iso00100109(true),
        Iso00800108(true),
        V25IsoATX(false);

        private final boolean requiresStructuredAddress;

        private Version(boolean requiresStructuredAddress) {
            this.requiresStructuredAddress = requiresStructuredAddress;
        }

        public boolean requiresStructuredAddress() {
            return this.requiresStructuredAddress;
        }
    }

    public static enum DebitType {
        CORE,
        B2B,
        COR1;

    }

    public static enum ServiceLevel {
        SEPA,
        URGP,
        INST;

    }
}

