/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.sepa.MultipleInputStream;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.SEPAReportExtractor00200110;
import de.businesslogics.format.sepa.SEPAReportExtractorV3Iso;
import de.businesslogics.format.sepa.SEPAReportExtractorV5;
import de.businesslogics.format.sepa.pain00200103.Document;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class GeneralSEPAReportExtractor {
    public static List<RejectedSEPAOrder> getRejectedOrders(InputStream is) throws IOException, SAXException {
        ArrayList<RejectedSEPAOrder> rejectedOrders = new ArrayList<RejectedSEPAOrder>();
        for (EbicsElement d : GeneralSEPAReportExtractor.getDocuments(is)) {
            if (d instanceof de.businesslogics.format.iso20022.pain00200110.Document) {
                rejectedOrders.add(SEPAReportExtractor00200110.getRejectedOrder((de.businesslogics.format.iso20022.pain00200110.Document)d));
                continue;
            }
            if (d instanceof Document) {
                rejectedOrders.add(SEPAReportExtractorV5.getRejectedOrder((Document)d));
                continue;
            }
            if (d instanceof de.businesslogics.format.iso20022.pain00200103.Document) {
                rejectedOrders.add(SEPAReportExtractorV3Iso.getRejectedOrder((de.businesslogics.format.iso20022.pain00200103.Document)d));
                continue;
            }
            throw new IOException("Unsupported SEPA version");
        }
        return rejectedOrders;
    }

    public static List<EbicsElement> getDocuments(InputStream is) throws IOException, SAXException {
        ArrayList<EbicsElement> documents = new ArrayList<EbicsElement>();
        MultipleInputStream mis = new MultipleInputStream(is);
        do {
            RootChoiceParser p = new RootChoiceParser();
            p.addPossibleRoot(de.businesslogics.format.iso20022.pain00200110.Document.class);
            p.addPossibleRoot(de.businesslogics.format.iso20022.pain00200103.Document.class);
            p.addPossibleRoot(Document.class);
            EbicsHandler h = new EbicsHandler(p);
            h.setValidate(false);
            documents.add(h.parse(mis));
        } while (mis.reopen());
        mis.realClose();
        return documents;
    }

    public static Date getCreationDate(EbicsElement d) {
        if (d instanceof de.businesslogics.format.iso20022.pain00200110.Document) {
            return ((de.businesslogics.format.iso20022.pain00200110.Document)d).getCstmrPmtStsRpt().getGrpHdr().getCreDtTm().getDate();
        }
        if (d instanceof de.businesslogics.format.iso20022.pain00200103.Document) {
            return ((de.businesslogics.format.iso20022.pain00200103.Document)d).getCstmrPmtStsRpt().getGrpHdr().getCreDtTm().getDate();
        }
        if (d instanceof Document) {
            return ((Document)d).getCstmrPmtStsRpt().getGrpHdr().getCreDtTm().getDate();
        }
        return null;
    }

    public static boolean isDebitReport(EbicsElement d) {
        String orglMsgType = null;
        if (d instanceof de.businesslogics.format.iso20022.pain00200110.Document) {
            orglMsgType = ((de.businesslogics.format.iso20022.pain00200110.Document)d).getCstmrPmtStsRpt().getOrgnlGrpInfAndSts().getOrgnlMsgNmId().getValue();
        } else if (d instanceof de.businesslogics.format.iso20022.pain00200103.Document) {
            orglMsgType = ((de.businesslogics.format.iso20022.pain00200103.Document)d).getCstmrPmtStsRpt().getOrgnlGrpInfAndSts().getOrgnlMsgNmId().getValue();
        } else if (d instanceof Document) {
            orglMsgType = ((Document)d).getCstmrPmtStsRpt().getOrgnlGrpInfAndSts().getOrgnlMsgNmId().getValue();
        }
        return orglMsgType != null && orglMsgType.startsWith("pain.008");
    }

    public static boolean isInstantPaymentReport(EbicsElement d) {
        if (d instanceof de.businesslogics.format.iso20022.pain00200110.Document) {
            return SEPAReportExtractor00200110.isInstantPaymentReport((de.businesslogics.format.iso20022.pain00200110.Document)d);
        }
        if (d instanceof de.businesslogics.format.iso20022.pain00200103.Document) {
            return SEPAReportExtractorV3Iso.isInstantPaymentReport((de.businesslogics.format.iso20022.pain00200103.Document)d);
        }
        return false;
    }

    public static boolean isVopReport(EbicsElement d, boolean defaultValue) {
        if (d instanceof de.businesslogics.format.iso20022.pain00200110.Document) {
            return SEPAReportExtractor00200110.isVopReport((de.businesslogics.format.iso20022.pain00200110.Document)d, defaultValue);
        }
        return false;
    }

    public static void addNameSpaceDecl(EbicsPrintStream eps, EbicsElement d) {
        eps.addNamespaceDecl("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }
}

