/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.iso20022.pain00100103.Document2;
import de.businesslogics.format.sepa.Pain00100102GrpDocument;
import de.businesslogics.format.sepa.SEPADebitExtractorDk33;
import de.businesslogics.format.sepa.SEPADebitExtractorV2;
import de.businesslogics.format.sepa.SEPADebitExtractorV2Iso;
import de.businesslogics.format.sepa.SEPADebitExtractorV3;
import de.businesslogics.format.sepa.SEPADebitExtractorV3Iso;
import de.businesslogics.format.sepa.SEPADebitExtractorV4;
import de.businesslogics.format.sepa.SEPADebitExtractorV5;
import de.businesslogics.format.sepa.SEPADebitExtractorV8Iso;
import de.businesslogics.format.sepa.SEPAExtractor;
import de.businesslogics.format.sepa.SEPAExtractorDk33;
import de.businesslogics.format.sepa.SEPAExtractorV2;
import de.businesslogics.format.sepa.SEPAExtractorV2Iso;
import de.businesslogics.format.sepa.SEPAExtractorV2Stuzza;
import de.businesslogics.format.sepa.SEPAExtractorV3;
import de.businesslogics.format.sepa.SEPAExtractorV3Ch;
import de.businesslogics.format.sepa.SEPAExtractorV3Iso;
import de.businesslogics.format.sepa.SEPAExtractorV4;
import de.businesslogics.format.sepa.SEPAExtractorV5;
import de.businesslogics.format.sepa.SEPAExtractorV8Iso;
import de.businesslogics.format.sepa.SEPAExtractorV9Iso;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPaymentMethod;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.format.sepa.containernnn00102.MsgPain008;
import de.businesslogics.format.sepa.containernnn00302.Conxml;
import de.businesslogics.format.sepa.containernnn00302.MsgPain001;
import de.businesslogics.format.sepa.pain00100202.Document;
import de.businesslogics.format.sepa.pain00800102.Document;
import de.businesslogics.format.sepa.pain00800201.Pain00800201Document;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class GeneralSEPAExtractor {
    public static final String TEMP_MESSAGE_ID = "TempMessageId";
    public static final String NOTPROVIDED = "NOTPROVIDED";
    public static final String TRF = SEPAPaymentMethod.TRF.name();
    public static final String DD = SEPAPaymentMethod.DD.name();
    public static final String SEPA = SEPAServiceLevel.SEPA.name();
    public static final String URGP = SEPAServiceLevel.URGP.name();
    public static final String SDVA = SEPAServiceLevel.SDVA.name();
    public static final String NURG = SEPAServiceLevel.NURG.name();
    public static final String QRR = "QRR";
    public static final String SCOR = "SCOR";
    public static final String RF = "RF";
    public static final String EUR = "EUR";

    public static SEPAPaymentData getPaymentFromCCT(InputStream is) throws Exception {
        List<SEPAPaymentData> payments = GeneralSEPAExtractor.getPaymentsFromCCT(is);
        if (payments != null && payments.size() == 1) {
            return payments.get(0);
        }
        throw new Exception("Payment file contains more than 1 payment");
    }

    public static SEPAPaymentData getDebitPayment(InputStream is) throws Exception {
        List<SEPAPaymentData> payments = GeneralSEPAExtractor.getDebitPayments(is);
        if (payments != null && payments.size() == 1) {
            return payments.get(0);
        }
        throw new Exception("Payment file contains more than 1 payment");
    }

    public static List<SEPAPaymentData> getPaymentsFromCCT(InputStream is) throws IOException, SAXException {
        return GeneralSEPAExtractor.getPaymentsFromCCT(is, false);
    }

    public static List<SEPAPaymentData> getPaymentsFromCCT(InputStream is, boolean allowContainerFiles) throws IOException, SAXException {
        EbicsElement e = GeneralSEPAExtractor.getCreditDocument(is, allowContainerFiles);
        try {
            return GeneralSEPAExtractor.getPaymentsFromCCT(e);
        }
        catch (Exception exception) {
            if (allowContainerFiles) {
                return GeneralSEPAExtractor.getPaymentsFromContainer(e);
            }
            throw exception;
        }
    }

    public static SEPAPaymentData getPaymentFromATX(InputStream is) throws Exception {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(Document2.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00100109.Document.class);
        EbicsElement e = EbicsHandler.parse(is, p);
        List<SEPAPaymentData> payments = SEPAExtractorV3Iso.getATXPayments((Document2)e);
        if (e instanceof de.businesslogics.format.iso20022.pain00100103.Document) {
            payments = SEPAExtractorV3Iso.getATXPayments((Document2)e);
        } else if (e instanceof de.businesslogics.format.iso20022.pain00100109.Document) {
            payments = SEPAExtractorV9Iso.getPayments((de.businesslogics.format.iso20022.pain00100109.Document)e);
        }
        if (payments != null && payments.size() == 1) {
            return payments.get(0);
        }
        throw new Exception("Payment file contains more than 1 payment");
    }

    private static List<SEPAPaymentData> getPaymentsFromCCT(EbicsElement e) throws IOException {
        if (e instanceof de.businesslogics.format.sepa.pain00100103.Document) {
            return SEPAExtractorV5.getPaymentsFromCCT((de.businesslogics.format.sepa.pain00100103.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100203.Document) {
            return SEPAExtractorV3.getPaymentsFromCCT((de.businesslogics.format.sepa.pain00100203.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100303.Document) {
            return SEPAExtractorV4.getPaymentsFromCCT((de.businesslogics.format.sepa.pain00100303.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100202.Document) {
            return SEPAExtractorV2.getPaymentsFromCCT((de.businesslogics.format.sepa.pain00100202.Document)e);
        }
        if (e instanceof Pain00100102GrpDocument) {
            return SEPAExtractor.getPaymentsFromCCT((Pain00100102GrpDocument)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100102.Document) {
            return SEPAExtractorV2Iso.getPayments((de.businesslogics.format.iso20022.pain00100102.Document)e);
        }
        if (e instanceof de.businesslogics.format.stuzza.pain00100102at02.Document) {
            return SEPAExtractorV2Stuzza.getPayments((de.businesslogics.format.stuzza.pain00100102at02.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100103.Document) {
            return SEPAExtractorV3Iso.getPayments((de.businesslogics.format.iso20022.pain00100103.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100108.Document) {
            return SEPAExtractorV8Iso.getPayments((de.businesslogics.format.iso20022.pain00100108.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100109.Document) {
            return SEPAExtractorV9Iso.getPayments((de.businesslogics.format.iso20022.pain00100109.Document)e);
        }
        if (e instanceof de.businesslogics.format.ch.pain0010010302.Document) {
            return SEPAExtractorV3Ch.getPayments((de.businesslogics.format.ch.pain0010010302.Document)e);
        }
        if (e instanceof de.businesslogics.format.dk33.pain00100103.Document) {
            return SEPAExtractorDk33.getPayments((de.businesslogics.format.dk33.pain00100103.Document)e);
        }
        throw new IOException("Unsupported SEPA version");
    }

    public static List<SEPALogicalFile> getLogicalFilesFromCCT(InputStream is) throws IOException, SAXException {
        return GeneralSEPAExtractor.getLogicalFiles(GeneralSEPAExtractor.getCreditDocument(is));
    }

    public static EbicsElement getCreditDocument(InputStream is) throws IOException, SAXException {
        return GeneralSEPAExtractor.getCreditDocument(is, false);
    }

    private static EbicsElement getCreditDocument(InputStream is, boolean allowContainerFiles) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        GeneralSEPAExtractor.addCreditRoots(p);
        if (allowContainerFiles) {
            GeneralSEPAExtractor.addContainerRoots(p);
        }
        return EbicsHandler.parse(is, p);
    }

    private static void addCreditRoots(RootChoiceParser p) {
        p.addParser(new Pain00100102GrpDocument.Parser(null));
        p.addParser(new Document.Parser(null));
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00100102.Document.class);
        p.addPossibleRoot(de.businesslogics.format.stuzza.pain00100102at02.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00100103.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00100108.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00100109.Document.class);
        p.addPossibleRoot(de.businesslogics.format.sepa.pain00100203.Document.class);
        p.addPossibleRoot(de.businesslogics.format.sepa.pain00100303.Document.class);
        p.addPossibleRoot(de.businesslogics.format.sepa.pain00100103.Document.class);
        p.addPossibleRoot(de.businesslogics.format.ch.pain0010010302.Document.class);
        p.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:004:N", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
        p.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:004", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
        p.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:003:N", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
        p.addPossibleRoot("ISO:pain.001.001.03:APC:STUZZA:payments:003", "Document", de.businesslogics.format.iso20022.pain00100103.Document.class);
    }

    public static List<SEPAPaymentData> getDebitPayments(InputStream is) throws IOException, SAXException {
        return GeneralSEPAExtractor.getDebitPayments(is, false);
    }

    public static List<SEPAPaymentData> getDebitPayments(InputStream is, boolean allowContainerFiles) throws IOException, SAXException {
        EbicsElement e = GeneralSEPAExtractor.getDebitDocument(is, allowContainerFiles);
        try {
            return GeneralSEPAExtractor.getDebitPayments(e);
        }
        catch (Exception exception) {
            if (allowContainerFiles) {
                return GeneralSEPAExtractor.getPaymentsFromContainer(e);
            }
            throw exception;
        }
    }

    public static List<SEPAPaymentData> getDebitPayments(EbicsElement e) throws IOException, SAXException {
        if (e instanceof de.businesslogics.format.iso20022.pain00800108.Document) {
            return SEPADebitExtractorV8Iso.getPayments((de.businesslogics.format.iso20022.pain00800108.Document)e);
        }
        if (e instanceof Document) {
            return SEPADebitExtractorV5.getPayments((Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00800202.Document) {
            return SEPADebitExtractorV3.getPayments((de.businesslogics.format.sepa.pain00800202.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00800302.Document) {
            return SEPADebitExtractorV4.getPayments((de.businesslogics.format.sepa.pain00800302.Document)e);
        }
        if (e instanceof Pain00800201Document) {
            return SEPADebitExtractorV2.getPayments((Pain00800201Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00800101.Document) {
            return SEPADebitExtractorV2Iso.getPayments((de.businesslogics.format.iso20022.pain00800101.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00800102.Document) {
            return SEPADebitExtractorV3Iso.getPayments((de.businesslogics.format.iso20022.pain00800102.Document)e);
        }
        if (e instanceof de.businesslogics.format.dk33.pain00800102.Document) {
            return SEPADebitExtractorDk33.getPayments((de.businesslogics.format.dk33.pain00800102.Document)e);
        }
        throw new IOException("Unsupported SEPA version");
    }

    public static List<SEPALogicalFile> getLogicalFilesFromDebit(InputStream is) throws IOException, SAXException {
        return GeneralSEPAExtractor.getLogicalFiles(GeneralSEPAExtractor.getDebitDocument(is));
    }

    public static EbicsElement getDebitDocument(InputStream is) throws IOException, SAXException {
        return GeneralSEPAExtractor.getDebitDocument(is, false);
    }

    private static EbicsElement getDebitDocument(InputStream is, boolean allowContainerFiles) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        GeneralSEPAExtractor.addDebitRoots(p);
        if (allowContainerFiles) {
            GeneralSEPAExtractor.addContainerRoots(p);
        }
        return EbicsHandler.parse(is, p);
    }

    private static void addDebitRoots(RootChoiceParser p) {
        p.addParser(new Pain00800201Document.Parser(null));
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00800108.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00800101.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.pain00800102.Document.class);
        p.addPossibleRoot(de.businesslogics.format.sepa.pain00800202.Document.class);
        p.addPossibleRoot(de.businesslogics.format.sepa.pain00800302.Document.class);
        p.addPossibleRoot(Document.class);
        p.addPossibleRoot("ISO:pain.008.001.02:APC:STUZZA:payments:003", "Document", de.businesslogics.format.iso20022.pain00800102.Document.class);
        p.addPossibleRoot("ISO:pain.008.001.02:APC:STUZZA:payments:004", "Document", de.businesslogics.format.iso20022.pain00800102.Document.class);
    }

    public static List<SEPALogicalFile> getLogicalFiles(InputStream is) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        GeneralSEPAExtractor.addDebitRoots(p);
        GeneralSEPAExtractor.addCreditRoots(p);
        return GeneralSEPAExtractor.getLogicalFiles(EbicsHandler.parse(is, p));
    }

    @Deprecated
    public static SepaHandlerKey findHandlerKey(List<SEPALogicalFile> files) {
        SepaHandlerKey handlerKey = null;
        for (SEPALogicalFile file : files) {
            for (SEPAPaymentData sepaData : file.getTransactions()) {
                SepaHandlerKey handlerKeyFound = null;
                if (!sepaData.isCredit()) {
                    if (sepaData.getDebitType().equals(SEPALocalInstrument.CORE.name())) {
                        handlerKeyFound = SepaHandlerKey.CDD;
                    } else if (sepaData.getDebitType().equals(SEPALocalInstrument.B2B.name())) {
                        handlerKeyFound = SepaHandlerKey.CDB;
                    } else if (sepaData.getDebitType().equals(SEPALocalInstrument.COR1.name())) {
                        handlerKeyFound = SepaHandlerKey.CD1;
                    }
                } else {
                    handlerKeyFound = URGP.equals(sepaData.getServiceLevel()) ? SepaHandlerKey.CCU : (sepaData.isForeignPayment() ? SepaHandlerKey.AXZ : (sepaData.isInstantPayment() ? SepaHandlerKey.CIP : (!SEPAPaymentData.EUR.equals(sepaData.getCurrency()) ? SepaHandlerKey.XCT : SepaHandlerKey.CCT)));
                }
                if (handlerKey == null) {
                    handlerKey = handlerKeyFound;
                    continue;
                }
                if (handlerKey.equals((Object)handlerKeyFound)) continue;
                return null;
            }
        }
        return handlerKey;
    }

    private static List<SEPALogicalFile> getLogicalFiles(EbicsElement e) throws IOException, SAXException {
        if (e instanceof de.businesslogics.format.iso20022.pain00800108.Document) {
            return SEPADebitExtractorV8Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00800108.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100103.Document) {
            return SEPAExtractorV5.getLogicalFilesFromCCT((de.businesslogics.format.sepa.pain00100103.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100203.Document) {
            return SEPAExtractorV3.getLogicalFilesFromCCT((de.businesslogics.format.sepa.pain00100203.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100303.Document) {
            return SEPAExtractorV4.getLogicalFilesFromCCT((de.businesslogics.format.sepa.pain00100303.Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00100202.Document) {
            return SEPAExtractorV2.getLogicalFilesFromCCT((de.businesslogics.format.sepa.pain00100202.Document)e);
        }
        if (e instanceof Pain00100102GrpDocument) {
            return SEPAExtractor.getLogicalFilesFromCCT((Pain00100102GrpDocument)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100102.Document) {
            return SEPAExtractorV2Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00100102.Document)e);
        }
        if (e instanceof de.businesslogics.format.stuzza.pain00100102at02.Document) {
            return SEPAExtractorV2Stuzza.getLogicalFiles((de.businesslogics.format.stuzza.pain00100102at02.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100103.Document) {
            return SEPAExtractorV3Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00100103.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100108.Document) {
            return SEPAExtractorV8Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00100108.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00100109.Document) {
            return SEPAExtractorV9Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00100109.Document)e);
        }
        if (e instanceof de.businesslogics.format.ch.pain0010010302.Document) {
            return SEPAExtractorV3Ch.getLogicalFiles((de.businesslogics.format.ch.pain0010010302.Document)e);
        }
        if (e instanceof Document) {
            return SEPADebitExtractorV5.getLogicalFiles((Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00800202.Document) {
            return SEPADebitExtractorV3.getLogicalFiles((de.businesslogics.format.sepa.pain00800202.Document)e);
        }
        if (e instanceof Pain00800201Document) {
            return SEPADebitExtractorV2.getLogicalFiles((Pain00800201Document)e);
        }
        if (e instanceof de.businesslogics.format.sepa.pain00800302.Document) {
            return SEPADebitExtractorV4.getLogicalFiles((de.businesslogics.format.sepa.pain00800302.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00800101.Document) {
            return SEPADebitExtractorV2Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00800101.Document)e);
        }
        if (e instanceof de.businesslogics.format.iso20022.pain00800102.Document) {
            return SEPADebitExtractorV3Iso.getLogicalFiles((de.businesslogics.format.iso20022.pain00800102.Document)e);
        }
        throw new IOException("Unsupported SEPA version");
    }

    public static List<SEPALogicalFile> getLogicalFilesFromContainer(InputStream inputStream) throws SAXException, IOException {
        ArrayList<SEPALogicalFile> logicalFiles;
        block9: {
            EbicsElement root;
            block8: {
                RootChoiceParser p = new RootChoiceParser();
                p.addPossibleRoot(Conxml.class);
                p.addPossibleRoot(de.businesslogics.format.sepa.containernnn00102.Conxml.class);
                root = EbicsHandler.parse(inputStream, p);
                logicalFiles = new ArrayList<SEPALogicalFile>();
                if (!(root instanceof Conxml)) break block8;
                Conxml conxml = (Conxml)root;
                if (conxml.getChoice1().getMsgPain001s() != null) {
                    for (MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                        logicalFiles.addAll(GeneralSEPAExtractor.getLogicalFiles(msgPain001.getDocument()));
                    }
                }
                if (conxml.getChoice1().getMsgPain008s() == null) break block9;
                for (de.businesslogics.format.sepa.containernnn00302.MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                    logicalFiles.addAll(GeneralSEPAExtractor.getLogicalFiles(msgPain008.getDocument()));
                }
                break block9;
            }
            if (root instanceof de.businesslogics.format.sepa.containernnn00102.Conxml) {
                de.businesslogics.format.sepa.containernnn00102.Conxml conxml = (de.businesslogics.format.sepa.containernnn00102.Conxml)root;
                if (conxml.getChoice1().getMsgPain001s() != null) {
                    for (de.businesslogics.format.sepa.containernnn00102.MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                        logicalFiles.addAll(GeneralSEPAExtractor.getLogicalFiles(msgPain001.getDocument()));
                    }
                }
                if (conxml.getChoice1().getMsgPain008s() != null) {
                    for (MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                        logicalFiles.addAll(GeneralSEPAExtractor.getLogicalFiles(msgPain008.getDocument()));
                    }
                }
            }
        }
        return logicalFiles;
    }

    public static List<SEPAPaymentData> getPaymentsFromContainer(InputStream inputStream) throws SAXException, IOException {
        return GeneralSEPAExtractor.getPaymentsFromContainer(inputStream, false);
    }

    public static List<SEPAPaymentData> getPaymentsFromContainer(InputStream inputStream, boolean allowNonContainerFiles) throws SAXException, IOException {
        RootChoiceParser p = new RootChoiceParser();
        GeneralSEPAExtractor.addContainerRoots(p);
        if (allowNonContainerFiles) {
            GeneralSEPAExtractor.addCreditRoots(p);
            GeneralSEPAExtractor.addDebitRoots(p);
        }
        EbicsElement root = EbicsHandler.parse(inputStream, p);
        return GeneralSEPAExtractor.getPaymentsFromContainer(root, allowNonContainerFiles);
    }

    private static List<SEPAPaymentData> getPaymentsFromContainer(EbicsElement root) throws SAXException, IOException {
        return GeneralSEPAExtractor.getPaymentsFromContainer(root, false);
    }

    private static List<SEPAPaymentData> getPaymentsFromContainer(EbicsElement root, boolean allowNonContainerFiles) throws SAXException, IOException {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        if (root instanceof de.businesslogics.format.dk39.containernnn001gbic5.Conxml) {
            de.businesslogics.format.dk39.containernnn001gbic5.Conxml conxml = (de.businesslogics.format.dk39.containernnn001gbic5.Conxml)root;
            if (conxml.getChoice1().getMsgPain001s() != null) {
                for (de.businesslogics.format.dk39.containernnn001gbic5.MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                    payments.addAll(GeneralSEPAExtractor.getPaymentsFromCCT(msgPain001.getDocument()));
                }
            }
            if (conxml.getChoice1().getMsgPain008s() != null) {
                for (de.businesslogics.format.dk39.containernnn001gbic5.MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                    payments.addAll(GeneralSEPAExtractor.getDebitPayments(msgPain008.getDocument()));
                }
            }
        } else if (root instanceof de.businesslogics.format.dk37.containernnn001gbic4.Conxml) {
            de.businesslogics.format.dk37.containernnn001gbic4.Conxml conxml = (de.businesslogics.format.dk37.containernnn001gbic4.Conxml)root;
            if (conxml.getChoice1().getMsgPain001s() != null) {
                for (de.businesslogics.format.dk37.containernnn001gbic4.MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                    payments.addAll(GeneralSEPAExtractor.getPaymentsFromCCT(msgPain001.getDocument()));
                }
            }
            if (conxml.getChoice1().getMsgPain008s() != null) {
                for (de.businesslogics.format.dk37.containernnn001gbic4.MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                    payments.addAll(GeneralSEPAExtractor.getDebitPayments(msgPain008.getDocument()));
                }
            }
        } else if (root instanceof de.businesslogics.format.dk36.containernnn00103.Conxml) {
            de.businesslogics.format.dk36.containernnn00103.Conxml conxml = (de.businesslogics.format.dk36.containernnn00103.Conxml)root;
            if (conxml.getChoice1().getMsgPain001s() != null) {
                for (de.businesslogics.format.dk36.containernnn00103.MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                    payments.addAll(GeneralSEPAExtractor.getPaymentsFromCCT(msgPain001.getDocument()));
                }
            }
            if (conxml.getChoice1().getMsgPain008s() != null) {
                for (de.businesslogics.format.dk36.containernnn00103.MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                    payments.addAll(GeneralSEPAExtractor.getDebitPayments(msgPain008.getDocument()));
                }
            }
        } else if (root instanceof Conxml) {
            Conxml conxml = (Conxml)root;
            if (conxml.getChoice1().getMsgPain001s() != null) {
                for (MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                    payments.addAll(GeneralSEPAExtractor.getPaymentsFromCCT(msgPain001.getDocument()));
                }
            }
            if (conxml.getChoice1().getMsgPain008s() != null) {
                for (de.businesslogics.format.sepa.containernnn00302.MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                    payments.addAll(GeneralSEPAExtractor.getDebitPayments(msgPain008.getDocument()));
                }
            }
        } else if (root instanceof de.businesslogics.format.sepa.containernnn00102.Conxml) {
            de.businesslogics.format.sepa.containernnn00102.Conxml conxml = (de.businesslogics.format.sepa.containernnn00102.Conxml)root;
            if (conxml.getChoice1().getMsgPain001s() != null) {
                for (de.businesslogics.format.sepa.containernnn00102.MsgPain001 msgPain001 : conxml.getChoice1().getMsgPain001s()) {
                    payments.addAll(GeneralSEPAExtractor.getPaymentsFromCCT(msgPain001.getDocument()));
                }
            }
            if (conxml.getChoice1().getMsgPain008s() != null) {
                for (MsgPain008 msgPain008 : conxml.getChoice1().getMsgPain008s()) {
                    payments.addAll(GeneralSEPAExtractor.getDebitPayments(msgPain008.getDocument()));
                }
            }
        } else if (allowNonContainerFiles) {
            try {
                return GeneralSEPAExtractor.getPaymentsFromCCT(root);
            }
            catch (Exception e) {
                return GeneralSEPAExtractor.getDebitPayments(root);
            }
        }
        return payments;
    }

    private static void addContainerRoots(RootChoiceParser p) {
        p.addPossibleRoot(Conxml.class);
        p.addPossibleRoot(de.businesslogics.format.sepa.containernnn00102.Conxml.class);
        p.addPossibleRoot(de.businesslogics.format.dk36.containernnn00103.Conxml.class);
        p.addPossibleRoot(de.businesslogics.format.dk37.containernnn001gbic4.Conxml.class);
        p.addPossibleRoot(de.businesslogics.format.dk39.containernnn001gbic5.Conxml.class);
    }

    @Deprecated
    public static enum SepaHandlerKey {
        CCT,
        CCU,
        CDB,
        CDD,
        CD1,
        CIP,
        AXZ,
        XCT;

    }
}

