/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.math.BigDecimal;
import org.xml.sax.SAXException;

public class EuroMax9Amount
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    final BigDecimal amount;

    public EuroMax9Amount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Ccy", "EUR");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.print(this.amount.toString());
    }

    public static class Parser
    extends SimpleStringElement.Parser {
        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            attributes.checkFixed("Ccy", "EUR");
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            return new EuroMax9Amount(new BigDecimal(this.getCondensed()));
        }
    }
}

