/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.ChargeBearerType2Code;
import de.businesslogics.format.sepa.DirectDebitTransaction4;
import de.businesslogics.format.sepa.EuroMax9Amount;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.PartyIdentification7;
import de.businesslogics.format.sepa.PartyIdentification9;
import de.businesslogics.format.sepa.PaymentIdentification4;
import de.businesslogics.format.sepa.PaymentTypeInformation14;
import de.businesslogics.format.sepa.RemittanceInformation3;
import org.xml.sax.SAXException;

public class DirectDebitTransactionInformation4
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private PaymentIdentification4 pmtId;
    private PaymentTypeInformation14 pmtTpInf;
    private EuroMax9Amount instdAmt;
    private ChargeBearerType2Code chrgBr;
    private DirectDebitTransaction4 drctDbtTx;
    private FinancialInstitution2 dbtrAgt;
    private PartyIdentification7 dbtr;
    private CashAccount8 dbtrAcct;
    private PartyIdentification9 ultmtDbtr;
    RemittanceInformation3 rmtInf;

    private DirectDebitTransactionInformation4() {
    }

    public DirectDebitTransactionInformation4(PaymentIdentification4 pmtId, EuroMax9Amount instdAmt, DirectDebitTransaction4 drctDbtTx, FinancialInstitution2 dbtrAgt, PartyIdentification7 dbtr, CashAccount8 dbtrAcct, RemittanceInformation3 rmtInf) {
        this.pmtId = pmtId;
        this.instdAmt = instdAmt;
        this.drctDbtTx = drctDbtTx;
        this.dbtrAgt = dbtrAgt;
        this.dbtr = dbtr;
        this.dbtrAcct = dbtrAcct;
        this.rmtInf = rmtInf;
    }

    public PaymentIdentification4 getPmtId() {
        return this.pmtId;
    }

    public EuroMax9Amount getInstdAmt() {
        return this.instdAmt;
    }

    public DirectDebitTransaction4 getDrctDbtTx() {
        return this.drctDbtTx;
    }

    public PartyIdentification7 getDbtr() {
        return this.dbtr;
    }

    public CashAccount8 getDbtrAcct() {
        return this.dbtrAcct;
    }

    public FinancialInstitution2 getDbtrAgt() {
        return this.dbtrAgt;
    }

    public PartyIdentification9 getUltmtDbtr() {
        return this.ultmtDbtr;
    }

    public RemittanceInformation3 getRmtInf() {
        return this.rmtInf;
    }

    public void setRmtInf(RemittanceInformation3 rmtInf) {
        this.rmtInf = rmtInf;
    }

    public void setUltmtDbtr(PartyIdentification9 ultmtDbtr) {
        this.ultmtDbtr = ultmtDbtr;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.pmtId.printOut("PmtId", ps);
        ps.printOut("PmtTpInf", this.pmtTpInf);
        this.instdAmt.printOut("InstdAmt", ps);
        ps.printOut("ChrgBr", this.chrgBr);
        this.drctDbtTx.printOut("DrctDbtTx", ps);
        this.dbtrAgt.printOut("DbtrAgt", ps);
        this.dbtr.printOut("Dbtr", ps);
        this.dbtrAcct.printOut("DbtrAcct", ps);
        if (this.ultmtDbtr != null) {
            this.ultmtDbtr.printOut("UltmtDbtr", ps);
        }
        if (this.rmtInf != null) {
            this.rmtInf.printOut("RmtInf", ps);
        }
    }

    public static class Parser
    extends ElementParser {
        final DirectDebitTransactionInformation4 toReturn = new DirectDebitTransactionInformation4();

        public Parser() {
            super(0);
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if ("urn:sepade:xsd:pain.008.001.01.grp".equals(uri)) {
                if ("PmtId".equals(localName) && this.allowChild(0)) {
                    return new PaymentIdentification4.Parser(uri);
                }
                if ("PmtTpInf".equals(localName) && this.allowChild(1)) {
                    return new PaymentTypeInformation14.Parser(uri);
                }
                if ("InstdAmt".equals(localName) && this.allowChild(0, 2)) {
                    return new EuroMax9Amount.Parser();
                }
                if ("ChrgBr".equals(localName) && this.allowChild(3)) {
                    return ChargeBearerType2Code.SLEV.createParser();
                }
                if ("DrctDbtTx".equals(localName) && this.allowChild(2, 4)) {
                    return new DirectDebitTransaction4.Parser(uri);
                }
                if ("DbtrAgt".equals(localName) && this.allowChild(5)) {
                    return new FinancialInstitution2.Parser(uri);
                }
                if ("Dbtr".equals(localName) && this.allowChild(6)) {
                    return new PartyIdentification7.Parser(uri);
                }
                if ("DbtrAcct".equals(localName) && this.allowChild(7)) {
                    return new CashAccount8.Parser(uri);
                }
                if ("UltmtDbtr".equals(localName) && this.allowChild(8)) {
                    return new PartyIdentification9.Parser(uri);
                }
                if ("RmtInf".equals(localName) && this.allowChild(7, 9)) {
                    return new RemittanceInformation3.Parser(uri);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtId = (PaymentIdentification4)element;
                    break;
                }
                case 1: {
                    this.toReturn.pmtTpInf = (PaymentTypeInformation14)element;
                    break;
                }
                case 2: {
                    this.toReturn.instdAmt = (EuroMax9Amount)element;
                    break;
                }
                case 3: {
                    this.toReturn.chrgBr = (ChargeBearerType2Code)element;
                    break;
                }
                case 4: {
                    this.toReturn.drctDbtTx = (DirectDebitTransaction4)element;
                    break;
                }
                case 5: {
                    this.toReturn.dbtrAgt = (FinancialInstitution2)element;
                    break;
                }
                case 6: {
                    this.toReturn.dbtr = (PartyIdentification7)element;
                    break;
                }
                case 7: {
                    this.toReturn.dbtrAcct = (CashAccount8)element;
                    break;
                }
                case 8: {
                    this.toReturn.ultmtDbtr = (PartyIdentification9)element;
                    break;
                }
                case 9: {
                    this.toReturn.rmtInf = (RemittanceInformation3)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(7);
            return this.toReturn;
        }
    }
}

