/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.sepa;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.format.sepa.CashAccount8;
import de.businesslogics.format.sepa.DirectDebitTransaction4;
import de.businesslogics.format.sepa.EuroMax9Amount;
import de.businesslogics.format.sepa.FinancialInstitution2;
import de.businesslogics.format.sepa.PartyIdentification12;
import de.businesslogics.format.sepa.PartyIdentification23;
import de.businesslogics.format.sepa.PaymentIdentification1_Ebics23;
import de.businesslogics.format.sepa.RemittanceInformation3;
import org.xml.sax.SAXException;

public class DirectDebitTransactionInformation2
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private PaymentIdentification1_Ebics23 pmtId;
    private EuroMax9Amount instdAmt;
    private DirectDebitTransaction4 drctDbtTx;
    private FinancialInstitution2 dbtrAgt;
    private PartyIdentification23 dbtr;
    private CashAccount8 dbtrAcct;
    private PartyIdentification12 ultmtDbtr;
    RemittanceInformation3 rmtInf;

    private DirectDebitTransactionInformation2() {
    }

    public DirectDebitTransactionInformation2(PaymentIdentification1_Ebics23 pmtId, EuroMax9Amount instdAmt, DirectDebitTransaction4 drctDbtTx, FinancialInstitution2 dbtrAgt, PartyIdentification23 dbtr, CashAccount8 dbtrAcct) {
        this.pmtId = pmtId;
        this.instdAmt = instdAmt;
        this.drctDbtTx = drctDbtTx;
        this.dbtrAgt = dbtrAgt;
        this.dbtr = dbtr;
        this.dbtrAcct = dbtrAcct;
    }

    public PaymentIdentification1_Ebics23 getPmtId() {
        return this.pmtId;
    }

    public EuroMax9Amount getInstdAmt() {
        return this.instdAmt;
    }

    public DirectDebitTransaction4 getDrctDbtTx() {
        return this.drctDbtTx;
    }

    public PartyIdentification23 getDbtr() {
        return this.dbtr;
    }

    public CashAccount8 getDbtrAcct() {
        return this.dbtrAcct;
    }

    public FinancialInstitution2 getDbtrAgt() {
        return this.dbtrAgt;
    }

    public PartyIdentification12 getUltmtDbtr() {
        return this.ultmtDbtr;
    }

    public RemittanceInformation3 getRmtInf() {
        return this.rmtInf;
    }

    public void setRmtInf(RemittanceInformation3 rmtInf) {
        this.rmtInf = rmtInf;
    }

    public void setUltmtDbtr(PartyIdentification12 ultmtDbtr) {
        this.ultmtDbtr = ultmtDbtr;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.pmtId.printOut("PmtId", ps);
        this.instdAmt.printOut("InstdAmt", ps);
        this.drctDbtTx.printOut("DrctDbtTx", ps);
        this.dbtrAgt.printOut("DbtrAgt", ps);
        this.dbtr.printOut("Dbtr", ps);
        this.dbtrAcct.printOut("DbtrAcct", ps);
        if (this.ultmtDbtr != null) {
            this.ultmtDbtr.printOut("UltmtDbtr", ps);
        }
        if (this.rmtInf != null) {
            this.rmtInf.printOut("RmtInf", ps);
        }
    }

    public static class Parser
    extends ElementParser {
        final DirectDebitTransactionInformation2 toReturn = new DirectDebitTransactionInformation2();

        public Parser() {
            super(0);
        }

        @Override
        protected ElementParser createChild(String uri, String localName, String qName) throws SAXException {
            if ("urn:sepade:xsd:pain.008.001.01".equals(uri)) {
                if ("PmtId".equals(localName) && this.allowChild(0)) {
                    return new PaymentIdentification1_Ebics23.Parser(uri);
                }
                if ("InstdAmt".equals(localName) && this.allowChild(1)) {
                    return new EuroMax9Amount.Parser();
                }
                if ("DrctDbtTx".equals(localName) && this.allowChild(2)) {
                    return new DirectDebitTransaction4.Parser(uri);
                }
                if ("DbtrAgt".equals(localName) && this.allowChild(3)) {
                    return new FinancialInstitution2.Parser(uri);
                }
                if ("Dbtr".equals(localName) && this.allowChild(4)) {
                    return new PartyIdentification23.Parser(uri);
                }
                if ("DbtrAcct".equals(localName) && this.allowChild(5)) {
                    return new CashAccount8.Parser(uri);
                }
                if ("UltmtDbtr".equals(localName) && this.allowChild(6)) {
                    return new PartyIdentification12.Parser(uri);
                }
                if ("RmtInf".equals(localName) && this.allowChild(5, 7)) {
                    return new RemittanceInformation3.Parser(uri);
                }
            }
            return null;
        }

        @Override
        protected void endChild(EbicsElement element) {
            switch (this.currentChild) {
                case 0: {
                    this.toReturn.pmtId = (PaymentIdentification1_Ebics23)element;
                    break;
                }
                case 1: {
                    this.toReturn.instdAmt = (EuroMax9Amount)element;
                    break;
                }
                case 2: {
                    this.toReturn.drctDbtTx = (DirectDebitTransaction4)element;
                    break;
                }
                case 3: {
                    this.toReturn.dbtrAgt = (FinancialInstitution2)element;
                    break;
                }
                case 4: {
                    this.toReturn.dbtr = (PartyIdentification23)element;
                    break;
                }
                case 5: {
                    this.toReturn.dbtrAcct = (CashAccount8)element;
                    break;
                }
                case 6: {
                    this.toReturn.ultmtDbtr = (PartyIdentification12)element;
                    break;
                }
                case 7: {
                    this.toReturn.rmtInf = (RemittanceInformation3)element;
                }
            }
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.checkLastMandatory(5);
            return this.toReturn;
        }
    }
}

